/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.IBasketStockApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PBasketService;
import cms.tmx.datatype.proto.PBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketStockApiImpl
extends CallApi
implements IBasketStockApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    private List<PBasketService.BasketSecurity> bskSecList = new LinkedList<PBasketService.BasketSecurity>();

    @Override
    public List<PBasketService.BasketSecurity> queryStocks(String marketGrp, String basketId, String uuid) throws MException {
        this.bskSecList.clear();
        PBase.Page defPage = this.baseApi.getDefPage();
        int i = 0;
        this.queryBskSecByPage(marketGrp, basketId, this.bskSecList, defPage, i, uuid);
        return this.bskSecList;
    }

    private void queryBskSecByPage(String marketGrp, String basketId, List<PBasketService.BasketSecurity> bskSecList, PBase.Page defPage, int i, String uuid) throws MException {
        MEvent event = new MEvent();
        PBasketService.GetBasketSecListReq.Builder builder = PBasketService.GetBasketSecListReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setBasketId(basketId);
        builder.setMarketGrp(marketGrp);
        builder.setPage(defPage);
        builder.setBatchId(uuid);
        event.setObj((Object)builder.build());
        this.action(this.queryService, "824", event);
        PBasketService.GetBasketSecListRsp resp = (PBasketService.GetBasketSecListRsp)event.getObj(PBasketService.GetBasketSecListRsp.class);
        this.checkStatus(resp.getStatus());
        bskSecList.addAll(resp.getSecutiryList());
        if (resp.getPage().getTotalRow() > defPage.getPageSize() * ++i) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getPageSize() * i + 1);
            this.queryBskSecByPage(marketGrp, basketId, bskSecList, pageBuilder.build(), i, uuid);
        }
    }

    @Override
    public void updateStock(String marketGrp, String basketId, List<PBasketService.BasketSecurity> bskSecList, PBase.Fragment fra, int i, String uuid) throws MException {
        this.updateBskSecByPage(marketGrp, basketId, bskSecList, fra, i, uuid);
    }

    private void updateBskSecByPage(String marketGrp, String basketId, List<PBasketService.BasketSecurity> bskSecList, PBase.Fragment fra, int i, String uuid) throws MException {
        ArrayList<PBasketService.BasketSecurity> list = new ArrayList<PBasketService.BasketSecurity>();
        if (fra.getTotalFragNum() == i) {
            list.addAll(bskSecList.subList(150 * (i - 1), bskSecList.size()));
        } else if (fra.getTotalFragNum() > i) {
            list.addAll(bskSecList.subList(150 * (i - 1), 150 * i));
        }
        PBasketService.UpdateBasketSecListReq.Builder builder = PBasketService.UpdateBasketSecListReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setBasketId(basketId);
        builder.setMarketGrp(marketGrp);
        builder.addAllSecurity(list);
        builder.setFragment(fra);
        builder.setBatchId(uuid);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.queryService, "825", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
        if (fra.getTotalFragNum() > i++) {
            PBase.Fragment.Builder fraBuilder = fra.toBuilder();
            fraBuilder.setIndex(i);
            this.updateBskSecByPage(marketGrp, basketId, bskSecList, fraBuilder.build(), i, uuid);
        }
    }
}

