/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.IBasketMngApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PBasketService;
import cms.tmx.datatype.proto.PBase;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketMngImpl
extends CallApi
implements IBasketMngApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;

    @Override
    public List<PBasketService.Basket> queryBaskets(String marketGrp) throws MException {
        MEvent event = new MEvent();
        PBasketService.GetBasketsReq.Builder builder = PBasketService.GetBasketsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.queryService, "823", event);
        PBasketService.GetBasketsRsp resp = (PBasketService.GetBasketsRsp)event.getObj(PBasketService.GetBasketsRsp.class);
        this.checkStatus(resp.getStatus());
        return resp.getBasketList();
    }

    @Override
    public PBasketService.Basket addBasket(String marketGrp, String basketName) throws MException {
        MEvent event = new MEvent();
        PBasketService.NewBasketReq.Builder builder = PBasketService.NewBasketReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setMarketGrp(marketGrp);
        builder.setBasketName(basketName);
        event.setObj((Object)builder.build());
        this.action(this.queryService, "820", event);
        PBasketService.NewBasketRsp resp = (PBasketService.NewBasketRsp)event.getObj(PBasketService.NewBasketRsp.class);
        this.checkStatus(resp.getStatus());
        return resp.getBasket();
    }

    @Override
    public void updateBasket(String marketGrp, String basketId, String basketName) throws MException {
        MEvent event = new MEvent();
        PBasketService.UpdateBasketReq.Builder builder = PBasketService.UpdateBasketReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        PBasketService.Basket.Builder basket = PBasketService.Basket.newBuilder();
        basket.setBasketId(basketId);
        basket.setBasketName(basketName);
        basket.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setBasket(basket.build());
        event.setObj((Object)builder.build());
        this.action(this.queryService, "821", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }

    @Override
    public void deleteBasket(String marketGrp, String basketId) throws MException {
        MEvent event = new MEvent();
        PBasketService.DeleteBasketReq.Builder builder = PBasketService.DeleteBasketReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setUserId(this.baseApi.getOpUser().getUserId());
        builder.setBasketId(basketId);
        builder.setMarketGrp(marketGrp);
        event.setObj((Object)builder.build());
        this.action(this.queryService, "822", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
    }
}

