/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.IBasketCancelReplaceApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketCancelReplaceApiImpl
extends CallApi
implements IBasketCancelReplaceApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.OrderServiceDefine orderService;

    @Override
    public void cancelReplace(List<PMessage.ListOrdGrpLeg> orderList, PBase.Fragment fra, int i, String uuid, String marketGrp, String reference, String resourceId) throws MException {
        this.replaceByPage(orderList, fra, i, uuid, marketGrp, reference, resourceId);
    }

    private void replaceByPage(List<PMessage.ListOrdGrpLeg> orderList, PBase.Fragment fra, int i, String uuid, String marketGrp, String reference, String resourceId) throws MException {
        ArrayList<PMessage.ListOrdGrpLeg> list = new ArrayList<PMessage.ListOrdGrpLeg>();
        if (fra.getTotalFragNum() == i) {
            list.addAll(orderList.subList(150 * (i - 1), orderList.size()));
        } else if (fra.getTotalFragNum() > i) {
            list.addAll(orderList.subList(150 * (i - 1), 150 * i));
        }
        PMessage.ListOrdGrp.Builder ordGrp = PMessage.ListOrdGrp.newBuilder();
        ordGrp.addAllOrdLeg(list);
        PMessage.ListCancelReplaceRequest.Builder builder = PMessage.ListCancelReplaceRequest.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setBatchId(uuid);
        builder.setOrigListId(((PMessage.ListOrdGrpLeg)list.get(0)).getSecondaryClOrdId());
        builder.setFragment(fra);
        builder.setOrders(ordGrp);
        builder.setReference(reference);
        builder.setResourceId(resourceId);
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.orderService, "278", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
        if (fra.getTotalFragNum() > i++) {
            PBase.Fragment.Builder fraBuilder = fra.toBuilder();
            fraBuilder.setIndex(i);
            this.replaceByPage(orderList, fraBuilder.build(), i, uuid, marketGrp, reference, resourceId);
        }
    }
}

