/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api.basket.imp;

import cms.tmx.api.CallApi;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.basket.IBasketCancelOrderApi;
import cms.tmx.api.mng.imp.BaseApiImpl;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketCancelOrderApiImpl
extends CallApi
implements IBasketCancelOrderApi {
    @Inject
    private BaseApiImpl baseApi;
    @Inject
    private TradeServiceDefines.OrderServiceDefine orderService;

    @Override
    public void cancel(List<PMessage.ListOrdGrpLeg> orderList, PBase.Fragment fra, int i, String uuid, String marketGrp, String clListId) throws MException {
        this.cancelByPage(orderList, fra, i, uuid, marketGrp, "", clListId);
    }

    @Override
    public void cancelSingleOrder(String listId, String marketGrp, String clListId) throws MException {
        PBase.Fragment.Builder fra = PBase.Fragment.newBuilder();
        fra.setIndex(1);
        fra.setTotalFragNum(1);
        fra.setTotalDataNum(0);
        this.cancelByPage(new ArrayList<PMessage.ListOrdGrpLeg>(), fra.build(), 1, UUID.randomUUID().toString(), marketGrp, listId, clListId);
    }

    private void cancelByPage(List<PMessage.ListOrdGrpLeg> orderList, PBase.Fragment fra, int i, String uuid, String marketGrp, String listId, String clListId) throws MException {
        ArrayList<PMessage.ListOrdGrpLeg> list = new ArrayList<PMessage.ListOrdGrpLeg>();
        PMessage.ListCancelRequest.Builder builder = PMessage.ListCancelRequest.newBuilder();
        if (orderList != null && !orderList.isEmpty()) {
            if (fra.getTotalFragNum() == i) {
                list.addAll(orderList.subList(150 * (i - 1), orderList.size()));
            } else if (fra.getTotalFragNum() > i) {
                list.addAll(orderList.subList(150 * (i - 1), 150 * i));
            }
            builder.setOrigListId(((PMessage.ListOrdGrpLeg)list.get(0)).getSecondaryClOrdId());
        }
        PMessage.ListOrdGrp.Builder ordGrp = PMessage.ListOrdGrp.newBuilder();
        ordGrp.addAllOrdLeg(list);
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(marketGrp);
        builder.setBatchId(uuid);
        builder.setFragment(fra);
        builder.setOrders(ordGrp);
        if (!StringUtils.isEmpty((String)listId)) {
            builder.setOrigListId(listId);
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            builder.setOrigClListId(clListId);
        }
        MEvent event = new MEvent();
        event.setObj((Object)builder.build());
        this.action(this.orderService, "277", event);
        this.checkStatus(PBase.OpStatus.class.cast(event.getObj()));
        if (fra.getTotalFragNum() > i++) {
            PBase.Fragment.Builder fraBuilder = fra.toBuilder();
            fraBuilder.setIndex(i);
            this.cancelByPage(orderList, fraBuilder.build(), i, uuid, marketGrp, listId, clListId);
        }
    }
}

