/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.api;

import cms.tmx.api.IServiceDefine;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.define.IErrorMsg;
import cms.tmx.utils.StringUtils;
import javax.inject.Inject;

public class CallApi {
    @Inject
    private IErrorMsg msg;
    @Inject
    protected MEventService es;

    protected void action(IServiceDefine sd, String method, MEvent event) throws MException {
        this.action(sd, method, event, "uap.call");
    }

    private void action(IServiceDefine sd, String method, MEvent event, String topic) throws MException {
        Object obj = event.getObj();
        event.put((Object)"saved_object", obj);
        event.put((Object)"method_code", (Object)(String.valueOf(sd.getServerCode()) + method));
        event.put((Object)"server_type", (Object)sd.getServerType(method));
        this.es.sendEvent(topic, event);
        this.es.postEvent("message.notification", event);
        if (!event.isOK()) {
            throw new MException(event);
        }
    }

    protected void subscribe(IServiceDefine sd, String method, MEvent event) throws MException {
        event.put((Object)"method_code", (Object)(String.valueOf(sd.getServerCode()) + method));
        event.put((Object)"server_type", (Object)sd.getServerType(method));
        this.action(sd, method, event, "uap.sub");
    }

    protected void login(IServiceDefine sd, String method, MEvent event) throws MException {
        this.action(sd, method, event, "uap.login");
    }

    protected void checkStatus(Object obj) throws MException {
        if (obj instanceof PBase.OpStatus) {
            PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(obj);
            int code = status.getStatus();
            if (code == 1 || code == 11) {
                return;
            }
            String reason = this.msg.getMsg(code);
            if (StringUtils.isEmpty((String)reason)) {
                reason = status.getReason();
            }
            if (StringUtils.isEmpty((String)reason)) {
                reason = "\u9519\u8bef\u7801\uff1a" + code;
            }
            MException e = new MException(code, reason);
            e.getEvent().setObj((Object)status.getData());
            throw e;
        }
        throw new MException(999996, "no server response");
    }

    protected void checkStatusForReason(Object obj) throws MException {
        if (obj instanceof PBase.OpStatus) {
            PBase.OpStatus status = (PBase.OpStatus)PBase.OpStatus.class.cast(obj);
            int code = status.getStatus();
            if (code == 1 || code == 11) {
                return;
            }
            String reason = status.getReason();
            if (StringUtils.isEmpty((String)reason)) {
                reason = this.msg.getMsg(code);
            }
            if (StringUtils.isEmpty((String)reason)) {
                reason = "\u9519\u8bef\u7801\uff1a" + code;
            }
            MException e = new MException(code, reason);
            e.getEvent().setObj((Object)status.getData());
            throw e;
        }
        throw new MException(999996, "no server response");
    }

    protected PBase.Page buildPage(IPageInTurn page) {
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        pageBuilder.setPageSize(page.getPageSize());
        pageBuilder.setStartRow(page.getStartRow());
        return pageBuilder.build();
    }
}

