/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.FuturePriceCell;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.futures.arbitrage.Response;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.FutureMarket;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.futures.dto.ArbitrageContract;
import cms.tmx.http.futures.dto.TbfContractSetting;
import cms.tmx.http.futures.dto.TbfLegSetting;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.trade.entrust.FutureArbitrageEntrust;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import futures.arbitrage.models.ArbitrageContractsModel;
import futures.arbitrage.models.FutureArbitrageOrderModel;
import futures.arbitrage.models.FutureArbitrageTradeModel;
import futures.arbitrage.models.UserPreCtrlFuturesArbitrageMarket;
import futures.arbitrage.views.FutureArbitrageConfirmDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureArbitrageTradePart
extends MxPart {
    @FXML
    private TableView<FutureMarket> tableMarketList;
    @FXML
    private TableView<HandicapInfo> tableSell;
    @FXML
    private TableView<HandicapInfo> tableBuy;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private CheckBox checkHedge;
    @FXML
    private CheckBox checkArbitrage;
    @FXML
    private CheckBox checkSplit;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private ComboBox<MxNode> cmbOcFlag;
    @FXML
    private ComboBox<MxNode> cmbPriceType;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    private Spinner<Double> priceSpn;
    @FXML
    private Spinner<Integer> countSpn;
    @FXML
    private ComboBox<MxNode> countStg;
    @FXML
    private Spinner<Integer> spnSplitCount;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Button btnBuy;
    @FXML
    private Button btnSell;
    @FXML
    private Label lbNowPrice;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    private ComboBox<String> cmbAcct;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private FutureArbitrageTradeModel model;
    @Inject
    private UserPreCtrlFuturesArbitrageMarket preModel;
    @Inject
    private MxAlert alert;
    @Inject
    private DialogFactory df;
    @Inject
    private MEventService es;
    @Inject
    private MObjFactory of;
    private MarketItem mktItem;
    private SecSuggest spCode = new SecSuggest(true);
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(false, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlSplitCount = new IntSpinnerCtrl(true, 9, 1);
    private static final Logger logger = LogManager.getLogger(FutureArbitrageTradePart.class);
    private String orderType = "";
    private boolean priceSettle = false;
    private SecConverter secCvt;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String confirmSymbol = "";
    @Inject
    private CtpUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    public Map<String, List<CtpOrder>> map;
    private double selectPrice;
    private boolean selectFlag = false;
    private List<RefItem> listRefItem = null;
    @Inject
    private FutureArbitrageOrderModel orderModel;
    @Inject
    private ArbitrageContractsModel contractsModel;
    @FXML
    private TableView<TbfLegSetting> tableLegs;
    @FXML
    private TableColumn<TbfLegSetting, String> index;
    @FXML
    private TableColumn<TbfLegSetting, String> securityId;
    @FXML
    private TableColumn<TbfLegSetting, String> active;
    @FXML
    private TableColumn<TbfLegSetting, ComboBox<String>> secAccntId;
    @FXML
    private TableColumn<TbfLegSetting, ComboBox<MxNode>> ocFlag;
    @FXML
    private TableColumn<TbfLegSetting, ComboBox<MxNode>> shFlag;
    @Inject
    public CtpAccountMap accMng;
    private Map<String, Object> codeMap = new HashMap<String, Object>();
    private Map<String, ArbitrageContract> arbMap = new HashMap<String, ArbitrageContract>();
    private ObservableList<TbfLegSetting> list = FxUtils.newArrayList();
    private Map<String, Integer> flagMap = new HashMap<String, Integer>();
    private MEventHandler orderHandler = event -> this.callback(event.getStr("rspInfo"));
    private MEventHandler inputEvent = event -> {
        if (!this.isVisible()) {
            return;
        }
        Platform.runLater(() -> {
            RefItem item = (RefItem)event.getObj(RefItem.class);
            this.txtCode.setText(item.getCode());
            this.listRefItem.forEach(ob -> {
                if (item.getMarket().isEmpty() && ob.getConId().equals(item.getConId())) {
                    this.txtCode.setUserData(ob);
                } else if (!item.getMarket().isEmpty() && ob.getCode().equals(item.getCode())) {
                    this.txtCode.setUserData(ob);
                }
            });
            this.onSecurityChange();
            this.onLegChange();
            String newPrice = event.getStr("0");
            this.priceSpn.getEditor().setText(newPrice);
        });
    };
    private InvalidationListener listenerMktItem = ob -> this.onMarketChange();
    private List<HandicapInfo> listBuyHandicap = new ArrayList<HandicapInfo>();
    private List<HandicapInfo> listSellHandicap = new ArrayList<HandicapInfo>();
    private InvalidationListener listenerUnfinishChange = ob -> this.resetMarketOrder();
    private MEventHandler handler = event -> {
        String secCode = event.getStr("sec_code");
        String side = event.getStr("side_sell");
        Platform.runLater(() -> {
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(secCode);
                if (side.equals("49") || side.equals("2")) {
                    this.btnBuy.requestFocus();
                } else if (side.equals("50") || side.equals("1")) {
                    this.btnSell.requestFocus();
                }
            }
        });
    };
    private List<CtpOrder> orders = new ArrayList<CtpOrder>();
    private ObservableList<RefItem> obList = FxUtils.newArrayList();
    private String ocFlagName = "";
    List<SecAccount> listSec = new ArrayList<SecAccount>();
    private Map<String, List<String>> mapSecId = new HashMap<String, List<String>>();
    private int shFlagValue = 1;
    private TbfLegSetting tbfLeg = new TbfLegSetting();
    private List<TbfLegSetting> legList = new ArrayList<TbfLegSetting>();
    private Instrument inst = new Instrument();
    boolean isArb = false;
    private List<FutureArbitrageEntrust> orderList = new ArrayList<FutureArbitrageEntrust>();
    private SecSuggest.StrSuggest strSuggest = SecSuggest.getStrSuggest();
    protected static ComboBox<?> SPONSOR = null;

    private List<RefItem> getRefList() {
        List list = (List)this.refMng.getItems(new String[]{"FUT"});
        list.sort((o1, o2) -> o1.getCode().compareTo(o2.getCode()));
        list = list.stream().distinct().collect(Collectors.toList());
        list.addAll(this.contractsModel.getListRefItem());
        this.listRefItem = list;
        return this.listRefItem;
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerMktItem));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinishChange));
        if (this.unfinishedModel.getList().size() == 0) {
            this.exe.execute(() -> this.unfinishedModel.query());
        }
    }

    private void onMarketChange() {
        this.exe.execute(() -> {
            long start = System.currentTimeMillis();
            if (this.isSame(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap()) && this.isSame(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap())) {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u76f8\u540c\uff0c\u4e0d\u5237\u65b0\uff01");
            } else {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u4e0d\u76f8\u540c\uff0c\u5237\u65b0\uff01");
                this.resetMarketOrder();
                if (this.model.isBidAskPrice()) {
                    double price = this.model.getHandicapPrice();
                    Platform.runLater(() -> this.model.setPrice(price));
                }
            }
            this.update();
            logger.error("\u884c\u60c5\u53d8\u5316\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        });
    }

    private void update() {
        this.updateHandicapInfo(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap());
        this.updateHandicapInfo(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap());
    }

    private void updateHandicapInfo(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listInfo.size() <= i) {
                listHandicap.get(i).clear();
            }
            listHandicap.get(i).update((Object)listInfo.get(i));
            ++i;
        }
    }

    private boolean isSame(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listHandicap.get(i).getPrice() != listInfo.get(i).getPrice()) {
                logger.error("old: " + listHandicap.get(i).getPrice() + "new: " + listInfo.get(i).getPrice());
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetMarketOrder() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            long start = System.currentTimeMillis();
            ObservableList observableList = this.unfinishedModel.getList();
            synchronized (observableList) {
                this.orders.clear();
                this.orders.addAll((Collection<CtpOrder>)this.unfinishedModel.getList());
            }
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (this.orders == null || this.orders.isEmpty()) continue;
                for (CtpOrder order : this.orders) {
                    if (!order.getSecId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (this.orders == null || this.orders.isEmpty()) continue;
                for (CtpOrder order : this.orders) {
                    if (!order.getSecId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            logger.error("resetMarketOrder\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.contractsModel.getListRefItem().forEach(ob -> this.codeMap.put(ob.getCode(), ob));
        this.contractsModel.getList().forEach(ob -> this.arbMap.put(ob.getContractId(), (ArbitrageContract)ob));
        this.refMng.changedProperty().addListener(ob -> {
            List<RefItem> codeList = this.getRefList();
            this.spCode.setAllSuggestions(codeList);
            this.obList.setAll(codeList);
        });
        this.contractsModel.changedProperty().addListener(ob -> Platform.runLater(() -> {
            this.txtCode.setText("");
            this.txtCode.setUserData(null);
            this.arbMap.clear();
            List<RefItem> codeList = this.getRefList();
            this.spCode.setAllSuggestions(codeList);
            this.obList.setAll(codeList);
            this.contractsModel.getList().forEach(cob -> this.arbMap.put(cob.getContractId(), (ArbitrageContract)cob));
            this.onSecurityChange();
            this.onLegChange();
        }));
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createTableView();
        this.es.subscribe("input_futures_trade_market", this.handler);
        this.es.subscribe("OnInsertAlgoOrder", this.orderHandler);
        this.es.subscribe("input_futures_arb_trade", this.inputEvent);
        this.cmbPriceTypeLimited.valueProperty().unbindBidirectional(this.model.priceTypeLimitedStgProperty());
        MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"2");
        node.removeOthers("2");
        this.cmbPriceTypeLimited.setItems(node.getNodes());
        this.cmbPriceTypeLimited.setValue((Object)node.getNode("2"));
        this.listenerUnfinishChange.invalidated(null);
        int i = 0;
        while (i < 5) {
            HandicapInfo infoBuy = new HandicapInfo();
            HandicapInfo infoSell = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoSell.setIndex(i + 1);
            this.listBuyHandicap.add(infoBuy);
            this.listSellHandicap.add(infoSell);
            ++i;
        }
        if (this.list.isEmpty()) {
            this.txtCode.setText("");
            this.lbName.setText("");
        }
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("input_futures_trade_market", this.handler);
        this.es.unSubscribe("OnInsertAlgoOrder", this.orderHandler);
        this.es.unSubscribe("input_futures_arb_trade", this.inputEvent);
    }

    private void initControls() {
        this.cmbAcct.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> {
            this.txtCode.requestFocus();
            this.txtCode.setText("");
            this.txtCode.setUserData(null);
            this.lbName.setText("");
            this.list.clear();
            this.legList.clear();
            this.flagMap.clear();
            this.mapSecId.clear();
            CtpFundAccount fund = this.accMng.getFundAcc(now);
            try {
                this.listSec = (List)this.accMng.getAccountMap().get(fund);
                if (this.listSec == null) {
                    return;
                }
                for (SecAccount sec : this.listSec) {
                    CtpSecAccount acc = (CtpSecAccount)sec;
                    List<String> listSecId = this.mapSecId.get(sec.getExchange().getRaw());
                    if (listSecId == null) {
                        listSecId = new LinkedList<String>();
                        this.mapSecId.put(sec.getExchange().getRaw(), listSecId);
                    }
                    listSecId.add(sec.getInverstorSecId());
                    this.flagMap.put(String.valueOf(acc.getInverstorSecId()) + acc.getExchange().getRaw(), acc.getHedgeFlag());
                }
            }
            catch (MException e) {
                logger.error("\u7ec4\u5408\u5957\u5229\u83b7\u53d6\u8d26\u53f7\u5931\u8d25", (Throwable)e);
            }
        });
        this.cmbAcct.valueProperty().bindBidirectional((Property)this.model.fundAcctProperty());
        if (this.model.accMng.getFundAccList().size() == 0) {
            logger.debug("\u8d44\u91d1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u89e6\u53d1\u76d1\u542c...");
            this.model.accMng.changedProperty().addListener((ob, old, now) -> {
                logger.debug("\u8d44\u91d1\u8d26\u53f7change\u5df2\u89e6\u53d1" + this.model.accMng.getFundAccList().size());
                this.cmbAcct.getItems().setAll((Collection)this.model.accMng.getFundAccList());
                this.strSuggest.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
                Platform.runLater(() -> this.cmbAcct.getSelectionModel().select(0));
            });
        } else {
            logger.debug("FutureArbitrageTradePart \u8d44\u91d1\u8d26\u53f7\u4e0d\u4e3a\u7a7a\uff0c");
            this.cmbAcct.getItems().setAll((Collection)this.model.accMng.getFundAccList());
            this.strSuggest.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        }
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.strSuggest);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getSelectionModel().select(0);
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
        this.checkHedge.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                if (this.checkArbitrage.isSelected()) {
                    this.checkArbitrage.setSelected(false);
                }
                this.shFlagValue = 2;
            }
        });
        this.checkArbitrage.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                if (this.checkHedge.isSelected()) {
                    this.checkHedge.setSelected(false);
                }
                this.shFlagValue = 4;
            }
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        List<RefItem> codeList = this.getRefList();
        this.spCode.setAllSuggestions(codeList);
        this.obList.setAll(codeList);
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> {
            this.onSecurityChange();
            this.onLegChange();
            this.tableBuy.refresh();
            this.tableSell.refresh();
        });
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.txtCode.textProperty().addListener((change, old, now) -> {
            if (now.isEmpty()) {
                this.lbName.setText("");
            }
        });
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        TooltipUtil.bind((Label)this.lbName);
        this.cmbOcFlag.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> {
            this.ocFlagName = now.getValue();
        });
        this.cmbOcFlag.setItems(this.model.getOcFlag().getNodes());
        this.cmbOcFlag.valueProperty().bindBidirectional(this.model.ocFlagProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.checkPriceType());
        this.cmbPriceTypeLimited.setItems(this.model.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.model.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, now) -> this.onPriceTypeLimitedChange((MxNode)now));
        this.cmbPriceTypeBidAsk.setItems(this.model.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.model.priceTypeBidAskStgProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceDisableBind();
        MxBindings.bindSDMinus((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceVisibleBind();
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().focusedProperty().addListener((ob, old, newV) -> this.pricelLoseFocus((Boolean)newV));
        this.model.priceProperty().addListener((observ, old, now) -> {
            if (this.model.isValidRef() && !this.priceSpn.getEditor().isFocused()) {
                double price = this.model.getPrice();
                int scale = this.getValidRef().getScale();
                if (scale == 0) {
                    this.priceSpn.getEditor().setText(String.valueOf((int)price));
                    this.model.setPrice(price);
                } else {
                    this.model.setPrice(price);
                    this.priceSpn.getValueFactory().setValue((Object)price);
                }
            }
        });
        this.ctrlCount.ctrl(this.countSpn);
        this.countDisableBind();
        MxBindings.bindSI((Property)this.countSpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.countSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.countSpn.getEditor().setOnMouseClicked(event -> this.countSpn.getEditor().selectAll());
        this.ctrlSplitCount.ctrl(this.spnSplitCount);
        this.spnSplitCount.getEditor().setText("39");
        this.spnSplitCount.disableProperty().bind((ObservableValue)this.checkSplit.selectedProperty().not());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.btnBuy.addEventHandler(KeyEvent.KEY_PRESSED, event -> this.orderBuyKeyPress((KeyEvent)event));
        this.btnSell.addEventHandler(KeyEvent.KEY_PRESSED, event -> this.orderSellKeyPress((KeyEvent)event));
        CssUtils.addStyleClass((Control)this.btnBuy, (String)"btnRed");
        CssUtils.addStyleClass((Control)this.btnSell, (String)"btnBlue");
    }

    private void onSecurityChange() {
        this.spnSplitCount.setVisible(true);
        this.checkSplit.setVisible(true);
        this.legList.clear();
        this.list.clear();
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.lbName.setText("");
        this.doChange(refItem);
    }

    private void onLegChange() {
        this.model.setContract(null);
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            RefItem refItem = (RefItem)RefItem.class.cast(obj);
            if (!refItem.getMarket().isEmpty()) {
                this.tbfLeg.setIndex(1);
                this.tbfLeg.setInstrument(this.inst);
                this.tbfLeg.getInstrument().setSecurityId(refItem.getCode());
                this.tbfLeg.getInstrument().setMarket(refItem.getMarket());
                this.tbfLeg.setActive(true);
                this.legList.add(this.tbfLeg);
                this.isArb = false;
                this.list.addAll(this.legList);
            } else if (refItem.getMarket().isEmpty()) {
                this.isArb = true;
                ArbitrageContract contract = this.arbMap.get(refItem.getCode());
                this.refreshLeg(contract);
            }
        } else if (obj instanceof ArbitrageContract) {
            this.isArb = true;
            ArbitrageContract contract = (ArbitrageContract)ArbitrageContract.class.cast(obj);
            this.refreshLeg(contract);
        }
    }

    private void refreshLeg(ArbitrageContract contractOld) {
        if (contractOld == null) {
            this.list.clear();
            this.model.setContract(null);
            return;
        }
        ArbitrageContract contract = new ArbitrageContract();
        contract.update(contractOld);
        this.model.setContract(contract);
        TbfContractSetting settingArbitrage = contractOld.getTbfContractSettingObject();
        if (settingArbitrage != null) {
            this.isArb = true;
            LinkedList listLeg = new LinkedList();
            settingArbitrage.getLeg().forEach(leg -> {
                TbfLegSetting tls = new TbfLegSetting();
                tls.update(leg);
                listLeg.add(tls);
            });
            TbfContractSetting setting = new TbfContractSetting();
            setting.setMinOrderQty(settingArbitrage.getMinOrderQty());
            setting.setMaxOrderQty(settingArbitrage.getMaxOrderQty());
            setting.setLeg(listLeg);
            contract.setTbfContractSettingObject(setting);
            this.list.addAll(listLeg);
        }
        this.spnSplitCount.setVisible(false);
        this.checkSplit.setVisible(false);
    }

    private void doChange(RefItem refItem) {
        this.countSpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getMI().setRefItem(refItem);
        this.model.onSecChange();
        this.resetMarketOrder();
        this.preModel.onSecurityChange();
        this.p.layout();
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
            this.checkHedge.setVisible(!"".equals(refItem.getMarket()));
            this.checkArbitrage.setVisible(!"".equals(refItem.getMarket()));
        }
        if (refItem != null && "".equals(refItem.getMarket())) {
            this.lbName.setText(refItem.getName());
        } else if (this.txtCode.getText().length() >= 6 && refItem == null) {
            this.check();
        }
        if (this.selectFlag) {
            this.selectFlag = false;
            this.model.setPrice(this.selectPrice);
        }
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    private void setPrePrice() {
        if (this.model.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        double price = this.preModel.getDefPrice();
        if (this.model.isValidRef()) {
            int scale = this.getValidRef().getScale();
            if (scale == 0) {
                this.priceSpn.getEditor().setText(String.valueOf((int)price));
                this.model.setPrice(price);
            } else {
                this.model.setPrice(price);
                this.priceSpn.getValueFactory().setValue((Object)price);
            }
        }
        if (this.model.getPrice() != 0.0) {
            this.priceSettle = true;
        }
    }

    @FXML
    private void buy() {
        this.order(true);
    }

    @FXML
    private void sell() {
        this.order(false);
    }

    private void order(boolean buy) {
        if (((String)this.cmbAcct.getSelectionModel().getSelectedItem()).isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8d26\u53f7");
            return;
        }
        if (this.txtCode.getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u5408\u7ea6\u4ee3\u7801");
            return;
        }
        if (StringUtils.parseDouble((String)this.priceSpn.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u4ef7\u683c");
            return;
        }
        if (StringUtils.parseDouble((String)this.countSpn.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6570\u91cf");
            return;
        }
        for (TbfLegSetting leg : this.legList) {
            if (!StringUtils.isEmpty((String)leg.getExtSecAccntId())) continue;
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8bc1\u5238\u8d26\u53f7");
            return;
        }
        if (this.model.getContract() != null) {
            this.checkLegInfo();
            if (this.submitConfirm(buy)) {
                this.model.submit(buy);
            }
        } else {
            if (this.checkHedge.isSelected()) {
                this.model.setHedgeType("2");
            } else if (this.checkArbitrage.isSelected()) {
                this.model.setHedgeType("4");
            } else {
                this.model.setHedgeType("1");
            }
            this.model.setEnableSplit(this.checkSplit.isSelected());
            if (this.model.isEnableSplit()) {
                if (this.spnSplitCount.getEditor().getText().isEmpty()) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u62c6\u5355\u6570\u91cf");
                    return;
                }
                this.model.setSplitCount(Integer.valueOf(this.spnSplitCount.getEditor().getText()));
            }
            if (this.valid() && this.orderConfirm(buy)) {
                this.submitOrder();
            }
        }
    }

    private boolean submitConfirm(boolean buy) {
        this.orderList.clear();
        FutureArbitrageConfirmDialog obj = (FutureArbitrageConfirmDialog)((Object)this.of.create(FutureArbitrageConfirmDialog.class));
        FutureArbitrageEntrust entrust = new FutureArbitrageEntrust();
        entrust.setSec(this.txtCode.getText());
        entrust.setSecName(this.lbName.getText());
        entrust.setSide(buy ? 49 : 50);
        entrust.setPrice(this.model.getPrice());
        entrust.setQuantity(this.model.getCount());
        obj.setBuySymbol(this.buySymbol);
        obj.setSellSymbol(this.sellSymbol);
        this.orderList.add(entrust);
        obj.setList(this.orderList);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        return dialog.launch() == ButtonType.OK;
    }

    private void submitOrder() {
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.clearCountCheck();
    }

    private ObservableList<Boolean> doAction() throws Exception, MException {
        return this.model.submit();
    }

    private void clearCountCheck() {
        block7: {
            if (!this.preModel.isClearAfterOrder()) break block7;
            switch (this.model.getCountStg().getRaw()) {
                case "1": {
                    this.model.setCount(0L);
                }
            }
        }
    }

    private boolean valid() {
        if (this.checkHedge.isSelected() && this.checkArbitrage.isSelected()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u4e0d\u53ef\u540c\u65f6\u52fe\u9009\u4fdd\u503c\u548c\u5957\u5229, \u53ef\u4ee5\u90fd\u4e0d\u52fe\u9009\u6216\u5355\u9009");
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtCode.getText())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u4ee3\u7801");
            return false;
        }
        if (this.model.getPrice() <= 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4ef7\u683c");
            return false;
        }
        if (this.model.getCount() <= 0L) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6570\u91cf");
            return false;
        }
        if (this.txtCode.getText().startsWith("TS")) {
            if (this.model.getCount() > 1000L) {
                this.alert.alert(Alert.AlertType.WARNING, "TS\u4e0a\u9650\u6570\u91cf\u4e3a1000, \u8bf7\u91cd\u65b0\u8f93\u5165");
                return false;
            }
        } else if (this.model.getCount() > 500L) {
            this.alert.alert(Alert.AlertType.WARNING, "T/TF\u4e0a\u9650\u6570\u91cf\u4e3a500, \u8bf7\u91cd\u65b0\u8f93\u5165");
            return false;
        }
        if (this.checkSplit.isSelected()) {
            if (this.spnSplitCount.getEditor().getText().isEmpty()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u62c6\u5355\u6570\u91cf");
                return false;
            }
            int count = Integer.valueOf(this.spnSplitCount.getEditor().getText());
            if (count > 39) {
                this.alert.alert(Alert.AlertType.WARNING, "\u62c6\u5355\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e39");
                return false;
            }
            if (count < 1) {
                this.alert.alert(Alert.AlertType.WARNING, "\u62c6\u5355\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
                return false;
            }
        }
        if (StringUtils.isEmpty((String)((String)this.cmbAcct.getSelectionModel().getSelectedItem()))) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8d26\u53f7");
            return false;
        }
        if (!this.model.accMng.getFundAccList().contains(this.cmbAcct.getValue())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8d26\u53f7\u9519\u8bef");
            return false;
        }
        return true;
    }

    private boolean orderConfirm(boolean buy) {
        block5: {
            try {
                List<FutureSingleEntrust> orderList = this.model.getMarketPreOrderList(buy, this.orderType, (String)this.cmbAcct.getValue());
                if (this.preModel.isPopBeforeOrder()) {
                    FuturesEntrustConfirmDialog obj = (FuturesEntrustConfirmDialog)((Object)this.of.create(FuturesEntrustConfirmDialog.class));
                    obj.setPriceTypeLimitedStg(this.model.getPriceTypeLimitedStg());
                    obj.setExecution(true);
                    obj.setInstructionType("0");
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.model.getPriceStg());
                    obj.setPriceTypeBidAskStg(this.model.getPriceTypeBidAskStg());
                    obj.setList(orderList);
                    obj.setBuySymbol(this.buySymbol);
                    obj.setSellSymbol(this.sellSymbol);
                    MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
                    if (dialog.launch() == ButtonType.OK) {
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
            catch (MException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private void priceFocus() {
        this.priceSpn.requestFocus();
        this.preModel.selectTwoOrAllPriceDecimal();
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.model.isLimitPrice()) {
                this.priceFocus();
            } else {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.btnBuy.requestFocus();
            key.consume();
        }
    }

    private void orderBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.btnSell.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order(true);
            this.priceFocus();
            key.consume();
        }
    }

    private void orderSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order(false);
            this.priceFocus();
            key.consume();
        }
    }

    private void onRefChange() {
        TradeBindings.ctpPriceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        if (this.mktItem.getRefItem() != null && !this.mktItem.getRefItem().getName().equals("")) {
            this.checkPriceType();
        }
        this.ctrlPrice.getVF().setUnit(this.mktItem.getRefItem().getPriceUnit());
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
    }

    private void createMarketTable() {
        this.lbNowPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        MxBindings.bindVisible((Control)this.lbNowPrice, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbNowPrice, (double)this.mktItem.getPreSettlementPrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableSell.getItems().size() - this.tableSell.getItems().indexOf(p.getValue())))))));
        this.colSellPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colSellCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colSellPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colBuyCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colBuyPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableBuy.setPlaceholder((Node)new Label());
        this.tableSell.setPlaceholder((Node)new Label());
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableBuy.getSelectionModel().clearSelection();
        this.tableSell.getSelectionModel().clearSelection();
    }

    private void pricelLoseFocus(Boolean flag) {
        if (!flag.booleanValue()) {
            double price = Double.parseDouble(this.priceSpn.getEditor().getText());
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        }
    }

    private void loseFocus(Boolean flag) {
        if (!flag.booleanValue() && this.txtCode.getText().length() > 0) {
            if (this.codeMap.get(this.txtCode.getText()) != null) {
                return;
            }
            this.check();
        } else if (flag.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText("\u65e0\u6548\u4ee3\u7801");
        }
    }

    public void setPrice(double price) {
        if (this.model.isLimitPrice()) {
            price = (double)Math.round(price * 1000.0) / 1000.0;
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            if (this.model.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void checkPriceType() {
        this.priceSpn.getEditor().clear();
        if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeBidAsk.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
        }
    }

    private void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    private void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbPriceType.getValue()).is("50") && !((MxNode)this.cmbPriceType.getValue()).is("0")) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
    }

    private void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.isBidAskPrice(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty()}));
    }

    private void countDisableBind() {
        this.countSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        this.preModel.setType("5", "200005002");
        this.model.setCloseToday("1".equals(this.preModel.getClose()));
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    private void createTableView() {
        this.index.setCellValueFactory(cell -> new SimpleStringProperty(String.valueOf(((TbfLegSetting)cell.getValue()).getIndex())));
        this.securityId.setCellValueFactory(cell -> new SimpleStringProperty(((TbfLegSetting)cell.getValue()).getInstrument().getSecurityId()));
        this.active.setCellValueFactory(cell -> new SimpleStringProperty(((TbfLegSetting)cell.getValue()).isActive() ? "\u4e3b\u52a8" : "\u88ab\u52a8"));
        this.secAccntId.setCellValueFactory(cell -> this.setComboboxSecAccnt((TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<String>>)cell));
        this.ocFlag.setCellValueFactory(cell -> this.setComboboxOcFlag((TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<MxNode>>)cell));
        this.shFlag.setCellValueFactory(cell -> this.setComboboxShFlag((TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<MxNode>>)cell));
        this.tableLegs.setItems(this.list);
    }

    private ReadOnlyObjectWrapper<ComboBox<String>> setComboboxSecAccnt(TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<String>> data) {
        TbfLegSetting setting = (TbfLegSetting)data.getValue();
        String market = setting.getInstrument().getMarket();
        if (this.mapSecId.get(market) != null) {
            setting.getListSecAccnt().setAll((Collection)this.mapSecId.get(market));
        }
        ComboBox cmbSecAccnt = new ComboBox();
        cmbSecAccnt.setItems(setting.getListSecAccnt());
        for (Map.Entry<String, Integer> entry : this.flagMap.entrySet()) {
            if (entry.getValue().intValue() != setting.getPurpose() || !entry.getKey().contains(market)) continue;
            String secChange = entry.getKey().substring(0, entry.getKey().length() - 4);
            cmbSecAccnt.getSelectionModel().select((Object)secChange);
            this.settingsInitAccntInfo(setting, secChange);
            break;
        }
        cmbSecAccnt.hoverProperty().addListener(ob -> {
            ComboBox comboBox2 = SPONSOR = cmbSecAccnt;
        });
        cmbSecAccnt.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> {
            if (now != null) {
                this.settingsInitAccntInfo(setting, (String)now);
                for (Map.Entry<String, Integer> m : this.flagMap.entrySet()) {
                    if (!m.getKey().equals(String.valueOf(now) + market)) continue;
                    setting.setPurpChanged(m.getValue().intValue());
                }
            }
        });
        setting.secChangedProperty().addListener((change, old, now) -> {
            if (cmbSecAccnt.equals(SPONSOR)) {
                return;
            }
            if (StringUtils.isEmpty((String)now)) {
                setting.setExtSecAccntId(now);
                cmbSecAccnt.getSelectionModel().clearSelection();
            } else {
                cmbSecAccnt.getSelectionModel().select(now);
                this.settingsInitAccntInfo(setting, (String)now);
            }
        });
        if (!this.isArb) {
            cmbSecAccnt.getSelectionModel().select(0);
        }
        return new ReadOnlyObjectWrapper((Object)cmbSecAccnt);
    }

    private void settingsInitAccntInfo(TbfLegSetting setting, String secChange) {
        SecAccount secAcc;
        String investorId = this.cmbAcct.getEditor().getText();
        CtpFundAccount fund = this.accMng.getFundAcc(investorId);
        if (fund != null) {
            setting.setExtCashAccntId(fund.getExtAccntId());
        }
        if ((secAcc = this.accMng.getSecAcc(String.valueOf(secChange) + fund.getInvestId())) != null) {
            setting.setExtSecAccntId(secAcc.getExtSecAccntId());
        } else {
            setting.setExtSecAccntId("");
        }
    }

    private ReadOnlyObjectWrapper<ComboBox<MxNode>> setComboboxShFlag(TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<MxNode>> data) {
        TbfLegSetting setting = (TbfLegSetting)data.getValue();
        String market = setting.getInstrument().getMarket();
        ComboBox cmbShFlag = new ComboBox();
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("algo_sh_flag", String.valueOf(setting.getPurpose()));
        cmbShFlag.setItems(node.getNodes());
        cmbShFlag.setValue((Object)node);
        cmbShFlag.hoverProperty().addListener(ob -> {
            ComboBox comboBox2 = SPONSOR = cmbShFlag;
        });
        cmbShFlag.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> {
            if (now != null) {
                String secChange = "";
                for (Map.Entry<String, Integer> m : this.flagMap.entrySet()) {
                    if (m.getValue() != Integer.valueOf(now.getRaw()) || !m.getKey().contains(market)) continue;
                    secChange = m.getKey().substring(0, m.getKey().length() - 4);
                    break;
                }
                setting.setSecChanged(secChange);
            }
        });
        setting.purpChangedProperty().addListener((ob, old, now) -> {
            if (cmbShFlag.equals(SPONSOR)) {
                return;
            }
            int purpose = now.intValue();
            setting.setPurpose(purpose);
            if (purpose == 1) {
                cmbShFlag.getSelectionModel().select(0);
            } else if (purpose == 2) {
                cmbShFlag.getSelectionModel().select(1);
            } else if (purpose == 4) {
                cmbShFlag.getSelectionModel().select(2);
            }
        });
        if (setting.getPurpose() == 1) {
            cmbShFlag.getSelectionModel().select(0);
        } else if (setting.getPurpose() == 2) {
            cmbShFlag.getSelectionModel().select(1);
        } else if (setting.getPurpose() == 4) {
            cmbShFlag.getSelectionModel().select(2);
        }
        this.checkHedge.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                cmbShFlag.getSelectionModel().select(1);
            } else {
                cmbShFlag.getSelectionModel().select(0);
            }
        });
        this.checkArbitrage.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                cmbShFlag.getSelectionModel().select(2);
            } else {
                cmbShFlag.getSelectionModel().select(0);
            }
        });
        if (!this.isArb) {
            cmbShFlag.getSelectionModel().select(0);
        }
        return new ReadOnlyObjectWrapper((Object)cmbShFlag);
    }

    private ReadOnlyObjectWrapper<ComboBox<MxNode>> setComboboxOcFlag(TableColumn.CellDataFeatures<TbfLegSetting, ComboBox<MxNode>> data) {
        ComboBox cmbocFlag = new ComboBox();
        TbfLegSetting setting = (TbfLegSetting)data.getValue();
        if (!this.list.isEmpty() && this.list.size() == 1) {
            cmbocFlag.setDisable(true);
        } else {
            cmbocFlag.setDisable(false);
        }
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("future_position_effect", "F");
        cmbocFlag.setItems(node.getNodes());
        cmbocFlag.setValue((Object)node);
        setting.setPositionEffect(node.getRaw());
        cmbocFlag.getSelectionModel().selectedItemProperty().addListener((change, old, now) -> setting.setPositionEffect(now.getRaw()));
        return new ReadOnlyObjectWrapper((Object)cmbocFlag);
    }

    public void callback(String rspInfo) {
        logger.info("\u7ec4\u5408\u5957\u5229\u4e0b\u5355\u56de\u62a5\u4fe1\u606f\uff1a" + rspInfo);
        Gson gson = new Gson();
        Response response = (Response)gson.fromJson(rspInfo, Response.class);
        Platform.runLater(() -> {
            if (response.getRetCode() == 0) {
                logger.info(String.valueOf(response.getAlgoOrderId()) + "\u4e0b\u5355\u6210\u529f\u3002");
                this.alert.alert(Alert.AlertType.INFORMATION, "\u4e0b\u8fbe\u59d4\u6258\u6210\u529f\uff0c\u6bcd\u5355\u53f7\uff1a" + response.getAlgoOrderId());
            } else {
                this.alert.alert(Alert.AlertType.ERROR, response.getRetMsg());
                logger.error("\u4e0b\u5355\u5931\u8d25\uff1a" + response.getRetMsg());
            }
        });
        this.orderModel.algoQuery();
    }

    private void checkLegInfo() {
        TbfContractSetting setting = this.model.getContract().getTbfContractSettingObject();
        for (TbfLegSetting leg : setting.getLeg()) {
            if (!StringUtils.isEmpty((String)leg.getExtSecAccntId())) continue;
            logger.info(String.valueOf(this.model.getContract().getConId()) + "\u63a8\u9001\u66f4\u65b0\u540e\u817f\u4fe1\u606f\u4e0d\u5168.");
        }
    }

    private void setOrderType(String type) {
        this.orderType = type;
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public int getShFlagValue() {
        return this.shFlagValue;
    }

    public void setShFlagValue(int shFlagValue) {
        this.shFlagValue = shFlagValue;
    }

    public class MainContractCell
    extends TableCell<FutureMarket, Number> {
        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (item.longValue() == 1L) {
                    this.setText("\u662f");
                } else {
                    this.setText("\u5426");
                }
                return;
            }
            this.setText(null);
        }
    }

    public class PriceCell
    extends TableCell<FutureMarket, String> {
        public void updateItem(String item, boolean empty) {
            double price;
            if (!empty && !item.isEmpty() && (price = Double.parseDouble(item)) > 0.0) {
                this.setText(item);
                return;
            }
            this.setText(null);
        }
    }

    public class PriceNowCell
    extends TableCell<FutureMarket, Number> {
        private Label label = new Label();

        public void updateItem(Number item, boolean empty) {
            if (!empty && item != null) {
                this.label.setText(Double.toString(item.doubleValue()));
                CssUtils.makeFall((Control)this.label);
                this.label.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    FutureArbitrageTradePart.this.selectPrice = item.doubleValue();
                    FutureArbitrageTradePart.this.selectFlag = true;
                });
            }
            this.setGraphic((Node)this.label);
        }
    }

    public class PriceSellCell
    extends TableCell<FutureMarket, String> {
        private Label label = new Label();

        private PriceSellCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String item, boolean empty) {
            if (!empty && !StringUtils.isEmpty((String)item)) {
                this.label.setText(item);
                CssUtils.makeFall((Control)this.label);
                this.label.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    FutureArbitrageTradePart.this.selectPrice = Double.parseDouble(item);
                    FutureArbitrageTradePart.this.selectFlag = true;
                });
            }
            this.setGraphic((Node)this.label);
        }
    }

    public class QtyCell
    extends TableCell<FutureMarket, Number> {
        private static final int INVALID_COUNT = -1;

        public void updateItem(Number item, boolean empty) {
            if (!empty && item.longValue() != -1L) {
                this.setText(String.valueOf(item));
            }
            this.setText(null);
        }
    }

    public class QtySellCell
    extends TableCell<FutureMarket, Number> {
        private static final int INVALID_COUNT = -1;
        private Label label = new Label();

        private QtySellCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty && item.longValue() != -1L) {
                this.label.setText(String.valueOf(item));
                CssUtils.makeFall((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

