/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.entity.trade.AlgoCtpOrder;
import cms.tmx.javafx.MxPart;
import cms.tmx.utils.StringUtils;
import futures.arbitrage.models.FutureArbitrageOrderModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;

public class FutureArbitrageOrderPart
extends MxPart {
    protected static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    protected static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    protected static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeTableView<AlgoCtpOrder> treeTableViewAlgo;
    @FXML
    protected TreeTableColumn<AlgoCtpOrder, Boolean> colCheckBox;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> algoId;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> orderId;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> code;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> name;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> side;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> time;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> status;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> errInfo;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, String> trader;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, Number> price;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, Number> count;
    @FXML
    private TreeTableColumn<AlgoCtpOrder, Number> percent;
    @FXML
    private Label lbQueryErr;
    @FXML
    private Button btnOrderCancel;
    @Inject
    private MxAlert alert;
    @Inject
    private FutureArbitrageOrderModel model;
    @Inject
    private ScheduledExecutorService ses;
    private ScheduledFuture<?> scheduledFuture;
    public static boolean isStart = false;
    private static final int DEFAULT_SECONDS = 2;
    private List<TreeItem<AlgoCtpOrder>> treeListAlgo = new ArrayList<TreeItem<AlgoCtpOrder>>();
    private List<AlgoCtpOrder> listAlgo = new ArrayList<AlgoCtpOrder>();
    private List<String> listAlgoId = new ArrayList<String>();
    private String errRsInfo;
    protected Callback<TreeTableColumn<AlgoCtpOrder, Boolean>, TreeTableCell<AlgoCtpOrder, Boolean>> checkBoxFactory = p -> new TreeTableCell<AlgoCtpOrder, Boolean>(){

        public synchronized void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            TreeTableRow row = this.getTreeTableRow();
            AlgoCtpOrder rowItem = (AlgoCtpOrder)row.getItem();
            TreeItem treeItem = row.getTreeItem();
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                row.pseudoClassStateChanged(NOT_LEAF, false);
                row.pseudoClassStateChanged(LEAF, false);
                row.pseudoClassStateChanged(pcMxSelected, false);
            } else if (rowItem != null) {
                CheckBox checkBox = new CheckBox();
                checkBox.selectedProperty().bindBidirectional((Property)rowItem.selectedProperty());
                checkBox.disableProperty().bind((ObservableValue)rowItem.canCancelProperty().not());
                if (treeItem == null) {
                    return;
                }
                if (treeItem.isLeaf()) {
                    checkBox.selectedProperty().addListener((ob, old, now) -> {
                        row.pseudoClassStateChanged(pcMxSelected, now.booleanValue());
                        if (now.booleanValue()) {
                            FutureArbitrageOrderPart.this.treeTableViewAlgo.getSelectionModel().select((Object)treeItem);
                            FutureArbitrageOrderPart.this.treeListAlgo.add(treeItem);
                        } else {
                            FutureArbitrageOrderPart.this.treeTableViewAlgo.getSelectionModel().clearSelection();
                            FutureArbitrageOrderPart.this.treeListAlgo.remove(treeItem);
                        }
                    });
                    row.pseudoClassStateChanged(LEAF, true);
                    row.pseudoClassStateChanged(NOT_LEAF, false);
                } else {
                    checkBox.selectedProperty().addListener((ob, old, newV) -> {
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                        if (newV.booleanValue()) {
                            FutureArbitrageOrderPart.this.treeTableViewAlgo.getSelectionModel().select((Object)treeItem);
                            FutureArbitrageOrderPart.this.treeListAlgo.add(treeItem);
                            FutureArbitrageOrderPart.this.treeTableViewAlgo.refresh();
                        } else {
                            FutureArbitrageOrderPart.this.treeTableViewAlgo.getSelectionModel().clearSelection();
                            FutureArbitrageOrderPart.this.treeListAlgo.remove(treeItem);
                            treeItem.getChildren().forEach(each -> {
                                if (((AlgoCtpOrder)each.getValue()).isCanCancel()) {
                                    ((AlgoCtpOrder)each.getValue()).setSelected(((AlgoCtpOrder)treeItem.getValue()).isSelected());
                                }
                            });
                        }
                    });
                    treeItem.expandedProperty().addListener((ob, old, newV) -> FutureArbitrageOrderPart.this.treeTableViewAlgo.refresh());
                    checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> {
                        if (((AlgoCtpOrder)each.getValue()).isCanCancel()) {
                            ((AlgoCtpOrder)each.getValue()).setSelected(((AlgoCtpOrder)treeItem.getValue()).isSelected());
                        }
                    }));
                    checkBox.disableProperty().addListener((ob, old, newV) -> treeItem.getChildren().forEach(each -> ((AlgoCtpOrder)each.getValue()).setCanCancel(newV.booleanValue())));
                    treeItem.getChildren().forEach(each -> ((AlgoCtpOrder)each.getValue()).setCanCancel(((AlgoCtpOrder)each.getValue()).isCanCancel()));
                    row.pseudoClassStateChanged(NOT_LEAF, true);
                    row.pseudoClassStateChanged(LEAF, false);
                }
                this.setGraphic((Node)checkBox);
            } else {
                row.pseudoClassStateChanged(NOT_LEAF, false);
                row.pseudoClassStateChanged(LEAF, false);
            }
        }
    };

    @FXML
    private void initialize() {
        this.createTable();
        this.refresh();
        this.addListener();
        this.startQuery();
    }

    private void addListener() {
        this.txtSearch.textProperty().bindBidirectional((Property)this.model.searchAlgoProperty());
    }

    public void startQuery() {
        if (!isStart) {
            isStart = true;
            this.ses.scheduleAtFixedRate(() -> {
                this.model.algoQuery();
                Platform.runLater(() -> {
                    this.treeTableViewAlgo.refresh();
                    this.treeTableViewAlgo.layout();
                    if (!StringUtils.isEmpty((String)this.model.getQueryErr())) {
                        this.lbQueryErr.setVisible(true);
                        this.lbQueryErr.setTextFill((Paint)Color.RED);
                        this.lbQueryErr.setText(this.model.getQueryErr());
                        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)5000.0), e -> {
                            this.lbQueryErr.setText("");
                            this.lbQueryErr.setVisible(false);
                        }, new KeyValue[0])});
                        animation.setCycleCount(1);
                        animation.setAutoReverse(false);
                        animation.play();
                    }
                });
            }, 0L, 2L, TimeUnit.SECONDS);
        }
    }

    @FXML
    private void createTable() {
        this.colCheckBox.setCellFactory(this.checkBoxFactory);
        this.colCheckBox.setCellValueFactory(data -> ((AlgoCtpOrder)data.getValue().getValue()).selectedProperty());
        this.algoId.setCellFactory(p -> new MClpsTreeTableCell());
        this.algoId.setCellValueFactory(data -> ((AlgoCtpOrder)data.getValue().getValue()).algoIdProperty());
        this.orderId.setCellValueFactory(data -> new SimpleStringProperty(((AlgoCtpOrder)data.getValue().getValue()).getOrderId()));
        this.code.setCellValueFactory(data -> new SimpleStringProperty(this.getCode(((AlgoCtpOrder)data.getValue().getValue()).getSecId())));
        this.name.setCellValueFactory(data -> new SimpleStringProperty(((AlgoCtpOrder)data.getValue().getValue()).getSecName()));
        this.side.setCellValueFactory(data -> new SimpleStringProperty(((AlgoCtpOrder)data.getValue().getValue()).getSide().getValue()));
        this.price.setCellValueFactory(data -> new SimpleDoubleProperty(((AlgoCtpOrder)data.getValue().getValue()).getPrice()));
        this.price.setCellFactory(p -> new PriceCell(3));
        this.count.setCellValueFactory(data -> new SimpleIntegerProperty(((AlgoCtpOrder)data.getValue().getValue()).getOrderQty()));
        this.percent.setCellValueFactory(data -> this.getPercent(((AlgoCtpOrder)data.getValue().getValue()).getDonePercent()));
        this.time.setCellValueFactory(data -> this.getTime(((AlgoCtpOrder)data.getValue().getValue()).getOrdTime()));
        this.status.setCellValueFactory(data -> ((AlgoCtpOrder)data.getValue().getValue()).statusValueProperty());
        this.errInfo.setCellValueFactory(data -> ((AlgoCtpOrder)data.getValue().getValue()).errInfoProperty());
        this.trader.setCellValueFactory(data -> new SimpleStringProperty(((AlgoCtpOrder)data.getValue().getValue()).getUserId()));
        this.treeTableViewAlgo.setRoot(this.model.getRootNode());
        this.treeTableViewAlgo.setShowRoot(false);
    }

    private DoubleProperty getPercent(double percent) {
        int scale = 2;
        return new SimpleDoubleProperty(Double.parseDouble(StringUtils.toThousands((String)String.valueOf(percent), (int)scale)));
    }

    private StringProperty getTime(String ordTime) {
        if (ordTime.isEmpty()) {
            return new SimpleStringProperty("");
        }
        return new SimpleStringProperty(ordTime.substring(0, 8));
    }

    private String getCode(String secId) {
        if (secId.contains("_")) {
            String beforeId = secId.substring(0, secId.indexOf("_"));
            String realContractId = secId.substring(beforeId.length() + 1, secId.length());
            return realContractId;
        }
        return secId;
    }

    private StringProperty getStatus(AlgoCtpOrder algoCtpOrder) {
        if (algoCtpOrder.getOrdStatus().getValue().isEmpty()) {
            return new SimpleStringProperty(algoCtpOrder.getAlgoStatus().getValue());
        }
        return new SimpleStringProperty(algoCtpOrder.getOrdStatus().getValue());
    }

    @FXML
    private void refresh() {
        this.model.algoQuery();
    }

    @FXML
    private void orderCancel() {
        this.model.setCancelNum(0);
        this.listAlgo.clear();
        this.listAlgoId.clear();
        String cancleAlgo = "";
        for (TreeItem<AlgoCtpOrder> treeAlgo : this.treeListAlgo) {
            this.listAlgo.add((AlgoCtpOrder)treeAlgo.getValue());
        }
        if (!this.listAlgo.isEmpty()) {
            for (AlgoCtpOrder ctpOrder : this.listAlgo) {
                if (!ctpOrder.isCanCancel() || !ctpOrder.isSelected()) continue;
                String algoOrderId = ctpOrder.getAlgoId();
                this.listAlgoId.add(algoOrderId);
            }
        }
        this.listAlgoId = this.listAlgoId.stream().distinct().collect(Collectors.toList());
        Collections.sort(this.listAlgoId, (o1, o2) -> o2.compareTo((String)o1));
        for (String algoOrderId : this.listAlgoId) {
            cancleAlgo = String.valueOf(cancleAlgo) + algoOrderId + "  ";
        }
        if (StringUtils.isEmpty((String)cancleAlgo.trim())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u672a\u9009\u4e2d\u6709\u6548\u6bcd\u5355");
            return;
        }
        for (String algoOrderId : this.listAlgoId) {
            this.model.orderCancel(algoOrderId);
        }
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                FutureArbitrageOrderPart.this.cancleResult();
            }
        };
        timer.schedule(task, 2000L);
    }

    private void cancleResult() {
        this.treeListAlgo.clear();
        this.refresh();
        this.treeTableViewAlgo.getRoot().getChildren().forEach(item -> ((AlgoCtpOrder)item.getValue()).setSelected(false));
        this.treeTableViewAlgo.refresh();
    }

    protected class MClpsTreeTableCell<S>
    extends TreeTableCell<S, String> {
        public MClpsTreeTableCell() {
            if (this.getTreeTableRow() == null || this.getTreeTableRow().getTreeItem() != null && this.getTreeTableRow().getTreeItem().getParent().getParent() != null) {
                this.setOnMouseClicked(event -> {
                    TreeItem item = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (item != null) {
                        if (item.isExpanded()) {
                            item.setExpanded(false);
                        } else {
                            item.setExpanded(true);
                        }
                    }
                });
            }
        }

        public synchronized void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null) {
                    if (this.getTreeTableRow() == null || this.getTreeTableRow().getTreeItem() != null && this.getTreeTableRow().getTreeItem().getParent().getParent() != null) {
                        this.setText(null);
                    } else {
                        this.setText(String.valueOf(item));
                    }
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class PriceCell
    extends EditTreeTableCell<AlgoCtpOrder> {
        PriceCell(int i) {
            super(i);
        }
    }
}

