/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxWebDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilterArbitrage;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.jxb.WebBrowserPart;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import futures.arbitrage.models.ArbitrageContractsModel;
import futures.arbitrage.views.FutureArbitrageLibraryDialog;
import futures.arbitrage.views.Market;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class FutureArbitrageMarketPart
extends MxPart {
    private final String CONFIRM_DELETE_BSK = "\u662f\u5426\u786e\u5b9a\u5220\u9664\u5217\u8868-";
    private final String CONFIRM_DELETE_ARB = "\u662f\u5426\u786e\u5b9a\u5220\u9664\u5408\u7ea6?";
    @FXML
    private TextField txtCode;
    private SecSuggest spCode = new SecSuggest(true);
    private SecConverter secCvt;
    @Inject
    private MObjFactory of;
    @Inject
    private ArbitrageContractsModel contractsModel;
    @Inject
    private MarketDataModel mktMng;
    @FXML
    private TableColumn<String, String> colBskName;
    @FXML
    private TableColumn<String, HBox> colDestroy;
    @FXML
    private TableColumn<String, String> colSpace;
    @FXML
    private TableView<MarketItem> tableSecurity;
    @FXML
    private TableColumn<MarketItem, String> code;
    @FXML
    private TableColumn<MarketItem, String> name;
    @FXML
    private TableColumn<MarketItem, Number> qtyBuy;
    @FXML
    private TableColumn<MarketItem, Number> priceBuy;
    @FXML
    private TableColumn<MarketItem, Number> qtySell;
    @FXML
    private TableColumn<MarketItem, Number> priceSell;
    @FXML
    private TableColumn<MarketItem, Number> qtyNow;
    @FXML
    private TableColumn<MarketItem, Number> priceNow;
    @FXML
    private TableColumn<MarketItem, Object> operate;
    @FXML
    private Label lbName;
    private MxList<MarketItem> list = new MxList();
    private MxList<MarketItem> mlist = new MxList();
    ObservableList<String> baskets = FxUtils.newList();
    Map<String, List<String>> map = new HashMap<String, List<String>>();
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    private DialogFactory df;
    private int addBasketNum = 1;
    @Inject
    private MxAlert alert;
    private StringBuilder newName;
    private Gson gson = new Gson();
    @Inject
    protected IRefDataMng refMng;
    private String userId;
    private String postId;
    private ObservableList<String> smlList = FxUtils.newList();
    private ObservableList<String> bigList = FxUtils.newList();
    private ObservableList<String> allList = FxUtils.newList();

    @FXML
    private void copy() {
    }

    @FXML
    private void refresh() {
    }

    @FXML
    private void exportExcel() {
    }

    @FXML
    private void initialize() {
        this.userId = this.baseApi.getOpUser().getUserId();
        this.postId = this.baseApi.getPostId();
        this.exe.execute(() -> this.read());
        this.createTableView();
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUT"}));
        this.spCode.addPossibleSuggestions(this.contractsModel.getListRefItem());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilterArbitrage()));
        this.refMng.changedProperty().addListener(ob -> {
            this.spCode.clearSuggestions();
            this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUT"}));
            this.spCode.addPossibleSuggestions(this.contractsModel.getListRefItem());
        });
        this.contractsModel.changedProperty().addListener(ob -> {
            if (!StringUtils.isEmpty((String)this.contractsModel.getUpdConId())) {
                for (MarketItem item : this.list.getList()) {
                    if (!this.contractsModel.getUpdConId().equals(item.getRefItem().getCode()) || !item.getRefItem().getMarket().isEmpty()) continue;
                    item.getRefItem().setName(this.contractsModel.getUpdConName());
                    Platform.runLater(() -> {
                        this.txtCode.setText("");
                        this.lbName.setText("");
                    });
                    this.logger.error("marketPart\u66f4\u65b0\u5408\u7ea6\uff1a" + this.contractsModel.getUpdConId());
                }
            } else if (!StringUtils.isEmpty((String)this.contractsModel.getDelConId())) {
                for (MarketItem item : this.list.getList()) {
                    if (!this.contractsModel.getDelConId().equals(item.getRefItem().getCode())) continue;
                    this.list.getList().remove((Object)item);
                    Platform.runLater(() -> {
                        this.txtCode.setText("");
                        this.lbName.setText("");
                    });
                    this.logger.error("marketPart\u5220\u9664\u5408\u7ea6\uff1a" + this.contractsModel.getDelConId());
                }
            }
            this.mlist.update((List)this.list.getList());
            this.tableSecurity.refresh();
            this.spCode.clearSuggestions();
            this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUT"}));
            this.spCode.addPossibleSuggestions(this.contractsModel.getListRefItem());
        });
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange((String)oldV));
        this.tableSecurity.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    Dragboard db = row.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    ClipboardContent cc = new ClipboardContent();
                    cc.putString(((MarketItem)row.getItem()).getRefItem().getCode());
                    db.setContent((Map)cc);
                }
            });
            row.setOnDragOver(event -> {
                event.getDragboard();
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            });
            row.setOnDragDropped(event -> {
                event.getDragboard();
                String code = event.getDragboard().getString();
                MarketItem s = null;
                for (MarketItem item : this.mlist.getList()) {
                    if (!item.getRefItem().getCode().equals(code)) continue;
                    s = item;
                }
                if (s != null) {
                    int dropIndex = row.getIndex();
                    if (dropIndex >= this.tableSecurity.getItems().size()) {
                        dropIndex = this.tableSecurity.getItems().size() - 1;
                    }
                    this.tableSecurity.getItems().remove((Object)s);
                    this.tableSecurity.getItems().add(dropIndex, (Object)s);
                    this.tableSecurity.getSelectionModel().select((Object)s);
                    int i = 0;
                    while (i < this.mlist.getList().size()) {
                        ((MarketItem)this.mlist.getList().get(i)).setIndex(i);
                        ++i;
                    }
                }
                event.setDropCompleted(true);
                event.consume();
            });
            return row;
        });
    }

    private void createTableView() {
        this.code.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().codeProperty());
        this.name.setCellValueFactory(data -> ((MarketItem)data.getValue()).getRefItem().nameProperty());
        this.qtyBuy.setCellValueFactory(data -> ((HandicapInfo)((MarketItem)data.getValue()).getListBuyHandicap().get(0)).countProperty());
        this.priceBuy.setCellValueFactory(data -> ((HandicapInfo)((MarketItem)data.getValue()).getListBuyHandicap().get(0)).priceProperty());
        this.priceBuy.setCellFactory(data -> new PriceCell());
        this.qtySell.setCellValueFactory(data -> ((HandicapInfo)((MarketItem)data.getValue()).getListSellHandicap().get(0)).countProperty());
        this.priceSell.setCellValueFactory(data -> ((HandicapInfo)((MarketItem)data.getValue()).getListSellHandicap().get(0)).priceProperty());
        this.priceSell.setCellFactory(data -> new PriceCell());
        this.priceNow.setCellValueFactory(data -> ((MarketItem)data.getValue()).nowPriceProperty());
        this.priceNow.setCellFactory(d -> new PriceCell());
        this.qtyNow.setCellValueFactory(data -> ((MarketItem)data.getValue()).volumeProperty());
        this.operate.setCellValueFactory(data -> this.setOperate((MarketItem)data.getValue()));
        TableUtils.orgnizeClmWidth(this.tableSecurity);
        this.tableSecurity.setPlaceholder((Node)new Label());
        this.tableSecurity.setItems(this.mlist.getList());
        this.tableDoubleClick();
    }

    protected void tableDoubleClick() {
        this.tableSecurity.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            MarketItem item;
            if (event.getClickCount() == 2 && (item = (MarketItem)this.tableSecurity.getSelectionModel().getSelectedItem()) != null) {
                MEvent mEvent = new MEvent();
                mEvent.setObj((Object)item.getRefItem());
                mEvent.put((Object)"0", (Object)item.getNowPrice());
                this.es.sendEvent("input_futures_arb_trade", mEvent);
            }
        });
    }

    private String getArbCode(String code) {
        if (code.contains("_")) {
            String beforeId = code.substring(0, code.indexOf("_"));
            String realContractId = code.substring(beforeId.length() + 1, code.length());
            return realContractId;
        }
        return code;
    }

    @FXML
    public void arbitrageLib() {
        FutureArbitrageLibraryDialog lib = (FutureArbitrageLibraryDialog)((Object)this.of.create(FutureArbitrageLibraryDialog.class));
        lib.setUrl("/custom-contract");
        MxWebDialog dialog = this.df.createWeb((WebBrowserPart)lib, "\u5408\u7ea6\u5e93", 1550, 750);
        dialog.launch();
        dialog.disposeBrowser();
        this.es.sendEvent("settingsDialogClose", null);
    }

    private void onSecurityChange(String newCode) {
        RefItem item = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            item = (RefItem)RefItem.class.cast(obj);
        }
        if (item == null) {
            this.lbName.setText("");
            return;
        }
        this.lbName.setText(item.getName());
        if (!"".equals(newCode)) {
            for (MarketItem it : this.mlist.getList()) {
                if (!item.getCode().equals(it.getRefItem().getCode()) || !it.getRefItem().getMarket().equals(item.getMarket())) continue;
                return;
            }
        }
        if (!"".equals(newCode)) {
            if (item.getMarket().isEmpty()) {
                this.onAdd(item.getCode(), item.getConId(), item.getName(), "", "secTypeArbitrage", -1, null);
            } else {
                this.onAdd("", "", "", "", "", -1, item);
            }
        }
    }

    private void onAdd(String code, String conId, String name, String market, String secType, int index, RefItem item) {
        MarketItem mktItem = this.mktMng.createItem(10);
        if (item == null) {
            RefItem refItem = new RefItem();
            refItem.setCode(code);
            refItem.setConId(conId);
            refItem.setName(name);
            refItem.setType("secTypeArbitrage");
            refItem.setScale(3);
            mktItem.setRefItem(refItem);
        } else {
            item.setConId(conId);
            mktItem.setRefItem(item);
        }
        this.mktMng.dye(mktItem);
        if (index >= 0) {
            mktItem.setIndex(index);
        } else {
            mktItem.setIndex(this.mlist.getList().size());
        }
        this.list.add((MxObject)mktItem);
        this.mlist.update((List)this.list.getList());
        this.close();
    }

    public void onDelete(MarketItem strategy) {
        this.list.remove((MxObject)strategy);
        this.mlist.remove((MxObject)strategy);
        this.close();
    }

    @FXML
    public void newBasket() {
        if (this.baskets.isEmpty()) {
            this.addBasketNum = 1;
        }
        this.newName = new StringBuilder("\u5217\u8868").append(this.addBasketNum++);
        this.baskets.forEach(each -> {
            if (each.toString().length() == 3) {
                this.smlList.add(each);
            } else {
                this.bigList.add(each);
            }
        });
        Collections.sort(this.smlList);
        Collections.sort(this.bigList);
        this.allList.clear();
        this.allList.addAll(this.smlList);
        this.allList.addAll(this.bigList);
        this.allList.forEach(each -> {
            if (this.newName.toString().equals(each)) {
                this.newName = new StringBuilder("\u5217\u8868").append(this.addBasketNum++);
            }
        });
        String newBsk = this.newName.toString();
        this.baskets.add((Object)this.newName.toString());
        this.baskets.indexOf((Object)newBsk);
    }

    @PreDestroy
    private void close() {
        ArrayList<Market> codes = new ArrayList<Market>();
        for (String basket : this.baskets) {
            codes.add(new Market(basket));
        }
        for (MarketItem item : this.list.getList()) {
            codes.add(new Market(item.getBasket(), item.getRefItem().getCode(), item.getRefItem().getConId(), item.getRefItem().getName(), item.getRefItem().getMarket(), item.getRefItem().getType(), item.getIndex()));
        }
        String json = this.gson.toJson(codes);
        this.write(json);
        System.out.println();
    }

    private void write(String json) {
        String str = String.valueOf(Paths.get(this.pathBase, "data").toString()) + "/" + this.userId + "-" + this.postId + "-" + "market.txt";
        File file = new File(str);
        try {
            FileOutputStream fileStream = new FileOutputStream(file);
            byte[] array = json.getBytes();
            fileStream.write(array);
            fileStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }

    public void read() {
        String str = String.valueOf(Paths.get(this.pathBase, "data").toString()) + "/" + this.userId + "-" + this.postId + "-" + "market.txt";
        File file = new File(str);
        try {
            if (file.exists()) {
                LinkedList codes = new LinkedList();
                FileInputStream fileStream = new FileInputStream(file);
                byte[] array = new byte[fileStream.available()];
                fileStream.read(array);
                String json = new String(array);
                codes = (LinkedList)this.gson.fromJson(json, new TypeToken<LinkedList<Market>>(){}.getType());
                for (Market code : codes) {
                    if (StringUtils.isEmpty((String)code.getCode())) {
                        this.baskets.add((Object)code.getBasket());
                        continue;
                    }
                    if (code.getMarket().isEmpty()) {
                        this.onAdd(code.getCode(), code.getConId(), code.getName(), code.getMarket(), code.getSecType(), code.getIndex(), null);
                        continue;
                    }
                    RefItem item = this.refMng.getItem(code.getSecType(), code.getMarket(), code.getCode());
                    if (item != null) {
                        this.onAdd(code.getCode(), code.getConId(), code.getName(), code.getMarket(), code.getSecType(), code.getIndex(), item);
                        continue;
                    }
                    this.logger.error("ref item is null" + item.getMarket() + item.getCode());
                }
                fileStream.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            this.logger.error(e1.getMessage());
        }
    }

    public ReadOnlyObjectWrapper<Object> setOperate(MarketItem ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Button btnUpdate = new Button("      ");
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        btnUpdate.setText("\u5220\u9664");
        btnUpdate.setOnAction(event -> {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u5b9a\u5220\u9664\u5408\u7ea6?")) {
                this.onDelete(ap);
            }
        });
        hBox.getChildren().add(0, (Object)btnUpdate);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private class MxEditTableCell<S>
    extends TextFieldTableCell<S, String> {
        private TextField textField;
        private ChangeListener<Boolean> lstnFocus = (ob, old, now) -> {
            if (!now.booleanValue() && this.textField != null) {
                this.commitEdit(this.textField.getText());
            }
        };

        public MxEditTableCell() {
            this.setConverter((StringConverter)new DefaultStringConverter());
        }

        public void startEdit() {
            super.startEdit();
            try {
                if (this.textField == null) {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("textField");
                    field.setAccessible(true);
                    this.textField = (TextField)field.get((Object)this);
                    if (this.textField != null) {
                        this.textField.focusedProperty().addListener(this.lstnFocus);
                        this.textField.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 19));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void commitEdit(String newValue) {
            TableView table;
            if (!this.isEditing() && !newValue.equals(this.getItem()) && (table = this.getTableView()) != null) {
                TableColumn col = this.getTableColumn();
                TableColumn.CellEditEvent event = new TableColumn.CellEditEvent(table, new TablePosition(table, this.getIndex(), col), TableColumn.editCommitEvent(), (Object)newValue);
                Event.fireEvent((EventTarget)col, (Event)event);
            }
            super.commitEdit((Object)newValue);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                    this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : ((String)this.getItem()).toString();
        }
    }

    protected class PriceCell
    extends DoubleTableCell<MarketItem> {
        int scale = 3;

        protected PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (item != null) {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                }
            } else {
                this.setText(null);
            }
        }
    }
}

