/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.entity.trade.ObCtpOrder;
import cms.tmx.query.current.views.CtpOrderPagePart;
import cms.tmx.query.history.views.TypeCell;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureArbitrageCtpOrderPart
extends CtpOrderPagePart {
    @FXML
    private TableColumn<ObCtpOrder, String> parentId;
    @FXML
    private TableColumn<ObCtpOrder, String> source;
    @FXML
    private TableColumn<ObCtpOrder, String> ordType;
    private static final Logger logger = LogManager.getLogger(FutureArbitrageCtpOrderPart.class);
    @Inject
    private MxAlert alert;

    @FXML
    public void initialize() {
        super.initialize();
        this.parentId.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).parentIdProperty());
        this.source.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).sourceProperty());
        this.ordType.setCellValueFactory(data -> ((ObCtpOrder)data.getValue()).execTypeProperty());
        this.ordType.setCellFactory(cell -> new TypeCell());
        this.tableCtpOrder.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            ObCtpOrder order = (ObCtpOrder)this.tableCtpOrder.getSelectionModel().getSelectedItem();
            if (order == null) {
                return;
            }
            MEvent e = new MEvent();
            e.put((Object)"input_ctp_market_making", (Object)order.getSecId());
            this.es.postEvent("input_ctp_market_making", e);
            MEvent eCall = new MEvent();
            eCall.put((Object)"sec_code", (Object)order.getSecId());
            eCall.put((Object)"side_sell", (Object)order.getSideRaw());
            this.es.postEvent("input_futures_trade_market", eCall);
        });
    }

    public void exportExcel() {
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableCtpOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @PreDestroy
    protected void close() {
        super.close();
    }
}

