/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.FutureArbitrageEntrust;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;

public class FutureArbitrageConfirmDialog
extends DialogObj {
    @FXML
    private TableView<FutureArbitrageEntrust> tableItems;
    @FXML
    private TableColumn<FutureArbitrageEntrust, String> index;
    @FXML
    private TableColumn<FutureArbitrageEntrust, String> colCode;
    @FXML
    private TableColumn<FutureArbitrageEntrust, String> colName;
    @FXML
    private TableColumn<FutureArbitrageEntrust, Number> colDirection;
    @FXML
    private TableColumn<FutureArbitrageEntrust, Number> colCount;
    @FXML
    private TableColumn<FutureArbitrageEntrust, Number> colPrice;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<FutureArbitrageEntrust> list = FxUtils.newList();
    private RefItem refItem;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private MxNode priceStg;

    @FXML
    public void initialize() {
        this.createTable();
    }

    private void createTable() {
        TableUtils.isAuto(this.index);
        this.colCode.setCellValueFactory(m -> ((FutureArbitrageEntrust)m.getValue()).secProperty());
        this.colName.setCellValueFactory(m -> ((FutureArbitrageEntrust)m.getValue()).secNameProperty());
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((FutureArbitrageEntrust)m.getValue()).sideProperty());
        this.colCount.setCellValueFactory(m -> ((FutureArbitrageEntrust)m.getValue()).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> ((FutureArbitrageEntrust)m.getValue()).priceProperty());
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setItems(this.list);
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setList(List<FutureArbitrageEntrust> list) {
        this.list.setAll(list);
    }

    public List<FutureArbitrageEntrust> getList() {
        return this.list;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<FutureArbitrageEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            FutureArbitrageEntrust item = (FutureArbitrageEntrust)FutureArbitrageEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            this.pseudoClassStateChanged(this.MARKET_PRICE, false);
            int scale = FutureArbitrageConfirmDialog.this.getRefItem() != null ? FutureArbitrageConfirmDialog.this.getRefItem().getScale() : 3;
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)scale);
            this.setText(text);
        }
    }

    private class SideCell
    extends TableCell<FutureArbitrageEntrust, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = MxNodeFactory.create((String)"side", (String)"");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            if (49 == side) {
                this.label.setText(FutureArbitrageConfirmDialog.this.buySymbol);
            } else if (50 == side) {
                this.label.setText(FutureArbitrageConfirmDialog.this.sellSymbol);
            }
            switch (side) {
                case 49: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

