/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.models;

import OrsClientApi.OrsClientApiService;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.futures.arbitrage.AlgoParams;
import cms.tmx.entity.futures.arbitrage.FutureArbitrageTradeReq;
import cms.tmx.futures.entrust.EntrustFactory;
import cms.tmx.http.futures.dto.ArbitrageContract;
import cms.tmx.http.futures.dto.Segments;
import cms.tmx.http.futures.dto.TbfContractSetting;
import cms.tmx.http.futures.dto.TbfLegSetting;
import cms.tmx.http.futures.dto.TradeTimeSetting;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IContractService;
import cmx.tmx.data.IMarketDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureArbitrageTradeModel
extends MxModel {
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private ArbitrageContract contract;
    @Inject
    private EntrustFactory ef;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    private List<String> acctList = new LinkedList<String>();
    private StringProperty fundAcct = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    @Inject
    public CtpAccountMap accMng;
    private MarketItem mktItem;
    private MarketItem mktItemNew;
    @Inject
    private MarketDataModel mktMd;
    @Inject
    private IMarketDataMng mktMng;
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private String hedgeType = "1";
    private ObjectProperty<MxNode> ocFlag = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private int splitCount = 39;
    private boolean enableSplit = true;
    private boolean closeToday;
    private List<FutureSingleEntrust> orderList;
    private String cashAccntBak;
    private String secAccntBak;
    private String cashAccntSet;
    private String secAccntSet;
    @Inject
    private IContractService contractService;
    private CtpContract con;
    @Inject
    private ExecutorService exe;
    private String rspInfo;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(5);
        this.mktItemNew = this.mktMd.createItem(5);
        this.mktItemNew.changedProperty().addListener(ob -> {
            RefItem item = this.mktItem.getRefItem();
            if (item != null && item.getMarket().equals("")) {
                this.mktItem.update((Object)this.mktItemNew);
            }
        });
        MxNode node = MxNodeFactory.create((String)"cstr_price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.createNew((String)"cstr_price_type_limited", (String)"2");
        this.initPriceTypeLimit(node);
        this.setPriceTypeLimitedStg(node);
        node = MxNodeFactory.create((String)"instr_handicap", (String)"-1");
        this.initPriceTypeGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.createNew((String)"position_effect", (String)"70");
        this.ocFlag(node);
        this.setOcFlag(node);
        node = MxNodeFactory.create((String)"futures_count_stg", (String)"1");
        this.setCountStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("arbitrage_price_type", "50");
        this.setPriceType(node);
    }

    public void submit(boolean buy) {
        if (this.contract == null) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u5408\u7ea6\u4ee3\u7801");
            return;
        }
        if (this.getCount() <= 0L) {
            this.alert.alert(Alert.AlertType.WARNING, "\u4e0b\u8fbe\u59d4\u6258\u6570\u91cf\u987b\u5927\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        AlgoParams algoParams = new AlgoParams();
        algoParams.setCode(this.contract.getConId());
        algoParams.setBs(buy ? "01" : "02");
        algoParams.setName(this.contract.getContractName());
        algoParams.setPattern(this.getPriceType().getRaw().equals("50") ? "1" : "2");
        algoParams.setPrice(Double.valueOf(this.getPrice()));
        algoParams.setQuantity(Integer.valueOf((int)this.getCount()));
        algoParams.setPrice_formula(this.contract.getPriceFormula());
        algoParams.setMin_quotation_unit(Double.valueOf(this.contract.getContractTickSize()));
        TbfContractSetting setting = this.contract.getTbfContractSettingObject();
        if (setting == null || setting.getLeg() == null) {
            return;
        }
        algoParams.setMin_order_amount(Integer.valueOf(setting.getMinOrderQty()));
        algoParams.setMax_order_amount(Integer.valueOf(setting.getMaxOrderQty()));
        TradeTimeSetting timeSetting = this.contract.getTradeTimeSetting();
        if (this.contract.getContractType() == 1) {
            algoParams.setLeg_cxl_flag("01");
        } else {
            algoParams.setLeg_cxl_flag(timeSetting.isCandlePassive() ? "11" : "12");
        }
        int tradeBeginTime = timeSetting.getTradeBeginTime();
        int tradeEndTime = timeSetting.getTradeEndTime();
        LocalTime time = LocalTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String nowTime = time.format(formatter).replace(":", "");
        for (Segments seg : timeSetting.getSegments()) {
            int startTime = this.getIntTime(seg.getStartTime(), tradeBeginTime, true);
            int endTime = this.getIntTime(seg.getEndTime(), tradeEndTime, false);
            if (Integer.parseInt(nowTime) > endTime) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(startTime);
            list.add(endTime);
            algoParams.getTrade_period().add(list);
        }
        String gatewayData = "#" + this.baseApi.getPostId() + "#CNY###" + "###############";
        FutureArbitrageTradeReq req = new FutureArbitrageTradeReq();
        req.getFutures().setGateway_id("0");
        req.getFutures().setGateway_data(gatewayData);
        req.getAlgo_info().setAlgo_params(algoParams);
        req.getAlgo_info().setOperator(this.baseApi.getUserId());
        req.getAlgo_info().setUser_id(this.baseApi.getUserId());
        try {
            byte[] bytes = "\u81ea\u5b9a\u4e49\u7684\u6570\u636e".getBytes("GBK");
            JsonObject dataObject = new JsonObject();
            dataObject.addProperty("userInfo", bytes.toString());
            dataObject.addProperty("investorId", this.baseApi.getUserId());
            req.setUser_data(dataObject.toString());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("to GBK error ", (Throwable)e);
        }
        for (TbfLegSetting leg : setting.getLeg()) {
            String extSecAccntId;
            String secAccnt;
            String cashAccnt;
            ArrayList<Object> arr = new ArrayList<Object>();
            String mkCode = MarketUtils.getMarketCodeById((String)leg.getInstrument().getMarket());
            arr.add(StringUtils.isEmpty((String)mkCode) ? "a" : mkCode);
            arr.add(leg.getInstrument().getSecurityId());
            if (StringUtils.isEmpty((String)leg.getExtSecAccntId())) {
                this.alert.alert(Alert.AlertType.WARNING, "\u4e0b\u8fbe\u59d4\u6258\u8bc1\u5238\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                return;
            }
            String string = cashAccnt = leg.getExtCashAccntId() == null ? "" : leg.getExtCashAccntId().replace("_CNY", "");
            if (cashAccnt.contains("_")) {
                this.cashAccntSet = String.valueOf(cashAccnt.substring(0, cashAccnt.indexOf("_"))) + "_CNY";
                arr.add(this.cashAccntSet);
                if (setting.getLeg().get(0) == leg) {
                    this.cashAccntBak = this.cashAccntSet;
                }
            } else {
                arr.add(this.cashAccntBak);
            }
            String string2 = secAccnt = leg.getExtSecAccntId() == null ? "" : leg.getExtSecAccntId().replace("_CNY", "");
            if (secAccnt.contains("_")) {
                this.secAccntSet = secAccnt.substring(secAccnt.indexOf("_") + 1);
                if (this.secAccntSet.contains("_")) {
                    this.secAccntSet = String.valueOf(this.secAccntSet.substring(0, this.secAccntSet.indexOf("_"))) + "_CNY";
                }
                arr.add(this.secAccntSet);
                if (setting.getLeg().get(0) == leg) {
                    this.secAccntBak = this.secAccntSet;
                }
            } else {
                arr.add(this.secAccntBak);
            }
            arr.add((long)leg.getQty() * this.getCount());
            arr.add(leg.getLegSide().equals("+") == buy ? "01" : "02");
            arr.add(StringUtils.isEmpty((String)leg.getPositionEffect()) ? "F" : leg.getPositionEffect());
            arr.add(String.valueOf(leg.getPurpose()));
            String id = String.valueOf(leg.getIndex());
            String active = leg.isActive() ? "0" : "1";
            String minPriceMove = "";
            String priceLevel = "";
            String acceptedExecPriceSlip = "";
            String supportMultQty = "";
            String timeoutFill = "";
            String stoplossFill = "";
            String priceLevelMove = "";
            if (leg.isActive()) {
                if (leg.getActiveLeg() != null) {
                    minPriceMove = String.valueOf(leg.getActiveLeg().getMinPriceMove());
                    priceLevel = String.valueOf(leg.getActiveLeg().getPriceLevel());
                }
            } else if (leg.getPassiveLeg() != null) {
                supportMultQty = String.valueOf(leg.getPassiveLeg().getSupportMultQty());
                priceLevelMove = String.valueOf(leg.getPassiveLeg().getPriceLevelMove());
                acceptedExecPriceSlip = String.valueOf(leg.getPassiveLeg().getAcceptedExecPriceSlip());
                timeoutFill = String.valueOf(leg.getPassiveLeg().getTimeoutFill());
                stoplossFill = String.valueOf(leg.getPassiveLeg().getStoplossFill());
            }
            String reserved1 = String.valueOf(id) + "#" + active + "#" + minPriceMove + "#" + priceLevel + "#" + supportMultQty + "#" + priceLevelMove + "#" + acceptedExecPriceSlip + "#" + timeoutFill + "#" + stoplossFill;
            String securityType = "";
            String appID = "010";
            String subSecAcctID = "";
            String extCashAccntId = leg.getExtCashAccntId() == null ? "" : leg.getExtCashAccntId();
            String string3 = extSecAccntId = leg.getExtSecAccntId() == null ? "" : leg.getExtSecAccntId();
            if (extSecAccntId.isEmpty()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u4e0b\u8fbe\u59d4\u6258\u8bc1\u5238\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                return;
            }
            if (leg.getInstrument() != null && leg.getInstrument().getSecurityType() != null) {
                securityType = leg.getInstrument().getSecurityType();
            }
            if (securityType.isEmpty()) {
                securityType = "FUT";
            }
            String reserved2 = String.valueOf(securityType) + "#" + appID + "#" + subSecAcctID + "#" + extCashAccntId + "#" + extSecAccntId;
            arr.add(reserved1);
            arr.add(reserved2);
            req.getFutures().getBasket().add(arr);
        }
        Gson gson = new Gson();
        String reqJson = gson.toJson((Object)req);
        int reqId = 0;
        int ret = 0;
        this.logger.info("\u7ec4\u5408\u5957\u5229\u4e0b\u5355\u5f00\u59cb");
        OrsClientApiService instance = OrsClientApiService.getInstance();
        this.logger.info("\u7ec4\u5408\u5957\u5229\u83b7\u53d6instance");
        ret = instance.InsertAlgoOrder("b", "TFArbitrage", ++reqId, reqJson);
        this.logger.info("InsertAlgoOrder. ret = " + ret + " --Json:" + reqJson);
    }

    public int getIntTime(String time, int seconds, boolean isStart) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        SimpleDateFormat sdfm = new SimpleDateFormat("HH:mm:ss");
        Date runTime = null;
        try {
            Date setTime = sdf.parse(time);
            runTime = isStart ? new Date(setTime.getTime() + (long)seconds) : new Date(setTime.getTime() - (long)(seconds *= 1000));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Integer.parseInt(sdfm.format(runTime).replace(":", ""));
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getType().equals("FUT") || this.mktItem.getRefItem().getType().equals("");
    }

    public List<FutureSingleEntrust> getMarketPreOrderList(boolean buy, String type, String investorId) throws Exception, MException {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        this.orderList = enList;
        long count = this.getCount();
        do {
            long quantity = 0L;
            if (this.isEnableSplit() && count > (long)this.splitCount) {
                quantity = this.splitCount;
                count -= (long)this.splitCount;
            } else {
                quantity = count;
                count = 0L;
            }
            CtpFundAccount fund = this.accMng.getFundAcc(this.getFundAcct());
            CtpSecAccount secAcct = (CtpSecAccount)this.getExtSecAcc(this.getFundAcct(), this.getHedgeType(), this.getMI().getRefItem().getMarket());
            FutureSingleEntrust en = this.ef.createSingle(fund.getExtAccntId(), secAcct.getExtSecAccntId());
            en.setQuantity(quantity);
            en.setMarket(this.mktItem.getRefItem().getMarket());
            en.setMarketGrp(MarketUtils.getMarketGroup((String)en.getMarket()));
            en.setSecType("FUT");
            if ("50".equals(this.getPriceStg().getRaw())) {
                en.setOrderType(50);
            } else if ("0".equals(this.getPriceStg().getRaw())) {
                en.setOrderType(0);
            }
            en.setPrice(this.getPrice());
            en.setSec(this.mktItem.getRefItem().getCode());
            en.setSecName(this.mktItem.getRefItem().getName());
            en.setHedgeFlag(Integer.parseInt(this.getHedgeType()));
            en.setBrokerId(fund.getBrokerId());
            en.setInvestorId(fund.getInvestId());
            en.setInvestorSecId(secAcct.getInverstorSecId());
            en.setSecAccount((SecAccount)secAcct);
            en.setFundAccount((FundAccount)fund);
            en.setSide(buy ? 49 : 50);
            en.setOffsetFlag(this.getOcFlag());
            this.con = this.contractService.getContract("FUTURES", en.getMarket(), en.getSec(), en.getBrokerId(), en.getInvestorId());
            en.setAmt(this.getAmt(this.getOcFlag(), this.getPrice(), this.getCount()));
            en.setShowCloseTip(false);
            enList.add(en);
        } while (count > 0L);
        return enList;
    }

    private double getAmt(MxNode ocFlag, double price, long quantity) {
        if (this.con == null) {
            return 0.0;
        }
        String offsetFlag = ocFlag.getRaw();
        if ("79".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(this.con.getUnderlyingMultiple())).multiply(new BigDecimal(this.con.getLongMarginRatio())).multiply(new BigDecimal(this.con.getVolumeMultiple())).setScale(this.getValidRef().getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        if ("67".equals(offsetFlag) || "84".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(this.con.getUnderlyingMultiple())).multiply(new BigDecimal(this.con.getShortMarginRatio())).multiply(new BigDecimal(this.con.getVolumeMultiple())).setScale(this.getValidRef().getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        return 0.0;
    }

    public synchronized ObservableList<Boolean> submit() throws Exception {
        ObservableList returnList = FxUtils.newList();
        CountDownLatch latch = new CountDownLatch(this.orderList.size());
        for (FutureSingleEntrust en : this.orderList) {
            this.exe.execute(() -> {
                try {
                    try {
                        en.submit();
                        returnList.add((Object)true);
                    }
                    catch (MException mException) {
                        returnList.add((Object)false);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        return returnList;
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws Exception, MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        if (secAcct == null) {
            throw new Exception("\u6839\u636e\u8d44\u91d1\u8d26\u53f7\u548c\u6295\u4fdd\u6807\u8bc6\u672a\u80fd\u627e\u5230\u8bc1\u5238\u8d26\u53f7");
        }
        return secAcct;
    }

    private void onPriceStgChange() {
        this.setPrice(this.getHandicapPrice());
    }

    public double getHandicapPrice() {
        if (!this.isBidAskPrice()) {
            return 0.0;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        return new BigDecimal(StringUtils.toPriceStr((double)price, (int)3)).doubleValue();
    }

    public boolean isLimitPrice() {
        return this.getPriceStg().is(Integer.toString(50));
    }

    private void ocFlag(MxNode node) {
        node.removeOthersAndAddThis("70");
        node.addNode("79");
        node.addNode("67");
    }

    public boolean isBidAskPrice() {
        return this.getPriceStg().is("0");
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("0");
    }

    private void initPriceTypeLimit(MxNode node) {
        this.removeOthers(node, "2");
        node.addNode("3");
        node.addNode("5");
    }

    private void initPriceTypeGear(MxNode node) {
        node.removeOthers("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item instanceof CtpRefItem && item.getType().equals("FUT")) {
            return (RefItem)CtpRefItem.class.cast(item);
        }
        if (item != null && item.getType().equals("secTypeArbitrage")) {
            return item;
        }
        return null;
    }

    public void onSecChange() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item.getMarket().equals("")) {
            item.setType("secTypeArbitrage");
            item.setScale(3);
            this.mktItemNew.setRefItem(this.getValidRef());
            this.mktMd.dye(this.mktItemNew);
            this.setName(item.getName());
        } else {
            this.mktItemNew.setRefItem(this.getValidRef());
            this.mktMng.dye(this.mktItem);
            this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
        }
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public final ObjectProperty<MxNode> ocFlagProperty() {
        return this.ocFlag;
    }

    public final MxNode getOcFlag() {
        return (MxNode)this.ocFlagProperty().get();
    }

    public final void setOcFlag(MxNode ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }

    public final StringProperty fundAcctProperty() {
        return this.fundAcct;
    }

    public final String getFundAcct() {
        return (String)this.fundAcctProperty().get();
    }

    public final void setFundAcct(String fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public StringProperty securityProperty() {
        return this.security;
    }

    public String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public final MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public final void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public final ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public final MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public final void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public String getHedgeType() {
        return this.hedgeType;
    }

    public void setHedgeType(String hedgeType) {
        this.hedgeType = hedgeType;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public void setSplitCount(int splitCount) {
        this.splitCount = splitCount;
    }

    public boolean isEnableSplit() {
        return this.enableSplit;
    }

    public void setEnableSplit(boolean enableSplit) {
        this.enableSplit = enableSplit;
    }

    public String getRspInfo() {
        return this.rspInfo;
    }

    public void setRspInfo(String rspInfo) {
        this.rspInfo = rspInfo;
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final LongProperty countProperty() {
        return this.count;
    }

    public final long getCount() {
        return this.countProperty().get();
    }

    public final void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public final MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public final void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public ArbitrageContract getContract() {
        return this.contract;
    }

    public void setContract(ArbitrageContract contract) {
        this.contract = contract;
    }

    public boolean isCloseToday() {
        return this.closeToday;
    }

    public void setCloseToday(boolean closeToday) {
        this.closeToday = closeToday;
    }
}

