/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.models;

import OrsClientApi.OrsClientApiService;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.futures.arbitrage.Data;
import cms.tmx.entity.futures.arbitrage.FutureArbitrageOrderResp;
import cms.tmx.entity.notice.AlgorithmStatusNoticeReport;
import cms.tmx.entity.trade.AlgoCtpOrder;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.CtpOrderModel;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FutureArbitrageOrderModel
extends MxModel {
    @Inject
    public CtpAccountMap accMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected ExecutorService exe;
    @Inject
    private MScheduler scheduler;
    @Inject
    private MScheduler schedulerPush;
    @Inject
    protected CtpOrderModel orderModel;
    protected MxTreeList<AlgoCtpOrder> parentItems;
    protected Map<String, MxTreeList<AlgoCtpOrder>> orderItems = new ConcurrentHashMap<String, MxTreeList<AlgoCtpOrder>>();
    private MxList<AlgoCtpOrder> list = new MxList();
    protected StringProperty searchAlgo = new SimpleStringProperty("");
    protected boolean hasRecord = false;
    protected boolean isInit = false;
    protected Gson gson = new Gson();
    @Inject
    protected IBaseApi baseApi;
    private MEventHandler handler = event -> this.callback(event.getStr("rspInfo"));
    private MEventHandler handlerCancle = event -> this.callbackCancel(event.getStr("rspInfo"));
    private String investorId = "";
    private InvalidationListener orderListener = ob -> this.refresh();
    private String queryErr;
    private TreeItem<AlgoCtpOrder> rootNode = new TreeItem((Object)new AlgoCtpOrder());
    private Map<String, List<AlgoCtpOrder>> map = new ConcurrentHashMap<String, List<AlgoCtpOrder>>();
    protected Predicate<AlgoCtpOrder> pdShow = dist -> {
        String search = this.getSearchAlgo();
        return dist.getAlgoId().contains(search);
    };
    private int cancelNum = 0;
    private String cancelErr = "";

    @PostConstruct
    private void init() {
        this.initAccnts();
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.scheduler.setInterval(1000);
        this.schedulerPush.setInterval(2000);
        this.orderModel.query();
        this.es.subscribe("OnQueryAlgoOrder", this.handler);
        this.es.subscribe("OnCancelAlgoOrder", this.handlerCancle);
        this.searchAlgo.addListener(ob -> this.filterAlgoId());
        this.orderModel.changedProperty().addListener(this.orderListener);
        this.es.subscribe("new.day.requery.data", event -> this.list.clear());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        AlgorithmStatusNoticeReport report;
        Object obj = event.getObj();
        if (obj == null) {
            return;
        }
        if (obj instanceof AlgorithmStatusNoticeReport && !StringUtils.isEmpty((String)(report = (AlgorithmStatusNoticeReport)AlgorithmStatusNoticeReport.class.cast(obj)).getReport().getExtAccntId()) && report.getReport().getExtAccntId().equals(this.baseApi.getUserId())) {
            ObservableList observableList = this.list.getList();
            synchronized (observableList) {
                this.list.getList().forEach(algo -> {
                    if (algo.getAlgoId().equals(report.getReport().getAlgoSysOrderId())) {
                        algo.getAlgoStatus().setRaw(Integer.toString(report.getReport().getBaseOrderStatus().getNumber()));
                        algo.setStatusValue(algo.getAlgoStatus().getValue());
                    }
                });
                Platform.runLater(() -> this.refreshTree());
            }
        }
    }

    private void initAccnts() {
        this.investorId = this.baseApi.getUserId();
    }

    public void algoQuery() {
        this.initAccnts();
        if (StringUtils.isEmpty((String)this.investorId)) {
            return;
        }
        this.scheduler.schedule(e -> this.query("", this.investorId));
    }

    public void query(String algoOrderIndexId, String acct) {
        JsonObject para = new JsonObject();
        para.add("operator", (JsonElement)new JsonPrimitive(acct));
        para.add("is_summary", (JsonElement)new JsonPrimitive((Number)0));
        para.add("user_id", (JsonElement)new JsonPrimitive(acct));
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        para.add("uuid", (JsonElement)new JsonPrimitive(uuid));
        if (!algoOrderIndexId.isEmpty()) {
            para.add("algo_order_id_index", (JsonElement)new JsonPrimitive(algoOrderIndexId));
        }
        int reqId = 0;
        int ret = 0;
        String reqInfo = para.toString();
        ret = OrsClientApiService.getInstance().QueryAlgoOrder("b", "", reqId, reqInfo);
        this.logger.info("QueryAlgoOrder. ret = " + ret + "\u6bcd\u5355\u67e5\u8be2uuid:" + uuid);
    }

    public void callback(String rspInfo) {
        this.logger.info("\u7ec4\u5408\u5957\u5229\u67e5\u8be2\u8fd4\u56de\u4fe1\u606f\uff1a" + rspInfo);
        try {
            FutureArbitrageOrderResp response = (FutureArbitrageOrderResp)this.gson.fromJson(rspInfo, FutureArbitrageOrderResp.class);
            if (response.getRet_code() == 0) {
                this.queryErr = "";
                this.logger.info("\u67e5\u8be2\u6210\u529f: " + this.gson.toJson((Object)response.getData()) + "---------------------");
                if (response.getData() != null && response.getData().size() > 0) {
                    for (Data data : response.getData()) {
                        AlgoCtpOrder order = new AlgoCtpOrder();
                        order.update((Object)data);
                        if (this.list.get((MxObject)order) == null) {
                            this.list.add((MxObject)order);
                            continue;
                        }
                        ((AlgoCtpOrder)this.list.get((MxObject)order)).update((Object)order);
                    }
                }
            } else {
                this.queryErr = "\u7ec4\u5408\u5957\u5229\u67e5\u8be2\u5931\u8d25: " + response.getRet_msg() + " \u9519\u8bef\u7801:" + response.getRet_code();
                this.logger.info("\u7ec4\u5408\u5957\u5229\u67e5\u8be2\u5931\u8d25: " + response.getRet_msg() + " \u9519\u8bef\u7801:" + response.getRet_code());
            }
            if (response.getAlgo_order_id_index() != null && !response.getAlgo_order_id_index().isEmpty()) {
                this.query(response.getAlgo_order_id_index(), this.investorId);
            }
        }
        catch (Exception e) {
            this.logger.error("JSON\u89e3\u6790\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
        }
        if (!this.isInit) {
            this.createTree();
        }
        this.refresh();
    }

    private void refresh() {
        this.schedulerPush.schedule(event -> {
            this.buildMap();
            this.refreshTree();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshTree() {
        LinkedList newList = new LinkedList();
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            newList.addAll(this.list.getList());
        }
        this.parentItems.update(newList);
        this.showAll(this.parentItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createTree() {
        if (this.list == null) {
            return;
        }
        LinkedList newList = new LinkedList();
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            if (this.list.getList().size() == 0) {
                return;
            }
            newList.addAll(this.list.getList());
        }
        LinkedList<AlgoCtpOrder> parentList = new LinkedList<AlgoCtpOrder>();
        this.parentItems = new MxTreeList(this.rootNode, this.rootNode.getChildren(), parentList);
        for (AlgoCtpOrder parentOrder : newList) {
            parentList.add(parentOrder);
            this.parentItems.update(parentList);
            List<AlgoCtpOrder> sonOrders = this.map.get(parentOrder.getAlgoId());
            if (sonOrders == null) continue;
            MxTreeList sonMxList = new MxTreeList((TreeItem)this.rootNode.getChildren().get(parentList.size() - 1), ((TreeItem)this.rootNode.getChildren().get(parentList.size() - 1)).getChildren(), sonOrders);
            this.orderItems.put(parentOrder.getAlgoId(), (MxTreeList<AlgoCtpOrder>)sonMxList);
        }
        this.isInit = true;
    }

    private void buildMap() {
    }

    private void filterAlgoId() {
        this.showAll(this.parentItems);
    }

    protected void showAll(MxTreeList<AlgoCtpOrder> distList) {
        if (distList.getOrList() == null) {
            return;
        }
        distList.filter(this.pdShow);
    }

    public void orderCancel(String algoOrderId) {
        if (algoOrderId.isEmpty()) {
            return;
        }
        JsonObject para = new JsonObject();
        para.add("algo_order_id", (JsonElement)new JsonPrimitive(algoOrderId));
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        para.add("uuid", (JsonElement)new JsonPrimitive(uuid));
        System.out.println(uuid);
        para.add("algo_name", (JsonElement)new JsonPrimitive("TFArbitrage"));
        para.add("operator", (JsonElement)new JsonPrimitive(this.investorId));
        int reqId = 0;
        int ret = 0;
        String reqInfo = para.toString();
        ret = OrsClientApiService.getInstance().CancelAlgoOrder("b", algoOrderId, reqId, reqInfo);
        System.out.println("CancelAlgoOrder. ret = " + ret + " \u64a4\u5355UUID:" + uuid);
    }

    private void callbackCancel(String rspInfo) {
        this.logger.info("\u64a4\u5355\u56de\u62a5\u4fe1\u606f\uff1a" + rspInfo);
        Gson gson = new Gson();
        FutureArbitrageOrderResp response = (FutureArbitrageOrderResp)gson.fromJson(rspInfo, FutureArbitrageOrderResp.class);
        if (response.getRet_code() == 0) {
            ++this.cancelNum;
            this.logger.info("\u6bcd\u5355\u53f7\uff1a" + response.getAlgo_order_id_index() + " \u64a4\u5355\u6210\u529f");
            if (this.cancelNum == 0) {
                this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u5355\u6210\u529f");
            }
        } else {
            this.logger.error("\u64a4\u5355\u5931\u8d25:" + response.getRet_msg());
            this.cancelErr = "\u64a4\u5355\u5931\u8d25\uff1a" + response.getRet_msg();
        }
    }

    public final StringProperty searchAlgoProperty() {
        return this.searchAlgo;
    }

    public final String getSearchAlgo() {
        return (String)this.searchAlgoProperty().get();
    }

    public final void setSearchAlgo(String searchAlgo) {
        this.searchAlgoProperty().set((Object)searchAlgo);
    }

    public int getCancelNum() {
        return this.cancelNum;
    }

    public void setCancelNum(int cancelNum) {
        this.cancelNum = cancelNum;
    }

    public String getCancelErr() {
        return this.cancelErr;
    }

    public void setCancelErr(String cancelErr) {
        this.cancelErr = cancelErr;
    }

    public TreeItem<AlgoCtpOrder> getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(TreeItem<AlgoCtpOrder> rootNode) {
        this.rootNode = rootNode;
    }

    public String getQueryErr() {
        return this.queryErr;
    }

    public void setQueryErr(String queryErr) {
        this.queryErr = queryErr;
    }
}

