/*
 * Decompiled with CFR 0.152.
 */
package futures.arbitrage.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.futures.dto.ArbitrageContract;
import cms.tmx.http.futures.dto.FutureContract;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.history.IArbitrageService;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class ArbitrageContractsModel
extends MxModel {
    private List<ArbitrageContract> list = new ArrayList<ArbitrageContract>();
    private List<RefItem> listRefItem = new ArrayList<RefItem>();
    private List<FutureContract> contList = new ArrayList<FutureContract>();
    @Inject
    private IArbitrageService arbitrageServcie;
    @Inject
    private HttpBaseApi httpBaseApi;
    protected Gson gson = new Gson();
    @Inject
    private MEventService es;
    private MEventHandler handler = event -> this.onPush(event);
    private MEventHandler delHandler = event -> this.delOnPush(event);
    private String delConId = "";
    private String updConId = "";
    private String updConName = "";

    @PostConstruct
    private void init() {
        this.queryContract();
        this.transferToRefItem();
        this.es.subscribe("uap.push.ArbitrageEvent", this.handler);
        this.es.subscribe("uap.push.DeleteArbitrageEvent", this.delHandler);
    }

    private void delOnPush(MEvent event) {
        if (event.isEmpty()) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        String delId = obj.getAsString();
        if (delId.contains("_")) {
            String beforeId = delId.substring(0, delId.indexOf("_"));
            this.delConId = delId.substring(beforeId.length() + 1, delId.length());
        }
        this.updConId = "";
        for (ArbitrageContract arbitrage : this.list) {
            if (!this.delConId.equals(arbitrage.getContractId())) continue;
            this.list.remove(arbitrage);
            this.listRefItem.clear();
            this.contList.clear();
            this.transferToRefItem();
            return;
        }
    }

    private void onPush(MEvent event) {
        if (event.isEmpty()) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        ArbitrageContract newArbitrage = (ArbitrageContract)this.gson.fromJson(obj.getAsString(), ArbitrageContract.class);
        if (newArbitrage.getContractId().isEmpty()) {
            return;
        }
        this.listRefItem.clear();
        this.contList.clear();
        for (ArbitrageContract arbitrage : this.list) {
            if (!arbitrage.getContractId().equals(newArbitrage.getContractId())) continue;
            this.updConId = newArbitrage.getContractId();
            this.updConName = newArbitrage.getContractName();
            arbitrage.update(newArbitrage);
            this.logger.error("\u66f4\u65b0\u5408\u7ea6\uff1a" + arbitrage.getContractId());
            this.transferToRefItem();
            return;
        }
        this.delConId = "";
        this.list.add(newArbitrage);
        this.logger.error("\u65b0\u589e\u5408\u7ea6:" + newArbitrage.getContractId());
        this.transferToRefItem();
    }

    public void queryContract() {
        String userId = this.httpBaseApi.getHttpOpUser().getUserId();
        String pageNum = "1";
        String pageSize = "200";
        LinkedList<ArbitrageContract> arbitrageContracts = new LinkedList();
        try {
            arbitrageContracts = this.arbitrageServcie.getArbitrageContracts(userId, pageNum, pageSize);
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e, e);
            e.printStackTrace();
        }
        if (arbitrageContracts == null) {
            return;
        }
        this.setList(arbitrageContracts);
    }

    public void transferToRefItem() {
        for (ArbitrageContract contract : this.list) {
            RefItem item = new RefItem();
            item.setCode(contract.getContractId());
            item.setConId(contract.getConId());
            item.setName(contract.getContractName());
            item.setPriceUnit(0.005);
            item.setScale(3);
            this.listRefItem.add(item);
            FutureContract cont = new FutureContract();
            cont.setCode(contract.getContractId());
            cont.setName(contract.getContractName());
            cont.setPriceFormula(contract.getPriceFormula());
            cont.setContractTickSize(contract.getContractTickSize());
            this.contList.add(cont);
        }
        this.changed();
    }

    public List<ArbitrageContract> getList() {
        return this.list;
    }

    public void setList(List<ArbitrageContract> list) {
        this.list = list;
    }

    public List<RefItem> getListRefItem() {
        return this.listRefItem;
    }

    public void setListRefItem(List<RefItem> listRefItem) {
        this.listRefItem = listRefItem;
    }

    public String getDelConId() {
        return this.delConId;
    }

    public void setDelConId(String delConId) {
        this.delConId = delConId;
    }

    public String getUpdConId() {
        return this.updConId;
    }

    public void setUpdConId(String updConId) {
        this.updConId = updConId;
    }

    public String getUpdConName() {
        return this.updConName;
    }

    public void setUpdConName(String updConName) {
        this.updConName = updConName;
    }

    public List<FutureContract> getContList() {
        return this.contList;
    }

    public void setContList(List<FutureContract> contList) {
        this.contList = contList;
    }
}

