/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation.strategy;

import cms.tmx.entity.data.MarketItem;
import com.cmschina.ficc.aggregation.IdentifyValueCalculator;
import com.cmschina.ficc.aggregation.constants.EIdentifier;
import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import com.cmschina.ficc.aggregation.strategy.AbstractStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;

public class ApproximatePriceStrategy
extends AbstractStrategy<MarketItem, Pair<Double, Integer>> {
    public ApproximatePriceStrategy(IdentifyValueCalculator calculator) {
        super(calculator);
    }

    @Override
    protected Pair<Double, Integer> start(AbstractStrategy.INode start, MarketItem marketData) throws AggregationError {
        AbstractStrategy.INode curr = start;
        double price = -1.0;
        int qty = -1;
        while (curr != null) {
            EIdentifier price_identifier;
            if (curr instanceof AbstractStrategy.Node) {
                price_identifier = ((AbstractStrategy.Node)curr).getValue();
                price = this.calculator.calcValue(price_identifier, marketData);
                if (price <= 0.0) {
                    curr = ((AbstractStrategy.Node)curr).getNext();
                    continue;
                }
                EIdentifier qty_identifier = EIdentifier.getMapedQty(price_identifier);
                qty = qty_identifier == null ? -1 : (int)this.calculator.calcValue(qty_identifier, marketData);
                return new Pair((Object)price, (Object)qty);
            }
            if (curr instanceof AbstractStrategy.ListNode) {
                List<AbstractStrategy.Node> nodes = ((AbstractStrategy.ListNode)curr).getNodes();
                for (AbstractStrategy.Node node : nodes) {
                    price_identifier = node.getValue();
                    price = this.calculator.calcValue(price_identifier, marketData);
                    if (price <= 0.0) continue;
                    EIdentifier qty_identifier = EIdentifier.getMapedQty(price_identifier);
                    qty = qty_identifier == null ? -1 : (int)this.calculator.calcValue(qty_identifier, marketData);
                    return new Pair((Object)price, (Object)qty);
                }
                curr = ((AbstractStrategy.ListNode)curr).getNext();
                continue;
            }
            throw new AggregationError(CmsErrorCodes.ERR_STRATEGY_APPROXIMATE_INVALID_STRATEGY_NODE);
        }
        throw new AggregationError(CmsErrorCodes.ERR_STRATEGY_APPROXIMATE_FAILED);
    }

    @Override
    protected Map<EIdentifier, AbstractStrategy.INode> initStrategy() {
        ConcurrentHashMap<EIdentifier, AbstractStrategy.INode> map = new ConcurrentHashMap<EIdentifier, AbstractStrategy.INode>();
        map.put(EIdentifier.AVG, this.createNode(EIdentifier.AVG, null));
        map.put(EIdentifier.PREV, this.createNode(EIdentifier.PREV, null));
        map.put(EIdentifier.LAST, this.createNode(EIdentifier.LAST, (AbstractStrategy.INode)map.get((Object)EIdentifier.PREV)));
        AbstractStrategy.ListNode node = this.createListNode(Arrays.asList(this.createNode(EIdentifier.ASK_1, null), this.createNode(EIdentifier.BID_1, null)), (AbstractStrategy.INode)map.get((Object)EIdentifier.LAST));
        map.put(EIdentifier.ASK_1, node);
        AbstractStrategy.ListNode nodeBid = this.createListNode(Arrays.asList(this.createNode(EIdentifier.BID_1, null), this.createNode(EIdentifier.ASK_1, null)), (AbstractStrategy.INode)map.get((Object)EIdentifier.LAST));
        map.put(EIdentifier.BID_1, nodeBid);
        map.put(EIdentifier.ASK_2, this.createNode(EIdentifier.ASK_2, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_1)));
        map.put(EIdentifier.ASK_3, this.createNode(EIdentifier.ASK_3, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_2)));
        map.put(EIdentifier.ASK_4, this.createNode(EIdentifier.ASK_4, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_3)));
        map.put(EIdentifier.ASK_5, this.createNode(EIdentifier.ASK_5, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_4)));
        map.put(EIdentifier.ASK_6, this.createNode(EIdentifier.ASK_6, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_5)));
        map.put(EIdentifier.ASK_7, this.createNode(EIdentifier.ASK_7, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_6)));
        map.put(EIdentifier.ASK_8, this.createNode(EIdentifier.ASK_8, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_7)));
        map.put(EIdentifier.ASK_9, this.createNode(EIdentifier.ASK_9, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_8)));
        map.put(EIdentifier.ASK_10, this.createNode(EIdentifier.ASK_10, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_9)));
        map.put(EIdentifier.BID_2, this.createNode(EIdentifier.BID_2, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_1)));
        map.put(EIdentifier.BID_3, this.createNode(EIdentifier.BID_3, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_2)));
        map.put(EIdentifier.BID_4, this.createNode(EIdentifier.BID_4, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_3)));
        map.put(EIdentifier.BID_5, this.createNode(EIdentifier.BID_5, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_4)));
        map.put(EIdentifier.BID_6, this.createNode(EIdentifier.BID_6, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_5)));
        map.put(EIdentifier.BID_7, this.createNode(EIdentifier.BID_7, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_6)));
        map.put(EIdentifier.BID_8, this.createNode(EIdentifier.BID_8, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_7)));
        map.put(EIdentifier.BID_9, this.createNode(EIdentifier.BID_9, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_8)));
        map.put(EIdentifier.BID_10, this.createNode(EIdentifier.BID_10, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_9)));
        map.put(EIdentifier.BID_QTY_1, this.createNode(EIdentifier.BID_QTY_1, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_1)));
        map.put(EIdentifier.BID_QTY_2, this.createNode(EIdentifier.BID_QTY_2, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_2)));
        map.put(EIdentifier.BID_QTY_3, this.createNode(EIdentifier.BID_QTY_3, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_3)));
        map.put(EIdentifier.BID_QTY_4, this.createNode(EIdentifier.BID_QTY_4, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_4)));
        map.put(EIdentifier.BID_QTY_5, this.createNode(EIdentifier.BID_QTY_5, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_5)));
        map.put(EIdentifier.BID_QTY_6, this.createNode(EIdentifier.BID_QTY_6, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_6)));
        map.put(EIdentifier.BID_QTY_7, this.createNode(EIdentifier.BID_QTY_7, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_7)));
        map.put(EIdentifier.BID_QTY_8, this.createNode(EIdentifier.BID_QTY_8, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_8)));
        map.put(EIdentifier.BID_QTY_9, this.createNode(EIdentifier.BID_QTY_9, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_9)));
        map.put(EIdentifier.BID_QTY_10, this.createNode(EIdentifier.BID_QTY_10, (AbstractStrategy.INode)map.get((Object)EIdentifier.BID_QTY_10)));
        map.put(EIdentifier.ASK_QTY_1, this.createNode(EIdentifier.ASK_QTY_1, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_1)));
        map.put(EIdentifier.ASK_QTY_2, this.createNode(EIdentifier.ASK_QTY_2, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_2)));
        map.put(EIdentifier.ASK_QTY_3, this.createNode(EIdentifier.ASK_QTY_3, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_3)));
        map.put(EIdentifier.ASK_QTY_4, this.createNode(EIdentifier.ASK_QTY_4, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_4)));
        map.put(EIdentifier.ASK_QTY_5, this.createNode(EIdentifier.ASK_QTY_5, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_5)));
        map.put(EIdentifier.ASK_QTY_6, this.createNode(EIdentifier.ASK_QTY_6, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_6)));
        map.put(EIdentifier.ASK_QTY_7, this.createNode(EIdentifier.ASK_QTY_7, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_7)));
        map.put(EIdentifier.ASK_QTY_8, this.createNode(EIdentifier.ASK_QTY_8, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_8)));
        map.put(EIdentifier.ASK_QTY_9, this.createNode(EIdentifier.ASK_QTY_9, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_9)));
        map.put(EIdentifier.ASK_QTY_10, this.createNode(EIdentifier.ASK_QTY_10, (AbstractStrategy.INode)map.get((Object)EIdentifier.ASK_QTY_10)));
        return map;
    }
}

