/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation.strategy;

import com.cmschina.ficc.aggregation.IdentifyValueCalculator;
import com.cmschina.ficc.aggregation.constants.EIdentifier;
import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import com.cmschina.ficc.aggregation.strategy.IStrategy;
import java.util.List;
import java.util.Map;

public abstract class AbstractStrategy<MarketItem, R>
implements IStrategy<MarketItem, EIdentifier, R> {
    private MapNode init_node = this.createMapNode(this.initStrategy(), null);
    private INode current_node;
    protected IdentifyValueCalculator calculator;

    public AbstractStrategy(IdentifyValueCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public R processStrategy(EIdentifier start, MarketItem marketData) throws AggregationError {
        if (start == null || marketData == null) {
            throw new AggregationError(CmsErrorCodes.ERR_STRATEGY_MISSING_PARAM);
        }
        this.current_node = this.init_node.computeWithDefaultNull(start);
        if (this.current_node == null) {
            throw new AggregationError(CmsErrorCodes.ERR_STRATEGY_INVALID_PARAM);
        }
        return this.start(this.current_node, marketData);
    }

    protected abstract R start(INode var1, MarketItem var2) throws AggregationError;

    protected abstract Map<EIdentifier, INode> initStrategy();

    public Node createNode(EIdentifier value, INode next) {
        return new Node(value, next);
    }

    public ListNode createListNode(List<Node> nodes, INode next) {
        return new ListNode(nodes, next);
    }

    public MapNode createMapNode(Map<EIdentifier, INode> map, INode next) {
        return new MapNode(map, next);
    }

    static interface INode {
        public INode getNext();
    }

    static class ListNode
    implements INode {
        private final List<Node> nodes;
        private final INode next;
        private int index = 0;

        public ListNode(List<Node> nodes, INode next) {
            this.nodes = nodes;
            this.next = next;
        }

        public int getIndex() {
            return this.index;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        @Override
        public INode getNext() {
            return this.next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ListNode:{").append("nodes = ").append(this.getNodes()).append(", next = ").append(this.getNext()).append(", index = ").append(this.getIndex()).append("}");
            return sb.toString();
        }
    }

    static class MapNode
    implements INode {
        private final Map<EIdentifier, INode> nodeMap;
        private final INode next;

        public MapNode(Map<EIdentifier, INode> nodeMap, INode next) {
            this.nodeMap = nodeMap;
            this.next = next;
        }

        public INode computeWithDefaultNull(EIdentifier identifier) {
            return this.nodeMap.getOrDefault((Object)identifier, null);
        }

        @Override
        public INode getNext() {
            return this.next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MapNode:{").append("nodeMap = ").append(this.nodeMap).append(", next = ").append(this.getNext()).append("}");
            return sb.toString();
        }
    }

    static class Node
    implements INode {
        private final EIdentifier value;
        private final INode next;

        public Node(EIdentifier value, INode next) {
            this.value = value;
            this.next = next;
        }

        public EIdentifier getValue() {
            return this.value;
        }

        @Override
        public INode getNext() {
            return this.next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node:{ value = ").append((Object)this.getValue()).append("}");
            return sb.toString();
        }
    }
}

