/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation.errorcode;

import java.util.HashMap;
import java.util.Map;

public class ErrorCode {
    private static Map<String, ErrorCode> allErrors = new HashMap<String, ErrorCode>();
    protected String errorCode = "Cms";
    protected String errorMessage = "";
    protected String toString = "Error";

    public ErrorCode(String errorCate, int errorCode, String errorMessage) {
        this.errorCode = "CMS-" + errorCate + "-" + String.format("%4d", errorCode).replace(' ', '0');
        this.errorMessage = errorMessage;
        this.toString = String.valueOf(this.errorCode) + "(" + this.errorMessage + ")";
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.toString;
    }

    private static void register(ErrorCode code) {
        if (allErrors.containsKey(code.getErrorCode())) {
            System.err.println("Duplicate error code" + code.toString);
        }
        allErrors.put(code.getErrorCode(), code);
    }

    public static ErrorCode getErrorCode(String code) {
        return allErrors.get(code);
    }
}

