/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation.constants;

import com.cmschina.ficc.aggregation.constants.IdentifyType;

public enum EIdentifier {
    AVG(IdentifyType.PRICE, "AVG"),
    PREV(IdentifyType.PRICE, "PREV"),
    LAST(IdentifyType.PRICE, "LAST"),
    LAST_QTY(IdentifyType.QUANTITY, "LAST_QTY"),
    VOLUME(IdentifyType.QUANTITY, "VOLUME"),
    TURNOVER(IdentifyType.QUANTITY, "TURNOVER"),
    LAST_FILL_PRICE(IdentifyType.PRICE, "LAST_FILL_PRICE"),
    LAST_FILL_QTY(IdentifyType.QUANTITY, "LAST_FILL_QTY"),
    BID_1(IdentifyType.PRICE, "BID_1"),
    BID_2(IdentifyType.PRICE, "BID_2"),
    BID_3(IdentifyType.PRICE, "BID_3"),
    BID_4(IdentifyType.PRICE, "BID_4"),
    BID_5(IdentifyType.PRICE, "BID_5"),
    BID_6(IdentifyType.PRICE, "BID_6"),
    BID_7(IdentifyType.PRICE, "BID_7"),
    BID_8(IdentifyType.PRICE, "BID_8"),
    BID_9(IdentifyType.PRICE, "BID_9"),
    BID_10(IdentifyType.PRICE, "BID_10"),
    BID_QTY_1(IdentifyType.QUANTITY, "BID_QTY_1"),
    BID_QTY_2(IdentifyType.QUANTITY, "BID_QTY_2"),
    BID_QTY_3(IdentifyType.QUANTITY, "BID_QTY_3"),
    BID_QTY_4(IdentifyType.QUANTITY, "BID_QTY_4"),
    BID_QTY_5(IdentifyType.QUANTITY, "BID_QTY_5"),
    BID_QTY_6(IdentifyType.QUANTITY, "BID_QTY_6"),
    BID_QTY_7(IdentifyType.QUANTITY, "BID_QTY_7"),
    BID_QTY_8(IdentifyType.QUANTITY, "BID_QTY_8"),
    BID_QTY_9(IdentifyType.QUANTITY, "BID_QTY_9"),
    BID_QTY_10(IdentifyType.QUANTITY, "BID_QTY_10"),
    ASK_1(IdentifyType.PRICE, "ASK_1"),
    ASK_2(IdentifyType.PRICE, "ASK_2"),
    ASK_3(IdentifyType.PRICE, "ASK_3"),
    ASK_4(IdentifyType.PRICE, "ASK_4"),
    ASK_5(IdentifyType.PRICE, "ASK_5"),
    ASK_6(IdentifyType.PRICE, "ASK_6"),
    ASK_7(IdentifyType.PRICE, "ASK_7"),
    ASK_8(IdentifyType.PRICE, "ASK_8"),
    ASK_9(IdentifyType.PRICE, "ASK_9"),
    ASK_10(IdentifyType.PRICE, "ASK_10"),
    ASK_QTY_1(IdentifyType.QUANTITY, "ASK_QTY_1"),
    ASK_QTY_2(IdentifyType.QUANTITY, "ASK_QTY_2"),
    ASK_QTY_3(IdentifyType.QUANTITY, "ASK_QTY_3"),
    ASK_QTY_4(IdentifyType.QUANTITY, "ASK_QTY_4"),
    ASK_QTY_5(IdentifyType.QUANTITY, "ASK_QTY_5"),
    ASK_QTY_6(IdentifyType.QUANTITY, "ASK_QTY_6"),
    ASK_QTY_7(IdentifyType.QUANTITY, "ASK_QTY_7"),
    ASK_QTY_8(IdentifyType.QUANTITY, "ASK_QTY_8"),
    ASK_QTY_9(IdentifyType.QUANTITY, "ASK_QTY_9"),
    ASK_QTY_10(IdentifyType.QUANTITY, "ASK_QTY_10");

    private String value;
    private int index;
    private IdentifyType type;

    private EIdentifier(IdentifyType type, String value) {
        this.value = value;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public IdentifyType getType() {
        return this.type;
    }

    public static EIdentifier getMapedQty(EIdentifier priceIdentify) {
        if (priceIdentify.getType() != IdentifyType.PRICE) {
            return null;
        }
        switch (priceIdentify) {
            case ASK_1: {
                return ASK_QTY_1;
            }
            case ASK_2: {
                return ASK_QTY_2;
            }
            case ASK_3: {
                return ASK_QTY_3;
            }
            case ASK_4: {
                return ASK_QTY_4;
            }
            case ASK_5: {
                return ASK_QTY_5;
            }
            case ASK_6: {
                return ASK_QTY_6;
            }
            case ASK_7: {
                return ASK_QTY_7;
            }
            case ASK_8: {
                return ASK_QTY_8;
            }
            case ASK_9: {
                return ASK_QTY_9;
            }
            case ASK_10: {
                return ASK_QTY_10;
            }
            case BID_1: {
                return BID_QTY_1;
            }
            case BID_2: {
                return BID_QTY_2;
            }
            case BID_3: {
                return BID_QTY_3;
            }
            case BID_4: {
                return BID_QTY_4;
            }
            case BID_5: {
                return BID_QTY_5;
            }
            case BID_6: {
                return BID_QTY_6;
            }
            case BID_7: {
                return BID_QTY_7;
            }
            case BID_8: {
                return BID_QTY_8;
            }
            case BID_9: {
                return BID_QTY_9;
            }
            case BID_10: {
                return BID_QTY_10;
            }
            case LAST: {
                return LAST_QTY;
            }
            case LAST_FILL_PRICE: {
                return LAST_FILL_QTY;
            }
        }
        return null;
    }

    public static EIdentifier getMapedPrice(EIdentifier qtyIdentify) {
        if (qtyIdentify.getType() != IdentifyType.QUANTITY) {
            return null;
        }
        switch (qtyIdentify) {
            case ASK_QTY_1: {
                return ASK_1;
            }
            case ASK_QTY_2: {
                return ASK_2;
            }
            case ASK_QTY_3: {
                return ASK_3;
            }
            case ASK_QTY_4: {
                return ASK_4;
            }
            case ASK_QTY_5: {
                return ASK_5;
            }
            case ASK_QTY_6: {
                return ASK_6;
            }
            case ASK_QTY_7: {
                return ASK_7;
            }
            case ASK_QTY_8: {
                return ASK_8;
            }
            case ASK_QTY_9: {
                return ASK_9;
            }
            case ASK_QTY_10: {
                return ASK_10;
            }
            case BID_QTY_1: {
                return BID_1;
            }
            case BID_QTY_2: {
                return BID_2;
            }
            case BID_QTY_3: {
                return BID_3;
            }
            case BID_QTY_4: {
                return BID_4;
            }
            case BID_QTY_5: {
                return BID_5;
            }
            case BID_QTY_6: {
                return BID_6;
            }
            case BID_QTY_7: {
                return BID_7;
            }
            case BID_QTY_8: {
                return BID_8;
            }
            case BID_QTY_9: {
                return BID_9;
            }
            case BID_QTY_10: {
                return BID_10;
            }
            case LAST_QTY: {
                return LAST;
            }
            case LAST_FILL_QTY: {
                return LAST_FILL_PRICE;
            }
        }
        return null;
    }
}

