/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation;

import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Parser {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int CONTRACT_IDENTIFY = 2;
    private static final int[] ZZ_LEXSTATE;
    private static final String ZZ_CMAP_PACKED = "\u0001\f\u0007\u0000\u0003\u0001\u0015\u0000\u0001\u0001\u0007\u0000\u0001\u0006\u0001\u0007\u0001\u0002\u0001\u0002\u0001\u0000\u0001\u0002\u0001\u0003\u0001\u0002\u0001\u0004\t\u0005\u0007\u0000\u001a\n\u0001\b\u0001\u0000\u0001\t\u0001\u0000\u0001\u000b\u0001\u0000\u001a\n\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uff95\u0000";
    private static final char[] ZZ_CMAP;
    private static final int[] ZZ_ACTION;
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0001\u0006\u0001\u0001\u0001\u0007\u0001\u0001\u0002\u0000\u0001\b\u0001\u0004\u0001\t\u0001\u0000";
    private static final int[] ZZ_ROWMAP;
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\r\u0000\u001a\u0000\u001a\u0000\u001a\u0000'\u00004\u0000\u001a\u0000\u001a\u0000A\u0000\u001a\u0000N\u0000[\u0000h\u0000u\u0000[\u0000\u001a\u0000\u0082";
    private static final int[] ZZ_TRANS;
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0003\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0003\u0003\u0001\u000b\u0003\u0003\u0001\f\t\u0003\u0010\u0000\u0001\r\f\u0000\u0001\r\u0002\u0007\u000b\u0000\u0002\u000e\u0004\u0000\u0001\u000e\f\u0000\u0001\u000f\u0006\u0000\u0002\u0010\u000b\u0000\u0002\u000e\u0003\u0000\u0001\u0011\u0001\u000e\u0006\u0000\u0002\u000f\u0004\u0000\u0001\u000f\u0001\u0012\u0005\u0000\u0002\u000f\u0004\u0000\u0001\u000f\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG;
    private static final int[] ZZ_ATTRIBUTE;
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0003\t\u0002\u0001\u0002\t\u0001\u0001\u0001\t\u0001\u0001\u0002\u0000\u0002\u0001\u0001\t\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private List<Token> tokens;
    private String contract;

    static {
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 1;
        ZZ_LEXSTATE = nArray;
        ZZ_CMAP = Parser.zzUnpackCMap(ZZ_CMAP_PACKED);
        ZZ_ACTION = Parser.zzUnpackAction();
        ZZ_ROWMAP = Parser.zzUnpackRowMap();
        ZZ_TRANS = Parser.zzUnpackTrans();
        ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
        ZZ_ATTRIBUTE = Parser.zzUnpackAttribute();
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[18];
        int offset = 0;
        offset = Parser.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[18];
        int offset = 0;
        offset = Parser.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[143];
        int offset = 0;
        offset = Parser.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[18];
        int offset = 0;
        offset = Parser.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public static void main(String[] args) {
        String expression = "3+4";
        Parser scanner = new Parser();
        try {
            System.out.println(scanner.parse(expression));
        }
        catch (AggregationError e) {
            System.out.println(e);
        }
    }

    public Parser() {
    }

    public List<Token> parse(String expression) throws AggregationError {
        if (expression == null || expression.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        this.tokens = new ArrayList<Token>();
        this.zzReader = new StringReader(String.valueOf(expression) + "\u0000");
        try {
            Token token;
            while ((token = this.yylex()) != null) {
                this.tokens.add(token);
            }
        }
        catch (IOException e) {
            throw new AggregationError(CmsErrorCodes.ERR_PARSE_IO, e.getMessage());
        }
        return this.tokens;
    }

    public Parser(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 84) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Token yylex() throws IOException, AggregationError {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block25: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            int zzCurrentPosL = this.zzStartRead;
            while (zzCurrentPosL < zzMarkedPosL) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                int zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        zzR = false;
                        break;
                    }
                    case 13: {
                        ++this.yyline;
                        zzR = true;
                        break;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            break;
                        }
                        ++this.yyline;
                        break;
                    }
                    default: {
                        zzR = false;
                    }
                }
                zzCurrentPosL += zzCharCount;
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    throw new AggregationError(CmsErrorCodes.ERR_PARSE_INVALID_INPUT, "\u5206\u8bcd\u5931\u8d25,\u7d22\u5f15:" + this.yychar + ", \u5f53\u524d\u5b57\u7b26:" + this.yytext());
                }
                case 10: {
                    continue block25;
                }
                case 2: {
                    System.out.println("Skip white space");
                }
                case 11: {
                    continue block25;
                }
                case 3: {
                    return new Token(TOKEN_TYPE.OPERATOR, this.yytext());
                }
                case 12: {
                    continue block25;
                }
                case 4: {
                    return new Token(TOKEN_TYPE.REAL, this.yytext());
                }
                case 13: {
                    continue block25;
                }
                case 5: {
                    return new Token(TOKEN_TYPE.LP, this.yytext());
                }
                case 14: {
                    continue block25;
                }
                case 6: {
                    return new Token(TOKEN_TYPE.RP, this.yytext());
                }
                case 15: {
                    continue block25;
                }
                case 7: {
                    return null;
                }
                case 16: {
                    continue block25;
                }
                case 8: {
                    this.yybegin(0);
                    return new IdentifyToken(TOKEN_TYPE.IDENTIFY, this.yytext().substring(1, this.yylength()), this.contract);
                }
                case 17: {
                    continue block25;
                }
                case 9: {
                    this.yybegin(2);
                    this.contract = this.yytext().substring(1, this.yylength() - 1);
                }
                case 18: {
                    continue block25;
                }
            }
            this.zzScanError(1);
        }
    }

    public static enum EPARSE_ERR_TYPE {
        ERR_IO,
        ERR_INVALID_INPUT;

    }

    public class IdentifyToken
    extends Token {
        private String contract;

        public IdentifyToken(TOKEN_TYPE type, String value, String contract) {
            super(type, value);
            this.contract = contract;
        }

        public String getContract() {
            return this.contract;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("IdentifyToken:{").append("Contract = ").append(this.getContract()).append(", ").append(super.toString()).append("}");
            return sb.toString();
        }
    }

    public static enum TOKEN_TYPE {
        REAL,
        OPERATOR,
        LP,
        RP,
        IDENTIFY;

    }

    public class Token {
        private TOKEN_TYPE type;
        private String value;

        public Token(TOKEN_TYPE type, String value) {
            this.type = type;
            this.value = value;
        }

        public TOKEN_TYPE getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Token:{").append("Type = ").append((Object)this.getType()).append(", Value = ").append(this.getValue()).append("}");
            return sb.toString();
        }
    }
}

