/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation;

import cms.tmx.entity.data.MarketItem;
import com.cmschina.ficc.aggregation.constants.EIdentifier;
import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import com.cmschina.ficc.aggregation.strategy.ApproximatePriceStrategy;
import com.cmschina.ficc.aggregation.strategy.IStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javafx.util.Pair;

public class IdentifyValueCalculator {
    private final Map<EIdentifier, Function<MarketItem, Double>> property_map = new ConcurrentHashMap<EIdentifier, Function<MarketItem, Double>>();
    private IStrategy<MarketItem, EIdentifier, Pair<Double, Integer>> approximateStrategy = new ApproximatePriceStrategy(this);
    private double lastFillPrice = -1.0;
    private double lastFillQty = -1.0;

    public IdentifyValueCalculator() {
        this.property_map.put(EIdentifier.AVG, data -> data.getAvgPrice());
        this.property_map.put(EIdentifier.PREV, data -> data.getClosePrice());
        this.property_map.put(EIdentifier.LAST, data -> data.getNowPrice());
        this.property_map.put(EIdentifier.LAST_QTY, markData -> 0.0);
        this.property_map.put(EIdentifier.VOLUME, markData -> 0.0);
        this.property_map.put(EIdentifier.TURNOVER, markData -> 0.0);
        this.property_map.put(EIdentifier.LAST_FILL_PRICE, markData -> this.lastFillPrice);
        this.property_map.put(EIdentifier.LAST_FILL_QTY, markData -> this.lastFillQty);
        this.property_map.put(EIdentifier.BID_1, data -> data.getBuyPrice(0));
        this.property_map.put(EIdentifier.BID_2, data -> data.getBuyPrice(1));
        this.property_map.put(EIdentifier.BID_3, data -> data.getBuyPrice(2));
        this.property_map.put(EIdentifier.BID_4, data -> data.getBuyPrice(3));
        this.property_map.put(EIdentifier.BID_5, data -> data.getBuyPrice(4));
        this.property_map.put(EIdentifier.BID_6, data -> data.getBuyPrice(5));
        this.property_map.put(EIdentifier.BID_7, data -> data.getBuyPrice(6));
        this.property_map.put(EIdentifier.BID_8, data -> data.getBuyPrice(7));
        this.property_map.put(EIdentifier.BID_9, data -> data.getBuyPrice(8));
        this.property_map.put(EIdentifier.BID_10, data -> data.getBuyPrice(9));
        this.property_map.put(EIdentifier.BID_QTY_1, data -> data.getBuyCount(0));
        this.property_map.put(EIdentifier.BID_QTY_2, data -> data.getBuyCount(1));
        this.property_map.put(EIdentifier.BID_QTY_3, data -> data.getBuyCount(2));
        this.property_map.put(EIdentifier.BID_QTY_4, data -> data.getBuyCount(3));
        this.property_map.put(EIdentifier.BID_QTY_5, data -> data.getBuyCount(4));
        this.property_map.put(EIdentifier.BID_QTY_6, data -> data.getBuyCount(5));
        this.property_map.put(EIdentifier.BID_QTY_7, data -> data.getBuyCount(6));
        this.property_map.put(EIdentifier.BID_QTY_8, data -> data.getBuyCount(7));
        this.property_map.put(EIdentifier.BID_QTY_9, data -> data.getBuyCount(8));
        this.property_map.put(EIdentifier.BID_QTY_10, data -> data.getBuyCount(9));
        this.property_map.put(EIdentifier.ASK_1, data -> data.getSellPrice(0));
        this.property_map.put(EIdentifier.ASK_2, data -> data.getSellPrice(1));
        this.property_map.put(EIdentifier.ASK_3, data -> data.getSellPrice(2));
        this.property_map.put(EIdentifier.ASK_4, data -> data.getSellPrice(3));
        this.property_map.put(EIdentifier.ASK_5, data -> data.getSellPrice(4));
        this.property_map.put(EIdentifier.ASK_6, data -> data.getSellPrice(5));
        this.property_map.put(EIdentifier.ASK_7, data -> data.getSellPrice(6));
        this.property_map.put(EIdentifier.ASK_8, data -> data.getSellPrice(7));
        this.property_map.put(EIdentifier.ASK_9, data -> data.getSellPrice(8));
        this.property_map.put(EIdentifier.ASK_10, data -> data.getSellPrice(9));
        this.property_map.put(EIdentifier.ASK_QTY_1, data -> data.getSellCount(0));
        this.property_map.put(EIdentifier.ASK_QTY_2, data -> data.getSellCount(1));
        this.property_map.put(EIdentifier.ASK_QTY_3, data -> data.getSellCount(2));
        this.property_map.put(EIdentifier.ASK_QTY_4, data -> data.getSellCount(3));
        this.property_map.put(EIdentifier.ASK_QTY_5, data -> data.getSellCount(4));
        this.property_map.put(EIdentifier.ASK_QTY_6, data -> data.getSellCount(5));
        this.property_map.put(EIdentifier.ASK_QTY_7, data -> data.getSellCount(6));
        this.property_map.put(EIdentifier.ASK_QTY_8, data -> data.getSellCount(7));
        this.property_map.put(EIdentifier.ASK_QTY_9, data -> data.getSellCount(8));
        this.property_map.put(EIdentifier.ASK_QTY_10, data -> data.getSellCount(9));
    }

    protected void updateLastFillPrice(double lastFillPrice) {
        this.lastFillPrice = lastFillPrice;
    }

    protected void updateLastFillQty(double lastFillQty) {
        this.lastFillQty = lastFillQty;
    }

    public double calcValue(EIdentifier identifier, MarketItem marketData) throws AggregationError {
        Function<MarketItem, Double> f = this.property_map.get((Object)identifier);
        if (f == null) {
            throw new AggregationError(CmsErrorCodes.ERR_CALC_ACQUIRE_IDENTIFIER_VALUE);
        }
        return f.apply(marketData);
    }

    protected Pair<Double, Integer> calcValueWithApproximateStrategy(EIdentifier identifier, MarketItem marketData) throws AggregationError {
        return this.approximateStrategy.processStrategy(identifier, marketData);
    }
}

