/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation;

import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.futures.FuturesUtils;
import cmx.tmx.data.IRefDataMng;
import com.cmschina.ficc.aggregation.AbstractExpressionCalculator;
import com.cmschina.ficc.aggregation.FalseRuleResult;
import com.cmschina.ficc.aggregation.Parser;
import com.cmschina.ficc.aggregation.RuleResult;
import com.cmschina.ficc.aggregation.TrueRuleResult;
import com.cmschina.ficc.aggregation.constants.EIdentifier;
import com.cmschina.ficc.aggregation.constants.EStrategy;
import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ExpressionCalculator
extends AbstractExpressionCalculator {
    @Inject
    private IRefDataMng refMng;
    private List<RefItem> nationalRefList = null;
    private Map<String, RefItem> mapCodeRef = new HashMap<String, RefItem>();
    private Map<String, List<Parser.Token>> mapExpressionTokens = new ConcurrentHashMap<String, List<Parser.Token>>();

    @PostConstruct
    private void init() {
        this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        for (RefItem item : this.nationalRefList) {
            this.mapCodeRef.put(item.getCode(), item);
        }
        this.refMng.changedProperty().addListener(ob -> {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
            for (RefItem item : this.nationalRefList) {
                this.mapCodeRef.put(item.getCode(), item);
            }
        });
    }

    private boolean isLegalCode(List<String> list) {
        for (String item : list) {
            if (this.mapCodeRef.get(item) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public RuleResult validateExpression(String expression) {
        if (this.mapExpressionTokens.containsKey(expression)) {
            return new TrueRuleResult();
        }
        try {
            Parser parser = new Parser();
            List<Parser.Token> tokens = parser.parse(expression);
            List<Parser.Token> last = this.midToLast(tokens);
            this.CalculateLastExpression(last, null, EStrategy.None, true);
            this.mapExpressionTokens.put(expression, last);
            List<String> list = this.getContracts(expression);
            if (!this.isLegalCode(list)) {
                this.mapExpressionTokens.remove(expression);
                throw new AggregationError(CmsErrorCodes.ERR_REFITEM_ILLEGAL);
            }
        }
        catch (AggregationError e) {
            return new FalseRuleResult(e.getCode(), e.getDetails());
        }
        return new TrueRuleResult();
    }

    @Override
    public double calculate(String expression, Map<String, MarketItem> marketData, double last_fill_price, int last_fill_qty, EStrategy strategy) throws AggregationError {
        RuleResult result = this.validateExpression(expression);
        if (result instanceof FalseRuleResult) {
            throw new AggregationError(((FalseRuleResult)result).getCode(), ((FalseRuleResult)result).getDesc());
        }
        List<Parser.Token> last = this.mapExpressionTokens.get(expression);
        this.identifier_util.updateLastFillPrice(last_fill_price);
        this.identifier_util.updateLastFillQty(last_fill_qty);
        double ret = this.CalculateLastExpression(last, marketData, strategy, false);
        return ret;
    }

    @Override
    public List<String> getContracts(String expression) {
        ArrayList<String> contracts = new ArrayList<String>();
        if (this.mapExpressionTokens.containsKey(expression)) {
            List<Parser.Token> tokens = this.mapExpressionTokens.get(expression);
            for (Parser.Token token : tokens) {
                if (token.getType() != Parser.TOKEN_TYPE.IDENTIFY) continue;
                contracts.add(((Parser.IdentifyToken)token).getContract());
            }
        }
        return contracts;
    }

    @Override
    public Pair<Double, Integer> getApproximatePriceAndQty(EIdentifier identifier, MarketItem marketData) throws AggregationError {
        return this.identifier_util.calcValueWithApproximateStrategy(identifier, marketData);
    }
}

