/*
 * Decompiled with CFR 0.152.
 */
package com.cmschina.ficc.aggregation;

import cms.tmx.entity.data.MarketItem;
import com.cmschina.ficc.aggregation.IExpressionCalculator;
import com.cmschina.ficc.aggregation.IdentifyValueCalculator;
import com.cmschina.ficc.aggregation.Parser;
import com.cmschina.ficc.aggregation.constants.EIdentifier;
import com.cmschina.ficc.aggregation.constants.EStrategy;
import com.cmschina.ficc.aggregation.errorcode.CmsErrorCodes;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import com.cmschina.ficc.aggregation.util.TypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractExpressionCalculator
implements IExpressionCalculator {
    protected IdentifyValueCalculator identifier_util = new IdentifyValueCalculator();

    /*
     * Enabled aggressive block sorting
     */
    protected List<Parser.Token> midToLast(List<Parser.Token> mid) throws AggregationError {
        ArrayList<Parser.Token> last = new ArrayList<Parser.Token>();
        Stack<Parser.Token> operators = new Stack<Parser.Token>();
        boolean s1 = false;
        for (Parser.Token token : mid) {
            block0 : switch (token.getType()) {
                case LP: {
                    s1 = false;
                    operators.push(token);
                    break;
                }
                case RP: {
                    while (true) {
                        if (operators.isEmpty() || ((Parser.Token)operators.peek()).getType() == Parser.TOKEN_TYPE.LP) {
                            if (!operators.isEmpty()) break;
                            throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_UNMATCHED_PAREN, token.getValue());
                        }
                        last.add((Parser.Token)operators.pop());
                    }
                    if (!s1) {
                        throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_EMPTY_PAREN, token.getValue());
                    }
                    operators.pop();
                    break;
                }
                case OPERATOR: {
                    if (!TypeUtil.getInstance().isOperator(token.getValue().charAt(0))) {
                        throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_IVALID_OP, token.getValue());
                    }
                    while (true) {
                        if (operators.isEmpty() || !this.priority(((Parser.Token)operators.peek()).getValue().charAt(0), token.getValue().charAt(0))) {
                            operators.push(token);
                            break block0;
                        }
                        last.add((Parser.Token)operators.pop());
                    }
                }
                case IDENTIFY: {
                    if (!TypeUtil.getInstance().isKeyWord(token.getValue())) {
                        throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_IVALID_IDENTIFIER, token.getValue());
                    }
                    last.add(token);
                    s1 = true;
                    break;
                }
                case REAL: {
                    if (!TypeUtil.getInstance().isReal(token.getValue())) {
                        throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_IVALID_REAL, token.getValue());
                    }
                    s1 = true;
                    last.add(token);
                    break;
                }
            }
        }
        while (!operators.isEmpty()) {
            if (((Parser.Token)operators.peek()).getType() == Parser.TOKEN_TYPE.LP) {
                throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_UNMATCHED_PAREN);
            }
            last.add((Parser.Token)operators.pop());
        }
        return last;
    }

    protected double CalculateLastExpression(List<Parser.Token> last, Map<String, MarketItem> marketData, EStrategy strategy, boolean flag) throws AggregationError {
        Stack<Double> ret = new Stack<Double>();
        for (Parser.Token token : last) {
            switch (token.getType()) {
                case OPERATOR: {
                    if (ret.size() < 2) {
                        throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_MISSING_OPERAND);
                    }
                    double b = (Double)ret.pop();
                    double a = (Double)ret.pop();
                    double c = flag ? 1.0 : this.operate(a, token.getValue().charAt(0), b);
                    ret.push(c);
                    break;
                }
                case IDENTIFY: {
                    double value = 1.0;
                    if (!flag) {
                        MarketItem data = marketData.get(((Parser.IdentifyToken)token).getContract());
                        if (data == null) {
                            throw new AggregationError(CmsErrorCodes.ERR_CALC_ACQUIRE_MARKET_DATA);
                        }
                        value = this.computeIdentifyValue(EIdentifier.valueOf(token.getValue()), data, strategy);
                    }
                    ret.push(value);
                    break;
                }
                case REAL: {
                    ret.push(Double.valueOf(token.getValue()));
                    break;
                }
            }
        }
        if (ret.size() != 1) {
            throw new AggregationError(CmsErrorCodes.ERR_SYNTAX_MISSING_OPERATOR);
        }
        return (Double)ret.pop();
    }

    private double computeIdentifyValue(EIdentifier identifier, MarketItem marketData, EStrategy strategy) throws AggregationError {
        switch (strategy) {
            case None: {
                return this.identifier_util.calcValue(identifier, marketData);
            }
            case ApproximatePriceStrategy: {
                return (Double)this.getApproximatePriceAndQty(identifier, marketData).getKey();
            }
        }
        throw new AggregationError(CmsErrorCodes.ERR_CALC_NOT_SUPPORT_STRATEGY);
    }

    protected double operate(double a, char op, double b) throws AggregationError {
        switch (op) {
            case '/': {
                if (b == 0.0) {
                    throw new AggregationError(CmsErrorCodes.ERR_CALC_DIVID_ZERO);
                }
                return a / b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '+': {
                return a + b;
            }
        }
        throw new AggregationError(CmsErrorCodes.ERR_CALC_UNSUPPORT_OP, String.valueOf(op));
    }

    protected boolean priority(char op1, char op2) {
        if (op1 == '*' || op1 == '/') {
            return op2 != '(';
        }
        if (op1 == '+' || op1 == '-') {
            return op2 == '+' || op2 == '-';
        }
        return op1 != '(';
    }
}

