/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.StrategySingleOrder;
import cms.tmx.futures.models.StrategySingleOrderModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategySingleOrderPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(StrategySingleOrderPart.class);
    private MxList<StrategySingleOrder> mlist = new MxList();
    @Inject
    private StrategySingleOrderModel model;
    @FXML
    private TableView<StrategySingleOrder> tableCross;
    @FXML
    private TableColumn<StrategySingleOrder, String> code;
    @FXML
    private TableColumn<StrategySingleOrder, MxNode> market;
    @FXML
    private TextField searchText;
    @Inject
    private MxAlert alert;
    private Predicate<StrategySingleOrder> p = data -> {
        String text = this.searchText.getText().trim();
        return data.getInstrument().getSecId().contains(text);
    };
    private InvalidationListener listener = ob -> Platform.runLater(() -> this.mlist.update(this.model.getList(), this.p));

    @FXML
    private void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.listener);
        this.refresh();
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.listener);
    }

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableCross);
        this.code.setCellValueFactory(data -> ((StrategySingleOrder)data.getValue()).getInstrument().secIdProperty());
        this.market.setCellValueFactory(data -> ((StrategySingleOrder)data.getValue()).getInstrument().marketProperty());
        this.tableCross.setItems(this.mlist.getList());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCross);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCross, (String)"\u6307\u4ee4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

