/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.views.CopyStrategyDialog;
import cms.tmx.futures.views.FutureSubStrategyDialog;
import cms.tmx.futures.views.UpdateStrategyDialog;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.apache.logging.log4j.Logger;

public interface StrategyControl {
    public MObjFactory getObjFactory();

    public DialogFactory getDialogFactory();

    public MxAlert getAlert();

    public FutureMarketMakingModel getModel();

    public Logger getLogger();

    public boolean isLibPane();

    public TableView<FutureStrategy> getTable();

    default public ReadOnlyObjectWrapper<Object> setOperate(FutureStrategy ap) {
        HBox hBox = new HBox();
        boolean canUpdate = false;
        canUpdate = this.isLibPane() ? !ap.isInExe() : ap.getStatus().getRaw().equals("2");
        hBox.setAlignment(Pos.CENTER);
        Button btnUpdate = new Button("      ");
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        if (canUpdate) {
            btnUpdate.setText("\u4fee\u6539");
            btnUpdate.setOnAction(event -> this.update(ap));
        }
        Label label = new Label("  ");
        Button btnShow = new Button("\u67e5\u770b");
        btnShow.getStyleClass().add((Object)"btnOperation");
        btnShow.setOnAction(event -> this.show(ap));
        Label label2 = new Label("  ");
        Button btnDetail = new Button("      ");
        btnDetail.getStyleClass().add((Object)"btnOperation");
        if (ap.isParentContext()) {
            btnDetail.setText("\u8be6\u60c5");
            btnDetail.setOnAction(event -> this.showStrategies(ap));
        }
        hBox.getChildren().add(0, (Object)btnUpdate);
        hBox.getChildren().add(1, (Object)label);
        hBox.getChildren().add(2, (Object)btnShow);
        hBox.getChildren().add(3, (Object)label2);
        hBox.getChildren().add(4, (Object)btnDetail);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    default public void update(FutureStrategy strategy) {
        UpdateStrategyDialog obj = (UpdateStrategyDialog)((Object)this.getObjFactory().create(UpdateStrategyDialog.class));
        FutureStrategy st = (FutureStrategy)this.getObjFactory().create(FutureStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u4fee\u6539\u7b56\u7565");
        dialog.launch();
        this.getTable().getSelectionModel().select((Object)strategy);
    }

    default public void show(FutureStrategy strategy) {
        UpdateStrategyDialog obj = (UpdateStrategyDialog)((Object)this.getObjFactory().create(UpdateStrategyDialog.class));
        Platform.runLater(() -> updateStrategyDialog.vboxAll.setDisable(true));
        FutureStrategy st = (FutureStrategy)this.getObjFactory().create(FutureStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u67e5\u770b\u7b56\u7565");
        dialog.launch();
        this.getTable().getSelectionModel().select((Object)strategy);
    }

    default public void showStrategies(FutureStrategy strategy) {
        FutureSubStrategyDialog obj = (FutureSubStrategyDialog)((Object)this.getObjFactory().create(FutureSubStrategyDialog.class));
        FutureStrategy st = (FutureStrategy)this.getObjFactory().create(FutureStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u67e5\u770b\u5b50\u7b56\u7565");
        dialog.launch();
        this.getTable().getSelectionModel().select((Object)strategy);
    }

    default public void copyNew(FutureStrategy strategy) {
        if (strategy == null) {
            this.getAlert().alert(Alert.AlertType.ERROR, "\u672a\u9009\u62e9\u8981\u590d\u5236\u7684\u7b56\u7565\uff01");
            return;
        }
        CopyStrategyDialog obj = (CopyStrategyDialog)((Object)this.getObjFactory().create(CopyStrategyDialog.class));
        obj.inExe = !this.isLibPane();
        FutureStrategy st = (FutureStrategy)this.getObjFactory().create(FutureStrategy.class);
        st.update((Object)strategy);
        obj.setStrategy(st);
        MxDialog dialog = this.getDialogFactory().create((DialogObj)obj, "\u590d\u5236\u65b0\u589e\u7b56\u7565");
        dialog.launch();
    }
}

