/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SgeSuggest;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.futures.instructions.models.PreciousMetalsBaseModel;
import cms.tmx.futures.instructions.models.UserPreCtrlPreMetals;
import cms.tmx.futures.instructions.viewers.LoadPartModel;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreciousMetalsTradeBasePart
extends MxPart {
    @FXML
    private TableView<HandicapInfo> tableSell;
    @FXML
    private TableView<HandicapInfo> tableBuy;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    protected TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    protected Spinner<Double> priceSpn;
    @FXML
    protected Spinner<Integer> countSpn;
    @FXML
    protected ComboBox<MxNode> countStg;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private GridPane pane2sty;
    @FXML
    private GridPane pane4sty;
    @FXML
    private GridPane pane1sty;
    private boolean isApprove = false;
    private boolean isExecution = false;
    @FXML
    protected Button btnOrder;
    @FXML
    protected Button openBuy;
    @FXML
    protected Button closeBuy;
    @FXML
    protected Button openSell;
    @FXML
    protected Button closeSell;
    @FXML
    protected Button buyIn2Sty;
    @FXML
    protected Button sellIn2Sty;
    @FXML
    private Label lbNowPrice;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected TableView<CtpAccountDistribution> tableAcct;
    @FXML
    protected TableColumn<CtpAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TableColumn<CtpAccountDistribution, CtpFundAccount> accountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> colDynBenefit;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> availableCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> weightCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> amountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> shortCountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, String> brokerNameCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> longCountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> canCloseLong;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> canCloseShort;
    @Inject
    protected RefDataMng refMng;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    protected PreciousMetalsBaseModel model;
    @Inject
    protected UserPreCtrlPreMetals preModel;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MEventService es;
    protected MarketItem mktItem;
    private SgeSuggest spCode = new SgeSuggest();
    private AutoCompletion<RefItem> autoCompletionNormal;
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private static final Logger logger = LogManager.getLogger(PreciousMetalsTradeBasePart.class);
    protected String orderType = "";
    private boolean isPstEvent = false;
    protected boolean priceSettle = false;
    private MEvent pstEvent = new MEvent();
    private SecConverter secCvt;
    protected Instruction instruction;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String confirmSymbol = "";
    @Inject
    private LoadPartModel load;
    @Inject
    protected IUIService uiService;
    @Inject
    private CtpUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    public Map<String, List<CtpOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    protected MEventHandler handler = event -> {
        Object obj = event.get((Object)"code");
        if (obj instanceof String) {
            Platform.runLater(() -> {
                String code = (String)obj;
                this.txtCode.requestFocus();
                if (this.txtCode.isFocused()) {
                    this.txtCode.setText(code);
                }
            });
        }
    };
    private MEventHandler ctpSetCode = event -> {
        if ("CMS-TMX-FUTURE-PART-SGE-POSITION".equals(event.getStr("parent_id").toUpperCase())) {
            String market = event.getStr("tMarket");
            String secType = event.getStr("sec_type");
            String secCode = event.getStr("sec_code");
            this.txtCode.setText(secCode);
            RefItem item = this.refMng.getItem(String.valueOf(secType) + market, market, secCode);
            this.txtCode.setUserData((Object)item);
            this.autoCompletionNormal.setChange(secCode);
            this.onSecurityChange();
            this.pstEvent = event;
            this.isPstEvent = true;
            if (this.txtCode.getText().equals(secCode)) {
                this.model.setCount(this.pstEvent.getLong("count"));
                if (this.pstEvent.getStr("side_sell").equals("1")) {
                    this.closeSell.requestFocus();
                } else if (this.pstEvent.getStr("side_sell").equals("2")) {
                    this.closeBuy.requestFocus();
                }
                this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
                this.model.setPstAcct(this.pstEvent.getStr("secAccount"), market);
            }
        }
    };
    @Inject
    private MObjFactory of;

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        if (this.unfinishedModel.getList().size() == 0) {
            this.exe.execute(() -> this.unfinishedModel.query());
        }
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CtpOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CtpOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CtpOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    @FXML
    public void initialize() {
        this.model.create("0");
        this.refMng.getFutures();
        this.mktItem = this.model.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.refMng.changedProperty().addListener(ob -> {
            Collection list = this.refMng.getItems(new String[]{"FUTSGEX"});
            this.spCode.setAllSuggestions(list);
        });
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTab();
        this.es.subscribe("ctpTradePanelSetCode", this.ctpSetCode);
        this.mktItem.changedProperty().addListener(ob -> this.onMktItemChange());
        this.es.subscribe("input.ctp.future.trade", this.handler);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("ctpTradePanelSetCode", this.ctpSetCode);
        this.es.unSubscribe("input.ctp.future.trade", this.handler);
    }

    private void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUTSGEX"}));
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> {
            this.onSecurityChange();
            this.tableBuy.refresh();
            this.tableSell.refresh();
            this.tableAcct.refresh();
        });
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9\\(\\)\\+]*", 8)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        TooltipUtil.bind((Label)this.lbName);
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.checkPriceType());
        this.cmbPriceTypeLimited.setItems(this.model.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.model.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, now) -> this.onPriceTypeLimitedChange((MxNode)now));
        this.cmbPriceTypeBidAsk.setItems(this.model.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.model.priceTypeBidAskStgProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceDisableBind();
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().setText("");
        this.priceVisibleBind();
        this.priceSpn.focusedProperty().addListener((ob, old, newV) -> this.priceLoseFocus((Boolean)newV));
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().focusedProperty().addListener((ob, old, newV) -> this.pricelLoseFocus((Boolean)newV));
        this.model.priceProperty().addListener((observ, old, now) -> {
            if (this.model.isValidRef() && !this.priceSpn.getEditor().isFocused()) {
                double price = this.model.getPrice();
                int scale = this.getValidRef().getScale();
                if (scale == 0) {
                    this.priceSpn.getEditor().setText(String.valueOf((int)price));
                    this.model.setPrice(price);
                } else {
                    this.model.setPrice(price);
                    this.priceSpn.getValueFactory().setValue((Object)price);
                }
            }
        });
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.countSpn);
        this.ctrlCount.ctrl(this.countSpn);
        this.countDisableBind();
        MxBindings.bindSI((Property)this.countSpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.countSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.countSpn.getEditor().setOnMouseClicked(event -> this.countSpn.getEditor().selectAll());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.openBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.openBuyKeyPress((KeyEvent)event));
        this.closeBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.closeBuyKeyPress((KeyEvent)event));
        this.openSell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.openSellKeyPress((KeyEvent)event));
        this.closeSell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.closeSellKeyPress((KeyEvent)event));
        this.buyIn2Sty.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.buyKeyPress((KeyEvent)event));
        this.sellIn2Sty.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.sellKeyPress((KeyEvent)event));
        CssUtils.addStyleClass((Control)this.openBuy, (String)"btnRed");
        CssUtils.addStyleClass((Control)this.closeBuy, (String)"btnRed");
        CssUtils.addStyleClass((Control)this.buyIn2Sty, (String)"btnRed");
        CssUtils.addStyleClass((Control)this.openSell, (String)"btnBlue");
        CssUtils.addStyleClass((Control)this.closeSell, (String)"btnBlue");
        CssUtils.addStyleClass((Control)this.sellIn2Sty, (String)"btnBlue");
    }

    protected void onSecurityChange() {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem);
        System.err.println("()()()()()()()()()()" + obj);
        System.err.println("()()()()()()()()()()" + refItem);
        if (refItem.isDelayedDelivery()) {
            this.getPane4sty().setVisible(true);
            this.getPane2sty().setVisible(false);
        } else {
            this.getPane4sty().setVisible(false);
            this.getPane2sty().setVisible(true);
        }
    }

    protected void doChange(RefItem refItem) {
        this.model.getMI().setRefItem(refItem);
        this.countSpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.onSecChange();
        this.preModel.onSecurityChange();
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.txtCode.getText().length() >= 6 && refItem == null) {
            this.check();
        }
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.model.setCount(this.pstEvent.getLong("count"));
            if (this.pstEvent.getStr("side_sell").equals("1")) {
                this.closeSell.requestFocus();
            } else if (this.pstEvent.getStr("side_sell").equals("2")) {
                this.closeBuy.requestFocus();
            }
            this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
            this.model.setPstAcct(this.pstEvent.getStr("secAccount"), this.pstEvent.getStr("tMarket"));
        }
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    protected void setPrePrice() {
        if (this.model.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        double price = this.preModel.getDefPrice();
        if (this.model.isValidRef()) {
            int scale = this.getValidRef().getScale();
            if (scale == 0) {
                this.priceSpn.getEditor().setText(String.valueOf((int)price));
                this.model.setPrice(price);
            } else {
                this.model.setPrice(price);
                this.priceSpn.getValueFactory().setValue((Object)price);
            }
        }
        if (this.model.getPrice() != 0.0) {
            this.priceSettle = true;
        }
    }

    @FXML
    protected void orderOpenBuy() {
        this.setOrderType("order_open_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    protected void orderOpenSell() {
        this.setOrderType("order_open_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    protected void orderCloseBuy() {
        this.setOrderType("order_close_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    protected void orderCloseSell() {
        this.setOrderType("order_close_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    protected void orderBuy() {
        this.setOrderType("order_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    protected void orderSell() {
        this.setOrderType("order_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    @FXML
    private void orderApprove() {
        this.countSpn.getEditor();
        if (this.valid() && this.orderConfirm()) {
            this.order();
        }
    }

    protected void order() {
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            } else {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.clearCountCheck();
    }

    protected ObservableList<Boolean> doAction() throws Exception, MException {
        return this.model.submit();
    }

    private void clearCountCheck() {
        block7: {
            if (!this.preModel.isClearAfterOrder()) break block7;
            switch (this.model.getCountStg().getRaw()) {
                case "1": {
                    this.model.setCount(0L);
                }
            }
        }
    }

    protected boolean valid() {
        String tip1;
        if (!this.alert.check(this.txtCode != null, Alert.AlertType.WARNING, tip1 = "\u8bf7\u8f93\u5165\u4ee3\u7801")) {
            return false;
        }
        if (!this.priceValid()) {
            return false;
        }
        String tip2 = "\u672a\u8f93\u5165\u6570\u91cf";
        if (!this.alert.check(this.model.getCount() > 0L, Alert.AlertType.WARNING, tip2)) {
            return false;
        }
        String tip3 = "\u672a\u9009\u62e9\u8d26\u6237";
        return this.alert.check(this.model.getAccDis().getAccList().filtered(each -> each.isSelected()).size() > 0, Alert.AlertType.WARNING, tip3);
    }

    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(!this.model.isLimitPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    protected void getSymbol(FuturesEntrustConfirmDialog obj, String type) {
    }

    private boolean orderConfirm() {
        block8: {
            try {
                this.model.setCloseToday("1".equals(this.preModel.getClose()));
                List<FutureSingleEntrust> orderList = this.model.getPreOrderList(this.instruction, this.orderType);
                if (this.preModel.isPopBeforeOrder()) {
                    FuturesEntrustConfirmDialog obj = (FuturesEntrustConfirmDialog)((Object)this.of.create(FuturesEntrustConfirmDialog.class));
                    obj.setPriceTypeLimitedStg(this.model.getPriceTypeLimitedStg());
                    if ("0".equals(this.model.getAccDis().getInstructType()) || "4".equals(this.model.getAccDis().getInstructType())) {
                        obj.setExecution(true);
                    } else {
                        obj.setInstruction(true);
                    }
                    if (this.model.getInstruction() != null) {
                        obj.setShowWarning(!this.model.getInstruction().isFrozen());
                    }
                    obj.setInstructionType(this.model.getAccDis().getInstructType());
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.model.getPriceStg());
                    obj.setPriceTypeBidAskStg(this.model.getPriceTypeBidAskStg());
                    obj.setSge(true);
                    obj.setList(orderList);
                    if ("1".equals(this.model.getAccDis().getInstructType()) || "2".equals(this.model.getAccDis().getInstructType()) || "3".equals(this.model.getAccDis().getInstructType())) {
                        this.getSymbol(obj, this.orderType);
                    }
                    obj.setBuySymbol(this.getBuySymbol());
                    obj.setSellSymbol(this.getSellSymbol());
                    MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
                    if (dialog.launch() == ButtonType.OK) {
                        return true;
                    }
                    break block8;
                }
                return true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private void priceFocus() {
        this.priceSpn.requestFocus();
        this.preModel.selectTwoOrAllPriceDecimal();
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.model.isLimitPrice()) {
                this.priceFocus();
            } else {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.getPane4sty().isVisible()) {
                this.openBuy.requestFocus();
            } else {
                this.buyIn2Sty.requestFocus();
            }
            key.consume();
        }
    }

    private void openBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.closeSell.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderOpenBuy();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void closeSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.closeBuy.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseSell();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void closeBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.openSell.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseBuy();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void openSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderOpenSell();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void buyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.sellIn2Sty.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderBuy();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void sellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.buyIn2Sty.requestFocus();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderSell();
            this.priceFocus();
        } else if (KeyCode.ESCAPE == key.getCode()) {
            this.txtCode.requestFocus();
        }
        key.consume();
    }

    private void priceLoseFocus(Boolean newV) {
        this.model.getAccDis().onPriceChange();
    }

    private void onRefChange() {
        TradeBindings.ctpPriceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.risePriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.fallPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        if (this.mktItem.getRefItem() != null && !this.mktItem.getRefItem().getName().equals("")) {
            this.checkPriceType();
        }
        this.ctrlPrice.getVF().setUnit(this.mktItem.getRefItem().getPriceUnit());
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
    }

    protected void onMktItemChange() {
        if (this.model.isBidAskPrice()) {
            this.model.setBidAskPrice();
        }
    }

    private void createMarketTable() {
        this.lbNowPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getRisePrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getFallPrice()));
        MxBindings.bindVisible((Control)this.lbNowPrice, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbNowPrice, (double)this.mktItem.getPrevSettlementPrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableSell.getItems().size() - this.tableSell.getItems().indexOf(p.getValue())))))));
        this.colSellPrice.setCellFactory(data -> new PriceCell(this.mktItem));
        this.colSellCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colSellPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(data -> new PriceCell(this.mktItem));
        this.colBuyCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colBuyPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableBuy.setPlaceholder((Node)new Label());
        this.tableSell.setPlaceholder((Node)new Label());
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
    }

    protected void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableBuy.getSelectionModel().clearSelection();
        this.tableSell.getSelectionModel().clearSelection();
    }

    private void pricelLoseFocus(Boolean flag) {
        if (!flag.booleanValue()) {
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        }
    }

    private void loseFocus(Boolean flag) {
        if (!flag.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (flag.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText("\u65e0\u6548\u4ee3\u7801");
        }
    }

    public void setPrice(double price) {
        if (this.model.isLimitPrice() && !this.model.isUnlimited() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            if (this.model.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void checkPriceType() {
        this.priceSpn.getEditor().clear();
        if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeBidAsk.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
        }
    }

    protected void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbPriceType.getValue()).is("50") && !((MxNode)this.cmbPriceType.getValue()).is("0")) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
    }

    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isUnlimited(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty()}));
    }

    protected void countDisableBind() {
        this.countSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    private void createAcctTab() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        TableUtils.isCheckBox(this.checkBoxCol);
        this.checkBoxCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).selectedProperty());
        this.accountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).ctpAccProperty());
        this.brokerNameCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).getCtpAcc().brokerIdProperty());
        this.colDynBenefit.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).getCtpAcc().dynamicBenefitProperty());
        this.colDynBenefit.setCellFactory(data -> new DoubleTableCell());
        this.availableCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).getCtpAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).countProperty());
        this.longCountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).longCountProperty());
        this.shortCountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).shortCountProperty());
        this.canCloseLong.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).canCloseLongProperty());
        this.canCloseShort.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).canCloseShortProperty());
        this.longCountCol.setCellFactory(p -> new PstCell());
        this.shortCountCol.setCellFactory(p -> new PstCell());
        this.canCloseLong.setCellFactory(p -> new PstCell());
        this.canCloseLong.setCellFactory(p -> new PstCell());
        this.tableAcct.getColumns().remove(this.longCountCol);
        this.tableAcct.getColumns().remove(this.shortCountCol);
        this.tableAcct.getColumns().remove(this.canCloseLong);
        this.tableAcct.getColumns().remove(this.canCloseShort);
        this.tableAcct.getColumns().remove(this.colDynBenefit);
        this.tableAcct.getColumns().remove(this.brokerNameCol);
        this.tableAcct.setItems(this.model.getAccDis().getAccList());
        this.tableAcct.refresh();
        this.tableAcct.setPlaceholder((Node)new Label());
        this.tableAcct.setEditable(true);
        this.availableCol.setEditable(false);
        TableUtils.orgnizeClmWidth(this.tableAcct);
    }

    @FXML
    private void refresh() {
        this.model.getAccDis().refreshAll();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAcct, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableAcct, (String)"\u8d26\u53f7\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void setOrderType(String type) {
        this.orderType = type;
    }

    private String getOcName(int oc) {
        if (oc == 79) {
            return "\u5f00\u4ed3";
        }
        if (this.model.isXSGE().booleanValue()) {
            if (oc == 67) {
                return "\u5e73\u6628";
            }
            if (oc == 84) {
                return "\u5e73\u4eca";
            }
        } else if (oc == 67) {
            return "\u5e73\u4ed3";
        }
        return "\u672a\u5b9a\u4e49";
    }

    public double getPrice(int gear) {
        switch (gear) {
            case 0: {
                return this.mktItem.getNowPrice();
            }
            case 100: {
                return this.mktItem.getUpLimitPrice();
            }
            case -100: {
                return this.mktItem.getDownLimitPrice();
            }
        }
        boolean buy = gear > 0;
        gear = Math.abs(gear);
        if (buy && this.mktItem.getListBuyHandicap().size() > gear - 1) {
            return ((HandicapInfo)this.mktItem.getListBuyHandicap().get(gear - 1)).getPrice();
        }
        if (!buy && this.mktItem.getListSellHandicap().size() > gear - 1) {
            return ((HandicapInfo)this.mktItem.getListSellHandicap().get(gear - 1)).getPrice();
        }
        return 0.0;
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        this.preModel.setType("5", "200005002");
        this.model.setPreModel(this.preModel);
        try {
            this.preModel.doSet();
            this.model.setCloseToday("1".equals(this.preModel.getClose()));
        }
        catch (MException | Exception throwable) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    public GridPane getPane2sty() {
        return this.pane2sty;
    }

    public GridPane getPane4sty() {
        return this.pane4sty;
    }

    public GridPane getPane1sty() {
        return this.pane1sty;
    }

    public boolean isApprove() {
        return this.isApprove;
    }

    public void setApprove(boolean isApprove) {
        this.isApprove = isApprove;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    private class MoneyCell
    extends EditTableCell<CtpAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }
    }

    public class PriceCell<E extends HandicapInfo>
    extends TableCell<HandicapInfo, String> {
        private MarketItem info;
        private Boolean bs;

        public PriceCell(MarketItem info) {
            CssUtils.priceTag((Control)this);
            this.info = info;
        }

        public PriceCell(MarketItem info, Boolean bs) {
            this(info);
            this.bs = bs;
        }

        public void updateItem(String item, boolean empty) {
            HandicapInfo handiInfo;
            if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
                double price = Double.parseDouble(item);
                CssUtils.checkPrice((Control)this, (double)this.info.getPrevSettlementPrice(), (double)price);
                if (price > 0.0) {
                    String txt = String.format("%." + this.info.getRefItem().getScale() + "f", price);
                    this.setText(txt);
                    return;
                }
            }
            this.setText(null);
        }
    }

    private class PstCell
    extends TableCell<CtpAccountDistribution, Number> {
        private Label label = new Label();

        private PstCell() {
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                this.label.setText(String.valueOf(item));
                this.setGraphic((Node)this.label);
                this.getGraphic().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> PreciousMetalsTradeBasePart.this.model.isValidRef(), (Observable[])new Observable[]{PreciousMetalsTradeBasePart.this.model.securityProperty()}));
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class WeightCell
    extends EditTableCell<CtpAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

