/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.HedgeTask;
import cms.tmx.futures.models.HedgeTaskModel;
import cms.tmx.futures.views.HedgeTaskUpdateDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.utils.HedgeStatusCell;
import cms.tmx.query.utils.SideCell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class HedgeTaskPart
extends MxPart {
    @FXML
    private CheckBox onlyUnfinished;
    @FXML
    private TextField searchText;
    @FXML
    private TableView<HedgeTask> tableHedge;
    @FXML
    private TableColumn<HedgeTask, MxNode> hedgeStatus;
    @FXML
    private TableColumn<HedgeTask, MxNode> hedgeOrdSide;
    @FXML
    private TableColumn<HedgeTask, Object> operate;
    @FXML
    private TableColumn<HedgeTask, Boolean> selected;
    @FXML
    private TableColumn<HedgeTask, MxNode> strategyType;
    @Inject
    private MxAlert alert;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private HedgeTaskModel model;
    private MxList<HedgeTask> mlist = new MxList();
    private Predicate<HedgeTask> pd = t -> {
        String txt;
        if (this.onlyUnfinished.isSelected() && t.getHedgeStatus().getRaw().equals("3")) {
            return false;
        }
        String name = t.getStrategyName().toUpperCase();
        return name.contains(txt = this.searchText.getText().toUpperCase());
    };
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        ArrayList<HedgeTask> newList = new ArrayList<HedgeTask>();
        List<HedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.filter(newList, this.pd);
            this.tableHedge.refresh();
        });
    });
    private InvalidationListener lstnModel = ob -> {
        ArrayList<HedgeTask> newList = new ArrayList<HedgeTask>();
        List<HedgeTask> list = this.model.getList();
        synchronized (list) {
            newList.addAll(this.model.getList());
        }
        Platform.runLater(() -> {
            this.mlist.update(newList, this.pd);
            this.tableHedge.refresh();
        });
    };
    private boolean ctrlPressed = false;
    private boolean shiftPressed = false;
    private int lastIndex = -1;

    @FXML
    public void initialize() {
        this.setKey();
        this.createTableView();
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.onlyUnfinished.setSelected(true);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.onlyUnfinished.selectedProperty().addListener(this.lstnSearch);
    }

    protected void createTableView() {
        this.tableHedge.getColumns().remove(this.strategyType);
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableHedge.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        this.selected.setSortable(false);
        TableUtils.initValueFactory(this.tableHedge);
        this.operate.setCellValueFactory(data -> this.setOperate((HedgeTask)data.getValue()));
        this.hedgeStatus.setCellFactory(data -> new HedgeStatusCell());
        this.hedgeOrdSide.setCellFactory(data -> new SideCell());
        this.tableHedge.setPlaceholder((Node)new Label());
        this.tableHedge.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        try {
            this.model.query();
        }
        catch (MException e) {
            this.logger.error("\u671f\u8d27\u5bf9\u51b2\u4efb\u52a1\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    public ReadOnlyObjectWrapper<Object> setOperate(HedgeTask task) {
        Button btnStart = new Button("\u542f\u52a8");
        btnStart.setMinWidth(86.0);
        btnStart.getStyleClass().add((Object)"btnOperation");
        btnStart.setOnAction(event -> this.start(task));
        Button btnStop = new Button("\u505c\u6b62");
        btnStop.setMinWidth(86.0);
        btnStop.getStyleClass().add((Object)"btnOperation");
        btnStop.setOnAction(event -> this.stop(task));
        Button btnUpdate = new Button("\u4fee\u6539");
        btnUpdate.setMinWidth(86.0);
        btnUpdate.getStyleClass().add((Object)"btnOperation");
        btnUpdate.setOnAction(event -> this.update(task));
        Button btnFinish = new Button("\u7f6e\u4e3a\u5df2\u5b8c\u6210");
        btnFinish.setMinWidth(130.0);
        btnFinish.getStyleClass().add((Object)"btnOperation");
        btnFinish.setOnAction(event -> this.finish(task));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER);
        if (task.getHedgeStatus().getRaw().equals("2")) {
            hBox.getChildren().add((Object)btnStart);
            hBox.getChildren().add((Object)btnUpdate);
            hBox.getChildren().add((Object)btnFinish);
        }
        if (task.getHedgeStatus().getRaw().equals("1")) {
            hBox.getChildren().add((Object)btnStop);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public void start(HedgeTask strategy) {
        this.exe.execute(() -> {
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(strategy.getTaskId());
                Map<String, String> failed = this.model.start(list);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u542f\u52a8\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public void stop(HedgeTask task) {
        this.exe.execute(() -> {
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(task.getTaskId());
                Map<String, String> failed = this.model.stop(list);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public void update(HedgeTask strategy) {
        HedgeTaskUpdateDialog obj = (HedgeTaskUpdateDialog)((Object)this.of.create(HedgeTaskUpdateDialog.class));
        obj.setOrder(strategy);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u5bf9\u51b2\u5355");
        dialog.launch();
    }

    public void finish(HedgeTask strategy) {
        boolean bFinish = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5c06 " + strategy.getTaskId() + " \u7f6e\u4e3a\u5b8c\u6210\uff1f");
        if (!bFinish) {
            return;
        }
        try {
            this.model.finish(strategy);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void startAll() {
        ArrayList<String> listId = new ArrayList<String>();
        for (HedgeTask strategy : this.tableHedge.getItems()) {
            if (!strategy.isSelected() || !strategy.getHedgeStatus().getRaw().equals("2")) continue;
            listId.add(strategy.getTaskId());
        }
        this.exe.execute(() -> {
            try {
                Map<String, String> failed = this.model.start(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u542f\u52a8\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public void stopAll() {
        this.exe.execute(() -> {
            ArrayList<String> listId = new ArrayList<String>();
            for (HedgeTask strategy : this.tableHedge.getItems()) {
                if (!strategy.isSelected() || !strategy.getHedgeStatus().getRaw().equals("1")) continue;
                listId.add(strategy.getTaskId());
            }
            try {
                Map<String, String> failed = this.model.stop(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> {
                        boolean bl = this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    });
                }
            }
            catch (MException e) {
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                });
            }
        });
    }

    public void finishAll() {
        boolean bFinish = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5c06\u52fe\u9009\u90e8\u5206\u7f6e\u4e3a\u5b8c\u6210\uff1f");
        if (!bFinish) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (HedgeTask strategy : this.tableHedge.getItems()) {
            if (!strategy.isSelected() || strategy.getHedgeStatus().getRaw().equals("3")) continue;
            try {
                this.model.finish(strategy);
            }
            catch (MException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                builder.append(String.valueOf(strategy.getTaskId()) + " : " + e.getMessage() + "\n");
            }
        }
        if (!builder.toString().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, builder.toString());
        }
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableHedge, (String)"\u5bf9\u51b2\u4efb\u52a1\u67e5\u8be2", (int)1, (int)(this.tableHedge.getColumns().size() - 1));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableHedge, (int)1, (int)0);
    }

    private void setKey() {
        this.tableHedge.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = true;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = true;
                HedgeTask strategy = (HedgeTask)this.tableHedge.getSelectionModel().getSelectedItem();
                if (strategy != null) {
                    this.lastIndex = this.tableHedge.getItems().indexOf((Object)strategy);
                }
            }
        });
        this.tableHedge.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = false;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = false;
            }
        });
        this.tableHedge.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            block8: {
                HedgeTask strategy = (HedgeTask)this.tableHedge.getSelectionModel().getSelectedItem();
                if (strategy == null) break block8;
                boolean isSelect = strategy.isSelected();
                if (this.ctrlPressed) {
                    strategy.setSelected(!isSelect);
                } else {
                    this.tableHedge.getItems().forEach(item -> {
                        if (item.equals((Object)strategy)) {
                            item.setSelected(true);
                        } else {
                            item.setSelected(false);
                        }
                    });
                }
                if (this.shiftPressed) {
                    if (this.lastIndex == -1) {
                        return;
                    }
                    int index = this.tableHedge.getItems().indexOf((Object)strategy);
                    if (index > this.lastIndex) {
                        int i = this.lastIndex;
                        while (i <= index) {
                            ((HedgeTask)this.tableHedge.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    } else {
                        int i = index;
                        while (i <= this.lastIndex) {
                            ((HedgeTask)this.tableHedge.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    }
                }
            }
        });
    }
}

