/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;

public class FuturesEntrustConfirmDialog
extends DialogObj {
    @FXML
    private TableView<FutureSingleEntrust> tableItems;
    @FXML
    private TableColumn<FutureSingleEntrust, String> index;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colCode;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colName;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colMkt;
    @FXML
    private TableColumn<FutureSingleEntrust, Number> colDirection;
    @FXML
    private TableColumn<FutureSingleEntrust, MxNode> colOcFlag;
    @FXML
    private TableColumn<FutureSingleEntrust, Number> colCount;
    @FXML
    private TableColumn<FutureSingleEntrust, Number> colPrice;
    @FXML
    private TableColumn<FutureSingleEntrust, Number> colAmt;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colAcc;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colSecAcc;
    @FXML
    private TableColumn<FutureSingleEntrust, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<FutureSingleEntrust> list = FxUtils.newList();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    private long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    private boolean triggered = false;
    private RefItem refItem;
    private boolean isInstruction = false;
    private String instructionType = "";
    private boolean isExecution = false;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String approveSymbol = "\u5ba1\u6279\u901a\u8fc7";
    private MxNode priceStg;
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeBidAskStg;
    private boolean showWarning = true;
    private boolean sge = false;

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
    }

    private void initControl() {
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)3));
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void calTotalInfo() {
        for (FutureSingleEntrust item : this.list) {
            double money = item.getAmt();
            if (this.isOpen(item)) {
                Double num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            this.totalCount += item.getQuantity().longValue();
            this.totalAmt += money;
            if (!this.showWarning || !this.checkSufficient(item)) continue;
            this.triggered = true;
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        if (!this.showWarning) {
            return;
        }
        StringBuilder bld = new StringBuilder();
        for (FundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getAvailable() < this.accBuyMap.get(acc))) continue;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t");
        }
        this.strTip = bld.toString();
    }

    private boolean checkSufficient(FutureSingleEntrust item) {
        switch (item.getOffsetFlag().getRaw()) {
            case "79": {
                item.setInsufficient(item.getAmt() > item.getFundAccount().getAvailable());
                item.setTip(item.isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "67": {
                if (!item.isShowCloseTip()) break;
                switch (item.getSide()) {
                    case 49: {
                        if ("XSGE".equals(item.getMarket()) || "XINE".equals(item.getMarket())) {
                            item.setInsufficient(item.getQuantity() > item.getCanCloseYdShort());
                            item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u6628\u7a7a\u4e0d\u8db3" : "");
                            break;
                        }
                        item.setInsufficient(item.getQuantity() > item.getCanCloseShort());
                        item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u7a7a\u4e0d\u8db3" : "");
                        break;
                    }
                    case 50: {
                        if ("XSGE".equals(item.getMarket()) || "XINE".equals(item.getMarket())) {
                            item.setInsufficient(item.getQuantity() > item.getCanCloseYdLong());
                            item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u6628\u591a\u4e0d\u8db3" : "");
                            break;
                        }
                        item.setInsufficient(item.getQuantity() > item.getCanCloseLong());
                        item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u591a\u4e0d\u8db3" : "");
                    }
                }
                break;
            }
            case "84": {
                if (!item.isShowCloseTip()) break;
                switch (item.getSide()) {
                    case 49: {
                        if ("XSGE".equals(item.getMarket()) || "XINE".equals(item.getMarket())) {
                            item.setInsufficient(item.getQuantity() > item.getCanCloseTdShort());
                            item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u4eca\u7a7a\u4e0d\u8db3" : "");
                            break;
                        }
                        item.setInsufficient(item.getQuantity() > item.getCanCloseShort());
                        item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u7a7a\u4e0d\u8db3" : "");
                        break;
                    }
                    case 50: {
                        if ("XSGE".equals(item.getMarket()) || "XINE".equals(item.getMarket())) {
                            item.setInsufficient(item.getQuantity() > item.getCanCloseTdLong());
                            item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u4eca\u591a\u4e0d\u8db3" : "");
                            break;
                        }
                        item.setInsufficient(item.getQuantity() > item.getCanCloseLong());
                        item.setTip(item.isInsufficient() ? "\u53ef\u5e73\u591a\u4e0d\u8db3" : "");
                    }
                }
                break;
            }
        }
        return item.isInsufficient();
    }

    private void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        TableUtils.isAuto(this.index);
        this.colCode.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).secProperty());
        this.colName.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).secNameProperty());
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((FutureSingleEntrust)m.getValue()).getMarket()).getValue()));
        this.colDirection.setCellFactory(cell -> new SideCell());
        this.colDirection.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).sideProperty());
        this.colOcFlag.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).offsetFlagProperty());
        this.colCount.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).quantityProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).priceProperty());
        this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
        this.colAmt.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).amtProperty());
        this.colAcc.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).investorSecIdProperty());
        if (this.isSge()) {
            this.tableItems.getColumns().remove(this.colAmt);
            if (!this.refItem.isDelayedDelivery()) {
                this.tableItems.getColumns().remove(this.colOcFlag);
            }
            this.colName.setText("\u5408\u7ea6\u540d\u79f0");
            this.colCode.setText("\u5408\u7ea6\u4ee3\u7801");
        }
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((FutureSingleEntrust)m.getValue()).tipProperty());
        this.tableItems.setPlaceholder((Node)new Label());
        this.tableItems.setItems(this.list);
    }

    private boolean isOpen(FutureSingleEntrust item) {
        return "79".equals(item.getOffsetFlag().getRaw());
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setList(List<FutureSingleEntrust> list) {
        this.list.setAll(list);
    }

    public List<FutureSingleEntrust> getList() {
        return this.list;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public String getInstructionType() {
        return this.instructionType;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getApproveSymbol() {
        return this.approveSymbol;
    }

    public void setApproveSymbol(String approveSymbol) {
        this.approveSymbol = approveSymbol;
    }

    public MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public boolean isSge() {
        return this.sge;
    }

    public void setSge(boolean sge) {
        this.sge = sge;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<FutureSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            FutureSingleEntrust item = (FutureSingleEntrust)FutureSingleEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            if (FuturesEntrustConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 50) {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = FuturesEntrustConfirmDialog.this.getRefItem() != null ? FuturesEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        if (FuturesEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null) {
                            text = "-";
                        }
                        text = String.valueOf(text) + StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    }
                    if (FuturesEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null && "3".equals(FuturesEntrustConfirmDialog.this.getPriceTypeLimitedStg().getRaw())) {
                        text = "";
                    }
                    this.setText(String.valueOf(FuturesEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null ? FuturesEntrustConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 0) {
                    this.setText(FuturesEntrustConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + FuturesEntrustConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    int scale = FuturesEntrustConfirmDialog.this.getRefItem() != null ? FuturesEntrustConfirmDialog.this.getRefItem().getScale() : 3;
                    String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)scale);
                    this.setText(text);
                }
            } else {
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                int scale = FuturesEntrustConfirmDialog.this.getRefItem() != null ? FuturesEntrustConfirmDialog.this.getRefItem().getScale() : 3;
                String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)scale);
                this.setText(text);
            }
        }
    }

    private class SideCell
    extends TableCell<FutureSingleEntrust, Number> {
        private Label label = new Label();
        private MxNode sideNode;

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            this.sideNode = MxNodeFactory.create((String)"side", (String)"");
        }

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            int side = value.intValue();
            FutureSingleEntrust cfr_ignored_0 = (FutureSingleEntrust)FutureSingleEntrust.class.cast(this.getTableRow().getItem());
            if (FuturesEntrustConfirmDialog.this.isInstruction) {
                if (49 == side) {
                    this.label.setText(FuturesEntrustConfirmDialog.this.buySymbol);
                } else if (50 == side) {
                    this.label.setText(FuturesEntrustConfirmDialog.this.sellSymbol);
                } else if ("3".equals(FuturesEntrustConfirmDialog.this.instructionType)) {
                    this.label.setText(FuturesEntrustConfirmDialog.this.approveSymbol);
                } else {
                    this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
                }
            } else {
                this.label.setText(this.sideNode.getNode(String.valueOf(side)).getValue());
            }
            switch (side) {
                case 49: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<FutureSingleEntrust, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

