/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.FuturePriceCell;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.futures.models.FutureTradeModel;
import cms.tmx.futures.models.UserPreCtrlFuture;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureTradePart
extends MxPart {
    @FXML
    private TableView<HandicapInfo> tableSell;
    @FXML
    private TableView<HandicapInfo> tableBuy;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private ComboBox<MxNode> cmbHedgeType;
    @FXML
    private ComboBox<MxNode> cmbPriceType;
    @FXML
    private Spinner<Double> priceSpn;
    @FXML
    private Spinner<Integer> countSpn;
    @FXML
    private ComboBox<MxNode> countStg;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private GridPane pane2sty;
    @FXML
    private GridPane pane4sty;
    @FXML
    private Button openBuy;
    @FXML
    private Button closeBuy;
    @FXML
    private Button openSell;
    @FXML
    private Button closeSell;
    @FXML
    private Button buyIn2Sty;
    @FXML
    private Button sellIn2Sty;
    @FXML
    private Label lbNowPrice;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    private ComboBox<MxNode> cmbDist;
    @FXML
    private TableView<CtpAccountDistribution> tableAcct;
    @FXML
    private TableColumn<CtpAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TableColumn<CtpAccountDistribution, CtpFundAccount> accountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> availableCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> weightCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> amountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> shortCountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, String> brokerNameCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> longCountCol;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> canCloseLong;
    @FXML
    private TableColumn<CtpAccountDistribution, Number> canCloseShort;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private FutureTradeModel model;
    @Inject
    protected UserPreCtrlFuture preModel;
    @Inject
    private MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected MEventService es;
    private MarketItem mktItem;
    private SecSuggest spCode = new SecSuggest();
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private static final Logger logger = LogManager.getLogger(FutureTradePart.class);
    private String orderType = "";
    private boolean isPstEvent = false;
    private MEvent pstEvent = new MEvent();
    private SecConverter secCvt;
    @Inject
    private CtpUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    public Map<String, List<CtpOrder>> map;
    private InvalidationListener listenerUnfinish = ob -> Platform.runLater(() -> {
        ObservableList list = this.unfinishedModel.getList();
        this.map = list.stream().collect(Collectors.groupingBy(t -> t.getInstrument().getSecId()));
        this.MonitOnRefChange();
    });
    private MEventHandler ctpSetCode = event -> {
        if ("CMS-TMX-FUTURE-PART-POSITION".equals(event.getStr("parent_id").toUpperCase())) {
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(event.getStr("sec_code"));
            }
            this.pstEvent = event;
            this.isPstEvent = true;
            if (this.txtCode.getText().equals(event.getStr("sec_code"))) {
                this.model.setCount(this.pstEvent.getInt("count"));
                if (this.pstEvent.getStr("side_sell").equals("1")) {
                    this.closeSell.requestFocus();
                } else if (this.pstEvent.getStr("side_sell").equals("2")) {
                    this.closeBuy.requestFocus();
                }
                this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
                this.cmbHedgeType.setValue((Object)this.model.getHedgeType().getNode(this.pstEvent.getStr("hedgeFlag")));
            }
        }
    };
    @Inject
    private MObjFactory of;

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinish));
        if (this.unfinishedModel.getList().size() == 0) {
            this.exe.execute(() -> this.unfinishedModel.query());
        }
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            List<CtpOrder> orders = this.map.get(this.mktItem.getRefItem().getCode());
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CtpOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (orders == null || orders.isEmpty()) continue;
                for (CtpOrder order : orders) {
                    if (order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
        }
    }

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.initListenerUnfinish();
        this.refMng.changedProperty().addListener(ob -> {
            Collection list = this.refMng.getItems(new String[]{"FUT"});
            this.spCode.setAllSuggestions(list);
        });
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createAcctTab();
        this.es.subscribe("ctpTradePanelSetCode", this.ctpSetCode);
        this.mktItem.changedProperty().addListener((ob, old, now) -> {
            if (this.model.getPrice() > 0.0) {
                return;
            }
            this.model.setPrice(this.preModel.getDefPrice());
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        });
    }

    private void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{"FUT"}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        TooltipUtil.bind((Label)this.lbName);
        this.cmbHedgeType.setItems(this.model.getHedgeType().getNodes());
        this.cmbHedgeType.valueProperty().bindBidirectional(this.model.hedgeTypeProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener((ob, old, now) -> this.checkPriceType(now.getRaw()));
        this.ctrlPrice.ctrl(this.priceSpn);
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().setText("");
        this.priceSpn.focusedProperty().addListener((ob, old, newV) -> this.priceLoseFocus((Boolean)newV));
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().focusedProperty().addListener((ob, old, newV) -> this.pricelLoseFocus((Boolean)newV));
        this.priceSpn.getEditor().textProperty().addListener((observ, old, now) -> {
            if (this.priceSpn.getEditor().isFocused()) {
                this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
            }
        });
        SpinnerUtils.arrowsStyle(this.priceSpn);
        SpinnerUtils.arrowsStyle(this.countSpn);
        this.ctrlCount.ctrl(this.countSpn);
        MxBindings.bindSI((Property)this.countSpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.countSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.countSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.countSpn.getEditor().setOnMouseClicked(event -> this.countSpn.getEditor().selectAll());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.openBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.openBuyKeyPress((KeyEvent)event));
        this.closeBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.closeBuyKeyPress((KeyEvent)event));
        this.openSell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.openSellKeyPress((KeyEvent)event));
        this.closeSell.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.closeSellKeyPress((KeyEvent)event));
        this.buyIn2Sty.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.buyKeyPress((KeyEvent)event));
        this.sellIn2Sty.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.sellKeyPress((KeyEvent)event));
    }

    protected void onSecurityChange() {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.model.getMI().setRefItem(refItem);
        this.model.onSecChange();
        this.preModel.onSecurityChange();
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.txtCode.getText().length() >= 6 && refItem == null) {
            this.check();
        }
        if (this.isPstEvent) {
            this.isPstEvent = false;
            this.model.setCount(this.pstEvent.getInt("count"));
            if (this.pstEvent.getStr("side_sell").equals("1")) {
                this.closeSell.requestFocus();
            } else if (this.pstEvent.getStr("side_sell").equals("2")) {
                this.closeBuy.requestFocus();
            }
            this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
            this.cmbHedgeType.setValue((Object)this.model.getHedgeType().getNode(this.pstEvent.getStr("hedgeFlag")));
        }
    }

    @FXML
    private void orderOpenBuy() {
        this.setOrderType("order_open_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    @FXML
    private void orderOpenSell() {
        this.setOrderType("order_open_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    @FXML
    private void orderCloseBuy() {
        this.setOrderType("order_close_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    @FXML
    private void orderCloseSell() {
        this.setOrderType("order_close_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    @FXML
    private void orderBuy() {
        this.setOrderType("order_buy");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    @FXML
    private void orderSell() {
        this.setOrderType("order_sell");
        if (this.valid() && this.orderConfirm()) {
            this.order(this.orderType);
        }
    }

    private void order(String type) {
        try {
            ObservableList<Boolean> listCont = this.model.submit(type);
            this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            this.clearCountCheck();
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void clearCountCheck() {
        block7: {
            if (!this.preModel.isClearAfterOrder()) break block7;
            switch (this.model.getCountStg().getRaw()) {
                case "1": {
                    this.model.setCount(0L);
                }
            }
        }
    }

    private boolean valid() {
        return this.alert.check(this.txtCode != null, Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u4ee3\u7801") && this.alert.check(!this.model.isFixedPrice() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, "\u672a\u8f93\u5165\u4ef7\u683c") && this.alert.check(this.model.getCount() > 0L, Alert.AlertType.WARNING, "\u672a\u8f93\u5165\u6570\u91cf") && this.alert.check(this.model.getAccDis().getAccList().filtered(each -> each.isSelected()).size() > 0, Alert.AlertType.WARNING, "\u672a\u9009\u62e9\u8d26\u6237");
    }

    private boolean orderConfirm() {
        try {
            if (this.preModel.isPopBeforeOrder()) {
                FuturesEntrustConfirmDialog obj = (FuturesEntrustConfirmDialog)((Object)this.of.create(FuturesEntrustConfirmDialog.class));
                obj.setRefItem(this.mktItem.getRefItem());
                obj.setList(this.model.getPreOrderList(this.orderType));
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                if (dialog.launch() == ButtonType.OK) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        return false;
    }

    private void priceFocus() {
        this.priceSpn.requestFocus();
        TextFieldUtils.selectTwoPriceDecimal((TextField)this.priceSpn.getEditor());
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.priceFocus();
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.openBuy.requestFocus();
            key.consume();
        }
    }

    private void openBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.closeSell.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderOpenBuy();
            this.priceFocus();
            key.consume();
        }
    }

    private void closeSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.closeBuy.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseSell();
            this.priceFocus();
            key.consume();
        }
    }

    private void closeBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.openSell.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseBuy();
            this.priceFocus();
            key.consume();
        }
    }

    private void openSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderOpenSell();
            this.priceFocus();
            key.consume();
        }
    }

    private void buyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.buyIn2Sty.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseSell();
            this.priceFocus();
            key.consume();
        }
    }

    private void sellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.sellIn2Sty.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.orderCloseSell();
            this.priceFocus();
            key.consume();
        }
    }

    private void priceLoseFocus(Boolean newV) {
        this.model.getAccDis().onPriceChange();
    }

    private void onRefChange() {
        TradeBindings.ctpPriceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        if (this.mktItem.getRefItem() != null && !this.mktItem.getRefItem().getName().equals("")) {
            String stg = ((MxNode)this.cmbPriceType.getValue()).getRaw();
            this.checkPriceType(stg);
        }
        this.ctrlPrice.getVF().setUnit(this.mktItem.getRefItem().getPriceUnit());
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
    }

    private void createMarketTable() {
        this.mktItem.nowPriceProperty().addListener((observ, old, now) -> this.onPriceTypeChange((MxNode)this.cmbPriceType.getValue()));
        ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).priceProperty().addListener((observ, old, now) -> this.onPriceTypeChange((MxNode)this.cmbPriceType.getValue()));
        ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).priceProperty().addListener((observ, old, now) -> this.onPriceTypeChange((MxNode)this.cmbPriceType.getValue()));
        this.lbNowPrice.setOnMouseClicked(event -> {
            boolean bl = this.changePrice(this.mktItem.getNowPrice());
        });
        this.lbUpLimit.setOnMouseClicked(event -> {
            boolean bl = this.changePrice(this.mktItem.getUpLimitPrice());
        });
        this.lbDownLimit.setOnMouseClicked(event -> {
            boolean bl = this.changePrice(this.mktItem.getDownLimitPrice());
        });
        MxBindings.bindVisible((Control)this.lbNowPrice, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbNowPrice, (double)this.mktItem.getPreSettlementPrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableSell.getItems().size() - this.tableSell.getItems().indexOf(p.getValue())))))));
        this.colSellPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colSellCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colSellPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colBuyCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colBuyPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableBuy.setPlaceholder((Node)new Label());
        this.tableSell.setPlaceholder((Node)new Label());
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableAcct.setPlaceholder((Node)new Label());
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.changePrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableBuy.getSelectionModel().clearSelection();
        this.tableSell.getSelectionModel().clearSelection();
    }

    private void pricelLoseFocus(Boolean flag) {
        if (!flag.booleanValue()) {
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        }
    }

    private void loseFocus(Boolean flag) {
        if (!flag.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (flag.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText("\u65e0\u6548\u4ee3\u7801");
        }
    }

    public boolean changePrice(double price) {
        if (price > 0.0) {
            this.model.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
        }
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode("50"));
        return false;
    }

    private void onPriceTypeChange(MxNode now) {
        String stg = now.getRaw();
        this.checkPriceType(stg);
    }

    private void checkPriceType(String stg) {
        if (this.mktItem.getRefItem() != null && stg.equals("newp")) {
            this.model.setPrice(this.mktItem.getNowPrice());
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        } else if (this.mktItem.getRefItem() != null && stg.equals("buy1")) {
            this.model.setPrice(((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice());
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        } else if (this.mktItem.getRefItem() != null && stg.equals("sell1")) {
            this.model.setPrice(((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice());
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        } else if (stg.equals("opp")) {
            this.priceSpn.getValueFactory().setValue((Object)0.0);
            this.priceSpn.getEditor().setText("");
        }
    }

    private void createAcctTab() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        try {
            this.model.getAccDis().create();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        TableUtils.isCheckBox(this.checkBoxCol);
        this.checkBoxCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).selectedProperty());
        this.accountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).ctpAccProperty());
        this.brokerNameCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).getCtpAcc().brokerIdProperty());
        this.availableCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).getCtpAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.weightCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).countProperty());
        this.longCountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).longCountProperty());
        this.shortCountCol.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).shortCountProperty());
        this.canCloseLong.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).canCloseLongProperty());
        this.canCloseShort.setCellValueFactory(data -> ((CtpAccountDistribution)((Object)((Object)data.getValue()))).canCloseShortProperty());
        this.longCountCol.setCellFactory(p -> new PstCell());
        this.shortCountCol.setCellFactory(p -> new PstCell());
        this.canCloseLong.setCellFactory(p -> new PstCell());
        this.canCloseLong.setCellFactory(p -> new PstCell());
        this.tableAcct.setItems(this.model.getAccDis().getAccList());
        this.tableAcct.refresh();
        this.tableAcct.setPlaceholder((Node)new Label());
        this.tableAcct.setEditable(true);
        this.availableCol.setEditable(false);
        TableUtils.orgnizeClmWidth(this.tableAcct);
    }

    @FXML
    private void refresh() {
        this.model.getAccDis().refreshAll();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAcct, (int)1, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableAcct, (String)"\u8d26\u53f7\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void setOrderType(String type) {
        switch (this.orderType = type) {
            case "order_open_buy": {
                this.model.setBs("\u4e70\u5165");
                this.model.setOc("\u5f00\u4ed3");
                break;
            }
            case "order_open_sell": {
                this.model.setBs("\u5356\u51fa");
                this.model.setOc("\u5f00\u4ed3");
                break;
            }
            case "order_close_buy": {
                this.model.setBs("\u4e70\u5165");
                this.model.setOc("\u5e73\u4ed3");
                break;
            }
            case "order_close_sell": {
                this.model.setBs("\u5356\u51fa");
                this.model.setOc("\u5e73\u4ed3");
                break;
            }
            case "order_buy": {
                this.model.setBs("\u4e70\u5165");
                break;
            }
            case "order_sell": {
                this.model.setBs("\u5356\u51fa");
                break;
            }
        }
    }

    private String getOcName(int oc) {
        if (oc == 79) {
            return "\u5f00\u4ed3";
        }
        if (this.model.isXSGE().booleanValue()) {
            if (oc == 67) {
                return "\u5e73\u6628";
            }
            if (oc == 84) {
                return "\u5e73\u4eca";
            }
        } else if (oc == 67) {
            return "\u5e73\u4ed3";
        }
        return "\u672a\u5b9a\u4e49";
    }

    public double getPrice(int gear) {
        switch (gear) {
            case 0: {
                return this.mktItem.getNowPrice();
            }
            case 100: {
                return this.mktItem.getUpLimitPrice();
            }
            case -100: {
                return this.mktItem.getDownLimitPrice();
            }
        }
        boolean buy = gear > 0;
        gear = Math.abs(gear);
        if (buy && this.mktItem.getListBuyHandicap().size() > gear - 1) {
            return ((HandicapInfo)this.mktItem.getListBuyHandicap().get(gear - 1)).getPrice();
        }
        if (!buy && this.mktItem.getListSellHandicap().size() > gear - 1) {
            return ((HandicapInfo)this.mktItem.getListSellHandicap().get(gear - 1)).getPrice();
        }
        return 0.0;
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        this.preModel.setType("4", "200005");
        this.model.setPreModel(this.preModel);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    public GridPane getPane2sty() {
        return this.pane2sty;
    }

    public GridPane getPane4sty() {
        return this.pane4sty;
    }

    private class MoneyCell
    extends EditTableCell<CtpAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }
    }

    private class PstCell
    extends TableCell<CtpAccountDistribution, Number> {
        private Label label = new Label();

        private PstCell() {
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                this.label.setText(String.valueOf(item));
                this.setGraphic((Node)this.label);
                this.getGraphic().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> FutureTradePart.this.model.isValidRef(), (Observable[])new Observable[]{FutureTradePart.this.model.securityProperty()}));
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class WeightCell
    extends EditTableCell<CtpAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

