/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.views.FutureMarketMakingPart;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureSubStrategyDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(FutureMarketMakingPart.class);
    @Inject
    protected FutureMarketMakingModel model;
    private MxList<FutureStrategy> mlist = new MxList();
    private FutureStrategy strategy = null;
    @FXML
    private TableView<FutureStrategy> tableStrategy;
    @FXML
    private TableColumn<FutureStrategy, String> parentContextId;
    @FXML
    private TableColumn<FutureStrategy, String> contextId;
    @FXML
    private TableColumn<FutureStrategy, String> security;
    @FXML
    private TableColumn<FutureStrategy, MxNode> tacticsType;
    @FXML
    private TableColumn<FutureStrategy, String> name;
    @FXML
    private TableColumn<FutureStrategy, String> errorMsg;
    @FXML
    private TableColumn<FutureStrategy, MxNode> status;
    @FXML
    private TableColumn<FutureStrategy, Number> qty;
    @FXML
    private TableColumn<FutureStrategy, Number> filledQty;
    @Inject
    private MxAlert alert;
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mlist.update((List)this.model.getMlistSubStrategy().getList());
        this.tableStrategy.refresh();
    });
    @Inject
    protected MEventService es;

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedSubProperty().addListener(this.lstnModel);
        this.tableStrategy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            MEvent event = new MEvent();
            event.put((Object)"input_ctp_market_making", (Object)now.getSecurity());
            this.es.sendEvent("input_ctp_market_making", event);
        });
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.security.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).securityProperty());
        this.tacticsType.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).tacticsTypeProperty());
        this.name.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).nameProperty());
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.parentContextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).parentContextIdProperty());
        this.errorMsg.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).errorMsgProperty());
        this.status.setCellValueFactory(data -> ((FutureStrategy)data.getValue()).statusProperty());
        this.qty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).bidQtyProperty());
        this.filledQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).filledQtyProperty());
        this.tableStrategy.setItems(this.mlist.getList());
    }

    @FXML
    public void refresh() {
        try {
            this.model.querySubStrategy(this.strategy.getContextId());
        }
        catch (MException | InvalidProtocolBufferException e) {
            logger.error((Object)e, e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    public FutureStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(FutureStrategy strategy) {
        this.strategy = strategy;
    }
}

