/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.entity.trade.FutureStrategySerialize;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.views.AddStrategyDialog;
import cms.tmx.futures.views.FutureMarketMakingPart;
import cms.tmx.futures.views.StrategyControl;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureStrategyLibraryDialog
extends DialogObj
implements StrategyControl {
    private static final Logger logger = LogManager.getLogger(FutureMarketMakingPart.class);
    @Inject
    protected FutureMarketMakingModel model;
    private MxList<FutureStrategy> mlist = new MxList();
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnDel;
    @FXML
    private TableView<FutureStrategy> tableStrategy;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<FutureStrategy, Boolean> selected;
    @FXML
    private TableColumn<FutureStrategy, Object> operate;
    @FXML
    private TableColumn<FutureStrategy, Number> dealLimit;
    @FXML
    private TableColumn<FutureStrategy, Number> baseSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> spreadSum;
    @FXML
    private TableColumn<FutureStrategy, Number> bidSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> askSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> hedgeSpreadBuy;
    @FXML
    private TableColumn<FutureStrategy, Number> hedgeSpreadSell;
    @FXML
    private TableColumn<FutureStrategy, String> contextId;
    @FXML
    private TableColumn<FutureStrategy, String> security;
    @FXML
    private TableColumn<FutureStrategy, MxNode> tacticsType;
    @FXML
    private TableColumn<FutureStrategy, String> name;
    @FXML
    private TableColumn<FutureStrategy, String> investorId;
    @FXML
    private TableColumn<FutureStrategy, String> investorSecId;
    @FXML
    private TableColumn<FutureStrategy, Number> bidQty;
    @FXML
    private TableColumn<FutureStrategy, Number> askQty;
    @FXML
    private TableColumn<FutureStrategy, String> hedgeContract;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    @Inject
    private ExecutorService exe;
    private Predicate<FutureStrategy> pd = data -> {
        String text = this.txtSearch.getText().trim().toUpperCase();
        return data.getSecurity().toUpperCase().contains(text) || data.getName().toUpperCase().contains(text);
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        if (this.mlist.getList().size() == this.model.getMlistStrategyLib().size() - 1) {
            this.mlist.update(this.model.getMlistStrategyLib(), this.pd);
            FutureStrategy copy = this.model.getCopyStrategy();
            int last = this.mlist.getList().size() - 1;
            if (copy != null) {
                FutureStrategy strategyNew = (FutureStrategy)this.mlist.getList().get(last);
                int insertIndex = this.tableStrategy.getItems().indexOf((Object)copy) + 1;
                this.tableStrategy.getItems().remove(last);
                this.tableStrategy.getItems().add(insertIndex, (Object)strategyNew);
                this.tableStrategy.getSelectionModel().select((Object)strategyNew);
            } else {
                this.tableStrategy.getSelectionModel().select(last);
            }
        } else {
            this.mlist.update(this.model.getMlistStrategyLib(), this.pd);
        }
        this.checkBtnStatus();
        this.tableStrategy.refresh();
    });
    private InvalidationListener listenerSearch = ob -> Platform.runLater(() -> this.mlist.filter(this.model.getMlistStrategyLib(), this.pd));
    private InvalidationListener listener = ob -> this.refresh();
    @Inject
    protected MEventService es;
    public ButtonType buttonType = new ButtonType("\u6dfb\u52a0\u5230\u6267\u884c\u9762\u677f", ButtonBar.ButtonData.OK_DONE);
    public Button button;
    Gson gson = new Gson();

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedLibProperty().addListener(this.lstnModel);
        this.txtSearch.textProperty().addListener(this.listenerSearch);
        this.ref.changedProperty().addListener(this.listener);
        this.tableStrategy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            MEvent event = new MEvent();
            event.put((Object)"input_ctp_market_making", (Object)now.getSecurity());
            this.es.sendEvent("input_ctp_market_making", event);
        });
        this.refresh();
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{this.buttonType, ButtonType.CANCEL};
    }

    public void onFinished(ButtonType bt) {
        if (bt == this.buttonType) {
            for (FutureStrategy strategy : this.tableStrategy.getItems()) {
                if (!strategy.isSelected() || strategy.isInExe()) continue;
                try {
                    FutureStrategy s = new FutureStrategy();
                    s.update((Object)strategy);
                    s.setInExe(true);
                    this.model.updateStrategy(s);
                }
                catch (MException e) {
                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    @FXML
    public void add() {
        AddStrategyDialog obj = (AddStrategyDialog)((Object)this.of.create(AddStrategyDialog.class));
        obj.inExe = false;
        this.model.setCopyStrategy(null);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        dialog.launch();
    }

    @FXML
    public void copyNew() {
        FutureStrategy strategy = (FutureStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.model.setCopyStrategy(strategy);
        this.copyNew(strategy);
    }

    @FXML
    public void exportStrategy() {
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("rd files (*.txt)", new String[]{".txt"});
        chooser.getExtensionFilters().add((Object)filter);
        chooser.setInitialFileName("strategy");
        File file = chooser.showSaveDialog(null);
        try {
            if (file != null) {
                LinkedList<FutureStrategySerialize> list = new LinkedList<FutureStrategySerialize>();
                for (FutureStrategy strategy : this.model.getMlistStrategyLib()) {
                    FutureStrategySerialize strategy2 = new FutureStrategySerialize();
                    strategy2.update(strategy);
                    list.add(strategy2);
                }
                FileOutputStream fileStream = new FileOutputStream(file);
                String json = this.gson.toJson(list);
                byte[] array = json.getBytes();
                fileStream.write(array);
                fileStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    @FXML
    public void importStrategy() {
        FileChooser chooser = new FileChooser();
        File file = chooser.showOpenDialog(null);
        try {
            if (file != null) {
                LinkedList strategyList = new LinkedList();
                FileInputStream fileStream = new FileInputStream(file);
                byte[] array = new byte[fileStream.available()];
                fileStream.read(array);
                String json = new String(array);
                strategyList = (LinkedList)this.gson.fromJson(json, new TypeToken<LinkedList<FutureStrategySerialize>>(){}.getType());
                for (FutureStrategySerialize strategy : strategyList) {
                    try {
                        strategy.setHedgePriceCustomSell(strategy.getHedgePriceCustomSell().trim().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                        strategy.setHedgePriceCustomBuy(strategy.getHedgePriceCustomBuy().trim().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                        this.model.addStrategy(strategy);
                    }
                    catch (MException e) {
                        e.printStackTrace();
                        logger.error(e.getMessage());
                    }
                }
                fileStream.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.error(e1.getMessage());
        }
        this.refresh();
    }

    @FXML
    public void delete() {
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (strategy.isSelected()) continue;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                this.model.delStrategy(strategy.getContextId());
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                e.printStackTrace();
            }
        }
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.ref.changedProperty().removeListener(this.listener);
        this.txtSearch.textProperty().removeListener(this.listenerSearch);
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.security.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).securityProperty());
        this.tacticsType.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).tacticsTypeProperty());
        this.name.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).nameProperty());
        this.investorId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).investorIdProperty());
        this.investorSecId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).investorSecIdProperty());
        this.dealLimit.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).dealLimitProperty());
        this.baseSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).baseSpreadProperty());
        this.spreadSum.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).spreadSumProperty());
        this.bidSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).bidSpreadProperty());
        this.askSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).askSpreadProperty());
        this.bidQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).bidQtyProperty());
        this.askQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).askQtyProperty());
        this.hedgeContract.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeContractProperty());
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.hedgeSpreadBuy.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeSpreadBuyProperty());
        this.hedgeSpreadSell.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeSpreadSellProperty());
        this.selected.setCellValueFactory(data -> {
            BooleanProperty bp = ((FutureStrategy)data.getValue()).selectedProperty();
            bp.addListener((ob, old, now) -> this.checkBtnStatus());
            return bp;
        });
        this.operate.setCellValueFactory(data -> this.setOperate((FutureStrategy)data.getValue()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private void checkBtnStatus() {
        this.button.setDisable(true);
        int selectedNum = 0;
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.isInExe()) continue;
            ++selectedNum;
        }
        if (selectedNum > 0) {
            this.button.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public FutureMarketMakingModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return true;
    }

    @Override
    public TableView<FutureStrategy> getTable() {
        return this.tableStrategy;
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> {
            try {
                this.getModel().query("strategy.lib");
            }
            catch (MException | InvalidProtocolBufferException e) {
                logger.error((Object)e, e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }
}

