/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.entity.web.settings.FuturePriceMaxDiff;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.models.FutureMktMakingSettingsModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.cmschina.ficc.aggregation.ExpressionCalculator;
import com.cmschina.ficc.aggregation.FalseRuleResult;
import com.cmschina.ficc.aggregation.RuleResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureStrategyDialog
extends DialogObj {
    private Logger logger = LogManager.getLogger(FutureStrategyDialog.class);
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    @FXML
    protected VBox vboxAll;
    @FXML
    protected VBox vboxUp;
    @FXML
    protected VBox vboxSplit;
    @FXML
    protected VBox vboxDown;
    @FXML
    protected GridPane gridUpDefine;
    @FXML
    protected GridPane gridUpUnDefine;
    @FXML
    protected GridPane gridSplit;
    @FXML
    protected GridPane gridDownDefine;
    @FXML
    protected GridPane gridDownUnDefine;
    @FXML
    protected GridPane gridBottom;
    @FXML
    protected GridPane gridHedgeContract;
    @FXML
    protected ComboBox<String> cmbAcct;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    protected Label lbContract;
    @FXML
    protected ComboBox<MxNode> cmbShFlag;
    @FXML
    protected ComboBox<MxNode> cmbOcFlag;
    @FXML
    protected ComboBox<MxNode> cmbType;
    @FXML
    protected TextField txtName;
    @FXML
    protected TextField txtBaseCode;
    @FXML
    protected Label lbBaseCodeErr;
    @FXML
    protected TextField txtPriceCustom;
    @FXML
    private Spinner<Double> spnBaseSpread;
    @FXML
    private Label lbBaseSpread;
    @FXML
    private Label lbSpreadSum;
    @FXML
    private Label lbPriceBuyType;
    @FXML
    private Label lbPriceSellType;
    @FXML
    private Spinner<Double> spnPriceSlip;
    @FXML
    private Spinner<Double> spnSpreadSum;
    @FXML
    protected ComboBox<MxNode> cmbPriceType;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Spinner<Integer> spnQtyBuy;
    @FXML
    private Spinner<Integer> spnQtySell;
    @FXML
    private Spinner<Integer> spnTotalQty;
    @FXML
    private Spinner<Integer> spnDealLimit;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    protected ToggleGroup group = new ToggleGroup();
    @FXML
    protected TextField txtHedgeContract;
    @FXML
    protected CheckBox checkSplit;
    @FXML
    protected CheckBox checkHedge;
    @FXML
    protected TextField txtHedgePriceCustomSell;
    @FXML
    protected TextField txtHedgePriceCustomBuy;
    @FXML
    protected ComboBox<MxNode> cmbPriceBuyType;
    @FXML
    protected ComboBox<MxNode> cmbPriceSellType;
    @FXML
    protected Spinner<Double> spnHedgeSlip;
    @FXML
    protected Spinner<Double> spnSpreadBuy;
    @FXML
    protected Spinner<Double> spnSpreadSell;
    @FXML
    protected TextField txtMarketMaking;
    @FXML
    protected TextField txtHedge;
    @FXML
    protected TextField txtTimeoutFill;
    @FXML
    protected Spinner<Double> spnStoplossFill;
    @FXML
    private Label lbAcctErr;
    @FXML
    private Label lbPriceCustomErr;
    @FXML
    private Label lbHedgePriceCustomSellErr;
    @FXML
    private Label lbHedgePriceCustomBuyErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPriceSlipErr;
    @FXML
    private Label lbDealLimitErr;
    @FXML
    private Label lbDiffBuyErr;
    @FXML
    private Label lbDiffSellErr;
    @FXML
    private Label lbSpreadSumErr;
    @FXML
    private Label lbQtyBuyErr;
    @FXML
    private Label lbQtySellErr;
    @FXML
    private Label lbTotalQtyErr;
    @FXML
    private Label lbMarketMakingErr;
    @FXML
    private Label lbHedgeErr;
    @FXML
    private Label lbStarLong;
    @FXML
    private Label lbStarShort;
    @FXML
    private Label lbStarPercent;
    @FXML
    private Label lbMaxDiff;
    @FXML
    private Label lbStarDiffSell;
    @FXML
    private Label lbStarQtySell;
    @FXML
    private Label lbStarDiffBuy;
    @FXML
    private Label lbStarQtyBuy;
    @FXML
    private Label lbStarPriceBuyType;
    @FXML
    private Label lbStarPriceSellType;
    @FXML
    private Label lbStarTotalQty;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected FutureMarketMakingModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    private FutureMktMakingSettingsModel settings;
    public double maxDiff = Double.MAX_VALUE;
    private DoubleSpinnerCtrl ctrlThreshold = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlStoploss = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlBaseSpread = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadBuy = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadSell = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlHedgeSlip = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlDealLimit = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlTotalCount = new IntSpinnerCtrl(true, 9, 1);
    private SecSuggest spCode = new SecSuggest();
    protected RefItem refItem;
    private RefItem refItemHedge = null;
    public List<String> nameList = new ArrayList<String>();
    private List<RefItem> nationalRefList = null;
    private SecSuggest.StrSuggest suggestFund = SecSuggest.getStrSuggest();
    private StringBinding stringBindingBuySpread = null;
    private StringBinding stringBindingSellSpread = null;
    protected FutureStrategy stg;
    @Inject
    private ExpressionCalculator exp;
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> this.spCode.setAllSuggestions(this.getRefList());

    public FutureStrategyDialog() {
        super("FutureStrategyDialog.fxml");
    }

    private void setPriceSpreadByFormula(String formula, ComboBox<MxNode> price, Spinner<Double> spread) {
        int begin = formula.indexOf(46);
        int end = formula.indexOf(43);
        boolean negative = false;
        if (end < 0) {
            end = formula.indexOf(45);
            negative = true;
        }
        if (end > 0 && (!((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals("11") || spread != this.spnSpreadBuy && spread != this.spnSpreadSell)) {
            spread.getEditor().setText(formula.substring(end + 1).trim());
            if (negative) {
                spread.getEditor().setText("-" + formula.substring(end + 1).trim());
            }
        }
        String raw = "LAST";
        raw = formula.contains("LFP") ? "LFP" : (end > 0 ? formula.substring(begin + 1, end).trim() : formula.substring(begin + 1).trim());
        if (raw.isEmpty()) {
            raw = "LAST";
        }
        MxNode node = new MxNode().load("future_strategy_price_type", raw);
        if (price == this.cmbPriceType) {
            node.removeNode("LFP");
        }
        price.setItems(node.getNodes());
        price.setValue((Object)node);
    }

    public void fillDialog() {
        this.txtCode.setText(this.stg.getSecurity());
        this.refItem = this.refMng.getItem(this.stg.getMarket(), this.stg.getSecurity());
        CtpRefItem ctpItem = (CtpRefItem)this.refItem;
        if (ctpItem != null) {
            this.maxDiff = this.getPriceMaxDiff(ctpItem);
            if (this.maxDiff == Double.MAX_VALUE) {
                this.spnSpreadSum.getEditor().setPromptText("\u62a5\u4ef7\u4ef7\u5dee\u65e0\u4e0a\u9650");
            } else {
                this.spnSpreadSum.getEditor().setPromptText("\u6700\u5927\u4e3a " + this.getPriceMaxDiff(ctpItem));
            }
        } else {
            this.maxDiff = Double.MAX_VALUE;
            this.lbMaxDiff.setText("");
        }
        this.txtName.setText(this.stg.getName());
        this.cmbAcct.setValue((Object)this.stg.getInvestorId());
        this.spnPriceSlip.getEditor().setText(String.valueOf(this.stg.getPriceSlip()));
        if (((MxNode)this.cmbType.getValue()).getRaw().equals("6")) {
            this.txtPriceCustom.setText(this.stg.getRefPriceCustom());
            this.txtHedgePriceCustomSell.setText(this.stg.getHedgePriceCustomSell());
            this.txtHedgePriceCustomBuy.setText(this.stg.getHedgePriceCustomBuy());
        } else if (((MxNode)this.cmbType.getValue()).getRaw().equals("9")) {
            this.txtPriceCustom.setText(this.stg.getRefPriceCustom());
            this.txtHedgePriceCustomSell.setText(this.stg.getHedgePriceCustomSell());
            this.txtHedgePriceCustomBuy.setText(this.stg.getHedgePriceCustomBuy());
        } else {
            int begin = this.stg.getRefPriceCustom().indexOf(91);
            int end = this.stg.getRefPriceCustom().indexOf(93);
            this.txtBaseCode.setText(this.stg.getRefPriceCustom().substring(begin + 1, end));
            this.setPriceSpreadByFormula(this.stg.getRefPriceCustom(), this.cmbPriceType, this.spnBaseSpread);
            this.setPriceSpreadByFormula(this.stg.getHedgePriceCustomSell(), this.cmbPriceSellType, this.spnSpreadSell);
            this.setPriceSpreadByFormula(this.stg.getHedgePriceCustomBuy(), this.cmbPriceBuyType, this.spnSpreadBuy);
        }
        if (((MxNode)this.cmbType.getValue()).getRaw().equals("11")) {
            this.spnHedgeSlip.getEditor().setText(String.valueOf(this.stg.getHedgeSlip()));
        }
        this.spnDiffBuy.getEditor().setText(String.valueOf(this.stg.getBidSpread()));
        this.spnDiffSell.getEditor().setText(String.valueOf(this.stg.getAskSpread()));
        this.spnSpreadSum.getEditor().setText(String.format("%.3f", this.stg.getBidSpread() + this.stg.getAskSpread()));
        this.spnQtyBuy.getEditor().setText(String.valueOf(this.stg.getBidQty()));
        this.spnQtySell.getEditor().setText(String.valueOf(this.stg.getAskQty()));
        this.spnDealLimit.getEditor().setText(String.valueOf(this.stg.getDealLimit()));
        this.txtHedgeContract.setText(this.stg.getHedgeContract());
        if (this.stg.getHedgeCount() > 0) {
            this.txtHedge.setText(String.valueOf(this.stg.getHedgeCount()));
        }
        if (this.stg.getMarketMakingCount() > 0) {
            this.txtMarketMaking.setText(String.valueOf(this.stg.getMarketMakingCount()));
        }
        this.txtTimeoutFill.setText(String.valueOf(this.stg.getTimeoutFill()));
        this.spnStoplossFill.getEditor().setText(String.valueOf(this.stg.getStoplossFill()));
        this.resetUnit(this.ctrlDiffBuy, this.ctrlBaseSpread, this.ctrlDiffSell, this.ctrlThreshold, this.ctrlStoploss, this.ctrlSpreadBuy, this.ctrlSpreadSell);
        this.checkHedge.setSelected(!this.stg.getHedgeContract().isEmpty());
        if (this.stg.isBuy()) {
            this.radioBuy.setSelected(true);
        } else {
            this.radioSell.setSelected(true);
        }
        this.checkSplit.setSelected(this.stg.isSplit());
        if (this.stg.isSplit()) {
            this.spnTotalQty.getEditor().setText(String.valueOf(this.stg.getTotalQty()));
        }
    }

    private List<RefItem> getRefList() {
        if (this.nationalRefList == null) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        return this.nationalRefList;
    }

    public void onFinished(ButtonType bt) {
        this.refMng.changedProperty().removeListener(this.refListener);
    }

    @FXML
    public void initialize() {
        String type;
        this.stringBindingBuySpread = Bindings.createStringBinding(() -> {
            double baseSpread = 0.0;
            double diffSell = 0.0;
            double hedgeSlip = 0.0;
            double spreadBuy = 0.0;
            if (!this.spnBaseSpread.getEditor().getText().isEmpty()) {
                baseSpread = Double.valueOf(this.spnBaseSpread.getEditor().getText().replaceAll(",", ""));
            }
            if (!this.spnDiffSell.getEditor().getText().isEmpty()) {
                diffSell = Double.valueOf(this.spnDiffSell.getEditor().getText().replaceAll(",", ""));
            }
            if (!this.spnHedgeSlip.getEditor().getText().isEmpty()) {
                hedgeSlip = Double.valueOf(this.spnHedgeSlip.getEditor().getText().replaceAll(",", ""));
            }
            spreadBuy = -1.0 * baseSpread - diffSell + hedgeSlip;
            return String.valueOf(spreadBuy);
        }, (Observable[])new Observable[]{this.spnBaseSpread.getEditor().textProperty(), this.spnDiffSell.getEditor().textProperty(), this.spnHedgeSlip.getEditor().textProperty()});
        this.stringBindingSellSpread = Bindings.createStringBinding(() -> {
            double baseSpread = 0.0;
            double diffBuy = 0.0;
            double hedgeSlip = 0.0;
            double spreadSell = 0.0;
            if (!this.spnBaseSpread.getEditor().getText().isEmpty()) {
                baseSpread = Double.valueOf(this.spnBaseSpread.getEditor().getText().replaceAll(",", ""));
            }
            if (!this.spnDiffBuy.getEditor().getText().isEmpty()) {
                diffBuy = Double.valueOf(this.spnDiffBuy.getEditor().getText().replaceAll(",", ""));
            }
            if (!this.spnHedgeSlip.getEditor().getText().isEmpty()) {
                hedgeSlip = Double.valueOf(this.spnHedgeSlip.getEditor().getText().replaceAll(",", ""));
            }
            spreadSell = -1.0 * baseSpread + diffBuy - hedgeSlip;
            return String.valueOf(spreadSell);
        }, (Observable[])new Observable[]{this.spnBaseSpread.getEditor().textProperty(), this.spnDiffBuy.getEditor().textProperty(), this.spnHedgeSlip.getEditor().textProperty()});
        this.refMng.changedProperty().addListener(this.refListener);
        this.initControls();
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("sh_flag", this.stg != null ? this.stg.getShFlag() : "1");
        this.cmbShFlag.setItems(node.getNodes());
        this.cmbShFlag.setValue((Object)node);
        node = ((MxNode)this.of.create(MxNode.class)).load("position_effect", this.stg != null ? this.stg.getOcFlag() : "70");
        node.removeNode("67");
        this.cmbOcFlag.setItems(node.getNodes());
        this.cmbOcFlag.setValue((Object)node);
        if (this.stg == null) {
            node = new MxNode().load("future_strategy_price_type", "LAST");
            this.cmbPriceBuyType.setItems(node.getNodes());
            this.cmbPriceBuyType.setValue((Object)node);
            node = new MxNode().load("future_strategy_price_type", "LAST");
            this.cmbPriceSellType.setItems(node.getNodes());
            this.cmbPriceSellType.setValue((Object)node);
            node = new MxNode().load("future_strategy_price_type", "LAST");
            node.removeNode("LFP");
            this.cmbPriceType.setItems(node.getNodes());
            this.cmbPriceType.setValue((Object)node);
        }
        this.txtHedge.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        this.txtMarketMaking.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        this.txtPriceCustom.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300));
        this.txtHedgePriceCustomSell.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300));
        this.txtHedgePriceCustomBuy.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300));
        this.spnTotalQty.disableProperty().bind((ObservableValue)this.checkSplit.selectedProperty().not());
        this.lbStarTotalQty.visibleProperty().bind((ObservableValue)this.checkSplit.selectedProperty());
        this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpUnDefine});
        this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownUnDefine});
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.typeChanged((MxNode)now));
        this.checkSplit.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.spnQtySell.getEditor().setText(this.spnQtyBuy.getEditor().getText());
                this.spnQtySell.setDisable(true);
            } else {
                this.spnQtySell.setDisable(false);
            }
        });
        if (this.stg != null) {
            type = this.stg.getTacticsType().getRaw();
            this.cmbType.setEditable(false);
        } else {
            type = "1";
        }
        node = ((MxNode)this.of.create(MxNode.class)).load("future_strategy_type", type);
        this.cmbType.setItems(node.getNodes());
        this.cmbType.setValue((Object)node);
        this.registerCheck();
    }

    private void reset() {
        this.txtBaseCode.setEditable(true);
        this.txtHedgeContract.setEditable(true);
        this.txtBaseCode.setPromptText("");
        this.txtHedgeContract.setPromptText("");
        this.spnSpreadSum.setVisible(true);
        this.spnDiffBuy.setDisable(false);
        this.spnQtyBuy.setDisable(false);
        this.spnDiffSell.setDisable(false);
        this.spnQtySell.setDisable(false);
        this.cmbPriceBuyType.setDisable(false);
        this.cmbPriceBuyType.setVisible(true);
        this.spnSpreadBuy.setDisable(false);
        this.cmbPriceSellType.setDisable(false);
        this.cmbPriceSellType.setVisible(true);
        this.spnHedgeSlip.setVisible(false);
        this.lbPriceSellType.setText("\u5356\u4ef7\u7c7b\u578b");
        this.lbPriceBuyType.setVisible(true);
        this.spnSpreadSell.setDisable(false);
        this.spnBaseSpread.setVisible(true);
        this.lbBaseSpread.setVisible(true);
        this.checkSplit.setSelected(false);
        this.vboxSplit.getChildren().setAll((Object[])new Node[0]);
        this.txtMarketMaking.setDisable(false);
        this.txtHedge.setDisable(false);
        this.lbSpreadSum.setText("\u62a5\u4ef7\u4ef7\u5dee");
        this.lbSpreadSum.setVisible(true);
        this.lbStarDiffBuy.setVisible(true);
        this.lbStarDiffSell.setVisible(true);
        this.lbStarQtyBuy.setVisible(true);
        this.lbStarQtySell.setVisible(true);
        this.lbStarPriceBuyType.setVisible(true);
        this.lbStarPriceSellType.setVisible(true);
        this.txtHedgePriceCustomBuy.setDisable(false);
        this.radioBuy.setVisible(false);
        this.radioSell.setVisible(false);
        this.spnSpreadBuy.getEditor().textProperty().unbind();
        this.spnSpreadSell.getEditor().textProperty().unbind();
    }

    protected void typeChanged(MxNode node) {
        this.reset();
        this.registerCheck();
        if (node.getRaw().equals("6")) {
            this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpDefine});
            this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownDefine});
            this.spnBaseSpread.setVisible(false);
            this.lbBaseSpread.setVisible(false);
        } else if (node.getRaw().equals("9")) {
            this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpDefine});
            this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownDefine});
            this.spnBaseSpread.setVisible(false);
            this.lbBaseSpread.setVisible(false);
            this.lbSpreadSum.setText("\u4e70\u5356\u65b9\u5411");
            this.spnSpreadSum.setVisible(false);
            this.radioBuy.setVisible(true);
            this.radioSell.setVisible(true);
            this.spnDiffSell.setDisable(true);
            this.spnQtySell.setDisable(true);
            this.txtHedgePriceCustomBuy.setDisable(true);
        } else if (StringUtils.belongto((String)node.getRaw(), (String[])new String[]{"5", "1"})) {
            this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpUnDefine});
            this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownUnDefine});
            this.vboxSplit.getChildren().setAll((Object[])new Node[]{this.gridSplit});
            if (node.getRaw().equals("5")) {
                this.txtHedgeContract.setEditable(false);
                this.txtHedgeContract.setPromptText("\u540c\u57fa\u51c6\u5408\u7ea6");
                this.txtHedgeContract.setText(this.txtBaseCode.getText());
            }
            if (node.getRaw().equals("1")) {
                this.txtBaseCode.setEditable(false);
                this.txtHedgeContract.setEditable(false);
                this.txtBaseCode.setPromptText("\u540c\u505a\u5e02\u5408\u7ea6");
                this.txtHedgeContract.setPromptText("\u540c\u505a\u5e02\u5408\u7ea6");
                this.txtBaseCode.setText(this.txtCode.getText());
                this.txtHedgeContract.setText(this.txtCode.getText());
            }
        } else if (node.getRaw().equals("11")) {
            this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpUnDefine});
            this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownUnDefine});
            this.vboxSplit.getChildren().setAll((Object[])new Node[]{this.gridSplit});
            this.txtHedgeContract.setEditable(false);
            this.txtHedgeContract.setPromptText("\u540c\u57fa\u51c6\u5408\u7ea6");
            this.txtHedgeContract.setText(this.txtBaseCode.getText());
            this.lbPriceBuyType.setVisible(false);
            this.lbPriceSellType.setText("\u5bf9\u51b2\u6ed1\u70b9");
            this.cmbPriceBuyType.setVisible(false);
            this.cmbPriceSellType.setVisible(false);
            this.spnHedgeSlip.setVisible(true);
            this.spnSpreadBuy.setDisable(true);
            this.spnSpreadSell.setDisable(true);
            this.spnSpreadBuy.getEditor().textProperty().bind((ObservableValue)this.stringBindingBuySpread);
            this.spnSpreadSell.getEditor().textProperty().bind((ObservableValue)this.stringBindingSellSpread);
            this.txtMarketMaking.setText("1");
            this.txtMarketMaking.setDisable(true);
            this.txtHedge.setText("1");
            this.txtHedge.setDisable(true);
        } else if (StringUtils.belongto((String)node.getRaw(), (String[])new String[]{"7"})) {
            this.vboxUp.getChildren().setAll((Object[])new Node[]{this.gridUpUnDefine});
            this.vboxDown.getChildren().setAll((Object[])new Node[]{this.gridDownUnDefine});
            this.txtHedgeContract.setEditable(false);
            this.txtHedgeContract.setPromptText("\u540c\u57fa\u51c6\u5408\u7ea6");
            this.txtHedgeContract.setText(this.txtBaseCode.getText());
            this.lbSpreadSum.setVisible(false);
            this.spnSpreadSum.setVisible(false);
            this.spnDiffSell.setDisable(true);
            this.spnQtySell.setDisable(true);
            this.spnDiffSell.getEditor().clear();
            this.spnQtySell.getEditor().clear();
            this.cmbPriceBuyType.setDisable(true);
            this.spnSpreadBuy.setDisable(true);
            this.spnSpreadBuy.getEditor().clear();
            this.lbStarDiffSell.setVisible(false);
            this.lbStarQtySell.setVisible(false);
            this.lbStarPriceBuyType.setVisible(false);
        } else if (StringUtils.belongto((String)node.getRaw(), (String[])new String[]{"8"})) {
            this.txtHedgeContract.setEditable(false);
            this.txtHedgeContract.setPromptText("\u540c\u57fa\u51c6\u5408\u7ea6");
            this.txtHedgeContract.setText(this.txtBaseCode.getText());
            this.lbSpreadSum.setVisible(false);
            this.spnSpreadSum.setVisible(false);
            this.spnDiffBuy.setDisable(true);
            this.spnQtyBuy.setDisable(true);
            this.spnDiffBuy.getEditor().clear();
            this.spnQtyBuy.getEditor().clear();
            this.cmbPriceSellType.setDisable(true);
            this.spnSpreadSell.setDisable(true);
            this.spnSpreadSell.getEditor().clear();
            this.lbStarDiffBuy.setVisible(false);
            this.lbStarQtyBuy.setVisible(false);
            this.lbStarPriceSellType.setVisible(false);
        }
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbAcctErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbAcct.getEditor().getText().isEmpty()) {
                this.lbAcctErr.setText("\u8bf7\u8f93\u5165\u8d44\u91d1\u8d26\u6237");
                return false;
            }
            if (!this.model.accMng.getFundAccList().contains(this.cmbAcct.getEditor().getText())) {
                this.lbAcctErr.setText("\u8f93\u5165\u7684\u8d44\u91d1\u8d26\u53f7\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbAcct.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.lbName.getText().isEmpty() && this.stg == null) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            if (INVALID_CODE.equals(this.lbName.getText())) {
                this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbPriceCustomErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtPriceCustom.isFocused() || this.cmbType.getValue() != null && !StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"6", "9"})) {
                return true;
            }
            if (this.txtPriceCustom.getText().isEmpty()) {
                this.lbPriceCustomErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
                return false;
            }
            RuleResult result = this.exp.validateExpression(this.txtPriceCustom.getText().trim());
            if (!result.getResult()) {
                FalseRuleResult falseResult = (FalseRuleResult)result;
                this.lbPriceCustomErr.setText(falseResult.getCode().getErrorMessage());
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPriceCustom.focusedProperty(), this.txtPriceCustom.textProperty(), this.cmbType.valueProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtName.getText().isEmpty()) {
                this.lbNameErr.setText("\u8bf7\u8f93\u5165\u7b56\u7565\u540d\u79f0");
                return false;
            }
            if (this.nameList.contains(this.txtName.getText())) {
                this.lbNameErr.setText("\u6b64\u540d\u79f0\u5df2\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.registerCheck((Node)this.lbBaseCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"5", "7", "8", "11"})) {
                return true;
            }
            if (this.txtBaseCode.getText().isEmpty()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBaseCode.textProperty(), this.cmbType.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbPriceSlipErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnPriceSlip.getEditor().getText().isEmpty()) {
                this.lbPriceSlipErr.setText("\u8bf7\u8f93\u5165\u6700\u5c0f\u79fb\u52a8");
                return false;
            }
            if (Double.valueOf(this.spnPriceSlip.getEditor().getText().replaceAll(",", "")) == 0.0) {
                this.lbPriceSlipErr.setText("\u6700\u5c0f\u79fb\u52a8\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPriceSlip.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbDealLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnDealLimit.getEditor().getText().isEmpty()) {
                this.lbDealLimitErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u6210\u4ea4");
                return false;
            }
            if (Integer.valueOf(this.spnDealLimit.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbDealLimitErr.setText("\u6700\u5927\u6210\u4ea4\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDealLimit.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbDiffBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("8")) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioSell.isSelected()) {
                return true;
            }
            if (this.spnDiffBuy.getEditor().getText().isEmpty()) {
                this.lbDiffBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u4ef7\u70b9\u5dee");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffBuy.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbDiffSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("7")) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioBuy.isSelected()) {
                return true;
            }
            if (this.spnDiffSell.getEditor().getText().isEmpty()) {
                this.lbDiffSellErr.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u70b9\u5dee");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDiffSell.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbSpreadSumErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"7", "8", "9"})) {
                return true;
            }
            double buy = StringUtils.parseDouble((String)this.spnDiffBuy.getEditor().getText());
            double sell = StringUtils.parseDouble((String)this.spnDiffSell.getEditor().getText());
            if (buy > this.maxDiff || sell > this.maxDiff) {
                this.lbSpreadSumErr.setText("\u62a5\u4ef7\u4ef7\u5dee\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u62a5\u4ef7\u4ef7\u5dee" + this.maxDiff);
                this.spnSpreadSum.getEditor().setText(String.format("%.3f", buy + sell));
                return false;
            }
            if (buy + sell > this.maxDiff) {
                if (this.spnDiffSell.isFocused()) {
                    this.spnDiffBuy.getEditor().setText(String.format("%.3f", this.maxDiff - sell));
                } else {
                    this.spnDiffSell.getEditor().setText(String.format("%.3f", this.maxDiff - buy));
                }
            }
            if (!(buy + sell > 0.0)) {
                this.spnSpreadSum.getEditor().setText("");
                this.lbSpreadSumErr.setText("\u4e70\u5356\u70b9\u5dee\u4e0d\u53ef\u540c\u65f6\u4e3a0");
                return false;
            }
            this.spnSpreadSum.getEditor().setText(String.format("%.3f", buy + sell));
            return true;
        }, (Observable[])new Observable[]{this.spnDiffSell.getEditor().textProperty(), this.spnDiffBuy.getEditor().textProperty(), this.lbMaxDiff.textProperty()}));
        this.registerCheck((Node)this.lbQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("8")) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioSell.isSelected()) {
                return true;
            }
            if (this.spnQtyBuy.getEditor().getText().isEmpty()) {
                this.lbQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                return false;
            }
            if (Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")) > 39) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u624b\u6570\u4e0a\u9650\u4e3a39");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtyBuy.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("7")) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioBuy.isSelected()) {
                return true;
            }
            if (this.checkSplit.isSelected()) {
                return true;
            }
            if (this.spnQtySell.getEditor().getText().isEmpty()) {
                this.lbQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                return false;
            }
            if (Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")) > 39) {
                this.lbQtySellErr.setText("\u5356\u51fa\u624b\u6570\u4e0a\u9650\u4e3a39");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQtySell.getEditor().textProperty(), this.radioBuy.selectedProperty()}));
        this.registerCheck((Node)this.lbTotalQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.checkSplit.isSelected() || !this.gridSplit.isVisible()) {
                return true;
            }
            if (this.spnTotalQty.getEditor().getText().isEmpty()) {
                this.lbTotalQtyErr.setText("\u8bf7\u8f93\u5165\u603b\u4e0b\u5355\u6570\u91cf");
                return false;
            }
            int total = Integer.valueOf(this.spnTotalQty.getEditor().getText().replaceAll(",", ""));
            int qty = Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", ""));
            if (total == 0) {
                this.lbTotalQtyErr.setText("\u603b\u4e0b\u5355\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            if (qty > 0 && Math.ceil(1.0 * (double)total / (double)qty) > 80.0) {
                this.lbTotalQtyErr.setText("\u5b50\u7b56\u7565\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e80");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTotalQty.getEditor().textProperty(), this.spnQtyBuy.getEditor().textProperty(), this.checkSplit.selectedProperty(), this.gridSplit.visibleProperty()}));
        this.registerCheck((Node)this.lbMarketMakingErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.checkHedge.isSelected()) {
                return true;
            }
            if (this.txtMarketMaking.getText().isEmpty()) {
                this.lbMarketMakingErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtMarketMaking.getText().replaceAll(",", "")) <= 0) {
                this.lbMarketMakingErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtMarketMaking.textProperty(), this.checkHedge.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.checkHedge.isSelected()) {
                return true;
            }
            if (this.txtHedge.getText().isEmpty()) {
                this.lbHedgeErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtHedge.getText().replaceAll(",", "")) <= 0) {
                this.lbHedgeErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedge.textProperty(), this.checkHedge.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgePriceCustomSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.checkHedge.isSelected() || this.cmbType.getValue() != null && !StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"6", "9"})) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioSell.isSelected()) {
                return true;
            }
            if (this.txtHedgePriceCustomSell.isFocused() && this.refItem != null) {
                return true;
            }
            if (this.refItem == null) {
                this.lbHedgePriceCustomSellErr.setText("\u8bf7\u5148\u8f93\u5165\u6709\u6548\u4ee3\u7801");
                return false;
            }
            if (this.txtHedgePriceCustomSell.getText().isEmpty()) {
                this.lbHedgePriceCustomSellErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
                return false;
            }
            String expression = this.txtHedgePriceCustomSell.getText().trim().replaceAll("LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE");
            RuleResult result = this.exp.validateExpression(expression);
            if (!result.getResult()) {
                FalseRuleResult falseResult = (FalseRuleResult)result;
                this.lbHedgePriceCustomSellErr.setText(falseResult.getCode().getErrorMessage());
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedgePriceCustomSell.focusedProperty(), this.checkHedge.selectedProperty(), this.txtHedgePriceCustomSell.textProperty(), this.cmbType.valueProperty(), this.radioSell.selectedProperty()}));
        this.registerCheck((Node)this.lbHedgePriceCustomBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.checkHedge.isSelected() || this.cmbType.getValue() != null && !StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"6", "9"})) {
                return true;
            }
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("9") && this.radioBuy.isSelected()) {
                return true;
            }
            if (this.txtHedgePriceCustomBuy.isFocused() && this.refItem != null) {
                return true;
            }
            if (this.refItem == null) {
                this.lbHedgePriceCustomBuyErr.setText("\u8bf7\u5148\u8f93\u5165\u6709\u6548\u4ee3\u7801");
                return false;
            }
            if (this.txtHedgePriceCustomBuy.getText().isEmpty()) {
                this.lbHedgePriceCustomBuyErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u516c\u5f0f");
                return false;
            }
            String expression = this.txtHedgePriceCustomBuy.getText().trim().replaceAll("LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE");
            RuleResult result = this.exp.validateExpression(expression);
            if (!result.getResult()) {
                FalseRuleResult falseResult = (FalseRuleResult)result;
                this.lbHedgePriceCustomBuyErr.setText(falseResult.getCode().getErrorMessage());
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedgePriceCustomBuy.focusedProperty(), this.checkHedge.selectedProperty(), this.txtHedgePriceCustomBuy.textProperty(), this.cmbType.valueProperty(), this.radioBuy.selectedProperty()}));
    }

    private String addPositive(String str) {
        if (str.length() > 0 && str.toCharArray()[0] != '-') {
            return String.valueOf('+') + str;
        }
        return str;
    }

    protected FutureStrategy getStrategy(boolean isCopyOrNew) throws Exception, MException {
        FutureStrategy strategy = (FutureStrategy)this.of.create(FutureStrategy.class);
        if (this.stg != null) {
            strategy.setInExe(this.stg.isInExe());
        }
        if (isCopyOrNew) {
            strategy.setMarket(this.refItem.getMarket());
            strategy.setExtFundAccntId(this.model.accMng.getFundAcc(this.cmbAcct.getEditor().getText()).getExtAccntId());
            SecAccount secAcct = this.model.getExtSecAcc(this.cmbAcct.getEditor().getText(), ((MxNode)this.cmbShFlag.getSelectionModel().getSelectedItem()).getRaw(), this.refItem.getMarket());
            strategy.setExtSecAccntId(secAcct.getExtSecAccntId());
            strategy.setSecurity(this.txtCode.getText());
            strategy.setSecurityType(this.refItem.getType());
        } else {
            strategy.setContextId(this.stg.getContextId());
            strategy.setMarket(this.stg.getMarket());
            strategy.setExtFundAccntId(this.stg.getExtFundAccntId());
            strategy.setExtSecAccntId(this.stg.getExtSecAccntId());
            strategy.setSecurity(this.stg.getSecurity());
            strategy.setSecurityType(this.stg.getSecurityType());
        }
        strategy.setShFlag(((MxNode)this.cmbShFlag.getSelectionModel().getSelectedItem()).getRaw());
        strategy.setOcFlag(((MxNode)this.cmbOcFlag.getSelectionModel().getSelectedItem()).getRaw());
        strategy.setTacticsType((MxNode)this.cmbType.getSelectionModel().getSelectedItem());
        strategy.setBuy(this.radioBuy.isSelected());
        strategy.setName(this.txtName.getText());
        if (StringUtils.belongto((String)((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw(), (String[])new String[]{"6", "9"})) {
            strategy.setRefPriceCustom(this.txtPriceCustom.getText());
            strategy.setHedgePriceCustomSell(this.txtHedgePriceCustomSell.getText().trim().replaceAll("LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE"));
            strategy.setHedgePriceCustomBuy(this.txtHedgePriceCustomBuy.getText().trim().replaceAll("LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE"));
        } else {
            String custom = "[" + this.txtBaseCode.getText() + "]." + ((MxNode)this.cmbPriceType.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnBaseSpread.getEditor().getText().trim());
            strategy.setRefPriceCustom(custom);
            if (this.checkHedge.isSelected()) {
                String priceBuy = null;
                String priceSell = null;
                if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals("11")) {
                    priceBuy = "[" + this.refItem.getCode() + "].LAST_FILL_PRICE" + this.addPositive(this.spnSpreadBuy.getEditor().getText().trim());
                    priceSell = "[" + this.refItem.getCode() + "].LAST_FILL_PRICE" + this.addPositive(this.spnSpreadSell.getEditor().getText().trim());
                } else {
                    priceBuy = "[" + this.txtHedgeContract.getText() + "]." + ((MxNode)this.cmbPriceBuyType.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadBuy.getEditor().getText().trim());
                    priceSell = "[" + this.txtHedgeContract.getText() + "]." + ((MxNode)this.cmbPriceSellType.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadSell.getEditor().getText().trim());
                    if (priceSell.contains("LFP")) {
                        priceSell = priceSell.replaceAll("\\[" + this.txtHedgeContract.getText() + "\\]." + "LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE");
                    }
                    if (priceBuy.contains("LFP")) {
                        priceBuy = priceBuy.replaceAll("\\[" + this.txtHedgeContract.getText() + "\\]." + "LFP", "[" + this.refItem.getCode() + "].LAST_FILL_PRICE");
                    }
                }
                strategy.setHedgePriceCustomSell(priceSell);
                strategy.setHedgePriceCustomBuy(priceBuy);
            }
        }
        strategy.setPriceSlip(Double.valueOf(this.spnPriceSlip.getEditor().getText().replaceAll(",", "")).doubleValue());
        if (!this.spnDiffBuy.getEditor().getText().isEmpty()) {
            strategy.setBidSpread(Double.valueOf(this.spnDiffBuy.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnDiffSell.getEditor().getText().isEmpty()) {
            strategy.setAskSpread(Double.valueOf(this.spnDiffSell.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnQtyBuy.getEditor().getText().isEmpty()) {
            strategy.setBidQty(Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")).intValue());
        }
        if (!this.spnQtySell.getEditor().getText().isEmpty()) {
            strategy.setAskQty(Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")).intValue());
        }
        strategy.setDealLimit(Integer.valueOf(this.spnDealLimit.getEditor().getText().replaceAll(",", "")).intValue());
        if (this.checkHedge.isSelected()) {
            strategy.setHedgeContract(this.txtHedgeContract.getText());
            if (!this.txtHedge.getText().isEmpty()) {
                strategy.setHedgeCount(Integer.valueOf(this.txtHedge.getText()).intValue());
            }
            if (!this.txtMarketMaking.getText().isEmpty()) {
                strategy.setMarketMakingCount(Integer.valueOf(this.txtMarketMaking.getText()).intValue());
            }
            if (!this.txtTimeoutFill.getText().isEmpty()) {
                strategy.setTimeoutFill(Integer.valueOf(this.txtTimeoutFill.getText()).intValue());
            }
            if (!this.spnStoplossFill.getEditor().getText().isEmpty()) {
                strategy.setStoplossFill(Double.valueOf(this.spnStoplossFill.getEditor().getText().replaceAll(",", "")).doubleValue());
            }
        }
        strategy.setSplit(this.checkSplit.isSelected());
        if (this.checkSplit.isSelected() && !this.spnQtyBuy.getEditor().getText().isEmpty()) {
            strategy.setTotalQty(Integer.valueOf(this.spnTotalQty.getEditor().getText().replaceAll(",", "")).intValue());
        }
        return strategy;
    }

    private double getPriceMaxDiff(CtpRefItem ref) {
        FuturePriceMaxDiff future2;
        if (ref == null) {
            return Double.MAX_VALUE;
        }
        int mainContract = ref.getMainContract();
        HashMap<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
        for (FuturePriceMaxDiff future2 : this.settings.getMaxDifPriceSettingList()) {
            map.put(future2.getType(), future2);
        }
        future2 = (FuturePriceMaxDiff)map.get(ref.getProductId());
        if (future2 == null || future2.getEnable() == 3) {
            future2 = (FuturePriceMaxDiff)map.get("DEFAULT");
        }
        if (future2 == null || future2.getEnable() == 3) {
            return Double.MAX_VALUE;
        }
        return mainContract == 1 ? future2.getDominantContract() : future2.getNonPrimeContract();
    }

    protected void initControls() {
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
        this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
        this.cmbAcct.getSelectionModel().select(0);
        this.suggestFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.suggestFund);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.spCode.addPossibleSuggestions(this.getRefList());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            CtpRefItem ctpItem;
            this.refItem = (RefItem)this.txtCode.getUserData();
            if (this.refItem == null || this.refItem.getName().equals("")) {
                this.lbName.setText(INVALID_CODE);
            } else {
                this.lbName.setText(this.refItem.getName());
            }
            if (this.txtCode.getText().isEmpty()) {
                this.lbName.setText("");
            }
            this.resetUnit(this.ctrlDiffBuy, this.ctrlBaseSpread, this.ctrlDiffSell, this.ctrlThreshold, this.ctrlStoploss, this.ctrlSpreadBuy, this.ctrlSpreadSell);
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("1")) {
                this.txtBaseCode.setText(this.txtCode.getText());
                if (this.checkHedge.isSelected()) {
                    this.txtHedgeContract.setText(this.txtCode.getText());
                }
            }
            if ((ctpItem = (CtpRefItem)this.refItem) != null) {
                this.maxDiff = this.getPriceMaxDiff(ctpItem);
                if (this.maxDiff == Double.MAX_VALUE) {
                    this.spnSpreadSum.getEditor().setPromptText("\u62a5\u4ef7\u4ef7\u5dee\u65e0\u4e0a\u9650");
                } else {
                    this.spnSpreadSum.getEditor().setPromptText("\u6700\u5927\u4e3a " + this.getPriceMaxDiff(ctpItem));
                }
            } else {
                this.maxDiff = Double.MAX_VALUE;
                this.lbMaxDiff.setText("");
            }
        });
        TooltipUtil.bind((Label)this.lbName);
        this.txtBaseCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Search.bindAutoCompletion((TextField)this.txtBaseCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            if (!StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"6", "9"}) && this.checkHedge.isSelected()) {
                this.txtHedgeContract.setText(this.txtBaseCode.getText());
            }
        });
        this.vboxDown.disableProperty().bind((ObservableValue)this.checkHedge.selectedProperty().not());
        this.gridHedgeContract.disableProperty().bind((ObservableValue)this.checkHedge.selectedProperty().not());
        this.gridBottom.disableProperty().bind((ObservableValue)this.checkHedge.selectedProperty().not());
        this.checkHedge.selectedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.txtHedgeContract.clear();
                this.txtHedgePriceCustomBuy.clear();
                this.txtHedgePriceCustomSell.clear();
                this.spnSpreadBuy.getEditor().clear();
                this.spnSpreadSell.getEditor().clear();
                this.txtMarketMaking.clear();
                this.txtHedge.clear();
                this.txtTimeoutFill.clear();
                this.spnStoplossFill.getEditor().clear();
            } else {
                if (!StringUtils.belongto((String)((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw(), (String[])new String[]{"6", "9"})) {
                    this.txtHedgeContract.setText(this.txtBaseCode.getText());
                }
                if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals("11")) {
                    this.txtMarketMaking.setText("1");
                    this.txtHedge.setText("1");
                }
            }
        });
        this.txtHedgeContract.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Search.bindAutoCompletion((TextField)this.txtHedgeContract, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItemHedge = (RefItem)this.txtHedgeContract.getUserData();
            if (this.refItemHedge == null || this.refItemHedge.getName().equals("")) {
                this.lbContract.setText(INVALID_CODE);
            } else {
                this.lbContract.setText(this.refItemHedge.getName());
            }
            if (this.txtHedgeContract.getText().isEmpty()) {
                this.lbContract.setText("");
            }
        });
        this.txtHedgeContract.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtHedgeContract.selectAll());
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5\\.]*", 32));
        this.ctrlThreshold.ctrl(this.spnPriceSlip);
        this.spnPriceSlip.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceSlip.getEditor()));
        this.ctrlBaseSpread.ctrl(this.spnBaseSpread);
        this.spnBaseSpread.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnBaseSpread.getEditor()));
        this.ctrlSpreadBuy.ctrl(this.spnSpreadBuy);
        this.spnSpreadBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadBuy.getEditor()));
        this.ctrlSpreadSell.ctrl(this.spnSpreadSell);
        this.spnSpreadSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadSell.getEditor()));
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        this.spnDiffBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffBuy.getEditor()));
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        this.spnDiffSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiffSell.getEditor()));
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.spnQtyBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            if (this.checkSplit.isSelected()) {
                this.spnQtySell.getEditor().setText(now);
            }
        });
        this.ctrlCountSell.ctrl(this.spnQtySell);
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        this.ctrlTotalCount.ctrl(this.spnTotalQty);
        this.spnTotalQty.getEditor().setOnMouseClicked(event -> this.spnTotalQty.getEditor().selectAll());
        this.ctrlDealLimit.ctrl(this.spnDealLimit);
        this.spnDealLimit.getEditor().setOnMouseClicked(event -> this.spnDealLimit.getEditor().selectAll());
        this.txtTimeoutFill.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 9));
        this.ctrlStoploss.ctrl(this.spnStoplossFill);
        this.spnPriceSlip.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnStoplossFill.getEditor()));
        this.ctrlHedgeSlip.getVF().setUnit(0.005);
        this.ctrlHedgeSlip.ctrl(this.spnHedgeSlip);
        this.radioBuy.setToggleGroup(this.group);
        this.radioSell.setToggleGroup(this.group);
        this.radioBuy.setSelected(true);
        this.radioBuy.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.spnDiffBuy.setDisable(false);
                this.spnQtyBuy.setDisable(false);
                this.txtHedgePriceCustomSell.setDisable(false);
                this.spnDiffSell.setDisable(true);
                this.spnQtySell.setDisable(true);
                this.txtHedgePriceCustomBuy.setDisable(true);
                this.spnDiffSell.getEditor().clear();
                this.spnQtySell.getEditor().clear();
                this.txtHedgePriceCustomBuy.clear();
            } else {
                this.spnDiffBuy.setDisable(true);
                this.spnQtyBuy.setDisable(true);
                this.txtHedgePriceCustomSell.setDisable(true);
                this.spnDiffSell.setDisable(false);
                this.spnQtySell.setDisable(false);
                this.txtHedgePriceCustomBuy.setDisable(false);
                this.spnDiffBuy.getEditor().clear();
                this.spnQtyBuy.getEditor().clear();
                this.txtHedgePriceCustomSell.clear();
            }
        });
    }

    private void resetUnit(DoubleSpinnerCtrl ... ctrls) {
        if (this.refItem == null) {
            return;
        }
        if (this.refItem.getPriceUnit() == 0.0) {
            this.refItem.setPriceUnit(0.001);
        }
        if (this.refItem.getScale() == 0) {
            this.refItem.setScale(3);
        }
        DoubleSpinnerCtrl[] doubleSpinnerCtrlArray = ctrls;
        int n = ctrls.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleSpinnerCtrl ctrl = doubleSpinnerCtrlArray[n2];
            ctrl.getVF().setUnit(this.refItem.getPriceUnit());
            ctrl.setScale(this.refItem.getScale());
            ++n2;
        }
    }
}

