/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.views.FutureMonitorPart;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.current.models.CtpAccountMap;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureMonitorPartAll
extends MxPart {
    private static final Logger logger = LogManager.getLogger(FutureMonitorPartAll.class);
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @FXML
    private FlowPane flowPane;
    @Inject
    private MObjFactory of;
    @FXML
    private AnchorPane addPane;
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;
    @Inject
    public CtpAccountMap accMng;
    private List<FutureMonitorPart> list = new ArrayList<FutureMonitorPart>();
    private static final String FUNDACCT = "fundAcct";
    private static final String TYPE = "type";
    private static final String MARKET = "market";
    private static final String CODE = "code";
    private static final String TOPIC_MONITOR = "shutdown.monitor";
    private MEventHandler handler = event -> {
        if (event.getObj() instanceof Parent) {
            Parent parent = (Parent)event.getObj();
            this.remove(parent);
        }
    };
    private boolean loaded = false;
    List<RefItem> nationalRefList = null;
    private InvalidationListener acctChange = ob -> {
        logger.debug("\u89e6\u53d1\u4e86\u8d44\u91d1\u8d26\u53f7change:" + this.nationalRefList.size());
        if (this.nationalRefList.size() != 0) {
            Platform.runLater(() -> this.showLast());
        }
    };
    private InvalidationListener refChange = ob -> {
        logger.debug("\u89e6\u53d1\u4e86\u9759\u6001\u6570\u636echange:" + this.accMng.getFundAccList().size());
        this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        if (this.accMng.getFundAccList().size() != 0 && this.nationalRefList.size() != 0) {
            Platform.runLater(() -> this.showLast());
        }
    };

    @FXML
    private void initialize() {
        this.es.subscribe(TOPIC_MONITOR, this.handler);
        this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        if (this.accMng.getFundAccList().size() == 0) {
            logger.error("\u8d44\u91d1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u542f\u52a8\u76d1\u542c...");
            this.accMng.changedProperty().addListener(this.acctChange);
        }
        if (this.nationalRefList.size() == 0) {
            logger.error("\u9759\u6001\u6570\u636e\u4e3a\u7a7a\uff0c\u542f\u52a8\u76d1\u542c...");
            this.refMng.changedProperty().addListener(this.refChange);
        }
        if (this.accMng.getFundAccList().size() != 0 && this.nationalRefList.size() != 0) {
            this.showLast();
        }
    }

    private void showLast() {
        String postId;
        logger.debug("\u5f00\u59cb\u6e32\u67d3\uff0cshowLast!" + this.accMng.getFundAccList().size() + "  " + this.nationalRefList.size());
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        String userId = this.eCore.getStr("user_id");
        File file = Paths.get(this.pathBase, "data", userId, postId = this.eCore.getStr("post_id"), "future_marketmaking_monitor.txt").toFile();
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                byte[] b = new byte[in.available()];
                in.read(b);
                String json = new String(b);
                Gson gson = new Gson();
                JsonArray array = (JsonArray)gson.fromJson(json, JsonArray.class);
                if (array == null) {
                    in.close();
                    return;
                }
                for (JsonElement element : array) {
                    JsonObject obj;
                    if (!element.isJsonObject() || (obj = element.getAsJsonObject()).get(FUNDACCT) == null || obj.get(CODE) == null) continue;
                    logger.debug(obj.get(FUNDACCT) + " " + obj.get(CODE));
                    FutureMonitorPart part = (FutureMonitorPart)((Object)this.of.create(FutureMonitorPart.class));
                    if (part.cmbAcct.getItems().contains((Object)obj.get(FUNDACCT).getAsString())) {
                        part.cmbAcct.getSelectionModel().select((Object)obj.get(FUNDACCT).getAsString());
                    }
                    part.txtCode.setText(obj.get(CODE).getAsString());
                    part.txtCode.setUserData((Object)this.refMng.getItem(obj.get(TYPE).getAsString(), obj.get(MARKET).getAsString(), obj.get(CODE).getAsString()));
                    part.auto.setChange(obj.get(CODE).getAsString());
                    int index = this.flowPane.getChildren().size() - 1;
                    this.flowPane.getChildren().add(index, (Object)part.content);
                    this.list.add(index, part);
                }
                in.close();
            }
            catch (IOException e) {
                logger.error(String.valueOf(e.getMessage()) + "showLast\u5f02\u5e38", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe(TOPIC_MONITOR, this.handler);
        String userId = this.eCore.getStr("user_id");
        String postId = this.eCore.getStr("post_id");
        File file = Paths.get(this.pathBase, "data", userId, postId, "future_marketmaking_monitor.txt").toFile();
        JsonArray array = new JsonArray();
        for (FutureMonitorPart part : this.list) {
            JsonObject obj = new JsonObject();
            if (part.cmbAcct.getSelectionModel().getSelectedItem() != null) {
                obj.addProperty(FUNDACCT, (String)part.cmbAcct.getSelectionModel().getSelectedItem());
            }
            if (part.mktItem != null && part.mktItem.getRefItem() != null) {
                obj.addProperty(TYPE, part.mktItem.getRefItem().getType());
                obj.addProperty(MARKET, part.mktItem.getRefItem().getMarket());
                obj.addProperty(CODE, part.mktItem.getRefItem().getCode());
            }
            array.add((JsonElement)obj);
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(array.toString().getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        this.accMng.changedProperty().removeListener(this.acctChange);
        this.refMng.changedProperty().removeListener(this.refChange);
    }

    @FXML
    private void add() {
        FutureMonitorPart part = (FutureMonitorPart)((Object)this.of.create(FutureMonitorPart.class));
        int index = this.flowPane.getChildren().size() - 1;
        this.flowPane.getChildren().add(index, (Object)part.content);
        this.list.add(index, part);
    }

    private void remove(Parent parent) {
        int index = this.flowPane.getChildren().indexOf((Object)parent);
        if (this.flowPane.getChildren().contains((Object)parent)) {
            this.flowPane.getChildren().remove((Object)parent);
            this.list.remove(index);
        }
    }
}

