/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MEvent;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.FuturePriceCell;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.datatype.proto.strategy.PStrategyMonitor;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Indicator;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.models.FutureMonitorModel;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.trade.message.NoticeTipsSettingsMng;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureMonitorPart
extends MxTabContent {
    private static final Logger logger = LogManager.getLogger(FutureMonitorPart.class);
    private MxList<Indicator> mlist = new MxList();
    @FXML
    private HBox hboxMonitor;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private Circle circleMain;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell2;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy2;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    protected Label lbUpLimit;
    @FXML
    protected Label lbDownLimit;
    @FXML
    public TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    public ComboBox<String> cmbAcct;
    protected MarketItem mktItem;
    @Inject
    private FutureMonitorModel model;
    protected SecSuggest spCode = new SecSuggest();
    private SecConverter secCvt;
    @Inject
    private MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @FXML
    private TableView<Indicator> monitTable;
    @FXML
    private TableColumn<Indicator, MxNode> indicator;
    @FXML
    private TableColumn<Indicator, String> value;
    @Inject
    private ExecutorService exe;
    private Future<?> future;
    @Inject
    private ScheduledExecutorService ses;
    private static final String CONTINUE_BIDDING_PERCENT = "3";
    @FXML
    private TableColumn<Indicator, Object> color;
    private CtpRefItem refItem = null;
    private InvalidationListener lstnModel = ob -> {
        System.currentTimeMillis();
        this.mlist.update(this.model.getList(), p -> true);
        Platform.runLater(() -> this.monitTable.layout());
    };
    private InvalidationListener listenerRefMng = ob -> this.spCode.setAllSuggestions(this.getRefList());
    private InvalidationListener listenerMktItemPercent = ob -> {
        CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getPreSettlementPrice(), (double)this.mktItem.getNowPrice());
        CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
    };
    @Inject
    private NoticeTipsSettingsMng ntsMng;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    private InvalidationListener resetedOccur = ob -> Platform.runLater(() -> {
        this.tableMarketBuy2.layout();
        this.tableMarketSell2.layout();
    });
    private List<HandicapInfo> listBuyHandicap = new ArrayList<HandicapInfo>();
    private List<HandicapInfo> listSellHandicap = new ArrayList<HandicapInfo>();
    private InvalidationListener marketItemChanged = ob -> this.exe.execute(() -> {
        if (this.mktItem.isClear()) {
            return;
        }
        this.model.refresh();
    });
    private String nowPrice = "";
    private String upLimitPrice = "";
    private Map<String, FundAccount> mapFund = new HashMap<String, FundAccount>(1000);
    protected SecSuggest.StrSuggest spFund = SecSuggest.getStrSuggest();
    public AutoCompletion<RefItem> auto;
    private List<RefItem> nationalRefList = null;

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.createMarketTable();
        this.initControls();
        this.mktItem.changedProperty().addListener(this.marketItemChanged);
        this.scrollPane.setVvalue(0.5);
        this.createTableView();
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.resetProperty().addListener(this.resetedOccur);
        this.future = this.ses.scheduleAtFixedRate(() -> this.refresh(), 0L, 5L, TimeUnit.SECONDS);
        this.hboxMonitor.addEventFilter(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton().name().equals(MouseButton.MIDDLE.name())) {
                MEvent event = new MEvent();
                event.setObj((Object)this.content);
                this.es.sendEvent("shutdown.monitor", event);
                this.model.close();
                this.close();
            }
        });
        this.tableMarketSell2.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                HandicapInfo info = (HandicapInfo)this.tableMarketSell2.getSelectionModel().getSelectedItem();
                if (info == null) {
                    return;
                }
                MEvent e = new MEvent();
                e.put((Object)"price", (Object)info.getPrice());
                this.es.postEvent("monitor.cancel.order", e);
            }
            Platform.runLater(() -> this.tableMarketSell2.getSelectionModel().clearSelection());
        });
        this.tableMarketBuy2.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() == 2) {
                HandicapInfo info = (HandicapInfo)this.tableMarketBuy2.getSelectionModel().getSelectedItem();
                if (info == null) {
                    return;
                }
                MEvent e = new MEvent();
                e.put((Object)"price", (Object)info.getPrice());
                this.es.postEvent("monitor.cancel.order", e);
            }
            Platform.runLater(() -> this.tableMarketBuy2.getSelectionModel().clearSelection());
        });
        this.model.accountProperty().bind((ObservableValue)this.cmbAcct.valueProperty());
        this.model.codeProperty().bind((ObservableValue)this.txtCode.textProperty());
        this.refMng.changedProperty().addListener(this.listenerRefMng);
        int i = 0;
        while (i < 5) {
            HandicapInfo infoBuy = new HandicapInfo();
            HandicapInfo infoSell = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoSell.setIndex(i + 1);
            this.listBuyHandicap.add(infoBuy);
            this.listSellHandicap.add(infoSell);
            ++i;
        }
    }

    @PreDestroy
    private void close() {
        this.mktItem.changedProperty().removeListener(this.marketItemChanged);
        this.future.cancel(true);
        this.model.accountProperty().unbind();
        this.model.codeProperty().unbind();
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
        this.mktItem.pctProperty().removeListener(this.listenerMktItemPercent);
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.resetProperty().addListener(this.resetedOccur);
    }

    private void refresh() {
        this.exe.execute(() -> {
            System.currentTimeMillis();
            this.model.query();
        });
    }

    private void createTableView() {
        this.indicator.setCellValueFactory(cell -> ((Indicator)cell.getValue()).indicatorProperty());
        this.value.setCellValueFactory(cell -> {
            SimpleStringProperty str = new SimpleStringProperty();
            String s = String.format("%.1f", ((Indicator)cell.getValue()).getRealtimeValue());
            if (((Indicator)cell.getValue()).getIndicator().getRaw().equals(CONTINUE_BIDDING_PERCENT)) {
                s = String.valueOf(s) + "%";
            }
            str.set((Object)s);
            return str;
        });
        this.color.setCellValueFactory(cell -> this.setColor((Indicator)cell.getValue()));
        this.monitTable.setItems(this.mlist.getList());
        this.monitTable.setPlaceholder((Node)new Label());
        this.indicator.setCellFactory(data -> new TooltipTableCell<Indicator, MxNode>(){

            protected void updateItem(MxNode item, boolean empty) {
                Indicator ap;
                super.updateItem((Object)item, empty);
                if (this.getTableRow() != null && !empty && (ap = (Indicator)this.getTableRow().getItem()) != null) {
                    this.setText(ap.getIndicator().getValue());
                }
            }

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    Indicator i = (Indicator)this.getValue();
                    StringBuilder sb = new StringBuilder();
                    sb.append("\u6863\u4f4d\u4e00  \u9608\u503c\uff1a" + i.getValue1() + "  \u989c\u8272 " + FutureMonitorPart.this.getColorString(i.getColor1()) + "\n");
                    sb.append("\u6863\u4f4d\u4e8c  \u9608\u503c\uff1a" + i.getValue2() + "  \u989c\u8272 " + FutureMonitorPart.this.getColorString(i.getColor2()) + "\n");
                    return sb.toString();
                }
                return null;
            }
        });
    }

    private String getColorString(PStrategyMonitor.Color color) {
        switch (color.getNumber()) {
            case 0: {
                return "\u672a\u8bbe\u7f6e";
            }
            case 1: {
                return "\u65e0\u989c\u8272";
            }
            case 2: {
                return "\u9ec4\u8272";
            }
            case 3: {
                return "\u7ea2\u8272";
            }
        }
        return "";
    }

    public ReadOnlyObjectWrapper<Object> setColor(Indicator ap) {
        Circle circle = new Circle();
        circle.setRadius(5.0);
        if (ap.getRealtimeSound() == PStrategyMonitor.SoundAlert.SOUND_ALERT_SYS) {
            this.ntsMng.voicePrompt("\u98ce\u9669\u76d1\u63a7 ");
        }
        if (ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_YELLOW) {
            circle.setFill((Paint)Color.YELLOW);
        } else if (ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_RED) {
            circle.setFill((Paint)Color.RED);
        } else if (ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_UNDEFINED || ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_NONE) {
            return null;
        }
        return new ReadOnlyObjectWrapper((Object)circle);
    }

    private void update() {
        this.updateHandicapInfo(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap());
        this.updateHandicapInfo(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap());
    }

    private void updateHandicapInfo(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < this.model.getGear()) {
            if (listInfo.size() <= i) {
                listHandicap.get(i).clear();
            }
            listHandicap.get(i).update((Object)listInfo.get(i));
            ++i;
        }
    }

    private boolean isSame(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < this.model.getGear()) {
            if (listHandicap.get(i).getPrice() != listInfo.get(i).getPrice()) {
                logger.error("old: " + listHandicap.get(i).getPrice() + "new: " + listInfo.get(i).getPrice());
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateLabelPrice() {
        if (this.mktItem == null || this.mktItem.getRefItem() == null) {
            return;
        }
        int scale = this.mktItem.getRefItem().getScale();
        String nowPrice = String.format("%." + scale + "f", this.mktItem.getNowPrice());
        String upLimitPrice = String.format("%." + scale + "f", this.mktItem.getUpLimitPrice());
        String downLimitPrice = String.format("%." + scale + "f", this.mktItem.getDownLimitPrice());
        String rate = String.valueOf(String.format("%1$,.2f", this.mktItem.getPct())) + "%";
        if (!this.nowPrice.equals(nowPrice) || !this.upLimitPrice.equals(upLimitPrice)) {
            this.nowPrice = nowPrice;
            this.upLimitPrice = upLimitPrice;
            Platform.runLater(() -> {
                this.lbLatest.setText(nowPrice);
                this.lbUpLimit.setText(upLimitPrice);
                this.lbDownLimit.setText(downLimitPrice);
                this.lbRate.setText(rate);
            });
        }
    }

    protected void onSecChange() {
        this.model.getMI().setRefItem((RefItem)this.refItem);
        this.refresh();
        if (this.refItem != null) {
            this.lbName.setText(this.refItem.getName());
        } else {
            this.lbName.setText("");
        }
        TradeBindings.priceBinding((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
        TradeBindings.priceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
    }

    private List<RefItem> getRefList() {
        if (this.nationalRefList == null || this.nationalRefList.size() == 0) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        return this.nationalRefList;
    }

    protected void initControls() {
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(this.getRefList());
        this.auto = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.auto.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            Object obj = this.txtCode.getUserData();
            if (obj instanceof CtpRefItem) {
                this.refItem = (CtpRefItem)CtpRefItem.class.cast(obj);
                if (this.refItem.getMainContract() == 1) {
                    this.circleMain.setVisible(true);
                } else {
                    this.circleMain.setVisible(false);
                }
            } else {
                this.circleMain.setVisible(false);
                if (this.refItem != null) {
                    this.refItem = null;
                } else {
                    return;
                }
            }
            this.onSecChange();
            this.model.onSecChange();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        TooltipUtil.bind((Label)this.lbName);
        this.mapFund.clear();
        if (this.model.accMng.getFundAccList().size() == 0) {
            this.model.accMng.changedProperty().addListener((ob, old, now) -> {
                this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
                this.spFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
            });
        } else {
            this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
            this.spFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        }
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.spFund);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getSelectionModel().select(0);
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
    }

    public void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy2.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new FuturePriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy2.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy2.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell2.getItems().size() - this.tableMarketSell2.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new FuturePriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.colSellOrder.setCellFactory(cell -> new OrderCell());
        this.colBuyOrder.setCellFactory(cell -> new OrderCell());
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableMarketSell2.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell2.setPlaceholder((Node)new Label());
        this.lbLatest.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbRate.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(this.listenerMktItemPercent);
    }

    class OrderCell
    extends TableCell<HandicapInfo, Number> {
        private static final int INVALID_COUNT = -1;

        OrderCell() {
        }

        public void updateItem(Number item, boolean empty) {
            HandicapInfo handiInfo;
            if (!empty && item.longValue() != -1L && item.longValue() != 0L && (handiInfo = (HandicapInfo)this.getTableRow().getItem()) != null && handiInfo.getOrder() > 0) {
                this.getTableRow().setStyle("-fx-background-color: -fx-tab-bg-quote-color");
                this.setText("(" + handiInfo.getOrder() + ")");
                return;
            }
            this.getTableRow().setStyle("");
            this.setText(null);
        }
    }
}

