/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.web.settings.FuturePriceMaxDiff;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.models.FutureMktMakingSettingsModel;
import cms.tmx.futures.views.AddStrategyDialog;
import cms.tmx.futures.views.FormulaUtils;
import cms.tmx.futures.views.FutureStrategyLibraryDialog;
import cms.tmx.futures.views.StrategyControl;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.query.current.views.FutureCancelConfirmDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureMarketMakingPart
extends MxPart
implements StrategyControl {
    private MxList<FutureStrategy> mlist = new MxList();
    @Inject
    protected FutureMarketMakingModel model;
    @FXML
    private ComboBox<String> cmbCode;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnStart;
    @FXML
    private Button btnStop;
    @FXML
    private TableView<FutureStrategy> tableStrategy;
    @FXML
    private TableColumn<FutureStrategy, Boolean> selected;
    @FXML
    private TableColumn<FutureStrategy, Number> basePrice;
    @FXML
    private TableColumn<FutureStrategy, String> errorMsg;
    @FXML
    private TableColumn<FutureStrategy, Object> operate;
    @FXML
    private TableColumn<FutureStrategy, MxNode> status;
    @FXML
    private TableColumn<FutureStrategy, Number> dealLimit;
    @FXML
    private TableColumn<FutureStrategy, Number> baseSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> askSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> bidSpread;
    @FXML
    private TableColumn<FutureStrategy, Number> hedgeSpreadBuy;
    @FXML
    private TableColumn<FutureStrategy, Number> hedgeSpreadSell;
    @FXML
    private TableColumn<FutureStrategy, String> contextId;
    @FXML
    private TableColumn<FutureStrategy, String> security;
    @FXML
    private TableColumn<FutureStrategy, MxNode> tacticsType;
    @FXML
    private TableColumn<FutureStrategy, String> name;
    @FXML
    private TableColumn<FutureStrategy, String> investorId;
    @FXML
    private TableColumn<FutureStrategy, String> investorSecId;
    @FXML
    private TableColumn<FutureStrategy, Number> filledQty;
    @FXML
    private TableColumn<FutureStrategy, Number> spreadSum;
    @FXML
    private TableColumn<FutureStrategy, Number> bidQty;
    @FXML
    private TableColumn<FutureStrategy, Number> askQty;
    @FXML
    private TableColumn<FutureStrategy, String> hedgeContract;
    @FXML
    private TextField searchText;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    @Inject
    private CtpUnfinishedOrderModel ctpModel;
    @Inject
    private FutureCancelFactory cf;
    @Inject
    private UserPreOrderTips setTips;
    @FXML
    private Label lbTips;
    @FXML
    private Label lbCount;
    @Inject
    private ExecutorService exe;
    @Inject
    private FutureMktMakingSettingsModel settings;
    private Predicate<FutureStrategy> pd = t -> {
        if (!t.isInExe()) {
            return false;
        }
        String code = String.valueOf(t.getSecurity().toUpperCase()) + "\u5168\u90e8";
        String name = t.getName().toUpperCase();
        String txt = this.searchText.getText().toUpperCase();
        String cmb = (String)this.cmbCode.getSelectionModel().getSelectedItem();
        if (cmb == null) {
            return true;
        }
        if (!code.contains(cmb)) {
            return false;
        }
        return code.contains(txt) || name.contains(txt);
    };
    private ChangeListener<? super Boolean> selectedLis = (o, old, now) -> this.checkBtnStatus();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        if (this.mlist.getList().size() == this.model.getList().size() - 1) {
            this.mlist.update(this.model.getList(), this.pd);
            FutureStrategy copy = this.model.getCopyStrategy();
            int last = this.mlist.getList().size() - 1;
            if (copy != null) {
                FutureStrategy strategyNew = (FutureStrategy)this.mlist.getList().get(last);
                int insertIndex = this.tableStrategy.getItems().indexOf((Object)copy) + 1;
                this.tableStrategy.getItems().remove(last);
                this.tableStrategy.getItems().add(insertIndex, (Object)strategyNew);
                this.tableStrategy.getSelectionModel().select((Object)strategyNew);
            } else {
                this.tableStrategy.getSelectionModel().select(last);
            }
        } else {
            this.mlist.update(this.model.getList(), this.pd);
        }
        this.checkBtnStatus();
        this.tableStrategy.refresh();
        this.tableStrategy.layout();
        for (FutureStrategy strategy : this.mlist.getList()) {
            strategy.selectedProperty().removeListener(this.selectedLis);
            strategy.selectedProperty().addListener(this.selectedLis);
        }
        logger.error("\u56fd\u503a\u671f\u8d27\u754c\u9762\u5237\u65b0\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatusChangedAndSelected = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.checkBtnStatus();
        logger.debug("checkBtnStatus\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatusChanged = ob -> Platform.runLater(() -> {
        this.tableStrategy.refresh();
        this.tableStrategy.layout();
    });
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        long start = System.currentTimeMillis();
        this.mlist.filter(this.model.getList(), this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getSecurity().compareTo(o2.getSecurity()));
        this.checkBtnStatus();
        Platform.runLater(() -> this.p.layout());
        logger.error("\u56fd\u503a\u671f\u8d27\u7b56\u7565\u8fc7\u6ee4: " + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listener = ob -> {
        this.refresh();
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.ref.getItems(new String[]{"FUT"})));
        Platform.runLater(() -> {
            this.cmbCode.setItems(code);
            this.cmbCode.setValue((Object)"\u5168\u90e8");
        });
    };
    Map<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
    protected MEventHandler handler = event -> {
        Object object = event.getObj();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)event.getObj();
        LinkedList<CtpOrder> orderList = new LinkedList<CtpOrder>();
        for (Object obj : list) {
            CtpOrder ctpOrder;
            if (!(obj instanceof CtpOrder) || (ctpOrder = (CtpOrder)CtpOrder.class.cast(obj)).getExecModeId() == 0) continue;
            FutureStrategy strategy = this.model.getFutureStrategy(String.valueOf(ctpOrder.getExecModeId()));
            if (strategy == null) {
                orderList.add(ctpOrder);
                continue;
            }
            if (!strategy.getStatus().getRaw().equals("2")) continue;
            orderList.add(ctpOrder);
        }
        if (orderList.size() < 1) {
            return;
        }
        Platform.runLater(() -> {
            if (this.ctpModel.isPopBeforeCancel() && this.createDialog(orderList)) {
                return;
            }
            if (orderList.size() < 1) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8ba2\u5355\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u65e0\u6cd5\u64a4\u5355\uff01");
                return;
            }
            MEvent mEvent = this.ctpModel.cancel(orderList);
            this.alert.check(!this.setTips.getCancelOrderTips(), Alert.AlertType.INFORMATION, "\u64a4\u5355\u63d0\u4ea4\u6210\u529f\uff1a" + mEvent.getInt("suc.count") + "\u7b14\n\u5931\u8d25\uff1a" + mEvent.getInt("fail.count") + "\u7b14");
        });
    };
    private MProps initProp;
    private String baseDir;
    private boolean ctrlPressed = false;
    private boolean shiftPressed = false;
    private int lastIndex = -1;
    @Inject
    private FormulaUtils formula;
    private static final Logger logger = LogManager.getLogger(StrategyControl.class);

    public List<String> getNationalDebtCode(Collection<RefItem> items) {
        ArrayList<String> list = new ArrayList<String>();
        for (RefItem item : items) {
            if (!(item instanceof CtpRefItem)) continue;
            CtpRefItem it = (CtpRefItem)CtpRefItem.class.cast(item);
            if (!StringUtils.belongto((String)it.getProductId(), (String[])new String[]{"TS", "TF", "T"})) continue;
            list.add(it.getCode());
        }
        list.sort((o1, o2) -> o1.compareTo((String)o2));
        return list;
    }

    private void initCmbCode() {
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.ref.getItems(new String[]{"FUT"})));
        this.cmbCode.setItems(code);
        this.cmbCode.setValue((Object)"\u5168\u90e8");
    }

    @FXML
    public void initialize() {
        this.setKey();
        this.createTable();
        this.initCmbCode();
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.statusChangedAndSelectedProperty().addListener(this.listenerStatusChangedAndSelected);
        this.model.statusChangedProperty().addListener(this.listenerStatusChanged);
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.cmbCode.getSelectionModel().selectedItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.ref.changedProperty().addListener(this.listener);
        this.refresh();
        this.lbTips.visibleProperty().bind((ObservableValue)FutureMarketMakingModel.isEditting);
        this.lbCount.textProperty().bind((ObservableValue)FutureMarketMakingModel.refreshTime);
        this.tableStrategy.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (row.getItem() == null) {
                    return;
                }
                MEvent e = new MEvent();
                e.put((Object)"input_ctp_market_making", (Object)((FutureStrategy)row.getItem()).getSecurity());
                this.es.sendEvent("input_ctp_market_making", e);
            });
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    Dragboard db = row.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    ClipboardContent cc = new ClipboardContent();
                    cc.putString(((FutureStrategy)row.getItem()).getContextId());
                    db.setContent((Map)cc);
                }
            });
            row.setOnDragOver(event -> {
                event.getDragboard();
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            });
            row.setOnDragDropped(event -> {
                event.getDragboard();
                String contextId = event.getDragboard().getString();
                FutureStrategy s = this.model.getFutureStrategy(contextId);
                if (s != null) {
                    int dropIndex = row.getIndex();
                    if (dropIndex >= this.tableStrategy.getItems().size()) {
                        dropIndex = this.tableStrategy.getItems().size() - 1;
                    }
                    this.tableStrategy.getItems().remove((Object)s);
                    this.tableStrategy.getItems().add(dropIndex, (Object)s);
                    this.tableStrategy.getSelectionModel().select((Object)s);
                }
                event.setDropCompleted(true);
                event.consume();
            });
            return row;
        });
        this.es.subscribe("input_futures_stopped_cancel_market", this.handler);
    }

    private boolean createDialog(List<CtpOrder> list) {
        FutureCancelConfirmDialog obj = (FutureCancelConfirmDialog)this.of.create(FutureCancelConfirmDialog.class);
        LinkedList<FutureCancelEntrust> enList = new LinkedList<FutureCancelEntrust>();
        for (CtpOrder or : list) {
            FutureCancelEntrust en = this.cf.createSingle(or.getExtAccntId(), or.getExtSecAccntId());
            en.setSec(or.getInstrument().getSecId());
            en.setSecName(or.getInstrument().getSymbol());
            en.setAcc(or.getInvestorId());
            en.setSecAcc(or.getInverstorSecId());
            en.setSecType(or.getInstrument().getSecType());
            en.setMarket(or.getInstrument().getMarket().getRaw());
            en.setOrderType(or.getOrdType());
            en.setSide(or.getSide());
            en.setQuantity((long)(or.getOrderQty() - or.getCumQty()));
            en.setPrice(or.getPrice());
            en.setAmt(this.ctpModel.getAmt((Order)or, or.getOcFlag().getRaw(), en.getPrice(), en.getQuantity()));
            en.setTip("".equals(or.getOrderId()) ? null : "\u59d4\u6258\u7f16\u53f7\uff1a" + or.getOrderId());
            enList.add(en);
        }
        obj.setList(enList);
        obj.setDialogType("\u64a4\u5355");
        MxDialog dialog = this.df.create((DialogObj)obj, "\u64a4\u5355\u786e\u8ba4");
        return dialog.launch() != ButtonType.OK;
    }

    @FXML
    private void resumeSort() {
        try {
            if (this.initProp == null) {
                this.initProp = this.initTableProp();
            }
            int i = 0;
            while (i < this.mlist.getList().size()) {
                FutureStrategy futureStrategy = (FutureStrategy)this.mlist.getList().get(i);
                int index = this.initProp.getInt(futureStrategy.getContextId(), 999);
                futureStrategy.setIndex(this.initProp.getInt(futureStrategy.getContextId(), 999));
                this.initProp.setValue(futureStrategy.getContextId(), (Object)index);
                ++i;
            }
            this.mlist.getList().sort((o1, o2) -> {
                if (o1.getIndex() > o2.getIndex()) {
                    return 1;
                }
                if (o1.getIndex() > o2.getIndex()) {
                    return -1;
                }
                return 0;
            });
            Platform.runLater(() -> {
                this.tableStrategy.setItems(this.mlist.getList());
                this.tableStrategy.refresh();
                this.tableStrategy.layout();
            });
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void saveSort() {
        try {
            if (this.initProp == null) {
                this.initProp = this.initTableProp();
            }
            int i = 0;
            while (i < this.mlist.getList().size()) {
                FutureStrategy futureStrategy = (FutureStrategy)this.mlist.getList().get(i);
                futureStrategy.setIndex(i);
                this.initProp.setValue(futureStrategy.getContextId(), (Object)i);
                ++i;
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u4fdd\u5b58\u6210\u529f");
    }

    private MProps initTableProp() throws IOException {
        this.baseDir = Paths.get(System.getProperty("user.dir"), "data").toString();
        MProps mProps = new MProps();
        Path dataPath = Paths.get(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getName()) + ".properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getName()) + ".properties").createNewFile();
        }
        mProps.load(file);
        return mProps;
    }

    @FXML
    public void add() {
        AddStrategyDialog obj = (AddStrategyDialog)((Object)this.of.create(AddStrategyDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        this.model.setCopyStrategy(null);
        dialog.launch();
    }

    @FXML
    public void copyNew() {
        FutureStrategy strategy = (FutureStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.model.setCopyStrategy(strategy);
        this.copyNew(strategy);
    }

    @FXML
    public void autoRefresh() {
        FutureMarketMakingModel.isEditting.set(false);
    }

    @FXML
    public void remove() {
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u505c\u6b62\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u7b56\u7565");
            return;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u79fb\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                FutureStrategy s = new FutureStrategy();
                s.update((Object)strategy);
                s.setInExe(false);
                this.model.updateStrategy(s);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void execute() {
        ArrayList<String> listId = new ArrayList<String>();
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        this.exe.execute(() -> {
            try {
                Map<String, String> failed = this.model.startStrategy(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u6267\u884c\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, str.toString()));
                }
            }
            catch (MException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                e.printStackTrace();
            }
            this.es.postEvent("unfinished.hedge.query", null);
        });
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            Map<String, String> failed = this.model.stopStrategy(listId);
            if (failed.keySet().size() > 0) {
                StringBuilder str = new StringBuilder();
                str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                for (String s : failed.keySet()) {
                    str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                }
                this.alert.alert(Alert.AlertType.ERROR, str.toString());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void strategyLib() {
        FutureStrategyLibraryDialog lib = (FutureStrategyLibraryDialog)this.of.create(FutureStrategyLibraryDialog.class);
        MxDialog dialog = this.df.create((DialogObj)lib, "\u7b56\u7565\u5e93");
        lib.button = dialog.getButton(lib.buttonType);
        dialog.launch();
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.model.statusChangedAndSelectedProperty().removeListener(this.listenerStatusChangedAndSelected);
        this.model.statusChangedProperty().removeListener(this.listenerStatusChanged);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.ref.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("input_futures_stopped_cancel_market", this.handler);
    }

    private void setKey() {
        this.tableStrategy.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = true;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = true;
                FutureStrategy strategy = (FutureStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
                if (strategy != null) {
                    this.lastIndex = this.tableStrategy.getItems().indexOf((Object)strategy);
                }
            }
        });
        this.tableStrategy.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = false;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = false;
            }
        });
        this.tableStrategy.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            block8: {
                FutureStrategy strategy = (FutureStrategy)this.tableStrategy.getSelectionModel().getSelectedItem();
                if (strategy == null) break block8;
                boolean isSelect = strategy.isSelected();
                if (this.ctrlPressed) {
                    strategy.setSelected(!isSelect);
                } else {
                    this.tableStrategy.getItems().forEach(item -> {
                        if (item.equals((Object)strategy)) {
                            item.setSelected(true);
                        } else {
                            item.setSelected(false);
                        }
                    });
                }
                if (this.shiftPressed) {
                    if (this.lastIndex == -1) {
                        return;
                    }
                    int index = this.tableStrategy.getItems().indexOf((Object)strategy);
                    if (index > this.lastIndex) {
                        int i = this.lastIndex;
                        while (i <= index) {
                            ((FutureStrategy)this.tableStrategy.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    } else {
                        int i = index;
                        while (i <= this.lastIndex) {
                            ((FutureStrategy)this.tableStrategy.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    }
                }
            }
        });
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        TableUtils.isCheckBox(this.selected);
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.security.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).securityProperty());
        this.tacticsType.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).tacticsTypeProperty());
        this.name.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).nameProperty());
        this.basePrice.setCellValueFactory(data -> ((FutureStrategy)data.getValue()).basePriceProperty());
        this.investorId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).investorIdProperty());
        this.investorSecId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).investorSecIdProperty());
        this.status.setCellValueFactory(data -> ((FutureStrategy)data.getValue()).statusProperty());
        this.status.setCellFactory(cell -> new StatusCell());
        this.errorMsg.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).errorMsgProperty());
        this.dealLimit.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).dealLimitProperty());
        this.filledQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).filledQtyProperty());
        this.baseSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).baseSpreadProperty());
        this.spreadSum.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).spreadSumProperty());
        this.bidSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).bidSpreadProperty());
        this.askSpread.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).askSpreadProperty());
        this.bidQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).bidQtyProperty());
        this.askQty.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).askQtyProperty());
        this.hedgeContract.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeContractProperty());
        this.contextId.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).contextIdProperty());
        this.hedgeSpreadBuy.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeSpreadBuyProperty());
        this.hedgeSpreadSell.setCellValueFactory(cell -> ((FutureStrategy)cell.getValue()).hedgeSpreadSellProperty());
        this.dealLimit.setCellFactory(t -> new DealLimitTableCell());
        this.baseSpread.setCellFactory(t -> new BaseSpreadTableCell());
        this.askSpread.setCellFactory(t -> new PriceSellDiff());
        this.bidSpread.setCellFactory(t -> new PriceBuyDiff());
        this.hedgeSpreadBuy.setCellFactory(t -> new HedgeSpreadBuyTableCell());
        this.hedgeSpreadSell.setCellFactory(t -> new HedgeSpreadSellTableCell());
        this.selected.setCellValueFactory(data -> ((FutureStrategy)data.getValue()).selectedProperty());
        this.operate.setCellValueFactory(data -> this.setOperate((FutureStrategy)data.getValue()));
        this.mlist.getList().sort((o1, o2) -> o1.getSecurity().compareTo(o2.getSecurity()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private double getPriceMaxDiff(CtpRefItem ref) {
        if (ref == null) {
            return Double.MAX_VALUE;
        }
        HashMap<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
        for (FuturePriceMaxDiff future : this.settings.getMaxDifPriceSettingList()) {
            map.put(future.getType(), future);
        }
        int mainContract = ref.getMainContract();
        FuturePriceMaxDiff future = (FuturePriceMaxDiff)map.get(ref.getProductId());
        if (future == null || future.getEnable() == 3) {
            future = (FuturePriceMaxDiff)map.get("DEFAULT");
        }
        if (future == null || future.getEnable() == 3) {
            return Double.MAX_VALUE;
        }
        return mainContract == 1 ? future.getDominantContract() : future.getNonPrimeContract();
    }

    private void checkBtnStatus() {
        System.err.println("checkBtnStatus runned");
        this.btnRemove.setDisable(true);
        this.btnStart.setDisable(true);
        this.btnStop.setDisable(true);
        int selectedNum = 0;
        int runningNum = 0;
        int pausingNum = 0;
        for (FutureStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            ++selectedNum;
            switch (strategy.getStatus().getRaw()) {
                case "1": {
                    ++runningNum;
                    break;
                }
                case "3": {
                    ++pausingNum;
                    break;
                }
            }
        }
        if (selectedNum > 0) {
            this.btnRemove.setDisable(false);
        }
        if (selectedNum - runningNum > 0) {
            this.btnStart.setDisable(false);
        }
        if (runningNum > 0 || pausingNum > 0) {
            this.btnStop.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public FutureMarketMakingModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return false;
    }

    @Override
    public TableView<FutureStrategy> getTable() {
        return this.tableStrategy;
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> {
            try {
                this.getModel().query("strategy.exe");
            }
            catch (MException | InvalidProtocolBufferException e) {
                logger.error((Object)e, e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    private class BaseSpreadTableCell
    extends Edit {
        public BaseSpreadTableCell() {
            this.canNegtive = true;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setBaseSpread(item.doubleValue());
                this.setText(String.valueOf(strategy.getBaseSpread()));
            }
        }
    }

    private class DealLimitTableCell
    extends Edit {
        DealLimitTableCell() {
            this.setFormat("%.0f");
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setDealLimit(item.intValue());
                this.setText(String.valueOf(strategy.getDealLimit()));
            }
        }
    }

    private class Edit
    extends EditTableCell<FutureStrategy> {
        protected FutureStrategy beforeModify;

        Edit() {
            super(3);
            this.beforeModify = new FutureStrategy();
            this.setFormat("%.3f");
        }

        public void startEdit() {
            FutureMarketMakingModel.isEditting.set(true);
            super.startEdit();
            this.beforeModify.update((Object)((FutureStrategy)this.getTableRow().getItem()));
        }

        protected boolean check(FutureStrategy strategy) {
            return true;
        }

        protected boolean modified(FutureStrategy strategy) {
            if (!this.beforeModify.getRefPriceCustom().equals(strategy.getRefPriceCustom())) {
                return true;
            }
            if (this.beforeModify.getBaseSpread() != strategy.getBaseSpread()) {
                return true;
            }
            if (this.beforeModify.getDealLimit() != strategy.getDealLimit()) {
                return true;
            }
            if (this.beforeModify.getBidSpread() != strategy.getBidSpread()) {
                return true;
            }
            if (this.beforeModify.getAskSpread() != strategy.getAskSpread()) {
                return true;
            }
            if (!this.beforeModify.getHedgePriceCustomBuy().equals(strategy.getHedgePriceCustomBuy())) {
                return true;
            }
            return !this.beforeModify.getHedgePriceCustomSell().equals(strategy.getHedgePriceCustomSell());
        }

        protected void loseFocus() {
            super.loseFocus();
            FutureStrategy strategyRow = (FutureStrategy)this.getTableRow().getItem();
            FutureStrategy strategy = new FutureStrategy();
            strategy.update((Object)strategyRow);
            System.err.println("limit 1 : " + strategy.getDealLimit());
            if (!this.check(strategy)) {
                FutureMarketMakingModel.isEditting.set(false);
                try {
                    FutureMarketMakingPart.this.model.query("strategy.exe");
                }
                catch (MException | InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
                return;
            }
            System.err.println("limit 2 : " + strategy.getDealLimit());
            if (!strategy.getTacticsType().getRaw().equals("6")) {
                int index = strategy.getRefPriceCustom().indexOf(46);
                String custom = String.valueOf(strategy.getRefPriceCustom().substring(0, index + 1)) + strategy.getBasePriceType() + this.addPositive(strategy.getBaseSpread());
                strategy.setRefPriceCustom(custom);
                if (!strategy.getHedgeContract().isEmpty()) {
                    String priceBuy = "[" + strategy.getHedgeContract() + "]." + strategy.getPriceBuyType() + this.addPositive(strategy.getHedgeSpreadBuy());
                    String priceSell = "[" + strategy.getHedgeContract() + "]." + strategy.getPriceSellType() + this.addPositive(strategy.getHedgeSpreadSell());
                    if (strategy.getPriceBuyType().equals("LFP")) {
                        priceBuy = "[" + strategy.getSecurity() + "].LAST_FILL_PRICE" + this.addPositive(strategy.getHedgeSpreadBuy());
                    }
                    if (strategy.getPriceSellType().equals("LFP")) {
                        priceSell = "[" + strategy.getSecurity() + "].LAST_FILL_PRICE" + this.addPositive(strategy.getHedgeSpreadSell());
                    }
                    strategy.setHedgePriceCustomSell(priceSell);
                    strategy.setHedgePriceCustomBuy(priceBuy);
                }
            }
            if (!this.modified(strategy)) {
                FutureMarketMakingModel.isEditting.set(false);
                return;
            }
            System.err.println("limit 3 : " + strategy.getDealLimit());
            boolean isRunning = false;
            ArrayList<String> list = new ArrayList<String>();
            if (strategy.getStatus().getRaw().equals("1") || strategy.getStatus().getRaw().equals("3")) {
                isRunning = true;
                list.add(strategy.getContextId());
                try {
                    Map<String, String> failed = FutureMarketMakingPart.this.model.stopStrategy(list);
                    if (failed.keySet().size() > 0) {
                        StringBuilder str = new StringBuilder();
                        str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                        for (String s : failed.keySet()) {
                            str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                        }
                        FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, str.toString());
                    }
                }
                catch (MException e) {
                    e.printStackTrace();
                    FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                }
            }
            System.err.println("limit 4 : " + strategy.getDealLimit());
            if (isRunning) {
                FutureMarketMakingPart.this.exe.execute(() -> {
                    try {
                        System.err.println("limit 5:" + strategy.getDealLimit());
                        Thread.sleep(3010L);
                        System.err.println("limit 6:" + strategy.getDealLimit());
                        FutureMarketMakingPart.this.model.updateStrategy(strategy);
                    }
                    catch (MException | InterruptedException e) {
                        e.printStackTrace();
                        FutureMarketMakingModel.isEditting.set(false);
                        Platform.runLater(() -> FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, "\u4fee\u6539\u5931\u8d25\uff1a " + e.getMessage()));
                        return;
                    }
                    try {
                        Thread.sleep(2010L);
                        Map<String, String> failed = FutureMarketMakingPart.this.model.startStrategy(list);
                        if (failed.keySet().size() > 0) {
                            StringBuilder str = new StringBuilder();
                            str.append("\u6267\u884c\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                            for (String s : failed.keySet()) {
                                str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                            }
                            Platform.runLater(() -> FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, str.toString()));
                        }
                        FutureMarketMakingModel.isEditting.set(false);
                    }
                    catch (MException | InterruptedException e) {
                        e.printStackTrace();
                        FutureMarketMakingModel.isEditting.set(false);
                        Platform.runLater(() -> FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, "\u6267\u884c\u5931\u8d25\uff1a " + e.getMessage()));
                    }
                });
            } else {
                FutureMarketMakingModel.isEditting.set(false);
                try {
                    FutureMarketMakingPart.this.model.updateStrategy(strategy);
                }
                catch (MException e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                }
            }
        }

        private String addPositive(double d) {
            if (d > 0.0) {
                return String.valueOf('+') + String.valueOf(d);
            }
            if (d == 0.0) {
                return "";
            }
            return String.valueOf(d);
        }
    }

    private class HedgeSpreadBuyTableCell
    extends Edit {
        public HedgeSpreadBuyTableCell() {
            this.canNegtive = true;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setHedgeSpreadBuy(item.doubleValue());
                this.setText(String.valueOf(strategy.getHedgeSpreadBuy()));
            }
        }
    }

    private class HedgeSpreadSellTableCell
    extends Edit {
        public HedgeSpreadSellTableCell() {
            this.canNegtive = true;
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setHedgeSpreadSell(item.doubleValue());
                this.setText(String.valueOf(strategy.getHedgeSpreadSell()));
            }
        }
    }

    private class PriceBuyDiff
    extends Edit {
        private PriceBuyDiff() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setBidSpread(item.doubleValue());
                this.setText(String.valueOf(strategy.getBidSpread()));
            }
        }

        @Override
        protected boolean check(FutureStrategy strategy) {
            RefItem refItem = FutureMarketMakingPart.this.ref.getItem(strategy.getMarket(), strategy.getSecurity());
            CtpRefItem item = null;
            if (refItem instanceof CtpRefItem) {
                item = (CtpRefItem)refItem;
            }
            double maxDiff = FutureMarketMakingPart.this.getPriceMaxDiff(item);
            if (strategy.getBidSpread() > maxDiff) {
                Platform.runLater(() -> FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u4ef7\u70b9\u5dee\u8d85\u51fa\u4e86\u8bbe\u7f6e\u7684\u6700\u5927\u4ef7\u5dee" + maxDiff));
                return false;
            }
            if (strategy.getBidSpread() + strategy.getAskSpread() > maxDiff) {
                strategy.setAskSpread(maxDiff - strategy.getBidSpread());
            }
            strategy.setSpreadSum(Double.valueOf(String.format("%.3f", strategy.getBidSpread() + strategy.getAskSpread())).doubleValue());
            return true;
        }
    }

    class PriceCell<T>
    extends TableCell<FutureStrategy, T> {
        PriceCell() {
        }

        public void updateItem(T item, boolean empty) {
            long start = System.currentTimeMillis();
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                if (strategy == null) {
                    return;
                }
                double price = FutureMarketMakingPart.this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                this.setText(String.format("%.3f", price));
            }
            logger.debug("\u8ba1\u7b97\u57fa\u51c6\u4ef7\u683c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    private class PriceSellDiff
    extends Edit {
        private PriceSellDiff() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                strategy.setAskSpread(item.doubleValue());
                this.setText(String.valueOf(strategy.getAskSpread()));
            }
        }

        @Override
        protected boolean check(FutureStrategy strategy) {
            RefItem refItem = FutureMarketMakingPart.this.ref.getItem(strategy.getMarket(), strategy.getSecurity());
            CtpRefItem item = null;
            if (refItem instanceof CtpRefItem) {
                item = (CtpRefItem)refItem;
            }
            double maxDiff = FutureMarketMakingPart.this.getPriceMaxDiff(item);
            if (strategy.getAskSpread() > maxDiff) {
                Platform.runLater(() -> FutureMarketMakingPart.this.alert.alert(Alert.AlertType.ERROR, "\u5356\u4ef7\u70b9\u5dee\u8d85\u51fa\u4e86\u8bbe\u7f6e\u7684\u6700\u5927\u4ef7\u5dee" + maxDiff));
                return false;
            }
            if (strategy.getBidSpread() + strategy.getAskSpread() > maxDiff) {
                strategy.setBidSpread(maxDiff - strategy.getAskSpread());
            }
            strategy.setSpreadSum(Double.valueOf(String.format("%.3f", strategy.getBidSpread() + strategy.getAskSpread())).doubleValue());
            return true;
        }
    }

    private class StatusCell
    extends TableCell<FutureStrategy, MxNode> {
        private Label label = new Label();

        private StatusCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value.getValue());
            switch (value.getRaw()) {
                case "1": {
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                case "2": {
                    CssUtils.makeRise((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

