/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.trade.ConversionParam;
import cms.tmx.entity.trade.FutureMarket;
import cms.tmx.futures.models.FutureMarketListModel;
import cms.tmx.futures.views.ConversionParamDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class FutureMarketListPart
extends MxPart {
    @FXML
    private TableView<FutureMarket> tableMarketList;
    @FXML
    private TableColumn<FutureMarket, String> code;
    @FXML
    private TableColumn<FutureMarket, Number> isMain;
    @FXML
    private TableColumn<FutureMarket, String> lastDay;
    @FXML
    private TableColumn<FutureMarket, Number> lastPrice;
    @FXML
    private TableColumn<FutureMarket, Number> qtyBuy;
    @FXML
    private TableColumn<FutureMarket, String> buyYtm;
    @FXML
    private TableColumn<FutureMarket, String> priceBuy;
    @FXML
    private TableColumn<FutureMarket, String> priceSell;
    @FXML
    private TableColumn<FutureMarket, String> sellYtm;
    @FXML
    private TableColumn<FutureMarket, Number> qtySell;
    @FXML
    private TableColumn<FutureMarket, Number> openPrice;
    @FXML
    private TableColumn<FutureMarket, Number> highestPrice;
    @FXML
    private TableColumn<FutureMarket, Number> lowestPrice;
    @FXML
    private TableColumn<FutureMarket, Number> totalDealQty;
    @FXML
    private TableColumn<FutureMarket, Number> totalPositionQty;
    @FXML
    private TableColumn<FutureMarket, Number> lastDealQty;
    @FXML
    private TableColumn<FutureMarket, Number> lastPositionQty;
    @Inject
    private FutureMarketListModel model;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    private MxList<FutureMarket> mlist = new MxList();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mlist.update(this.model.getList());
        this.tableMarketList.refresh();
    });

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
    }

    private void createTable() {
        this.code.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().codeProperty());
        this.isMain.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().mainContractProperty());
        this.isMain.setCellFactory(cell -> new MainContractCell());
        this.lastDay.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().expireDateProperty());
        this.lastPrice.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().nowPriceProperty());
        this.priceBuy.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListBuyHandicap().get(0)).priceStrProperty());
        this.priceSell.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListSellHandicap().get(0)).priceStrProperty());
        this.qtyBuy.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListBuyHandicap().get(0)).countProperty());
        this.qtyBuy.setCellFactory(cell -> new QtyCell());
        this.qtySell.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListSellHandicap().get(0)).countProperty());
        this.qtySell.setCellFactory(cell -> new QtyCell());
        this.buyYtm.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMktItemNew().buyYtmProperty());
        this.sellYtm.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMktItemNew().sellYtmProperty());
        this.openPrice.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().openPriceProperty());
        this.highestPrice.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().highPriceProperty());
        this.lowestPrice.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().lowPriceProperty());
        this.lastDealQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().lastDealQtyProperty());
        this.lastPositionQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().lastPositionQtyProperty());
        this.totalDealQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().totalDealQtyProperty());
        this.totalPositionQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().totalPositionQtyProperty());
        this.mlist.update(this.model.getList());
        this.tableMarketList.setItems(this.mlist.getList());
    }

    @FXML
    public void conversionParamSet() {
        try {
            List<ConversionParam> list = this.model.getYtmPrarms();
            ConversionParamDialog obj = (ConversionParamDialog)((Object)this.of.create(ConversionParamDialog.class));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6362\u7b97\u53c2\u6570\u7ef4\u62a4");
            obj.setList(list);
            dialog.launch();
        }
        catch (MException | IOException e) {
            this.logger.error((Object)e, e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public class MainContractCell
    extends TableCell<FutureMarket, Number> {
        public void updateItem(Number item, boolean empty) {
            if (item == null) {
                this.setText(null);
                return;
            }
            if (!empty) {
                if (item.longValue() == 1L) {
                    this.setText("\u662f");
                } else {
                    this.setText("\u5426");
                }
                return;
            }
            this.setText(null);
        }
    }

    public class QtyCell
    extends TableCell<FutureMarket, Number> {
        private static final int INVALID_COUNT = -1;

        public void updateItem(Number item, boolean empty) {
            if (item == null) {
                this.setText(null);
                return;
            }
            if (!empty && item.longValue() != -1L) {
                this.setText(String.valueOf(item));
                return;
            }
            this.setText(null);
        }
    }
}

