/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.ImportExcel;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.FuturePriceCell;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.FutureEntrust;
import cms.tmx.entity.web.settings.FuturePriceMaxDiff;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.models.FutureManualModel;
import cms.tmx.futures.models.FutureMktMakingSettingsModel;
import cms.tmx.futures.views.FormulaUtils;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.trade.views.EntrustConfirmDialog;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.cmschina.ficc.aggregation.ExpressionCalculator;
import com.cmschina.ficc.aggregation.FalseRuleResult;
import com.cmschina.ficc.aggregation.RuleResult;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureManualPart
extends MxPart {
    @Inject
    protected FutureManualModel model;
    @FXML
    private TableView<HandicapInfo> tableSell;
    @FXML
    private TableView<HandicapInfo> tableBuy;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @Inject
    public CtpAccountMap accMng;
    @FXML
    private Spinner<Double> spnBasePrice;
    @FXML
    private Spinner<Double> spnDiffMax;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Label lbName;
    @FXML
    private TextField txtPriceBuy;
    @FXML
    private TextField txtPriceSell;
    @FXML
    private Spinner<Integer> spnQtyBuy;
    @FXML
    private Spinner<Integer> spnQtySell;
    @FXML
    private ComboBox<String> cmbAcct;
    @FXML
    private Button btnForceOrder;
    @FXML
    private Label lbNowPrice;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    protected TextField txtCode;
    @FXML
    private TextField txtPriceCustom;
    @Inject
    private IRefDataMng refMng;
    @FXML
    private CheckBox chkEnable;
    @Inject
    protected DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    protected MEventService es;
    private MarketItem mktItem;
    private SecSuggest spCode = new SecSuggest();
    private DoubleSpinnerCtrl ctrlBasePrice = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffMax = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlPriceBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlPriceSell = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 1);
    private static final Logger logger = LogManager.getLogger(FutureManualPart.class);
    private int scale = 3;
    @Inject
    private FutureMktMakingSettingsModel settings;
    private InvalidationListener listenerMktItem = ob -> {
        if (this.chkEnable.isSelected()) {
            this.updateBasePrice();
        }
    };
    private InvalidationListener listenerRefMng = ob -> this.spCode.setAllSuggestions(this.getRefList());
    private InvalidationListener listenerRefItem = ob -> this.onRefChange();
    private List<RefItem> nationalRefList = null;
    @Inject
    private ExpressionCalculator exp;
    private MEventHandler handler = event -> Platform.runLater(() -> {
        Object obj = event.get((Object)"input_ctp_market_making");
        if (obj instanceof String) {
            String txt = (String)obj;
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(txt);
            }
        } else if (obj instanceof CtpPosition) {
            CtpPosition position = (CtpPosition)obj;
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(position.getSecId());
            }
        }
    });
    private final String XLSX = ".xlsx";
    private final String XLS = ".xls";
    @Inject
    private FormulaUtils formula;
    private SecConverter secCvt;
    @Inject
    private MObjFactory of;
    private String priceExpression = "";
    @FXML
    private ComboBox<MxNode> cmbHedgeType;
    @FXML
    private ComboBox<MxNode> cmbOcFlag;
    @FXML
    private RadioButton radioBS;
    @FXML
    private RadioButton radioBuy;
    @FXML
    private RadioButton radioSell;
    private ToggleGroup group = new ToggleGroup();
    private SecSuggest.StrSuggest suggestFund = SecSuggest.getStrSuggest();
    private RefItem refItem = null;

    @FXML
    protected void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener(this.listenerRefItem);
        this.refMng.changedProperty().addListener(this.listenerRefMng);
        this.mktItem.changedProperty().addListener(this.listenerMktItem);
        this.initControls();
        this.createMarketTable();
        this.enterEventHandler();
        this.disableHandler();
        this.es.subscribe("input_ctp_market_making", this.handler);
    }

    @PreDestroy
    private void close() {
        if (this.mktItem != null) {
            this.mktItem.refItemProperty().removeListener(this.listenerRefItem);
            this.mktItem.changedProperty().removeListener(this.listenerMktItem);
        }
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
        this.es.unSubscribe("input_ctp_market_making", this.handler);
    }

    private List<RefItem> getRefList() {
        if (this.nationalRefList == null || this.nationalRefList.size() == 0) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        return this.nationalRefList;
    }

    @FXML
    public void excelOrder() {
        try {
            FileChooser chooser = new FileChooser();
            File file = chooser.showOpenDialog(null);
            if (file == null) {
                return;
            }
            List<FutureEntrust> entrusts = this.checkExcel(file);
            EntrustConfirmDialog obj = (EntrustConfirmDialog)this.of.create(EntrustConfirmDialog.class);
            RefItem ref = this.refMng.getItem("CCFX", entrusts.get(0).getSecurityId());
            obj.setRefItem(ref);
            try {
                obj.setList(this.model.getEntrustList(entrusts));
            }
            catch (MException | Exception e1) {
                this.alert.alert(Alert.AlertType.ERROR, e1.getMessage());
                logger.error(e1.getMessage());
                return;
            }
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
            if (dialog.launch() == ButtonType.OK) {
                for (FutureEntrust entrust : entrusts) {
                    this.model.submit(entrust);
                }
            }
        }
        catch (MException | Exception e) {
            logger.error(e.getMessage(), e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private List<FutureEntrust> checkExcel(File file) throws Exception, MException {
        if (!file.getPath().endsWith(".xlsx") && !file.getPath().endsWith(".xls")) {
            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List entrustItemList = ImportExcel.read((String)file.getPath());
        if (entrustItemList == null) {
            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
        }
        if (!entrustItemList.isEmpty()) {
            entrustItemList.remove(0);
        }
        if (entrustItemList.size() == 0) {
            throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        ArrayList<FutureEntrust> list = new ArrayList<FutureEntrust>();
        int j = 0;
        while (j < entrustItemList.size()) {
            FutureEntrust future = new FutureEntrust();
            int nullRow = 0;
            for (String str : (List)entrustItemList.get(j)) {
                if (str != null && !"".equals(str.trim())) continue;
                ++nullRow;
            }
            if (nullRow != ((List)entrustItemList.get(j)).size()) {
                int i = 0;
                while (i < ((List)entrustItemList.get(j)).size()) {
                    String value = (String)((List)entrustItemList.get(j)).get(i);
                    switch (i) {
                        case 0: {
                            if ("".equals(value.trim())) {
                                throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u5408\u7ea6\u4ee3\u7801\u4e3a\u7a7a");
                            }
                            future.setSecurityId(value);
                            break;
                        }
                        case 1: {
                            BigDecimal b1;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b1 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u5356\u4ef7\u9519\u8bef");
                            }
                            future.setPriceSell(b1.doubleValue());
                            break;
                        }
                        case 2: {
                            BigDecimal b2;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b2 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u4e70\u4ef7\u9519\u8bef");
                            }
                            future.setPriceBuy(b2.doubleValue());
                            break;
                        }
                        case 3: {
                            BigDecimal b3;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b3 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u5356\u91cf\u9519\u8bef");
                            }
                            if (b3.intValue() > 39) {
                                String error = "\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u5356\u91cf\u8d85\u8fc739";
                                throw new Exception(error);
                            }
                            future.setCountSell((long)b3.intValue());
                            break;
                        }
                        case 4: {
                            BigDecimal b4;
                            if ("".equals(value)) {
                                value = "0";
                            }
                            try {
                                b4 = new BigDecimal(value);
                            }
                            catch (Exception e) {
                                logger.error("import failed", (Throwable)e);
                                throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u4e70\u91cf\u9519\u8bef");
                            }
                            if (b4.intValue() > 39) {
                                String error = "\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + future.getSecurityId() + " \u4e70\u91cf\u8d85\u8fc739";
                                throw new Exception(error);
                            }
                            future.setCountBuy((long)b4.intValue());
                            break;
                        }
                    }
                    ++i;
                }
                list.add(future);
            }
            ++j;
        }
        return list;
    }

    @FXML
    private void order() {
        if (!this.isValid()) {
            return;
        }
        EntrustConfirmDialog obj = (EntrustConfirmDialog)this.of.create(EntrustConfirmDialog.class);
        obj.setRefItem(this.mktItem.getRefItem());
        try {
            obj.setList(this.model.getEntrustList());
        }
        catch (MException | Exception e1) {
            this.alert.alert(Alert.AlertType.ERROR, e1.getMessage());
            logger.error(e1.getMessage());
            return;
        }
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            try {
                if (this.model.isBs()) {
                    this.model.submit();
                } else {
                    this.model.submitSingle();
                }
            }
            catch (MException | Exception e) {
                logger.error(e.getMessage());
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        return secAcct;
    }

    private boolean isValid() {
        String result;
        if (this.model.getFundAcct().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8d44\u91d1\u8d26\u53f7");
            return false;
        }
        if (this.txtCode.getText().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
            return false;
        }
        if (this.refItem == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8f93\u5165\u7684\u8bc1\u5238\u4ee3\u7801\u65e0\u6548");
            return false;
        }
        if (Double.valueOf(this.spnDiffMax.getEditor().getText()) == 0.0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5728 '\u7528\u6237\u8bbe\u7f6e - \u671f\u8d27' \u4e2d\u8bbe\u7f6e\u6700\u5927\u4ef7\u5dee");
            return false;
        }
        if (!this.model.accMng.getFundAccList().contains(this.model.getFundAcct())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8d44\u91d1\u8d26\u53f7\u9519\u8bef");
            return false;
        }
        if (this.chkEnable.isSelected() && this.priceExpression.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u57fa\u51c6\u516c\u5f0f");
            return false;
        }
        if (this.chkEnable.isSelected() && !(result = this.expressionResult()).isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, result);
            return false;
        }
        if (this.radioBS.isSelected() && this.model.getDiffBuy() + this.model.getDiffSell() > this.model.getDiffMax()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u4ef7\u70b9\u5dee\u4e0e\u5356\u4ef7\u70b9\u5dee\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u4ef7\u5dee");
            return false;
        }
        if (this.model.getDiffBuy() == 0.0 && this.model.getDiffSell() == 0.0 && this.model.isBs()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u4ef7\u70b9\u5dee\u4e0e\u5356\u4ef7\u70b9\u5dee\u4e0d\u53ef\u540c\u65f6\u4e3a0");
            return false;
        }
        if (this.model.getCountBuy() == 0L && (this.model.isBs() || this.model.isBuy())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4e70\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
            return false;
        }
        if (this.model.getCountSell() == 0L && !this.model.isBuy()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5356\u51fa\u6570\u91cf\u5e94\u5927\u4e8e0");
            return false;
        }
        return true;
    }

    private void onRefChange() {
        TradeBindings.ctpPriceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        this.resetUnit(this.ctrlBasePrice, this.ctrlDiffBuy, this.ctrlDiffMax, this.ctrlDiffSell, this.ctrlPriceBuy, this.ctrlPriceSell);
    }

    private void resetUnit(DoubleSpinnerCtrl ... ctrls) {
        if (this.mktItem.getRefItem().getPriceUnit() == 0.0) {
            this.mktItem.getRefItem().setPriceUnit(0.001);
        }
        if (this.scale == 0) {
            this.mktItem.getRefItem().setScale(3);
        }
        DoubleSpinnerCtrl[] doubleSpinnerCtrlArray = ctrls;
        int n = ctrls.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleSpinnerCtrl ctrl = doubleSpinnerCtrlArray[n2];
            ctrl.getVF().setUnit(this.mktItem.getRefItem().getPriceUnit());
            ctrl.setScale(this.scale);
            ++n2;
        }
    }

    private void initControls() {
        this.cmbAcct.valueProperty().bindBidirectional((Property)this.model.fundAcctProperty());
        if (this.model.accMng.getFundAccList().size() == 0) {
            logger.debug("\u8d44\u91d1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u89e6\u53d1\u76d1\u542c...");
            this.model.accMng.changedProperty().addListener((ob, old, now) -> {
                logger.debug("\u8d44\u91d1\u8d26\u53f7change\u5df2\u89e6\u53d1" + this.model.accMng.getFundAccList().size());
                this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
                this.suggestFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
                Platform.runLater(() -> this.cmbAcct.getSelectionModel().select(0));
            });
        } else {
            logger.debug("FutureManualPart \u8d44\u91d1\u8d26\u53f7\u4e0d\u4e3a\u7a7a\uff0c");
            this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
            this.suggestFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        }
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.suggestFund);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getSelectionModel().select(0);
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.getRefList());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.radioBS.setToggleGroup(this.group);
        this.radioBuy.setToggleGroup(this.group);
        this.radioSell.setToggleGroup(this.group);
        this.radioBS.selectedProperty().addListener((ob, old, now) -> {
            MxNode node = ((MxNode)this.of.create(MxNode.class)).load("position_effect", "70");
            if (now.booleanValue()) {
                node.removeNode("67");
            }
            this.cmbOcFlag.setItems(node.getNodes());
            this.cmbOcFlag.setValue((Object)node);
        });
        this.radioBS.selectedProperty().bindBidirectional((Property)this.model.bsProperty());
        this.radioBuy.selectedProperty().bindBidirectional((Property)this.model.buyProperty());
        MxBindings.bindSD((Property)this.txtPriceBuy.textProperty(), (Property)this.model.priceBuyProperty());
        MxBindings.bindSD((Property)this.txtPriceSell.textProperty(), (Property)this.model.priceSellProperty());
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        MxBindings.bindSI((Property)this.spnQtyBuy.getEditor().textProperty(), (Property)this.model.countBuyProperty());
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.ctrlCountSell.ctrl(this.spnQtySell);
        MxBindings.bindSI((Property)this.spnQtySell.getEditor().textProperty(), (Property)this.model.countSellProperty());
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("sh_flag", "1");
        this.cmbHedgeType.setItems(node.getNodes());
        this.cmbHedgeType.setValue((Object)node);
        this.cmbHedgeType.valueProperty().bindBidirectional(this.model.hedgeTypeProperty());
        node = ((MxNode)this.of.create(MxNode.class)).load("position_effect", "70");
        node.removeNode("67");
        this.cmbOcFlag.setItems(node.getNodes());
        this.cmbOcFlag.setValue((Object)node);
        this.cmbOcFlag.valueProperty().bindBidirectional(this.model.ocFlagProperty());
        this.txtPriceCustom.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9+\\-*/\\.\\[\\] \\\u3010\\\u3011\\(\\)_]*$", 300));
        this.txtPriceCustom.textProperty().addListener((ob, old, now) -> {
            this.priceExpression = this.txtPriceCustom.getText().trim();
        });
        this.txtPriceCustom.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                if (this.txtPriceCustom.getText().isEmpty()) {
                    this.spnBasePrice.getEditor().setText("");
                    return;
                }
                String result = this.expressionResult();
                if (!result.isEmpty()) {
                    this.spnBasePrice.getEditor().setText("");
                    return;
                }
                this.updateBasePrice();
            }
        });
        this.txtPriceCustom.disableProperty().bind((ObservableValue)this.chkEnable.selectedProperty().not());
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.lbNowPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        this.ctrlBasePrice.ctrl(this.spnBasePrice);
        this.spnBasePrice.getEditor().textProperty().addListener((ob, old, now) -> {
            if (!now.isEmpty() && this.mktItem.getRefItem() != null) {
                double d = Double.valueOf(now) - this.model.getDiffBuy();
                this.txtPriceBuy.setText(StringUtils.toStr((double)d, (int)this.scale));
                d = Double.valueOf(now) + this.model.getDiffSell();
                this.txtPriceSell.setText(StringUtils.toStr((double)d, (int)this.scale));
            }
            if (now.isEmpty()) {
                this.txtPriceBuy.setText("");
                this.txtPriceSell.setText("");
            }
        });
        this.spnBasePrice.editableProperty().bind((ObservableValue)this.chkEnable.selectedProperty().not());
        this.spnBasePrice.disableProperty().bind((ObservableValue)this.chkEnable.selectedProperty());
        MxBindings.bindSD((Property)this.spnBasePrice.getEditor().textProperty(), (Property)this.model.basePriceProperty());
        this.ctrlDiffMax.ctrl(this.spnDiffMax);
        MxBindings.bindSD((Property)this.spnDiffMax.getEditor().textProperty(), (Property)this.model.diffMaxProperty());
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        MxBindings.bindSD((Property)this.spnDiffBuy.getEditor().textProperty(), (Property)this.model.diffBuyProperty());
        this.spnDiffBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            Double d = this.model.getBasePrice() - this.getDouble((String)now);
            double priceBuy = this.getDouble(this.txtPriceBuy.getText().replaceAll(",", ""));
            if (d != priceBuy && !this.txtPriceBuy.isFocused()) {
                this.txtPriceBuy.setText(StringUtils.toStr((double)d, (int)this.scale));
            }
        });
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        MxBindings.bindSD((Property)this.spnDiffSell.getEditor().textProperty(), (Property)this.model.diffSellProperty());
        this.spnDiffSell.getEditor().textProperty().addListener((ob, old, now) -> {
            double priceSell;
            double d = this.model.getBasePrice() + this.getDouble((String)now);
            if (d != (priceSell = this.getDouble(this.txtPriceSell.getText().replaceAll(",", ""))) && !this.txtPriceSell.isFocused()) {
                this.txtPriceSell.setText(StringUtils.toStr((double)d, (int)this.scale));
            }
        });
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void setPrice(double price) {
        if (price > 0.0 && !this.chkEnable.isSelected()) {
            this.model.setBasePrice(price);
        }
    }

    private void clearSelection() {
        this.tableSell.getSelectionModel().clearSelection();
        this.tableBuy.getSelectionModel().clearSelection();
    }

    private void updateBasePrice() {
        if (this.txtPriceCustom.getText().isEmpty() || this.txtPriceCustom.isFocused()) {
            return;
        }
        if (!this.expressionResult().isEmpty()) {
            return;
        }
        double price = this.formula.getPriceByFormula(this.priceExpression);
        if (price < 0.0) {
            this.spnBasePrice.getEditor().clear();
            return;
        }
        if (this.model.getMI().getRefItem() == null) {
            this.spnBasePrice.getEditor().setText(String.format("%.3f", price));
            return;
        }
        this.spnBasePrice.getEditor().setText(String.format("%.3f", FormulaUtils.round(price, this.model.getMI().getRefItem().getPriceUnit())));
    }

    private String expressionResult() {
        RuleResult result = this.exp.validateExpression(this.priceExpression);
        if (!result.getResult()) {
            FalseRuleResult falseResult = (FalseRuleResult)result;
            return "\u57fa\u51c6\u516c\u5f0f\u4e0d\u5408\u6cd5(" + falseResult.getCode().getErrorMessage() + ")";
        }
        return "";
    }

    private double getDouble(String txt) {
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    private void createMarketTable() {
        MxBindings.bindVisible((Control)this.lbNowPrice, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbNowPrice, (double)this.mktItem.getPreSettlementPrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableSell.getItems().size() - this.tableSell.getItems().indexOf(p.getValue())))))));
        this.colSellPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colSellCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colSellPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colBuyCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colBuyPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.tableBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableBuy.setPlaceholder((Node)new Label());
        this.tableSell.setPlaceholder((Node)new Label());
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> Platform.runLater(() -> this.tableBuy.getSelectionModel().clearSelection()));
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> Platform.runLater(() -> this.tableSell.getSelectionModel().clearSelection()));
    }

    protected void onSecurityChange() {
        Object obj = this.txtCode.getUserData();
        this.refItem = obj instanceof RefItem ? (RefItem)RefItem.class.cast(obj) : null;
        this.model.getMI().setRefItem(this.refItem);
        this.model.onSecChange();
        if (this.refItem != null) {
            this.txtCode.setText(this.refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
            this.scale = this.refItem.getScale();
            if (this.refItem instanceof CtpRefItem) {
                CtpRefItem ref = (CtpRefItem)this.refItem;
                this.spnDiffMax.getEditor().setText(String.valueOf(this.getPriceMaxDiff(ref)));
            }
        }
    }

    private double getPriceMaxDiff(CtpRefItem ref) {
        FuturePriceMaxDiff future2;
        if (ref == null) {
            return Double.MAX_VALUE;
        }
        int mainContract = ref.getMainContract();
        HashMap<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
        for (FuturePriceMaxDiff future2 : this.settings.getMaxDifPriceSettingList()) {
            map.put(future2.getType(), future2);
        }
        future2 = (FuturePriceMaxDiff)map.get(ref.getProductId());
        if (future2 == null || future2.getEnable() == 3) {
            future2 = (FuturePriceMaxDiff)map.get("DEFAULT");
        }
        if (future2 == null || future2.getEnable() == 3) {
            return 0.0;
        }
        return mainContract == 1 ? future2.getDominantContract() : future2.getNonPrimeContract();
    }

    private void disableHandler() {
        this.spnDiffBuy.disableProperty().bind((ObservableValue)this.radioSell.selectedProperty());
        this.txtPriceBuy.disableProperty().bind((ObservableValue)this.radioSell.selectedProperty());
        this.spnQtyBuy.disableProperty().bind((ObservableValue)this.radioSell.selectedProperty());
        this.spnDiffSell.disableProperty().bind((ObservableValue)this.radioBuy.selectedProperty());
        this.txtPriceSell.disableProperty().bind((ObservableValue)this.radioBuy.selectedProperty());
        this.spnQtySell.disableProperty().bind((ObservableValue)this.radioBuy.selectedProperty());
    }

    private void enterEventHandler() {
        this.cmbAcct.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.txtCode.requestFocus();
            }
        });
        this.txtCode.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.txtPriceCustom.requestFocus();
            }
        });
        this.txtPriceCustom.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.spnBasePrice.requestFocus();
            }
        });
        this.spnBasePrice.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.spnDiffMax.requestFocus();
            }
        });
        this.spnDiffMax.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.spnDiffBuy.isDisabled()) {
                    this.spnDiffSell.requestFocus();
                    return;
                }
                this.spnDiffBuy.requestFocus();
            }
        });
        this.spnDiffBuy.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.spnDiffSell.isDisabled()) {
                    this.txtPriceBuy.requestFocus();
                    return;
                }
                this.spnDiffSell.requestFocus();
            }
        });
        this.spnDiffSell.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.txtPriceBuy.isDisabled()) {
                    this.txtPriceSell.requestFocus();
                    return;
                }
                this.txtPriceBuy.requestFocus();
            }
        });
        this.txtPriceBuy.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.txtPriceSell.isDisabled()) {
                    this.spnQtyBuy.requestFocus();
                    return;
                }
                this.txtPriceSell.requestFocus();
            }
        });
        this.txtPriceSell.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.spnQtyBuy.isDisabled()) {
                    this.spnQtySell.requestFocus();
                    return;
                }
                this.spnQtyBuy.requestFocus();
            }
        });
        this.spnQtyBuy.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                if (this.spnQtySell.isDisabled()) {
                    this.order();
                    return;
                }
                this.spnQtySell.requestFocus();
            }
        });
        this.spnQtySell.getEditor().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.order();
            }
        });
    }
}

