/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.FutureAlgo;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.entity.web.settings.FuturePriceMaxDiff;
import cms.tmx.futures.models.FutureAlgoModel;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.futures.models.FutureMktMakingSettingsModel;
import cms.tmx.futures.views.AddAlgoDialog;
import cms.tmx.futures.views.FormulaUtils;
import cms.tmx.futures.views.FutureAlgoLibraryDialog;
import cms.tmx.futures.views.IFutureAlgoPart;
import cms.tmx.futures.views.StrategyControl;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.query.current.models.FutureCancelFactory;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureAlgoPart
extends MxPart
implements IFutureAlgoPart {
    private MxList<FutureAlgo> mlist = new MxList();
    @Inject
    protected FutureAlgoModel model;
    @FXML
    private ComboBox<String> cmbCode;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnStart;
    @FXML
    private Button btnStop;
    @FXML
    private Button btnResume;
    @FXML
    private TableView<FutureAlgo> tableStrategy;
    @FXML
    private TableColumn<FutureAlgo, Boolean> selected;
    @FXML
    private TableColumn<FutureAlgo, Object> operate;
    @FXML
    private TableColumn<FutureAlgo, MxNode> status;
    @FXML
    private TextField searchText;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    @Inject
    private CtpUnfinishedOrderModel ctpModel;
    @Inject
    private FutureCancelFactory cf;
    @Inject
    private UserPreOrderTips setTips;
    @FXML
    private Label lbCount;
    @Inject
    private ExecutorService exe;
    @Inject
    private FutureMktMakingSettingsModel settings;
    private Predicate<FutureAlgo> pd = t -> {
        if (!t.isInExe()) {
            return false;
        }
        String code = String.valueOf(t.getSecurity().toUpperCase()) + "\u5168\u90e8";
        String name = t.getName().toUpperCase();
        String txt = this.searchText.getText().toUpperCase();
        String cmb = (String)this.cmbCode.getSelectionModel().getSelectedItem();
        if (cmb == null) {
            return true;
        }
        if (!code.contains(cmb)) {
            return false;
        }
        return code.contains(txt) || name.contains(txt);
    };
    private ChangeListener<? super Boolean> selectedLis = (o, old, now) -> this.checkBtnStatus();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        if (this.mlist.getList().size() == this.model.getList().size() - 1) {
            this.mlist.update(this.model.getList(), this.pd);
            FutureAlgo copy = this.model.getCopyStrategy();
            int last = this.mlist.getList().size() - 1;
            if (copy != null) {
                FutureAlgo strategyNew = (FutureAlgo)this.mlist.getList().get(last);
                int insertIndex = this.tableStrategy.getItems().indexOf((Object)copy) + 1;
                this.tableStrategy.getItems().remove(last);
                this.tableStrategy.getItems().add(insertIndex, (Object)strategyNew);
                this.tableStrategy.getSelectionModel().select((Object)strategyNew);
            } else {
                this.tableStrategy.getSelectionModel().select(last);
            }
        } else {
            this.mlist.update(this.model.getList(), this.pd);
        }
        this.checkBtnStatus();
        this.tableStrategy.refresh();
        for (FutureAlgo strategy : this.mlist.getList()) {
            strategy.selectedProperty().removeListener(this.selectedLis);
            strategy.selectedProperty().addListener(this.selectedLis);
        }
        logger.error("\u56fd\u503a\u671f\u8d27\u754c\u9762\u5237\u65b0\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatusChangedAndSelected = ob -> Platform.runLater(() -> {
        long start = System.currentTimeMillis();
        this.checkBtnStatus();
        logger.debug("checkBtnStatus\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listenerStatusChanged = ob -> Platform.runLater(() -> this.tableStrategy.refresh());
    @Inject
    private MScheduler scheduler;
    private InvalidationListener lstnSearch = ob -> this.scheduler.schedule(event -> {
        long start = System.currentTimeMillis();
        this.mlist.filter(this.model.getList(), this.pd);
        this.mlist.getList().sort((o1, o2) -> o1.getSecurity().compareTo(o2.getSecurity()));
        this.checkBtnStatus();
        Platform.runLater(() -> this.p.layout());
        logger.error("\u56fd\u503a\u671f\u8d27\u7b56\u7565\u8fc7\u6ee4: " + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
    });
    private InvalidationListener listener = ob -> {
        this.refresh();
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.ref.getItems(new String[]{"FUT"})));
        Platform.runLater(() -> {
            this.cmbCode.setItems(code);
            this.cmbCode.setValue((Object)"\u5168\u90e8");
        });
    };
    Map<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
    private MProps initProp;
    private String baseDir;
    private boolean ctrlPressed = false;
    private boolean shiftPressed = false;
    private int lastIndex = -1;
    @Inject
    private FormulaUtils formula;
    private static final Logger logger = LogManager.getLogger(StrategyControl.class);

    public List<String> getNationalDebtCode(Collection<RefItem> items) {
        ArrayList<String> list = new ArrayList<String>();
        for (RefItem item : items) {
            if (!(item instanceof CtpRefItem)) continue;
            CtpRefItem it = (CtpRefItem)CtpRefItem.class.cast(item);
            if (!StringUtils.belongto((String)it.getProductId(), (String[])new String[]{"TS", "TF", "T"})) continue;
            list.add(it.getCode());
        }
        list.sort((o1, o2) -> o1.compareTo((String)o2));
        return list;
    }

    private void initCmbCode() {
        ObservableList code = FxUtils.newList();
        code.add((Object)"\u5168\u90e8");
        code.addAll(this.getNationalDebtCode(this.ref.getItems(new String[]{"FUT"})));
        this.cmbCode.setItems(code);
        this.cmbCode.setValue((Object)"\u5168\u90e8");
    }

    @FXML
    public void initialize() {
        this.setKey();
        this.createTable();
        this.initCmbCode();
        this.model.changedProperty().addListener(this.lstnModel);
        this.model.statusChangedAndSelectedProperty().addListener(this.listenerStatusChangedAndSelected);
        this.model.statusChangedProperty().addListener(this.listenerStatusChanged);
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        CssUtils.addStyleClass((Control)this.btnResume, (String)"btnGreen");
        this.cmbCode.getSelectionModel().selectedItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnSearch));
        this.ref.changedProperty().addListener(this.listener);
        this.refresh();
        this.lbCount.textProperty().bind((ObservableValue)FutureMarketMakingModel.refreshTime);
        this.tableStrategy.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (row.getItem() == null) {
                    return;
                }
                MEvent e = new MEvent();
                e.put((Object)"input_ctp_market_making", (Object)((FutureAlgo)row.getItem()).getSecurity());
                this.es.sendEvent("input_ctp_market_making", e);
            });
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    Dragboard db = row.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    ClipboardContent cc = new ClipboardContent();
                    cc.putString(((FutureAlgo)row.getItem()).getContextId());
                    db.setContent((Map)cc);
                }
            });
            row.setOnDragOver(event -> {
                event.getDragboard();
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            });
            row.setOnDragDropped(event -> {
                event.getDragboard();
                String contextId = event.getDragboard().getString();
                FutureAlgo s = this.model.getFutureStrategy(contextId);
                if (s != null) {
                    int dropIndex = row.getIndex();
                    if (dropIndex >= this.tableStrategy.getItems().size()) {
                        dropIndex = this.tableStrategy.getItems().size() - 1;
                    }
                    this.tableStrategy.getItems().remove((Object)s);
                    this.tableStrategy.getItems().add(dropIndex, (Object)s);
                    this.tableStrategy.getSelectionModel().select((Object)s);
                }
                event.setDropCompleted(true);
                event.consume();
            });
            return row;
        });
    }

    @FXML
    private void resumeSort() {
        try {
            if (this.initProp == null) {
                this.initProp = this.initTableProp();
            }
            int i = 0;
            while (i < this.mlist.getList().size()) {
                FutureAlgo futureStrategy = (FutureAlgo)this.mlist.getList().get(i);
                int index = this.initProp.getInt(futureStrategy.getContextId(), 999);
                futureStrategy.setIndex(this.initProp.getInt(futureStrategy.getContextId(), 999));
                this.initProp.setValue(futureStrategy.getContextId(), (Object)index);
                ++i;
            }
            this.mlist.getList().sort((o1, o2) -> {
                if (o1.getIndex() > o2.getIndex()) {
                    return 1;
                }
                if (o1.getIndex() > o2.getIndex()) {
                    return -1;
                }
                return 0;
            });
            Platform.runLater(() -> {
                this.tableStrategy.setItems(this.mlist.getList());
                this.tableStrategy.refresh();
            });
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void saveSort() {
        try {
            if (this.initProp == null) {
                this.initProp = this.initTableProp();
            }
            int i = 0;
            while (i < this.mlist.getList().size()) {
                FutureAlgo futureStrategy = (FutureAlgo)this.mlist.getList().get(i);
                futureStrategy.setIndex(i);
                this.initProp.setValue(futureStrategy.getContextId(), (Object)i);
                ++i;
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u4fdd\u5b58\u6210\u529f");
    }

    private MProps initTableProp() throws IOException {
        this.baseDir = Paths.get(System.getProperty("user.dir"), "data").toString();
        MProps mProps = new MProps();
        Path dataPath = Paths.get(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getName()) + ".properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getName()) + ".properties").createNewFile();
        }
        mProps.load(file);
        return mProps;
    }

    @FXML
    public void add() {
        AddAlgoDialog obj = (AddAlgoDialog)((Object)this.of.create(AddAlgoDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        this.model.setCopyStrategy(null);
        dialog.launch();
    }

    @FXML
    public void copyNew() {
        FutureAlgo strategy = (FutureAlgo)this.tableStrategy.getSelectionModel().getSelectedItem();
        this.model.setCopyStrategy(strategy);
        this.copyNew(strategy);
    }

    @FXML
    public void remove() {
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u505c\u6b62\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u7b56\u7565");
            return;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u79fb\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                FutureAlgo s = new FutureAlgo();
                s.update((Object)strategy);
                s.setInExe(false);
                this.model.updateStrategy(s);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void execute() {
        ArrayList<String> listId = new ArrayList<String>();
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        this.exe.execute(() -> {
            try {
                Map<String, String> failed = this.model.startStrategy(listId);
                if (failed.keySet().size() > 0) {
                    StringBuilder str = new StringBuilder();
                    str.append("\u6267\u884c\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                    for (String s : failed.keySet()) {
                        str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                    }
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, str.toString()));
                }
            }
            catch (MException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                e.printStackTrace();
            }
        });
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            Map<String, String> failed = this.model.stopStrategy(listId);
            if (failed.keySet().size() > 0) {
                StringBuilder str = new StringBuilder();
                str.append("\u505c\u6b62\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                for (String s : failed.keySet()) {
                    str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                }
                this.alert.alert(Alert.AlertType.ERROR, str.toString());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    private void resume() {
        ArrayList<String> listId = new ArrayList<String>();
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("2")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            Map<String, String> failed = this.model.resumeStrategy(listId);
            if (failed.keySet().size() > 0) {
                StringBuilder str = new StringBuilder();
                str.append("\u6062\u590d\u5931\u8d25" + failed.keySet().size() + "\u7b14\n");
                for (String s : failed.keySet()) {
                    str.append(String.valueOf(s) + ":" + failed.get(s) + "\n");
                }
                this.alert.alert(Alert.AlertType.ERROR, str.toString());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void strategyLib() {
        FutureAlgoLibraryDialog lib = (FutureAlgoLibraryDialog)this.of.create(FutureAlgoLibraryDialog.class);
        MxDialog dialog = this.df.create((DialogObj)lib, "\u7b56\u7565\u5e93");
        lib.button = dialog.getButton(lib.buttonType);
        dialog.launch();
        this.refresh();
    }

    @PreDestroy
    public void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.model.statusChangedAndSelectedProperty().removeListener(this.listenerStatusChangedAndSelected);
        this.model.statusChangedProperty().removeListener(this.listenerStatusChanged);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        this.ref.changedProperty().removeListener(this.listener);
    }

    private void setKey() {
        this.tableStrategy.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = true;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = true;
                FutureAlgo strategy = (FutureAlgo)this.tableStrategy.getSelectionModel().getSelectedItem();
                if (strategy != null) {
                    this.lastIndex = this.tableStrategy.getItems().indexOf((Object)strategy);
                }
            }
        });
        this.tableStrategy.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.CONTROL) {
                this.ctrlPressed = false;
            }
            if (event.getCode() == KeyCode.SHIFT) {
                this.shiftPressed = false;
            }
        });
        this.tableStrategy.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            block8: {
                FutureAlgo strategy = (FutureAlgo)this.tableStrategy.getSelectionModel().getSelectedItem();
                if (strategy == null) break block8;
                boolean isSelect = strategy.isSelected();
                if (this.ctrlPressed) {
                    strategy.setSelected(!isSelect);
                } else {
                    this.tableStrategy.getItems().forEach(item -> {
                        if (item.equals((Object)strategy)) {
                            item.setSelected(true);
                        } else {
                            item.setSelected(false);
                        }
                    });
                }
                if (this.shiftPressed) {
                    if (this.lastIndex == -1) {
                        return;
                    }
                    int index = this.tableStrategy.getItems().indexOf((Object)strategy);
                    if (index > this.lastIndex) {
                        int i = this.lastIndex;
                        while (i <= index) {
                            ((FutureAlgo)this.tableStrategy.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    } else {
                        int i = index;
                        while (i <= this.lastIndex) {
                            ((FutureAlgo)this.tableStrategy.getItems().get(i)).setSelected(true);
                            ++i;
                        }
                    }
                }
            }
        });
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableStrategy);
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((FutureAlgo)data.getValue()).selectedProperty());
        this.operate.setCellValueFactory(data -> this.setOperate((FutureAlgo)data.getValue()));
        this.status.setCellFactory(cell -> new StatusCell());
        this.mlist.getList().sort((o1, o2) -> o1.getSecurity().compareTo(o2.getSecurity()));
        this.tableStrategy.setItems(this.mlist.getList());
    }

    private double getPriceMaxDiff(CtpRefItem ref) {
        if (ref == null) {
            return Double.MAX_VALUE;
        }
        HashMap<String, FuturePriceMaxDiff> map = new HashMap<String, FuturePriceMaxDiff>();
        for (FuturePriceMaxDiff future : this.settings.getMaxDifPriceSettingList()) {
            map.put(future.getType(), future);
        }
        int mainContract = ref.getMainContract();
        FuturePriceMaxDiff future = (FuturePriceMaxDiff)map.get(ref.getProductId());
        if (future == null || future.getEnable() == 3) {
            future = (FuturePriceMaxDiff)map.get("DEFAULT");
        }
        if (future == null || future.getEnable() == 3) {
            return Double.MAX_VALUE;
        }
        return mainContract == 1 ? future.getDominantContract() : future.getNonPrimeContract();
    }

    private void checkBtnStatus() {
        System.err.println("checkBtnStatus runned");
        this.btnRemove.setDisable(true);
        this.btnStart.setDisable(true);
        this.btnStop.setDisable(true);
        this.btnResume.setDisable(true);
        int selectedNum = 0;
        int runningNum = 0;
        int pausingNum = 0;
        int stoppedNum = 0;
        for (FutureAlgo strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            ++selectedNum;
            switch (strategy.getStatus().getRaw()) {
                case "1": {
                    ++runningNum;
                    break;
                }
                case "3": {
                    ++pausingNum;
                    break;
                }
                case "2": {
                    ++stoppedNum;
                }
            }
        }
        if (selectedNum > 0) {
            this.btnRemove.setDisable(false);
        }
        if (selectedNum - runningNum > 0) {
            this.btnStart.setDisable(false);
        }
        if (runningNum > 0 || pausingNum > 0) {
            this.btnStop.setDisable(false);
        }
        if (stoppedNum > 0) {
            this.btnResume.setDisable(false);
        }
    }

    @Override
    public MObjFactory getObjFactory() {
        return this.of;
    }

    @Override
    public DialogFactory getDialogFactory() {
        return this.df;
    }

    @Override
    public MxAlert getAlert() {
        return this.alert;
    }

    @Override
    public FutureAlgoModel getModel() {
        return this.model;
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public boolean isLibPane() {
        return false;
    }

    @Override
    public TableView<FutureAlgo> getTable() {
        return this.tableStrategy;
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> {
            try {
                this.getModel().query("strategy.exe");
            }
            catch (MException | InvalidProtocolBufferException e) {
                logger.error((Object)e, e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    class PriceCell<T>
    extends TableCell<FutureStrategy, T> {
        PriceCell() {
        }

        public void updateItem(T item, boolean empty) {
            long start = System.currentTimeMillis();
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                FutureStrategy strategy = (FutureStrategy)this.getTableRow().getItem();
                if (strategy == null) {
                    return;
                }
                double price = FutureAlgoPart.this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                this.setText(String.format("%.3f", price));
            }
            logger.debug("\u8ba1\u7b97\u57fa\u51c6\u4ef7\u683c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    private class StatusCell
    extends TableCell<FutureAlgo, MxNode> {
        private Label label = new Label();

        private StatusCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value.getValue());
            switch (value.getRaw()) {
                case "1": {
                    CssUtils.makeFall((Control)this.label);
                    break;
                }
                case "2": {
                    CssUtils.makeRise((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }
}

