/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.FutureAlgo;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.models.FutureAlgoModel;
import cms.tmx.futures.models.FutureMktMakingSettingsModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.cmschina.ficc.aggregation.ExpressionCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FutureAlgoDialog
extends DialogObj {
    private Logger logger = LogManager.getLogger(FutureAlgoDialog.class);
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    @FXML
    protected ComboBox<String> cmbAcct;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    protected Label lbContract;
    @FXML
    protected TextField txtName;
    @FXML
    protected ComboBox<MxNode> cmbType;
    @FXML
    protected ComboBox<MxNode> cmbCancelType;
    @FXML
    protected ComboBox<MxNode> cmbShFlag;
    @FXML
    protected ComboBox<MxNode> cmbOcFlag;
    @FXML
    protected TextField txtBaseCode;
    @FXML
    protected Label lbBaseCodeErr;
    @FXML
    private Spinner<Double> spnPriceSlip;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBuy;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeSell;
    @FXML
    private Spinner<Double> spnSpreadBuy;
    @FXML
    private Spinner<Double> spnSpreadSell;
    @FXML
    private Spinner<Integer> spnMaxExposure;
    @FXML
    private Spinner<Integer> spnDealLimit;
    @FXML
    protected TextField txtQtyBuy;
    @FXML
    protected TextField txtQtySell;
    @FXML
    protected ComboBox<String> cmbDelay;
    @FXML
    protected ComboBox<MxNode> cmbExposureEnable;
    @FXML
    protected ComboBox<MxNode> cmbDirectionFunction;
    @FXML
    private Spinner<Double> spnDirectionEffect;
    @FXML
    protected ComboBox<MxNode> cmbAdjustLimit;
    @FXML
    protected ComboBox<MxNode> cmbProtectFunction;
    @FXML
    private Spinner<Double> spnBondEffect;
    @FXML
    private Spinner<Integer> spnFuseLimit;
    @FXML
    protected ComboBox<MxNode> cmbPositionAdjustMode;
    @FXML
    protected TextField txtHedgeContract;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeBuyHedge;
    @FXML
    protected ComboBox<MxNode> cmbPriceTypeSellHedge;
    @FXML
    protected Spinner<Double> spnSpreadBuyHedge;
    @FXML
    protected Spinner<Double> spnSpreadSellHedge;
    @FXML
    protected TextField txtMarketMaking;
    @FXML
    protected TextField txtHedge;
    @FXML
    protected TextField txtTimeoutFill;
    @FXML
    protected Spinner<Double> spnStoplossFill;
    @FXML
    private Spinner<Integer> spnTriggerPosition;
    @FXML
    private TextField txtBidAdjust;
    @FXML
    private TextField txtAskAdjust;
    @FXML
    public VBox vboxAll;
    @FXML
    private VBox vboxAdjust;
    @FXML
    private VBox vboxHedge;
    @FXML
    private Label lbAcctErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbQtyBuyErr;
    @FXML
    private Label lbQtySellErr;
    @FXML
    private Label lbAdjustQtyBuyErr;
    @FXML
    private Label lbAdjustQtySellErr;
    @FXML
    private Label lbMaxExposureErr;
    @FXML
    private Label lbDealLimitErr;
    @FXML
    private Label lbTriggerPositionErr;
    @FXML
    private Label lbMarketMakingErr;
    @FXML
    private Label lbHedgeErr;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected FutureAlgoModel model;
    @Inject
    protected MxAlert alert;
    @Inject
    private FutureMktMakingSettingsModel settings;
    public double maxDiff = Double.MAX_VALUE;
    private DoubleSpinnerCtrl ctrlSlip = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlStoploss = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadBuy = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadSell = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadBuyHedge = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlSpreadSellHedge = new DoubleSpinnerCtrl(false, 6, 3);
    private DoubleSpinnerCtrl ctrlDirectEffect = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlProtectEffect = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlProtectFuse = new IntSpinnerCtrl(true, 6, 1);
    private IntSpinnerCtrl ctrlMaxExposure = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlDealLimit = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlTriggerPosition = new IntSpinnerCtrl(true, 9, 1);
    private SecSuggest spCode = new SecSuggest();
    protected RefItem refItem;
    private RefItem refItemHedge = null;
    public List<String> nameList = new ArrayList<String>();
    private List<RefItem> nationalRefList = null;
    private SecSuggest.StrSuggest suggestFund = SecSuggest.getStrSuggest();
    protected FutureAlgo algo;
    @Inject
    private ExpressionCalculator exp;
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> this.spCode.setAllSuggestions(this.getRefList());

    public FutureAlgoDialog() {
        super("FutureAlgoDialog.fxml");
    }

    private List<RefItem> getRefList() {
        if (this.nationalRefList == null) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        return this.nationalRefList;
    }

    public void onFinished(ButtonType bt) {
        this.refMng.changedProperty().removeListener(this.refListener);
    }

    @FXML
    public void initialize() {
        String type;
        this.refMng.changedProperty().addListener(this.refListener);
        this.cmbPositionAdjustMode.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            String mode = ((MxNode)this.cmbPositionAdjustMode.getSelectionModel().getSelectedItem()).getRaw();
            MxNode nodeDir = MxNodeFactory.createNew((String)"direction_function", (String)"LOG(([CODE].BID_QTY_1/[CODE].ASK_QTY_1);3)");
            MxNode nodePro = MxNodeFactory.createNew((String)"protection_function", (String)"MAX((([CODE].ASK_1-[CODE].BID_1)/0.005-2);0)");
            if (mode.equals("0")) {
                this.vboxAdjust.setDisable(true);
                this.vboxHedge.setDisable(true);
                nodeDir.removeNode("NET_EXPOSURE_CONTROL_D");
                nodePro.removeNode("NET_EXPOSURE_CONTROL_P");
            } else if (mode.equals("1")) {
                this.vboxAdjust.setDisable(true);
                this.vboxHedge.setDisable(false);
                nodeDir.removeNode("NET_EXPOSURE_CONTROL_D");
                nodePro.removeNode("NET_EXPOSURE_CONTROL_P");
            } else if (mode.equals("2")) {
                this.vboxAdjust.setDisable(false);
                this.vboxHedge.setDisable(true);
            }
            this.cmbDirectionFunction.setItems(nodeDir.getNodes());
            this.cmbDirectionFunction.setValue((Object)nodeDir);
            this.cmbProtectFunction.setItems(nodePro.getNodes());
            this.cmbProtectFunction.setValue((Object)nodePro);
        });
        this.initControls();
        MxNode node = MxNodeFactory.create((String)"sh_flag", (String)(this.algo != null ? this.algo.getShFlag() : "1"));
        this.cmbShFlag.setItems(node.getNodes());
        this.cmbShFlag.setValue((Object)node);
        node = MxNodeFactory.create((String)"position_effect", (String)(this.algo != null ? this.algo.getOcFlag() : "70"));
        node.removeNode("67");
        this.cmbOcFlag.setItems(node.getNodes());
        this.cmbOcFlag.setValue((Object)node);
        node = new MxNode().load("future_algo_price_type", "LAST");
        this.cmbPriceTypeBuy.setItems(node.getNodes());
        this.cmbPriceTypeBuy.setValue((Object)node);
        node = new MxNode().load("future_algo_price_type", "LAST");
        this.cmbPriceTypeSell.setItems(node.getNodes());
        this.cmbPriceTypeSell.setValue((Object)node);
        node = new MxNode().load("future_algo_price_type", "LAST");
        this.cmbPriceTypeBuyHedge.setItems(node.getNodes());
        this.cmbPriceTypeBuyHedge.setValue((Object)node);
        node = new MxNode().load("future_algo_price_type", "LAST");
        this.cmbPriceTypeSellHedge.setItems(node.getNodes());
        this.cmbPriceTypeSellHedge.setValue((Object)node);
        this.txtHedge.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        this.txtMarketMaking.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 6));
        if (this.algo != null) {
            type = this.algo.getTacticsType().getRaw();
            this.cmbType.setEditable(false);
        } else {
            type = "1";
        }
        node = MxNodeFactory.create((String)"future_algo_type", (String)type);
        this.cmbType.setItems(node.getNodes());
        this.cmbType.setValue((Object)node);
        if (this.algo != null) {
            type = this.algo.getCancelType().getRaw();
            this.cmbCancelType.setEditable(false);
        } else {
            type = "false";
        }
        node = MxNodeFactory.create((String)"strategy_cancel_type", (String)type);
        this.cmbCancelType.setItems(node.getNodes());
        this.cmbCancelType.setValue((Object)node);
        String mode = "0";
        if (this.algo != null) {
            mode = this.algo.getPositonAdjustMode().getRaw();
        }
        node = MxNodeFactory.create((String)"position_adjust_mode", (String)mode);
        this.cmbPositionAdjustMode.setItems(node.getNodes());
        this.cmbPositionAdjustMode.setValue((Object)node);
        if (this.algo != null) {
            String direction = this.algo.getDirectionFunction().replace(this.algo.getSecurity(), "CODE").replace(",", ";");
            node = ((MxNode)this.cmbDirectionFunction.getValue()).getNode(direction);
            this.cmbDirectionFunction.setValue((Object)node);
        }
        if (this.algo != null) {
            String protect = this.algo.getSpreadProtectionFunction().replace(this.algo.getSecurity(), "CODE").replace(",", ";");
            node = MxNodeFactory.create((String)"protection_function", (String)protect);
            this.cmbProtectFunction.setValue((Object)node);
        }
        node = MxNodeFactory.create((String)"exposure_enable", (String)"false");
        this.cmbExposureEnable.setItems(node.getNodes());
        this.cmbExposureEnable.setValue((Object)node);
        mode = "BID_1";
        if (this.algo != null) {
            int begin = this.algo.getAdjustLimit().indexOf(46);
            mode = this.algo.getAdjustLimit().substring(begin + 1);
        }
        node = MxNodeFactory.create((String)"adjust_limit_price", (String)mode);
        this.cmbAdjustLimit.setItems(node.getNodes());
        this.cmbAdjustLimit.setValue((Object)node);
        ObservableList value = FxUtils.newList();
        value.add((Object)"\u4e0d\u542f\u7528");
        value.add((Object)"500ms/NP");
        this.cmbDelay.setItems(value);
        this.cmbDelay.getSelectionModel().select(0);
        if (this.algo != null && this.algo.isDelay()) {
            this.cmbDelay.getSelectionModel().select(1);
        }
        this.registerCheck();
    }

    public void fillDialog() {
        this.cmbAcct.setValue((Object)this.algo.getInvestorId());
        this.txtCode.setText(this.algo.getSecurity());
        this.refItem = this.refMng.getItem(this.algo.getMarket(), this.algo.getSecurity());
        this.txtName.setText(this.algo.getName());
        this.setPriceSpreadByFormula(this.algo.getBidRefPriceCustom(), this.cmbPriceTypeBuy, this.spnSpreadBuy);
        this.setPriceSpreadByFormula(this.algo.getOfferRefPriceCustom(), this.cmbPriceTypeSell, this.spnSpreadSell);
        this.txtBaseCode.setText(this.algo.getSecurity());
        this.spnPriceSlip.getEditor().setText(String.valueOf(this.algo.getPriceSlip()));
        this.spnMaxExposure.getEditor().setText(String.valueOf(this.algo.getMaxAllowExposure()));
        this.spnDealLimit.getEditor().setText(String.valueOf(this.algo.getMaxAllowFilledQty()));
        this.txtQtyBuy.setText(this.algo.getBidRefQtyStr());
        this.txtQtySell.setText(this.algo.getAskRefQtyStr());
        this.cmbCancelType.getSelectionModel().select((Object)this.algo.getCancelType());
        this.cmbExposureEnable.getSelectionModel().select((Object)this.algo.getExposureEnable());
        this.spnDirectionEffect.getEditor().setText(String.valueOf(this.algo.getDirectionMaxEffect()));
        this.spnBondEffect.getEditor().setText(String.valueOf(this.algo.getBoundEffect()));
        this.spnFuseLimit.getEditor().setText(String.valueOf((int)this.algo.getFuseLimit()));
        this.cmbPositionAdjustMode.getSelectionModel().select((Object)this.algo.getPositonAdjustMode());
        if (!this.vboxAdjust.isDisable()) {
            this.spnTriggerPosition.getEditor().setText(String.valueOf(this.algo.getTriggerPositon()));
            this.txtBidAdjust.setText(this.algo.getBidAdjust());
            this.txtAskAdjust.setText(this.algo.getAskAdjust());
        }
        if (!this.vboxHedge.isDisable()) {
            this.setPriceSpreadByFormula(this.algo.getLongHedgePriceCustom(), this.cmbPriceTypeSellHedge, this.spnSpreadSellHedge);
            this.setPriceSpreadByFormula(this.algo.getShortHedgePriceCustom(), this.cmbPriceTypeBuyHedge, this.spnSpreadBuyHedge);
            this.txtHedgeContract.setText(this.algo.getHedgeContract());
            if (this.algo.getHedgeContractQtyScale() > 0) {
                this.txtHedge.setText(String.valueOf(this.algo.getHedgeContractQtyScale()));
            }
            if (this.algo.getAlgoContractQtyScale() > 0) {
                this.txtMarketMaking.setText(String.valueOf(this.algo.getAlgoContractQtyScale()));
            }
            this.txtTimeoutFill.setText(String.valueOf(this.algo.getTimeoutFill()));
            this.spnStoplossFill.getEditor().setText(String.valueOf(this.algo.getStoplossFill()));
        }
        this.resetUnit(this.ctrlSpreadBuy, this.ctrlSpreadSell, this.ctrlSlip, this.ctrlProtectEffect, this.ctrlDirectEffect, this.ctrlStoploss, this.ctrlSpreadBuyHedge, this.ctrlSpreadSellHedge);
    }

    private String addPositive(String str) {
        if (str.length() > 0 && str.toCharArray()[0] != '-') {
            return String.valueOf('+') + str;
        }
        return str;
    }

    protected FutureAlgo getStrategy(boolean isCopyOrNew) throws Exception, MException {
        FutureAlgo temp = (FutureAlgo)this.of.create(FutureAlgo.class);
        if (this.algo != null) {
            temp.setInExe(this.algo.isInExe());
        }
        if (isCopyOrNew) {
            temp.setMarket(this.refItem.getMarket());
            temp.setExtFundAccntId(this.model.accMng.getFundAcc(this.cmbAcct.getEditor().getText()).getExtAccntId());
            SecAccount secAcct = this.model.getExtSecAcc(this.cmbAcct.getEditor().getText(), ((MxNode)this.cmbShFlag.getSelectionModel().getSelectedItem()).getRaw(), this.refItem.getMarket());
            temp.setExtSecAccntId(secAcct.getExtSecAccntId());
            temp.setSecurity(this.txtCode.getText());
            temp.setSecurityType(this.refItem.getType());
        } else {
            temp.setContextId(this.algo.getContextId());
            temp.setMarket(this.algo.getMarket());
            temp.setExtFundAccntId(this.algo.getExtFundAccntId());
            temp.setExtSecAccntId(this.algo.getExtSecAccntId());
            temp.setSecurity(this.algo.getSecurity());
            temp.setSecurityType(this.algo.getSecurityType());
            temp.setCurrentExposure(this.algo.getCurrentExposure());
        }
        temp.setShFlag(((MxNode)this.cmbShFlag.getSelectionModel().getSelectedItem()).getRaw());
        temp.setOcFlag(((MxNode)this.cmbOcFlag.getSelectionModel().getSelectedItem()).getRaw());
        temp.setTacticsType((MxNode)this.cmbType.getSelectionModel().getSelectedItem());
        temp.setName(this.txtName.getText());
        String priceBuyCustom = null;
        String priceSellCustom = null;
        if (this.refItem == null) {
            throw new Exception("\u505a\u5e02\u5408\u7ea6\u65e0\u6548, \u8bf7\u68c0\u67e5\u662f\u5426\u8fc7\u671f!");
        }
        priceBuyCustom = "[" + this.refItem.getCode() + "]." + ((MxNode)this.cmbPriceTypeBuy.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadBuy.getEditor().getText().trim());
        priceSellCustom = "[" + this.refItem.getCode() + "]." + ((MxNode)this.cmbPriceTypeSell.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadSell.getEditor().getText().trim());
        temp.setBidRefPriceCustom(priceBuyCustom);
        temp.setOfferRefPriceCustom(priceSellCustom);
        if (!this.spnPriceSlip.getEditor().getText().isEmpty()) {
            temp.setPriceSlip(Double.valueOf(this.spnPriceSlip.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnSpreadBuy.getEditor().getText().isEmpty()) {
            temp.setBidSpread(Double.valueOf(this.spnSpreadBuy.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        if (!this.spnSpreadSell.getEditor().getText().isEmpty()) {
            temp.setAskSpread(Double.valueOf(this.spnSpreadSell.getEditor().getText().replaceAll(",", "")).doubleValue());
        }
        temp.setMaxAllowExposure(Integer.valueOf(this.spnMaxExposure.getEditor().getText().replaceAll(",", "")).intValue());
        temp.setMaxAllowFilledQty(Integer.valueOf(this.spnDealLimit.getEditor().getText().replaceAll(",", "")).intValue());
        temp.setBidRefQtyStr(this.txtQtyBuy.getText());
        temp.setAskRefQtyStr(this.txtQtySell.getText());
        if (this.cmbDelay.getSelectionModel().isSelected(0)) {
            temp.setDelay(false);
        } else {
            temp.setDelay(true);
        }
        temp.setCancelType((MxNode)this.cmbCancelType.getSelectionModel().getSelectedItem());
        temp.setExposureEnable((MxNode)this.cmbExposureEnable.getSelectionModel().getSelectedItem());
        temp.setDirectionFunction(((MxNode)this.cmbDirectionFunction.getSelectionModel().getSelectedItem()).getRaw().replace("CODE", this.txtCode.getText()).replace(";", ","));
        if (!this.spnDirectionEffect.getEditor().getText().isEmpty()) {
            temp.setDirectionMaxEffect(Double.valueOf(this.spnDirectionEffect.getEditor().getText().replace(",", "")).doubleValue());
        }
        temp.setAdjustLimit("[" + this.refItem.getCode() + "]." + ((MxNode)this.cmbAdjustLimit.getSelectionModel().getSelectedItem()).getRaw());
        temp.setSpreadProtectionFunction(((MxNode)this.cmbProtectFunction.getSelectionModel().getSelectedItem()).getRaw().replace("CODE", this.txtCode.getText()).replace(";", ","));
        if (!this.spnBondEffect.getEditor().getText().isEmpty()) {
            temp.setBoundEffect(Double.valueOf(this.spnBondEffect.getEditor().getText().replace(",", "")).doubleValue());
        }
        if (!this.spnFuseLimit.getEditor().getText().isEmpty()) {
            temp.setFuseLimit(Double.valueOf(this.spnFuseLimit.getEditor().getText().replace(",", "")).doubleValue());
        }
        temp.setPositonAdjustMode((MxNode)this.cmbPositionAdjustMode.getSelectionModel().getSelectedItem());
        if (!this.vboxHedge.isDisabled()) {
            String priceBuyHedgeCustom = null;
            String priceSellHedgeCustom = null;
            priceBuyHedgeCustom = "[" + this.txtHedgeContract.getText() + "]." + ((MxNode)this.cmbPriceTypeBuyHedge.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadBuyHedge.getEditor().getText().trim());
            priceSellHedgeCustom = "[" + this.txtHedgeContract.getText() + "]." + ((MxNode)this.cmbPriceTypeSellHedge.getSelectionModel().getSelectedItem()).getRaw() + this.addPositive(this.spnSpreadSellHedge.getEditor().getText().trim());
            if (priceSellHedgeCustom.contains("LAST_FILL_PRICE")) {
                priceSellHedgeCustom = priceSellHedgeCustom.replaceAll(this.txtHedgeContract.getText(), this.refItem.getCode());
            }
            if (priceBuyHedgeCustom.contains("LAST_FILL_PRICE")) {
                priceBuyHedgeCustom = priceBuyHedgeCustom.replaceAll(this.txtHedgeContract.getText(), this.refItem.getCode());
            }
            temp.setLongHedgePriceCustom(priceSellHedgeCustom);
            temp.setShortHedgePriceCustom(priceBuyHedgeCustom);
            temp.setHedgeContract(this.txtHedgeContract.getText());
            if (!this.txtMarketMaking.getText().isEmpty()) {
                temp.setAlgoContractQtyScale(Integer.valueOf(this.txtMarketMaking.getText()).intValue());
            }
            if (!this.txtHedge.getText().isEmpty()) {
                temp.setHedgeContractQtyScale(Integer.valueOf(this.txtHedge.getText()).intValue());
            }
            if (!this.txtTimeoutFill.getText().isEmpty()) {
                temp.setTimeoutFill(Integer.valueOf(this.txtTimeoutFill.getText()).intValue());
            }
            if (!this.spnStoplossFill.getEditor().getText().isEmpty()) {
                temp.setStoplossFill(Double.valueOf(this.spnStoplossFill.getEditor().getText().replaceAll(",", "")).doubleValue());
            }
        }
        if (!this.vboxAdjust.isDisabled()) {
            if (!this.spnTriggerPosition.getEditor().getText().isEmpty()) {
                temp.setTriggerPositon(Integer.valueOf(this.spnTriggerPosition.getEditor().getText().replaceAll(",", "")).intValue());
            }
            temp.setBidAdjust(this.txtBidAdjust.getText());
            temp.setAskAdjust(this.txtAskAdjust.getText());
        }
        return temp;
    }

    protected void initControls() {
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
        this.cmbAcct.getItems().addAll((Collection)this.model.accMng.getFundAccList());
        this.cmbAcct.getSelectionModel().select(0);
        this.suggestFund.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.suggestFund);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.spCode.addPossibleSuggestions(this.getRefList());
        TooltipUtil.bind((Label)this.lbName);
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItem = (RefItem)this.txtCode.getUserData();
            if (this.refItem == null || this.refItem.getName().equals("")) {
                this.lbName.setText(INVALID_CODE);
            } else {
                this.lbName.setText(this.refItem.getName());
            }
            if (this.txtCode.getText().isEmpty()) {
                this.lbName.setText("");
            }
            this.resetUnit(this.ctrlSpreadBuy, this.ctrlSpreadSell, this.ctrlSlip, this.ctrlProtectEffect, this.ctrlDirectEffect, this.ctrlStoploss, this.ctrlSpreadBuyHedge, this.ctrlSpreadSellHedge);
            if (((MxNode)this.cmbType.getValue()).getRaw().equals("1")) {
                this.txtBaseCode.setText(this.txtCode.getText());
                if (!this.vboxHedge.isDisable()) {
                    this.txtHedgeContract.setText(this.txtCode.getText());
                }
            }
        });
        this.txtBaseCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Search.bindAutoCompletion((TextField)this.txtBaseCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            if (!StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"6", "9"}) && !this.vboxHedge.isDisable()) {
                this.txtHedgeContract.setText(this.txtBaseCode.getText());
            }
        });
        this.vboxHedge.disabledProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && !StringUtils.belongto((String)((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw(), (String[])new String[]{"6", "9"})) {
                this.txtHedgeContract.setText(this.txtBaseCode.getText());
            }
        });
        this.txtHedgeContract.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        Search.bindAutoCompletion((TextField)this.txtHedgeContract, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItemHedge = (RefItem)this.txtHedgeContract.getUserData();
            if (this.refItemHedge == null || this.refItemHedge.getName().equals("")) {
                this.lbContract.setText(INVALID_CODE);
            } else {
                this.lbContract.setText(this.refItemHedge.getName());
            }
            if (this.txtHedgeContract.getText().isEmpty()) {
                this.lbContract.setText("");
            }
        });
        this.txtHedgeContract.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtHedgeContract.selectAll());
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5\\.]*", 32));
        this.ctrlSlip.ctrl(this.spnPriceSlip);
        this.spnPriceSlip.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceSlip.getEditor()));
        this.ctrlSpreadBuy.ctrl(this.spnSpreadBuy);
        this.spnSpreadBuy.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadBuy.getEditor()));
        this.ctrlSpreadSell.ctrl(this.spnSpreadSell);
        this.spnSpreadSell.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadSell.getEditor()));
        this.ctrlSpreadBuyHedge.ctrl(this.spnSpreadBuyHedge);
        this.spnSpreadBuyHedge.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadBuyHedge.getEditor()));
        this.ctrlSpreadSellHedge.ctrl(this.spnSpreadSellHedge);
        this.spnSpreadSellHedge.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnSpreadSellHedge.getEditor()));
        this.ctrlDealLimit.ctrl(this.spnDealLimit);
        this.spnDealLimit.getEditor().setOnMouseClicked(event -> this.spnDealLimit.getEditor().selectAll());
        this.txtTimeoutFill.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 9));
        this.ctrlStoploss.ctrl(this.spnStoplossFill);
        this.ctrlMaxExposure.ctrl(this.spnMaxExposure);
        this.spnPriceSlip.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceSlip.getEditor()));
        this.ctrlDirectEffect.ctrl(this.spnDirectionEffect);
        this.spnDirectionEffect.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDirectionEffect.getEditor()));
        this.ctrlProtectEffect.ctrl(this.spnBondEffect);
        this.spnBondEffect.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnBondEffect.getEditor()));
        this.ctrlProtectFuse.ctrl(this.spnFuseLimit);
        this.spnFuseLimit.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnFuseLimit.getEditor()));
        this.ctrlTriggerPosition.ctrl(this.spnTriggerPosition);
        this.spnDealLimit.getEditor().setOnMouseClicked(event -> this.spnDealLimit.getEditor().selectAll());
    }

    protected void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbAcctErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbAcct.getEditor().getText().isEmpty()) {
                this.lbAcctErr.setText("\u8bf7\u8f93\u5165\u8d44\u91d1\u8d26\u6237");
                return false;
            }
            if (!this.model.accMng.getFundAccList().contains(this.cmbAcct.getEditor().getText())) {
                this.lbAcctErr.setText("\u8f93\u5165\u7684\u8d44\u91d1\u8d26\u53f7\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbAcct.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.lbName.getText().isEmpty() && this.algo == null) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            if (INVALID_CODE.equals(this.lbName.getText())) {
                this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtName.getText().isEmpty()) {
                this.lbNameErr.setText("\u8bf7\u8f93\u5165\u7b56\u7565\u540d\u79f0");
                return false;
            }
            if (this.nameList.contains(this.txtName.getText())) {
                this.lbNameErr.setText("\u6b64\u540d\u79f0\u5df2\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.registerCheck((Node)this.lbBaseCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!StringUtils.belongto((String)((MxNode)this.cmbType.getValue()).getRaw(), (String[])new String[]{"5", "7", "8", "11"})) {
                return true;
            }
            if (this.txtBaseCode.getText().isEmpty()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBaseCode.textProperty(), this.cmbType.getSelectionModel().selectedItemProperty()}));
        this.registerCheck((Node)this.lbQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtQtyBuy.getText().isEmpty()) {
                this.lbQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                return false;
            }
            if (Integer.valueOf(this.txtQtyBuy.getText().replaceAll(",", "")) > 39) {
                this.lbQtyBuyErr.setText("\u4e70\u5165\u624b\u6570\u4e0a\u9650\u4e3a39");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtQtyBuy.textProperty()}));
        this.registerCheck((Node)this.lbQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtQtySell.getText().isEmpty()) {
                this.lbQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                return false;
            }
            if (Integer.valueOf(this.txtQtySell.getText().replaceAll(",", "")) > 39) {
                this.lbQtySellErr.setText("\u5356\u51fa\u624b\u6570\u4e0a\u9650\u4e3a39");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtQtySell.textProperty()}));
        this.registerCheck((Node)this.lbMaxExposureErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnMaxExposure.getEditor().getText().isEmpty()) {
                this.lbMaxExposureErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u51c0\u655e\u53e3");
                return false;
            }
            if (Integer.valueOf(this.spnMaxExposure.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbMaxExposureErr.setText("\u6700\u5927\u51c0\u655e\u53e3\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMaxExposure.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbDealLimitErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.spnDealLimit.getEditor().getText().isEmpty()) {
                this.lbDealLimitErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u6210\u4ea4");
                return false;
            }
            if (Integer.valueOf(this.spnDealLimit.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbDealLimitErr.setText("\u6700\u5927\u6210\u4ea4\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnDealLimit.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbTriggerPositionErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.vboxAdjust.isDisable()) {
                return true;
            }
            if (this.spnTriggerPosition.getEditor().getText().isEmpty()) {
                this.lbTriggerPositionErr.setText("\u8bf7\u8f93\u5165\u89e6\u53d1\u51c0\u655e\u53e3");
                return false;
            }
            if (Integer.valueOf(this.spnTriggerPosition.getEditor().getText().replaceAll(",", "")) == 0) {
                this.lbTriggerPositionErr.setText("\u89e6\u53d1\u51c0\u655e\u53e3\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTriggerPosition.getEditor().textProperty(), this.vboxAdjust.disabledProperty()}));
        this.registerCheck((Node)this.lbMarketMakingErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.vboxHedge.isDisable()) {
                return true;
            }
            if (this.txtMarketMaking.getText().isEmpty()) {
                this.lbMarketMakingErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtMarketMaking.getText().replaceAll(",", "")) <= 0) {
                this.lbMarketMakingErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtMarketMaking.textProperty(), this.vboxHedge.disabledProperty()}));
        this.registerCheck((Node)this.lbHedgeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.vboxHedge.isDisable()) {
                return true;
            }
            if (this.txtHedge.getText().isEmpty()) {
                this.lbHedgeErr.setText("\u8bf7\u8f93\u5165\u6bd4\u4f8b");
                return false;
            }
            if (Integer.valueOf(this.txtHedge.getText().replaceAll(",", "")) <= 0) {
                this.lbHedgeErr.setText("\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtHedge.textProperty(), this.vboxHedge.disabledProperty()}));
        this.registerCheck((Node)this.lbAdjustQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.vboxAdjust.isDisable()) {
                return true;
            }
            if (this.txtBidAdjust.getText().isEmpty()) {
                this.lbAdjustQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u53d1\u5355\u6570\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtBidAdjust.textProperty(), this.vboxAdjust.disabledProperty()}));
        this.registerCheck((Node)this.lbAdjustQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.vboxAdjust.isDisable()) {
                return true;
            }
            if (this.txtAskAdjust.getText().isEmpty()) {
                this.lbAdjustQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u53d1\u5355\u6570\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtAskAdjust.textProperty(), this.vboxAdjust.disabledProperty()}));
    }

    private void setPriceSpreadByFormula(String formula, ComboBox<MxNode> price, Spinner<Double> spread) {
        int begin = formula.indexOf(46);
        int end = formula.indexOf(43);
        boolean negative = false;
        if (end < 0) {
            end = formula.indexOf(45);
            negative = true;
        }
        if (end > 0) {
            spread.getEditor().setText(formula.substring(end + 1).trim());
            if (negative) {
                spread.getEditor().setText("-" + formula.substring(end + 1).trim());
            }
        }
        String raw = "LAST";
        raw = end > 0 ? formula.substring(begin + 1, end).trim() : formula.substring(begin + 1).trim();
        if (raw.isEmpty()) {
            raw = "LAST";
        }
        MxNode node = new MxNode().load("future_algo_price_type", raw);
        price.setItems(node.getNodes());
        price.setValue((Object)node);
    }

    private void resetUnit(DoubleSpinnerCtrl ... ctrls) {
        if (this.refItem == null) {
            return;
        }
        if (this.refItem.getPriceUnit() == 0.0) {
            this.refItem.setPriceUnit(0.001);
        }
        if (this.refItem.getScale() == 0) {
            this.refItem.setScale(3);
        }
        DoubleSpinnerCtrl[] doubleSpinnerCtrlArray = ctrls;
        int n = ctrls.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleSpinnerCtrl ctrl = doubleSpinnerCtrlArray[n2];
            ctrl.getVF().setUnit(this.refItem.getPriceUnit());
            ctrl.setScale(this.refItem.getScale());
            ++n2;
        }
    }
}

