/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.api.data.IRefItem;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.futures.FuturesUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.cmschina.ficc.aggregation.ExpressionCalculator;
import com.cmschina.ficc.aggregation.constants.EStrategy;
import com.cmschina.ficc.aggregation.exception.AggregationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FormulaUtils {
    private static final Logger logger = LogManager.getLogger(FormulaUtils.class);
    @Inject
    private ExpressionCalculator exp;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private IRefDataMng refMng;
    private Map<String, MarketItem> mktItemList = new HashMap<String, MarketItem>();
    private InvalidationListener listenerRefMng = ob -> this.setRefList();
    private List<RefItem> nationalRefList = null;

    @PostConstruct
    private void init() {
        this.refMng.changedProperty().addListener(this.listenerRefMng);
        this.setRefList();
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
    }

    private void setRefList() {
        if (this.nationalRefList == null || this.nationalRefList.size() == 0) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
    }

    public double getPriceByFormula(String formula) {
        MarketItem mktItem;
        if (!this.exp.validateExpression(formula).getResult()) {
            return 0.0;
        }
        if (this.nationalRefList.size() <= 0) {
            return 0.0;
        }
        List<String> codes = this.exp.getContracts(formula);
        ArrayList<RefItem> itemListAll = new ArrayList<RefItem>();
        ArrayList<RefItem> itemList = new ArrayList<RefItem>();
        for (RefItem item : this.nationalRefList) {
            if (!codes.contains(item.getCode())) continue;
            itemListAll.add(item);
            mktItem = this.mktMng.getItem(item);
            if (mktItem != null) continue;
            itemList.add(item);
        }
        if (itemList.size() > 0) {
            Gears gears = new Gears();
            gears.setBuy(new int[]{1, 2, 3, 4, 5});
            gears.setSell(new int[]{1, 2, 3, 4, 5});
            this.mktMng.query(itemList, gears);
        }
        for (RefItem item : itemListAll) {
            mktItem = this.mktMng.getItem(item);
            if (mktItem == null) {
                mktItem = this.mktMng.getInfo((IRefItem)item);
            }
            double price = (mktItem.getSellPrice(0) + mktItem.getBuyPrice(0)) / 2.0;
            double afterModify = FormulaUtils.round(price, item.getPriceUnit());
            mktItem.setAvgPrice(afterModify);
            this.mktItemList.put(item.getCode(), mktItem);
        }
        try {
            double price = this.exp.calculate(formula, this.mktItemList, 0.0, 0, EStrategy.ApproximatePriceStrategy);
            return Double.valueOf(String.format("%.3f", price));
        }
        catch (AggregationError e) {
            logger.error("\u516c\u5f0f:" + formula + e.getCode().getErrorMessage());
            return 0.0;
        }
    }

    public static double round(double price, double unit) {
        int unitInt;
        long priceInt = Math.round(price * 10000.0);
        long remainder = priceInt % (long)(unitInt = (int)(unit * 10000.0));
        if (remainder != 0L && (double)remainder * 1.0 / (double)unitInt > 0.5) {
            priceInt += (long)unitInt;
        }
        priceInt -= priceInt % (long)unitInt;
        return (double)priceInt / 10000.0;
    }
}

