/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IBrokerService;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpDataPart
extends MxPart {
    @FXML
    private TableView<CtpRefItem> tableCtpData;
    @FXML
    private TableColumn<CtpRefItem, String> colId;
    @FXML
    private TableColumn<CtpRefItem, String> colName;
    @FXML
    private TableColumn<CtpRefItem, String> colExChange;
    @FXML
    private TableColumn<CtpRefItem, String> colBroker;
    @FXML
    private TableColumn<CtpRefItem, Number> colVolumeMultiple;
    @FXML
    private TableColumn<CtpRefItem, Number> colPriceTick;
    @FXML
    private TableColumn<CtpRefItem, String> colMinMarketOrderVolume;
    @FXML
    private TableColumn<CtpRefItem, String> colMaxMarketOrderVolume;
    @FXML
    private TableColumn<CtpRefItem, String> colOpenDate;
    @FXML
    private TableColumn<CtpRefItem, String> colExpireDate;
    @FXML
    private TableColumn<CtpRefItem, String> colStartDeliveryDate;
    @FXML
    private TableColumn<CtpRefItem, String> colEndDeliveryDate;
    @FXML
    private TableColumn<CtpRefItem, Number> colListedBasePrice;
    @FXML
    private TableColumn<CtpRefItem, Number> colPriceUpRate;
    @FXML
    private TableColumn<CtpRefItem, Number> colPriceDownRate;
    @FXML
    private TableColumn<CtpRefItem, String> colOpenRatio;
    @FXML
    private TableColumn<CtpRefItem, Number> colOpenVolume;
    @FXML
    private TableColumn<CtpRefItem, Number> colDeliveryFeeVolume;
    @FXML
    private TableColumn<CtpRefItem, Number> colTouBuy;
    @FXML
    private TableColumn<CtpRefItem, Number> colTouSell;
    @FXML
    private TableColumn<CtpRefItem, Number> colTaoBuy;
    @FXML
    private TableColumn<CtpRefItem, Number> colTaoSell;
    @FXML
    private TextField searchText;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IBrokerService brokerMng;
    @Inject
    private ExecutorService exe;
    public static final int MARKDET_ID = 5;
    private MxList<CtpRefItem> mlist = new MxList();
    private ObservableList<CtpRefItem> obList = FxUtils.newList();
    private static final int REQ_TYPE_ALL = 4;
    private static Logger logger = LogManager.getLogger(CtpDataPart.class);
    @Inject
    private MxAlert alert;
    private Predicate<CtpRefItem> pd = item -> {
        String text = this.searchText.getText().toUpperCase().trim();
        if (item.getCode().toUpperCase().contains(text)) {
            return true;
        }
        return this.brokerMng.getBroker(item.getBrokerId()) != null && this.brokerMng.getBroker(item.getBrokerId()).getName().toUpperCase().contains(text);
    };
    private InvalidationListener lstnModel = ob -> {
        this.obList.clear();
        for (CtpRefItem ctpRef : this.refMng.getItems(new String[]{"FUT"})) {
            this.obList.add((Object)ctpRef);
        }
        Platform.runLater(() -> this.mlist.update(this.obList, this.pd));
    };

    @FXML
    public void initialize() {
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.searchText.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        Collections.sort(this.mlist.getList(), (o1, o2) -> o1.getCode().substring(0, 1).compareTo(o2.getCode().substring(0, 1)));
        try {
            this.brokerMng.queryBrokerList();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
        this.createTableView();
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> this.refMng.loadRefData(4, "FUTURES", "", ""));
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithTwoHead(this.tableCtpData, (int)0, (int)0);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeTwoHeadExcel(this.tableCtpData, (String)"\u671f\u8d27\u57fa\u672c\u4fe1\u606f");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTableView() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.tableCtpData.setPlaceholder((Node)new Label());
        this.colId.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).codeProperty());
        this.colName.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).nameProperty());
        this.colBroker.setCellValueFactory(data -> {
            String brokerId = ((CtpRefItem)data.getValue()).getBrokerId();
            String brokerName = this.brokerMng.getBroker(brokerId) == null ? brokerId : this.brokerMng.getBroker(brokerId).getName();
            SimpleStringProperty name = new SimpleStringProperty(brokerName);
            return name;
        });
        this.colExChange.setCellValueFactory(data -> {
            String market = ((CtpRefItem)data.getValue()).getMarket();
            ObservableList nodeList = node.getNodes();
            SimpleStringProperty flage = new SimpleStringProperty("");
            for (MxNode item : nodeList) {
                if (!market.contains(item.getRaw())) continue;
                flage = new SimpleStringProperty(item.getValue());
            }
            return flage;
        });
        this.colVolumeMultiple.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).volumeMultipleProperty());
        this.colPriceTick.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).priceTickProperty());
        this.colPriceTick.setCellFactory(p -> new PriceCell());
        this.colMinMarketOrderVolume.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).minMarketOrderVolumeProperty());
        this.colMaxMarketOrderVolume.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).maxMarketOrderVolumeProperty());
        this.colOpenDate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).openDateProperty());
        this.colExpireDate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).expireDateProperty());
        this.colStartDeliveryDate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).startDeliveryDateProperty());
        this.colEndDeliveryDate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).endDeliveryDateProperty());
        this.colListedBasePrice.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).listedBasePriceProperty());
        this.colListedBasePrice.setCellFactory(column -> new DoubleTableCell());
        this.colPriceUpRate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).priceUpRateProperty());
        this.colPriceUpRate.setCellFactory(column -> new DoubleTableCell());
        this.colPriceDownRate.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).priceDownRateProperty());
        this.colPriceDownRate.setCellFactory(column -> new DoubleTableCell());
        this.colOpenRatio.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).openRatioProperty());
        this.colOpenVolume.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).openVolumeProperty());
        this.colOpenVolume.setCellFactory(column -> new DoubleTableCell());
        this.colDeliveryFeeVolume.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).deliveryFeeVolumeProperty());
        this.colDeliveryFeeVolume.setCellFactory(column -> new DoubleTableCell());
        this.colTouBuy.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).longMarginRatioProperty());
        this.colTouBuy.setCellFactory(column -> new RatioPriceCell());
        this.colTouSell.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).shortMarginRatioProperty());
        this.colTouSell.setCellFactory(column -> new RatioPriceCell());
        this.colTaoBuy.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).longMarginRatioProperty());
        this.colTaoBuy.setCellFactory(column -> new RatioPriceCell());
        this.colTaoSell.setCellValueFactory(data -> ((CtpRefItem)data.getValue()).shortMarginRatioProperty());
        this.colTaoSell.setCellFactory(column -> new RatioPriceCell());
        this.obList.clear();
        for (CtpRefItem ctpRef : this.refMng.getItems(new String[]{"FUT"})) {
            this.obList.add((Object)ctpRef);
        }
        this.mlist.setAll(this.obList);
        this.tableCtpData.setItems(this.mlist.getList());
        this.colId.setSortType(TableColumn.SortType.ASCENDING);
        this.tableCtpData.getSortOrder().add(this.colId);
        this.tableCtpData.sort();
    }

    private class PriceCell
    extends EditTableCell<CtpRefItem> {
        int scale = 0;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                CtpRefItem ref = (CtpRefItem)CtpRefItem.class.cast(this.getTableRow().getItem());
                if (ref != null) {
                    this.scale = ref.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }

    private class RatioPriceCell
    extends DoubleTableCell<CtpRefItem> {
        int scale = 3;

        private RatioPriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

