/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.trade.message.FutureAlertMng;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.SimpleStringProperty;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CtpAccDetailPart
extends MxPart {
    @FXML
    private TableView<FundAccount> tableCtpAcc;
    @FXML
    private TableColumn<CtpFundAccount, String> colAcc;
    @FXML
    private TableColumn<CtpFundAccount, String> colBroker;
    @FXML
    private TableColumn<CtpFundAccount, Number> colFirstBenefit;
    @FXML
    private TableColumn<CtpFundAccount, Number> colAvailable;
    @FXML
    private TableColumn<CtpFundAccount, Number> colCloseProf;
    @FXML
    private TableColumn<CtpFundAccount, Number> colPosiProf;
    @FXML
    private TableColumn<CtpFundAccount, Number> colTotalProf;
    @FXML
    private TableColumn<CtpFundAccount, Number> colExcMargin;
    @FXML
    private TableColumn<CtpFundAccount, Number> colDynBenefit;
    @FXML
    private TableColumn<CtpFundAccount, String> colMarginRatio;
    private static final double PARAM = 0.8;
    private MxList<FundAccount> mxList = new MxList();
    @Inject
    private IFundAccountService fundAccMng;
    private static final Logger logger = LogManager.getLogger(CtpAccDetailPart.class);
    @Inject
    private MxAlert alert;
    @Inject
    private FutureAlertMng alertMng;
    private InvalidationListener table = ob -> {
        try {
            this.mxList.update(this.fundAccMng.getFundAccountList("FUTURES"));
            this.tableCtpAcc.refresh();
        }
        catch (Exception e) {
            logger.error("\u671f\u8d27\u8d26\u53f7\u5237\u65b0\u51fa\u9519", (Throwable)e);
        }
    };

    @FXML
    public void initialize() {
        this.mxList.update(this.fundAccMng.getFundAccountList("FUTURES"));
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.table));
        this.createTableView();
        this.refresh();
    }

    @FXML
    public void refresh() {
        this.fundAccMng.queryFundAccountList();
    }

    private void createTableView() {
        this.tableCtpAcc.setPlaceholder((Node)new Label());
        this.tableCtpAcc.setItems(this.mxList.getList());
        this.colAcc.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).investIdProperty());
        this.colBroker.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).brokerIdProperty());
        this.colCloseProf.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).closeProfitProperty());
        this.colFirstBenefit.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).firstBenefitProperty());
        this.colAvailable.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).availableProperty());
        this.colPosiProf.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).positionProfitProperty());
        this.colExcMargin.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).currentMarginProperty());
        this.colTotalProf.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).totalProfitProperty());
        this.colDynBenefit.setCellValueFactory(data -> ((CtpFundAccount)data.getValue()).dynamicBenefitProperty());
        this.colMarginRatio.setCellFactory(data -> new AutoTableCell());
        this.colMarginRatio.setCellValueFactory(data -> {
            String str = "";
            if (((CtpFundAccount)data.getValue()).getMarginRatio() != Double.NEGATIVE_INFINITY && ((CtpFundAccount)data.getValue()).getMarginRatio() != Double.POSITIVE_INFINITY) {
                str = String.valueOf(String.format("%.2f", ((CtpFundAccount)data.getValue()).getMarginRatio() * 100.0)) + "%";
            }
            return new SimpleStringProperty(str);
        });
        this.colCloseProf.setCellFactory(column -> new DoubleTableCell());
        this.colFirstBenefit.setCellFactory(column -> new DoubleTableCell());
        this.colAvailable.setCellFactory(column -> new DoubleTableCell());
        this.colPosiProf.setCellFactory(column -> new DoubleTableCell());
        this.colExcMargin.setCellFactory(column -> new DoubleTableCell());
        this.colTotalProf.setCellFactory(column -> new DoubleTableCell());
        this.colDynBenefit.setCellFactory(column -> new DoubleTableCell());
        this.colTotalProf.setCellFactory(column -> new DoubleTableCell());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCtpAcc);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCtpAcc, (String)"\u8d26\u53f7\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public class AutoTableCell<S, T>
    extends TableCell<CtpFundAccount, T> {
        CtpFundAccount fundAccnt;
        PseudoClass pcRise = PseudoClass.getPseudoClass((String)"rise");

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.fundAccnt = (CtpFundAccount)CtpFundAccount.class.cast(this.getTableRow().getItem());
                if (this.fundAccnt == null) {
                    this.setText(null);
                    return;
                }
                if (this.fundAccnt.getMarginRatio() != 0.0) {
                    String str = "";
                    if (this.fundAccnt.getMarginRatio() != Double.NEGATIVE_INFINITY && this.fundAccnt.getMarginRatio() != Double.POSITIVE_INFINITY) {
                        str = String.valueOf(String.format("%.2f", this.fundAccnt.getMarginRatio() * 100.0)) + "%";
                        if (this.fundAccnt.getMarginRatio() > 0.8) {
                            CtpAccDetailPart.this.alertMng.alert(this.fundAccnt);
                            this.setStyle("-fx-text-fill: #FF0000");
                        }
                    }
                    this.setText(str);
                } else {
                    this.setText("0.00%");
                }
            } else {
                this.setText(null);
            }
        }
    }
}

