/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ConversionParam;
import cms.tmx.futures.models.FutureMarketListModel;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.futures.api.FutureYtmApi;
import cms.tmx.javafx.utils.FxUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class ConversionParamDialog
extends DialogObj {
    private static final Logger logger = Logger.getLogger(ConversionParamDialog.class);
    @FXML
    protected CheckBox cbxConsistent;
    @FXML
    private TableView<ConversionParam> tableParam;
    @FXML
    private TableColumn<ConversionParam, String> code;
    @FXML
    private TableColumn<ConversionParam, ComboBox<Instrument>> ctdSec;
    @FXML
    private TableColumn<ConversionParam, Number> costCapital;
    @Inject
    private FutureYtmApi ytmApi;
    @Inject
    private FutureMarketListModel model;
    @Inject
    private MxAlert alert;
    private ObservableList<ConversionParam> list = FxUtils.newList();

    @FXML
    public void initialize() {
        this.cbxConsistent.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                double costCapital = ((ConversionParam)this.list.get(0)).getCostCapital();
                this.list.forEach(item -> item.setCostCapital(costCapital));
            }
        });
        this.createTable();
    }

    private void createTable() {
        this.tableParam.setEditable(true);
        this.costCapital.setEditable(true);
        this.ctdSec.setCellValueFactory(data -> this.setCombobox((TableColumn.CellDataFeatures<ConversionParam, ComboBox<Instrument>>)data));
        this.code.setCellValueFactory(data -> ((ConversionParam)data.getValue()).contractProperty());
        this.costCapital.setCellValueFactory(data -> ((ConversionParam)data.getValue()).costCapitalProperty());
        this.costCapital.setCellFactory(data -> new costCapitalCell(2));
        this.tableParam.setItems(this.list);
        this.tableParam.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                int index;
                if (this.cbxConsistent.isSelected() && (index = this.list.indexOf(row.getItem())) != 0 && row.isSelected()) {
                    event.consume();
                }
            });
            return row;
        });
        this.costCapital.addEventHandler(TableColumn.editCommitEvent(), event -> {
            double oldValue;
            double newValue = (Double)event.getNewValue();
            if (newValue == (oldValue = ((Double)event.getOldValue()).doubleValue())) {
                return;
            }
            if (this.cbxConsistent.isSelected()) {
                this.list.forEach(item -> item.setCostCapital(newValue));
            }
        });
    }

    private ReadOnlyObjectWrapper<ComboBox<Instrument>> setCombobox(TableColumn.CellDataFeatures<ConversionParam, ComboBox<Instrument>> data) {
        ComboBox cbx = new ComboBox();
        cbx.setConverter((StringConverter)new StringConverter<Instrument>(){

            public String toString(Instrument object) {
                return object.getSecurityId();
            }

            public Instrument fromString(String string) {
                return null;
            }
        });
        ConversionParam param = (ConversionParam)data.getValue();
        cbx.getItems().addAll((Collection)param.getListCtd());
        cbx.valueProperty().bindBidirectional((Property)param.ctdSecProperty());
        cbx.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
                cbx.hide();
            }
        });
        cbx.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {});
        return new ReadOnlyObjectWrapper((Object)cbx);
    }

    public void setList(List<ConversionParam> list) {
        this.list.setAll(list);
    }

    protected boolean isOK(ButtonType bt) {
        try {
            this.model.setFutureYmts((List<ConversionParam>)this.list);
        }
        catch (MException | IOException e) {
            logger.error((Object)"\u6362\u7b97\u53c2\u6570\u8bbe\u7f6e\u5931\u8d25\uff1a", e);
            this.alert.alert(Alert.AlertType.ERROR, "\u6362\u7b97\u53c2\u6570\u8bbe\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
        }
        return true;
    }

    private class costCapitalCell
    extends EditTableCell<ConversionParam> {
        costCapitalCell(int i) {
            super(i);
        }

        public void startEdit() {
            super.startEdit();
            if (this.getTextField().getTextFormatter() == null) {
                this.getTextField().setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
            }
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
        }
    }
}

