/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IFutureMarketMakingApi;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.StrategyCrossOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StrategyCrossOrderModel
extends MxModel {
    private ObservableList<StrategyCrossOrder> list = FxUtils.newList();
    @Inject
    private IFutureMarketMakingApi api;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private MObjFactory of;
    @Inject
    protected MEventService es;
    @Inject
    protected ScheduledExecutorService ses;

    public ObservableList<StrategyCrossOrder> getList() {
        return this.list;
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("requery_data", event -> this.ses.schedule(() -> {
            try {
                this.query();
            }
            catch (MException e) {
                this.logger.error("StrategyCrossOrder query failed:", (Throwable)e);
            }
        }, 60L, TimeUnit.SECONDS));
    }

    public void query() throws MException {
        PStrategy.GetCrossOrdersReq.Builder builder = PStrategy.GetCrossOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        List listCross = this.api.getCrossOrder(builder.build());
        this.list.clear();
        for (PStrategy.CrossOrder cross : listCross) {
            StrategyCrossOrder s = (StrategyCrossOrder)this.of.create(StrategyCrossOrder.class);
            s.update((Object)cross);
            this.list.add((Object)s);
        }
        this.changed();
    }
}

