/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.imp.HedgeTaskApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.strategy.PHedge;
import cms.tmx.entity.notice.HedgeTaskReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.trade.HedgeTask;
import cms.tmx.futures.models.FutureMarketMakingModel;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.trade.message.SoundControl;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class HedgeTaskModel
extends MxModel {
    @Inject
    private HedgeTaskApi api;
    @Inject
    protected IBaseApi iba;
    @Inject
    private QueryModel queryModel;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MEventService es;
    @Inject
    private SoundControl soundMng;
    private static final Logger logger = LogManager.getLogger(FutureMarketMakingModel.class);
    private MxList<HedgeTask> mlist = new MxList();
    protected Gson gson = GsonFactory.getInstance();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    public void init() {
        this.es.subscribe("server.sub", this.handler);
    }

    protected void onPush(MEvent event) {
        MxNotice obj = (MxNotice)event.getObj(MxNotice.class);
        if (obj instanceof HedgeTaskReport) {
            HedgeTaskReport report = (HedgeTaskReport)HedgeTaskReport.class.cast(obj);
            PHedge.HedgeTaskInfo info = report.getReport();
            HedgeTask task = new HedgeTask();
            task.update((Object)info);
            task.setExtFundAccntId(this.queryModel.getCtpInvestId(task.getExtFundAccntId()));
            task.setExtSecAccntId(this.queryModel.getCtpInverstorSecId(task.getExtSecAccntId()));
            if (info.getHedgeStatus().equals((Object)PHedge.HedgeStatus.HEDGE_STATUS_STOPPED) && !info.getText().equals("\u624b\u5de5\u505c\u6b62")) {
                this.soundMng.notifyTaskStopped(SoundControl.Audio.TASK_STOP);
            }
            this.mlist.updatePart((MxObject)task);
            this.changed();
        }
    }

    public void query() throws MException {
        PHedge.GetHedgeTasksReq.Builder builder = PHedge.GetHedgeTasksReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        List tasks = this.api.getTasks(builder);
        this.updateData(tasks);
    }

    private void updateData(List<PHedge.HedgeTaskInfo> listInfo) {
        ArrayList<HedgeTask> listTmp = new ArrayList<HedgeTask>();
        for (PHedge.HedgeTaskInfo info : listInfo) {
            HedgeTask strategy = new HedgeTask();
            strategy.update((Object)info);
            strategy.setExtFundAccntId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
            strategy.setExtSecAccntId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
            listTmp.add(strategy);
        }
        this.mlist.update(listTmp);
        this.changed();
    }

    public Map<String, String> start(List<String> list) throws MException {
        PHedge.StartHedgeTasksReq.Builder req = PHedge.StartHedgeTasksReq.newBuilder();
        req.setOpUser(this.iba.getOpUser());
        req.addAllTaskId(list);
        Map map = this.api.startStrategy(req.build());
        return map;
    }

    public Map<String, String> stop(List<String> list) throws MException {
        PHedge.StopHedgeTasksReq.Builder req = PHedge.StopHedgeTasksReq.newBuilder();
        req.setOpUser(this.iba.getOpUser());
        req.addAllTaskId(list);
        Map map = this.api.stopStrategy(req.build());
        return map;
    }

    public void update(HedgeTask task) throws MException {
        PHedge.UpdateHedgeTaskReq.Builder req = PHedge.UpdateHedgeTaskReq.newBuilder();
        PHedge.HedgeTaskInfo.Builder info = PHedge.HedgeTaskInfo.newBuilder();
        info.setTaskId(task.getTaskId());
        info.setHedgePriceCustom(task.getHedgePriceCustom());
        info.setLeavesQty(task.getLeavesQty());
        info.setStoplossFill(task.getStoplossFill());
        info.setTimeoutFill(task.getTimeoutFill());
        info.setHedgeStatusValue(Integer.valueOf(task.getHedgeStatus().getRaw()).intValue());
        req.setOpUser(this.iba.getOpUser());
        req.setTaskInfo(info.build());
        this.api.updateStrategy(req.build());
    }

    public void finish(HedgeTask task) throws MException {
        PHedge.UpdateHedgeTaskReq.Builder req = PHedge.UpdateHedgeTaskReq.newBuilder();
        PHedge.HedgeTaskInfo.Builder info = PHedge.HedgeTaskInfo.newBuilder();
        info.setTaskId(task.getTaskId());
        info.setHedgePriceCustom(task.getHedgePriceCustom());
        info.setLeavesQty(task.getLeavesQty());
        info.setStoplossFill(task.getStoplossFill());
        info.setTimeoutFill(task.getTimeoutFill());
        info.setHedgeStatus(PHedge.HedgeStatus.HEDGE_STATUS_FINISHED);
        req.setOpUser(this.iba.getOpUser());
        req.setTaskInfo(info.build());
        this.api.updateStrategy(req.build());
    }

    public List<HedgeTask> getList() {
        return this.mlist.getList();
    }
}

