/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.core.MException;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.futures.entrust.EntrustFactory;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.futures.models.CtpAccountDistributionModel;
import cms.tmx.futures.models.CtpEntrustSplitModel;
import cms.tmx.futures.models.UserPreCtrlFuture;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureTradeModel
extends MxModel {
    private StringProperty security = new SimpleStringProperty("");
    private ObjectProperty<MarketItem> item = new SimpleObjectProperty();
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> hedgeType = new SimpleObjectProperty();
    private StringProperty bs = new SimpleStringProperty("");
    private StringProperty oc = new SimpleStringProperty("");
    private MarketItem mktItem;
    @Inject
    private CtpAccountDistributionModel accModel;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private EntrustFactory ef;
    private UserPreCtrlFuture preModel;
    @Inject
    protected CtpEntrustSplitModel entrustSplit;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(5);
        this.accModel.securityProperty().bind((ObservableValue)this.security);
        this.accModel.priceProperty().bind((ObservableValue)this.price);
        MxNode node = MxNodeFactory.create((String)"futures_price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        node = MxNodeFactory.create((String)"sh_flag", (String)"1");
        this.hedgeType.addListener(ob -> this.onHedgeChange());
        this.setHedgeType(node);
        node = MxNodeFactory.create((String)"futures_count_stg", (String)"1");
        this.setCountStg(node);
        node = MxNodeFactory.create((String)"acc_dist_mode", (String)"1");
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.distStg(node);
        this.setDistStg(node);
        this.accModel.permissionProperty().addListener((ob, old, newV) -> this.onPermissionChange((boolean)newV));
        this.getAccDis().countProperty().bind((ObservableValue)this.countProperty());
    }

    public void onSecChange() {
        this.setCount(0L);
        this.setPrice(0.0);
        this.mktItem.setRefItem((RefItem)this.getValidRef());
        this.getAccDis().setRefItem(this.getValidRef());
        this.mktMng.dye(this.mktItem);
        this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
        this.accModel.filterAcc();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public StringProperty securityProperty() {
        return this.security;
    }

    public String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<MarketItem> itemProperty() {
        return this.item;
    }

    public MarketItem getItem() {
        return (MarketItem)this.itemProperty().get();
    }

    public void setItem(MarketItem item) {
        this.itemProperty().set((Object)item);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public double getOrderPrice() {
        if (this.getPriceStg().getRaw().equals("opp")) {
            if (this.getBs().equals("\u4e70\u5165")) {
                return ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice();
            }
            return ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice();
        }
        return this.getPrice();
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public ObjectProperty<MxNode> hedgeTypeProperty() {
        return this.hedgeType;
    }

    public MxNode getHedgeType() {
        return (MxNode)this.hedgeTypeProperty().get();
    }

    public void setHedgeType(MxNode hedgeType) {
        this.hedgeTypeProperty().set((Object)hedgeType);
    }

    public CtpAccountDistributionModel getAccDis() {
        return this.accModel;
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("sell1");
        node.addNode("newp");
        node.addNode("buy1");
        node.addNode("opp");
    }

    private void distStg(MxNode node) {
        node.removeNode("3");
    }

    public synchronized ObservableList<Boolean> submit(String type) throws Exception {
        ObservableList returnList = FxUtils.newList();
        for (FutureSingleEntrust en : this.getPreOrderList(type)) {
            try {
                en.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public List<FutureSingleEntrust> getPreOrderList(String type) throws Exception {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        for (CtpAccountDistribution accDis : this.accModel.getAccList().filtered(each -> each.isSelected() && each.getCount() > 0L)) {
            CtpSecAccount secAcc = this.accModel.getSecAcc(accDis.getCtpAcc(), this.mktItem.getRefItem().getMarket());
            if (secAcc == null) {
                throw new Exception("\u65e0\u8bc1\u5238\u8d26\u53f7");
            }
            FutureSingleEntrust en = this.ef.createSingle(accDis.getCtpAcc().getExtAccntId(), secAcc.getExtSecAccntId());
            en.setQuantity(accDis.getCount());
            en.setMarket(this.mktItem.getRefItem().getMarket());
            en.setMarketGrp(MarketUtils.getMarketGroup((String)en.getMarket()));
            en.setSecType("FUT");
            en.setOrderType(50);
            en.setPrice(this.getOrderPrice());
            en.setSec(this.mktItem.getRefItem().getCode());
            en.setSecName(this.mktItem.getRefItem().getName());
            en.setHedgeFlag(Integer.parseInt(this.getHedgeType().getRaw()));
            en.setBrokerId(accDis.getCtpAcc().getBrokerId());
            en.setInvestorId(secAcc.getInverstorId());
            en.setInvestorSecId(secAcc.getInverstorSecId());
            en.setSecAccount((SecAccount)secAcc);
            en.setFundAccount((FundAccount)accDis.getCtpAcc());
            this.entrustSplit.setRefItem(this.getValidRef());
            this.entrustSplit.setToday("1".equals(this.preModel.getClose()));
            this.entrustSplit.setInstructionType("0");
            this.entrustSplit.setAccDis(accDis);
            List<FutureSingleEntrust> splitList = this.entrustSplit.split(en, type, null);
            enList.addAll(splitList);
        }
        return enList;
    }

    private void onHedgeChange() {
        this.accModel.setHedgeType(this.getHedgeType().getRaw());
    }

    private void onPermissionChange(boolean isPermit) {
        if (!isPermit) {
            this.setName("\u8d26\u53f7\u65e0\u6743\u9650");
        } else {
            this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
        }
    }

    public Boolean isXSGE() {
        if (!this.isValidRef()) {
            return false;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSGE")) {
            return true;
        }
        return false;
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getType().equals("FUT");
    }

    public final StringProperty bsProperty() {
        return this.bs;
    }

    public final String getBs() {
        return (String)this.bsProperty().get();
    }

    public final void setBs(String bs) {
        this.bsProperty().set((Object)bs);
    }

    public final StringProperty ocProperty() {
        return this.oc;
    }

    public final String getOc() {
        return (String)this.ocProperty().get();
    }

    public final void setOc(String oc) {
        this.ocProperty().set((Object)oc);
    }

    public boolean isFixedPrice() {
        return !this.getPriceStg().getRaw().equals("opp");
    }

    private void onDistStgChange() {
        this.getAccDis().setDistStg(this.getDistStg().getRaw());
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CtpRefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item instanceof CtpRefItem && item.getType().equals("FUT")) {
            return (CtpRefItem)CtpRefItem.class.cast(item);
        }
        return null;
    }

    public void setPreModel(UserPreCtrlFuture preModel) {
        this.preModel = preModel;
    }
}

