/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureMonitorUnfinishedModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(FutureMonitorUnfinishedModel.class);
    @Inject
    private CtpUnfinishedOrderModel ccsUnfinishedOrderModel;
    @Inject
    protected MScheduler sdFullQuery;
    private InvalidationListener unfinishedOrderChange = ob -> {
        logger.debug("\u672a\u5b8c\u6210\u53d1\u751f\u53d8\u5316" + new SimpleDateFormat("HH:mm:ss:sss").format(new Date()));
        this.sdFullQuery.schedule(event -> this.calcUnfinishedOrder());
    };
    private Map<String, Map<Double, Integer>> map = new HashMap<String, Map<Double, Integer>>();
    private Map<String, Map<Double, Integer>> oldMap = new HashMap<String, Map<Double, Integer>>();
    public List<String> listMonitor = new ArrayList<String>();
    @Inject
    private MEventService es;

    public Map<Double, Integer> getMap(String investorSec) {
        return this.map.get(investorSec);
    }

    @PostConstruct
    private void init() {
        this.sdFullQuery.setInterval(1500);
        this.ccsUnfinishedOrderModel.changedProperty().addListener(this.unfinishedOrderChange);
        this.ccsUnfinishedOrderModel.query();
    }

    @PreDestroy
    private void close() {
    }

    public void finalize() {
        this.ccsUnfinishedOrderModel.changedProperty().removeListener(this.unfinishedOrderChange);
        logger.info("-------- FutureMonitorUnfinishedModel: finalize called " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void calcUnfinishedOrder() {
        long start = System.currentTimeMillis();
        logger.debug("===================  \u8ba1\u7b97\u672a\u5b8c\u6210\u5217\u8868  \u5f00\u59cb =======================");
        try {
            ArrayList unOrder = new ArrayList();
            ObservableList observableList = this.ccsUnfinishedOrderModel.getList();
            synchronized (observableList) {
                unOrder.addAll(this.ccsUnfinishedOrderModel.getList());
            }
            logger.debug("\u672a\u5b8c\u6210\u539f\u59cb\u5217\u8868\uff1a " + unOrder);
            this.map = new HashMap<String, Map<Double, Integer>>();
            for (CtpOrder order : unOrder) {
                String key = String.valueOf(order.getInvestorId()) + "_" + order.getInstrument().getSecId();
                if (this.map.get(key) == null) {
                    this.map.put(key, new HashMap());
                }
                if (this.map.get(key).get(order.getPrice()) != null) {
                    int qty = this.map.get(key).get(order.getPrice()) + order.getOrderQty() - order.getCumQty();
                    this.map.get(key).put(order.getPrice(), qty);
                    continue;
                }
                this.map.get(key).put(order.getPrice(), order.getOrderQty() - order.getCumQty());
            }
            logger.debug("\u6839\u636e\u672a\u5b8c\u6210\u5217\u8868\u751f\u6210\u7684 Map: " + this.map);
            logger.debug("\u5df2\u7ecf\u8ba2\u9605\u4e86\u76d1\u63a7\u7684listMonitor\uff1a" + this.listMonitor);
            HashSet<String> monitors = new HashSet<String>();
            monitors.addAll(this.listMonitor);
            for (String investorSec : monitors) {
                MEvent event;
                Map<Double, Integer> old = this.oldMap.get(investorSec);
                Map<Double, Integer> now = this.map.get(investorSec);
                logger.debug("\u6b63\u5728\u5224\u65ad" + investorSec + "\u7684\u672a\u5b8c\u6210\u662f\u5426\u6709\u53d8\u5316");
                logger.debug(String.valueOf(investorSec) + "\u8001\u7684\u672a\u5b8c\u6210\u4e3a\uff1a" + old);
                logger.debug(String.valueOf(investorSec) + "\u65b0\u7684\u672a\u5b8c\u6210\u4e3a\uff1a" + now);
                boolean shouldSend = false;
                if (old == null && now != null) {
                    event = new MEvent();
                    event.setObj(now);
                    this.es.postEvent(investorSec, event);
                    logger.debug(String.valueOf(investorSec) + "\u8001\u7684\u662fnull,\u65b0\u7684\u4e0d\u662fnull,\u901a\u77e5\u53d8\u5316");
                    continue;
                }
                if (old != null && now == null) {
                    event = new MEvent();
                    event.setObj(new HashMap());
                    this.es.postEvent(investorSec, event);
                    logger.debug(String.valueOf(investorSec) + "\u8001\u7684\u4e0d\u662fnull,\u65b0\u7684\u662fnull,\u901a\u77e5\u53d8\u5316");
                    continue;
                }
                if (old == null && now == null) {
                    logger.debug(String.valueOf(investorSec) + "\u65b0\u8001\u90fd\u662fnull,\u4e0d\u901a\u77e5\u53d8\u5316");
                    continue;
                }
                if (old.size() != now.size()) {
                    shouldSend = true;
                }
                for (Map.Entry<Double, Integer> entry : old.entrySet()) {
                    Integer i = now.get(entry.getKey());
                    if (i == null) {
                        shouldSend = true;
                        break;
                    }
                    if (i.equals(entry.getValue())) continue;
                    shouldSend = true;
                    break;
                }
                if (shouldSend) {
                    event = new MEvent();
                    event.setObj(now);
                    this.es.postEvent(investorSec, event);
                    logger.debug(String.valueOf(investorSec) + "\u65b0\u8001\u4e0d\u4e00\u6837\uff0c\u901a\u77e5\u53d8\u5316");
                    continue;
                }
                logger.debug(String.valueOf(investorSec) + "\u65b0\u8001\u4e00\u6837\uff0c\u4e0d\u901a\u77e5\u53d8\u5316");
            }
            this.oldMap = this.map;
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u672a\u5b8c\u6210\u5217\u8868\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        logger.debug("----------------------  \u8ba1\u7b97\u672a\u5b8c\u6210\u5217\u8868 \u7ed3\u675f, \u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
    }
}

