/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.trade.IStrategyMonitorApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Indicator;
import cms.tmx.futures.models.FutureMonitorUnfinishedModel;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureMonitorModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(FutureMonitorModel.class);
    @Inject
    private IStrategyMonitorApi api;
    @Inject
    private MObjFactory of;
    private List<Indicator> list = new ArrayList<Indicator>();
    @Inject
    public CtpAccountMap accMng;
    protected MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    public BooleanProperty reset = new SimpleBooleanProperty();
    private StringProperty code = new SimpleStringProperty("");
    private StringProperty account = new SimpleStringProperty("");
    @Inject
    private FutureMonitorUnfinishedModel model;
    @Inject
    protected MScheduler scheduler;
    @Inject
    private MConfService conf;
    private int gear = 5;
    @Inject
    private MEventService es;
    private MEventHandler handler = event -> {
        if (event.getObj() instanceof Map) {
            Map map = (Map)event.getObj();
            this.resetMarket(map);
        }
    };
    private ChangeListener<String> accountChange = (ob, old, now) -> {
        this.es.unSubscribe(String.valueOf(old) + "_" + (String)this.code.get(), this.handler);
        this.model.listMonitor.remove(String.valueOf(old) + "_" + (String)this.code.get());
        logger.debug("\u76d1\u63a7\u5217\u8868\u53d8\u5316\uff1a \u53d6\u6d88" + old + "_" + (String)this.code.get());
        if (this.accMng.getFundAccList().contains(now) && !((String)this.code.get()).isEmpty()) {
            this.es.subscribe(String.valueOf(now) + "_" + (String)this.code.get(), this.handler);
            this.model.listMonitor.add(String.valueOf(now) + "_" + (String)this.code.get());
            logger.debug("\u76d1\u63a7\u5217\u8868\u53d8\u5316\uff1a \u52a0\u4e0a" + now + "_" + (String)this.code.get());
            this.refresh();
        }
        logger.error("\u65b0\u7684\u76d1\u63a7\u5217\u8868\u4e3a\uff1a " + this.model.listMonitor);
        this.query();
    };
    private ChangeListener<RefItem> refItemChange = (ob, old, now) -> {
        this.es.unSubscribe(String.valueOf((String)this.account.get()) + "_" + old, this.handler);
        this.model.listMonitor.remove(String.valueOf((String)this.account.get()) + "_" + old);
        logger.debug("\u76d1\u63a7\u5217\u8868\u53d8\u5316\uff1a \u53d6\u6d88" + (String)this.account.get() + "_" + old);
        if (now != null && !now.getCode().isEmpty()) {
            this.es.subscribe(String.valueOf((String)this.account.get()) + "_" + now.getCode(), this.handler);
            this.model.listMonitor.add(String.valueOf((String)this.account.get()) + "_" + now.getCode());
            logger.debug("\u76d1\u63a7\u5217\u8868\u53d8\u5316\uff1a \u52a0\u4e0a" + (String)this.account.get() + "_" + now.getCode());
            this.refresh();
        }
        logger.error("\u65b0\u7684\u76d1\u63a7\u5217\u8868\u4e3a\uff1a " + this.model.listMonitor);
    };
    double max = 0.0;
    double min = 0.0;

    public List<Indicator> getList() {
        return this.list;
    }

    public BooleanProperty resetProperty() {
        return this.reset;
    }

    public void reseted() {
        this.reset.set(!this.reset.get());
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public void onSecChange() {
        this.mktMng.dye(this.mktItem);
    }

    @PostConstruct
    public void init() {
        this.scheduler.setInterval(1000);
        this.mktItem = this.mktMng.createItem(10);
        this.gear = this.conf.getValueAsInt("future.gear", 5);
        this.mktItem.setClearGears(this.gear);
        this.mktItem.setMarketMaking(true);
        this.account.addListener(this.accountChange);
        this.mktItem.refItemProperty().addListener(this.refItemChange);
    }

    @PreDestroy
    public void close() {
        this.es.unSubscribe(String.valueOf((String)this.account.get()) + "_" + (String)this.code.get(), this.handler);
        this.model.listMonitor.remove(String.valueOf((String)this.account.get()) + "_" + (String)this.code.get());
        this.account.removeListener(this.accountChange);
        this.mktItem.refItemProperty().removeListener(this.refItemChange);
        logger.error("\u76d1\u63a7\u5217\u8868\u53d8\u5316\uff1a \u5173\u95ed" + (String)this.account.get() + "_" + (String)this.code.get());
        logger.error("\u65b0\u7684\u76d1\u63a7\u5217\u8868\u4e3a\uff1a " + this.model.listMonitor);
    }

    public void refresh() {
        this.scheduler.schedule(event -> {
            Map<Double, Integer> map = this.model.getMap(String.valueOf((String)this.account.get()) + "_" + (String)this.code.get());
            logger.error("\u91cd\u65b0\u8bbe\u7f6e\u6302\u5355\u6570\u91cf: " + (String)this.account.get() + "_" + (String)this.code.get());
            this.resetMarket(map);
        });
    }

    public synchronized void resetMarket(Map<Double, Integer> map) {
        double price;
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("--------------  \u8bbe\u7f6e\u6302\u5355\u6570\u91cf \u5f00\u59cb -----------------" + (String)this.code.get());
            logger.debug(String.valueOf((String)this.code.get()) + "\u7684Map\u4e3a\uff1a " + map);
        }
        for (HandicapInfo handicap : this.mktItem.getListSellHandicap()) {
            if (handicap.getIndex() <= this.gear) continue;
            handicap.setCount(-1);
            handicap.setPrice(-1.0);
            handicap.setOrder(-1);
            handicap.setPriceStr("");
        }
        for (HandicapInfo handicap : this.mktItem.getListBuyHandicap()) {
            if (handicap.getIndex() <= this.gear) continue;
            handicap.setCount(-1);
            handicap.setPrice(-1.0);
            handicap.setOrder(-1);
            handicap.setPriceStr("");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("********** \u4e4b\u524d\u52a0\u4e0a\u53bb\u7684\u76d8\u53e3\u4ef7\u683c\u5df2\u6e05\u9664  ******************" + (String)this.code.get());
        }
        if (map == null || map.size() == 0) {
            for (HandicapInfo i : this.mktItem.getListSellHandicap()) {
                i.setOrder(-1);
            }
            for (HandicapInfo i : this.mktItem.getListBuyHandicap()) {
                i.setOrder(-1);
            }
            this.changed();
            logger.debug(String.valueOf((String)this.code.get()) + "\u7684 Map\u662f\u7a7a,\u76f4\u63a5\u7ed3\u675f \uff01 ******************");
            return;
        }
        this.max = 0.0;
        if (((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() > 0.0) {
            this.max = ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice();
        }
        for (HandicapInfo i : this.mktItem.getListSellHandicap()) {
            if (i.getIndex() > this.gear) break;
            i.setOrder(-1);
            double d = (double)Math.round(i.getPrice() * 1000.0) / 1000.0;
            double d2 = this.max = d > this.max ? d : this.max;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf((String)this.code.get()) + "   \u6863\u4f4d" + i.getIndex() + " \u4ef7\u683cString\uff1a" + i.getPriceStr() + ",   \u4ef7\u683c\uff1a" + d + ",    \u65b0max: " + this.max);
            }
            if (map.get(d) != null) {
                i.setOrder(map.get(d).intValue());
                if (logger.isDebugEnabled()) {
                    logger.debug(">>>>>>>>>>>>>>>\u5339\u914d\u5230\u76d8\u53e3\u4ef7\u683c\uff1a" + d + "  \u5e76\u5c06\u5176\u6302\u5355\u91cf\u8bbe\u7f6e\u4e3a" + i.getOrder());
                }
            }
            i.setClear(false);
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Double price3 : map.keySet()) {
            if (!(price3 > this.max)) continue;
            list.add(price3);
        }
        Collections.sort(list);
        if (logger.isDebugEnabled()) {
            logger.debug(">>>>>>>>>>>>>>>" + (String)this.code.get() + "   \u6bd4\u6700\u5927\u4ef7\u683c" + this.max + "\u5927\u7684\u59d4\u6258\u6709\uff1a" + list);
        }
        int index = 0;
        for (HandicapInfo handicapInfo : this.mktItem.getListSellHandicap()) {
            if (handicapInfo.getPrice() != -1.0 || list.size() <= index) continue;
            price = (Double)list.get(index);
            handicapInfo.setPrice(price);
            handicapInfo.setPriceStr(String.valueOf(price));
            handicapInfo.setOrder(map.get(price).intValue());
            handicapInfo.setClear(false);
            ++index;
        }
        this.min = Double.MAX_VALUE;
        if (((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() > 0.0) {
            this.min = ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice();
        }
        for (HandicapInfo handicapInfo : this.mktItem.getListBuyHandicap()) {
            if (handicapInfo.getIndex() > this.gear) break;
            handicapInfo.setOrder(-1);
            price = (double)Math.round(handicapInfo.getPrice() * 1000.0) / 1000.0;
            double d = this.min = price < this.min && price > 0.0 ? price : this.min;
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf((String)this.code.get()) + "   \u6863\u4f4d" + handicapInfo.getIndex() + " \u4ef7\u683cString\uff1a" + handicapInfo.getPriceStr() + "   ,\u4ef7\u683c\uff1a" + price + "   ,\u65b0min: " + this.min);
            }
            if (map.get(price) != null) {
                handicapInfo.setOrder(map.get(price).intValue());
                if (logger.isDebugEnabled()) {
                    logger.debug(">>>>>>>>>>>>>>>\u5339\u914d\u5230\u76d8\u53e3\u4ef7\u683c\uff1a" + price + "  \u5e76\u5c06\u5176\u6302\u5355\u91cf\u8bbe\u7f6e\u4e3a" + handicapInfo.getOrder());
                }
            }
            handicapInfo.setClear(false);
        }
        list = new ArrayList();
        for (Double d : map.keySet()) {
            if (!(d < this.min)) continue;
            list.add(d);
        }
        list.sort((o1, o2) -> Double.compare(o2, o1));
        if (logger.isDebugEnabled()) {
            logger.debug(">>>>>>>>>>>>>>>" + (String)this.code.get() + "   \u6bd4" + this.min + "\u5c0f\u7684\u59d4\u6258\u6709\uff1a" + list);
        }
        index = 0;
        for (HandicapInfo handicapInfo : this.mktItem.getListBuyHandicap()) {
            if (handicapInfo.getPrice() != -1.0 || list.size() <= index) continue;
            price = (Double)list.get(index);
            handicapInfo.setPrice(price);
            handicapInfo.setPriceStr(String.valueOf(price));
            handicapInfo.setOrder(map.get(price).intValue());
            handicapInfo.setClear(false);
            ++index;
        }
        this.reseted();
        logger.error("=====================  \u8bbe\u7f6e\u6302\u5355\u6570\u91cf \u7ed3\u675f ===" + (String)this.code.get() + ", \u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + " ms");
    }

    public void query() {
        try {
            if (this.accMng == null || this.accMng.getFundAcc((String)this.account.get()) == null) {
                this.list.clear();
                return;
            }
            String extAccntId = this.accMng.getFundAcc((String)this.account.get()).getExtAccntId();
            if (this.mktItem == null || this.mktItem.getRefItem() == null) {
                this.list.clear();
                return;
            }
            String market = this.mktItem.getRefItem().getMarket();
            if (((String)this.code.get()).isEmpty()) {
                this.list.clear();
                return;
            }
            if (!StringUtils.isEmpty((String)market) && !StringUtils.isEmpty((String)extAccntId)) {
                List result = this.api.GetRealTimeMonitior(this.mktItem.getRefItem().getMarket(), extAccntId, (String)this.code.get());
                this.list.clear();
                result.forEach(item -> {
                    System.currentTimeMillis();
                    Indicator indicator = (Indicator)this.of.create(Indicator.class);
                    indicator.update(item);
                    this.list.add(indicator);
                });
            } else {
                this.list.clear();
            }
        }
        catch (MException e) {
            this.list.clear();
            logger.error("FutureMonitorModel - query\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.changed();
    }

    public final StringProperty accountProperty() {
        return this.account;
    }

    public final String getAccount() {
        return (String)this.accountProperty().get();
    }

    public final void setAccount(String account) {
        this.accountProperty().set((Object)account);
    }

    public final StringProperty codeProperty() {
        return this.code;
    }

    public final String getCode() {
        return (String)this.codeProperty().get();
    }

    public final void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public int getGear() {
        return this.gear;
    }

    public void setGear(int gear) {
        this.gear = gear;
    }
}

