/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.FutureMktMakingSettings;
import cms.tmx.entity.web.settings.FuturePriceMaxDiff;
import cms.tmx.web.service.IUserSettingsService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureMktMakingSettingsModel {
    private List<FuturePriceMaxDiff> maxDifPriceSettingList = new ArrayList<FuturePriceMaxDiff>();
    @Inject
    protected MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType = "4";
    private String menuId = "200089";
    private static final Logger logger = LogManager.getLogger(FutureMktMakingSettingsModel.class);
    private MEventHandler reload = event -> this.doSet();

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.doSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void doSet() {
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof FutureMktMakingSettings) {
                FutureMktMakingSettings basket = (FutureMktMakingSettings)FutureMktMakingSettings.class.cast(settings);
                this.setMaxDifPriceSettingList(basket.getMaxDifPriceSettingList());
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public List<FuturePriceMaxDiff> getMaxDifPriceSettingList() {
        return this.maxDifPriceSettingList;
    }

    public void setMaxDifPriceSettingList(List<FuturePriceMaxDiff> maxDifPriceSettingList) {
        this.maxDifPriceSettingList = maxDifPriceSettingList;
    }
}

