/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IFutureMarketMakingApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.proto.strategy.PMarketMaking;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.notice.FutureStrategyReport;
import cms.tmx.entity.trade.FutureMarket;
import cms.tmx.entity.trade.FutureStrategy;
import cms.tmx.entity.trade.FutureStrategySerialize;
import cms.tmx.futures.models.FutureMarketListModel;
import cms.tmx.futures.views.FormulaUtils;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.cmschina.ficc.aggregation.ExpressionCalculator;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureMarketMakingModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(FutureMarketMakingModel.class);
    private MxList<FutureStrategy> mlist = new MxList();
    private MxList<FutureStrategy> mlistStrategyLib = new MxList();
    private MxList<FutureStrategy> mlistSubStrategy = new MxList();
    public static final String STRATEGY_LIB = "strategy.lib";
    public static final String STRATEGY_EXE = "strategy.exe";
    public static final String STRATEGY_SUB = "strategy.sub";
    public BooleanProperty statusChangedAndSelected = new SimpleBooleanProperty();
    public BooleanProperty statusChanged = new SimpleBooleanProperty();
    @Inject
    private IFutureMarketMakingApi api;
    @Inject
    private QueryModel queryModel;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private ExecutorService exe;
    private Future<?> future;
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private MEventService es;
    public static BooleanProperty isEditting = new SimpleBooleanProperty(false);
    public static StringProperty refreshTime = new SimpleStringProperty("");
    @Inject
    private FormulaUtils formula;
    private FutureStrategy copyStrategy;
    public Map<FutureStrategy, List<String>> strategySecurities = new HashMap<FutureStrategy, List<String>>();
    public Map<String, List<FutureStrategy>> securityStrategies = new HashMap<String, List<FutureStrategy>>();
    @Inject
    private MScheduler scheduler;
    @Inject
    protected MScheduler schedulerStatus;
    @Inject
    private ExpressionCalculator exp;
    @Inject
    private FutureMarketListModel marketListModel;
    @Inject
    public CtpAccountMap accMng;
    public BooleanProperty changedLib = new SimpleBooleanProperty();
    public BooleanProperty changedSub = new SimpleBooleanProperty();

    private void onPushStrategyLib(FutureStrategy strategy) {
        FutureStrategy old = (FutureStrategy)this.mlistStrategyLib.getListMap().get(strategy);
        if (old == null) {
            this.mlistStrategyLib.add((MxObject)strategy);
        } else {
            old.update((Object)strategy);
        }
        this.changedLib();
    }

    private void onPush(MEvent event) {
        if (!event.get((Object)"push_type").equals("154")) {
            return;
        }
        if (event.getObj() instanceof FutureStrategyReport) {
            FutureStrategyReport contextSettings = (FutureStrategyReport)event.getObj();
            PField.ExecModeType execModeType = contextSettings.getReport().getExecModeType();
            if (!execModeType.equals((Object)PField.ExecModeType.EXEC_MODE_TYPE_MARKETMAKING) && !execModeType.equals((Object)PField.ExecModeType.EXEC_MODE_TYPE_TBF_ARBITRAGE)) {
                return;
            }
            FutureStrategy strategy = new FutureStrategy();
            strategy.update((Object)contextSettings.getReport());
            logger.info("\u7b56\u7565\u63a8\u9001(id:" + strategy.getContextId() + (strategy.isInExe() ? " \u6267\u884c\u9762\u677f" : " \u7b56\u7565\u5e93") + " status:" + strategy.getStatus().getValue() + " errorMsg:" + strategy.getErrorMsg());
            strategy.setInvestorId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
            strategy.setInvestorSecId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
            FutureStrategy old = (FutureStrategy)this.mlist.getListMap().get(strategy);
            if (!strategy.isInExe()) {
                this.onPushStrategyLib(strategy);
                if (old != null) {
                    this.mlist.remove((MxObject)old);
                    this.changed();
                }
                return;
            }
            boolean inExeChanged = false;
            if (old == null) {
                if (strategy.isInExe()) {
                    double price = this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                    strategy.setBasePrice(price);
                }
                this.mlist.add((MxObject)strategy);
                this.resetStrategySecurities();
                this.changed();
            } else {
                boolean statusChanged;
                inExeChanged = old.isInExe() ^ strategy.isInExe();
                boolean bl = statusChanged = !old.getStatus().getRaw().equals(strategy.getStatus().getRaw());
                if (strategy.isInExe() && !strategy.getRefPriceCustom().equals(old.getRefPriceCustom()) || strategy.isInExe() && !old.isInExe()) {
                    double price = this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                    strategy.setBasePrice(price);
                    inExeChanged = !old.isInExe();
                    old.update((Object)strategy);
                    this.resetStrategySecurities();
                } else {
                    double basePrice = old.getBasePrice();
                    old.update((Object)strategy);
                    old.setBasePrice(basePrice);
                }
                if (inExeChanged) {
                    this.changed();
                }
                if (statusChanged) {
                    this.schedulerStatus.schedule(e -> this.statusChanged());
                    if (strategy.getStatus().getValue().equals("\u505c\u6b62")) {
                        this.es.postEvent("strategy_stopped_auto", null);
                    }
                }
                if (statusChanged && old.isSelected()) {
                    this.statusChangedAndSelected();
                }
            }
        }
    }

    public void changed() {
        this.scheduler.schedule(e -> super.changed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetStrategySecurities() {
        this.strategySecurities.clear();
        this.securityStrategies.clear();
        ObservableList observableList = this.mlist.getList();
        synchronized (observableList) {
            for (FutureStrategy strategy : this.mlist.getList()) {
                String formula;
                if (!strategy.isInExe() || !this.exp.validateExpression(formula = strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE")).getResult()) continue;
                List<String> codes = this.exp.getContracts(formula);
                this.strategySecurities.put(strategy, codes);
                for (String code : codes) {
                    if (this.securityStrategies.get(code) == null) {
                        this.securityStrategies.put(code, new ArrayList());
                    }
                    this.securityStrategies.get(code).add(strategy);
                }
            }
            logger.debug("strategySecurities\u5217\u8868\uff1a" + this.strategySecurities);
            logger.debug("securityStrategies \u5217\u8868" + this.securityStrategies);
        }
    }

    @PostConstruct
    public void init() {
        this.scheduler.setInterval(800);
        this.schedulerStatus.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        try {
            this.query(STRATEGY_EXE);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        catch (MException e) {
            e.printStackTrace();
        }
        this.resetStrategySecurities();
        for (FutureMarket market : this.marketListModel.getList()) {
            market.getMarketItem().changedProperty().addListener((ob, old, now) -> this.exe.execute(() -> {
                if (!market.getMarketItem().isClear()) {
                    String code = market.getMarketItem().getRefItem().getCode();
                    logger.debug(String.valueOf(code) + "\u884c\u60c5\u53d8\u52a8");
                    if (this.securityStrategies.get(code) == null) {
                        return;
                    }
                    logger.debug("\u884c\u60c5\u53d8\u52a8 \u6d89\u53ca\u7b56\u7565\uff1a" + this.securityStrategies.get(code));
                    for (FutureStrategy strategy : this.securityStrategies.get(code)) {
                        double price = this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                        logger.debug(String.valueOf(strategy.getContextId()) + "\uff1a \u4fee\u6539\u524d\uff1a" + strategy.getBasePrice() + " ,\u4fee\u6539\u540e\uff1a" + price + "\u516c\u5f0f\uff1a" + strategy.getRefPriceCustom());
                        strategy.setBasePrice(price);
                    }
                }
            }));
        }
        logger.debug("\u6267\u884cFutureMarketMakingModel\u7684init");
        try {
            this.future = this.ses.scheduleAtFixedRate(() -> {
                logger.debug("\u51c6\u5907\u5237\u65b0\u671f\u8d27\u81ea\u52a8\u505a\u5e02\u7b56\u7565");
                long start = System.currentTimeMillis();
                if (!isEditting.get()) {
                    try {
                        this.query(STRATEGY_EXE, null);
                        Platform.runLater(() -> refreshTime.set((Object)("\u5237\u65b0\u65f6\u95f4\uff1a" + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()))));
                    }
                    catch (MException | Exception e) {
                        e.printStackTrace();
                        logger.error("FutureMarketMakingModel\u5237\u65b0\u5931\u8d25\uff1a" + Thread.currentThread(), e);
                    }
                } else {
                    logger.debug("\u6b63\u5728\u7f16\u8f91, \u8df3\u8fc7\u5237\u65b0");
                }
                logger.debug("\u56fd\u503a\u671f\u8d27\u67e5\u8be2\u4e00\u6b21\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            }, 0L, 120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("FutureMarketMakingModel\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff1a" + Thread.currentThread(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        System.err.println(list);
        list.add(4, "a");
        System.err.println(list);
        System.err.println((String)list.get(list.size() - 1));
    }

    @PreDestroy
    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws Exception, MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        if (secAcct == null) {
            throw new Exception("\u6839\u636e\u8d44\u91d1\u8d26\u53f7\u548c\u6295\u4fdd\u6807\u8bc6\u672a\u80fd\u627e\u5230\u8bc1\u5238\u8d26\u53f7");
        }
        return secAcct;
    }

    private synchronized void query(String type, String parentContextId) throws MException, InvalidProtocolBufferException {
        long start = System.currentTimeMillis();
        PStrategy.GetCtxSettingsReq.Builder builder = PStrategy.GetCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setExecModeTypeValue(6);
        builder.setMarketGroup("FUTURES");
        if (type.equals(STRATEGY_SUB)) {
            builder.setParentContextId(parentContextId);
            builder.setCtxSettingStatus(PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE);
        } else {
            builder.setCtxSettingStatus(STRATEGY_LIB.equals(type) ? PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE : PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_RUNNING);
        }
        logger.debug("\u6784\u5efabuilder\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List list = this.api.getStrategy(builder);
        logger.debug("api.getStrategy\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.updateData(list, type);
        logger.debug("\u7b56\u7565\u6570\u636e\u66f4\u65b0\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
    }

    public synchronized void query(String type) throws InvalidProtocolBufferException, MException {
        this.query(type, null);
    }

    public synchronized void querySubStrategy(String parentContextId) throws InvalidProtocolBufferException, MException {
        this.query(STRATEGY_SUB, parentContextId);
    }

    private void updateData(List<PStrategy.ContextSettings> listInfo, String type) throws InvalidProtocolBufferException {
        ArrayList<FutureStrategy> listTmp = new ArrayList<FutureStrategy>();
        for (PStrategy.ContextSettings info : listInfo) {
            FutureStrategy strategy = new FutureStrategy();
            strategy.update((Object)info);
            strategy.setInvestorId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
            strategy.setInvestorSecId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
            if (strategy.isInExe() && !type.equals(STRATEGY_SUB)) {
                double price = this.formula.getPriceByFormula(strategy.getRefPriceCustom().replaceAll("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE"));
                strategy.setBasePrice(price);
            }
            listTmp.add(strategy);
        }
        switch (type) {
            case "strategy.exe": {
                this.mlist.update(listTmp);
                this.changed();
                break;
            }
            case "strategy.lib": {
                this.mlistStrategyLib.update(listTmp);
                this.changedLib();
                break;
            }
            case "strategy.sub": {
                this.mlistSubStrategy.update(listTmp);
                this.changedSub();
            }
        }
    }

    public PStrategy.ContextSettings getSettingsByStrategy(FutureStrategy strategy) {
        String custom;
        PMarketMaking.AccountSettings.Builder builderAcct = PMarketMaking.AccountSettings.newBuilder();
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        if (this.accMng.getCtpAccountMap().get(strategy.getExtFundAccntId()) != null) {
            builderAcct.setParentExtAccntId(((CtpFundAccount)this.accMng.getCtpAccountMap().get(strategy.getExtFundAccntId())).getParentId());
        }
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityId(strategy.getSecurity());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        PMarketMaking.SecuritySettings.Builder builderSec = PMarketMaking.SecuritySettings.newBuilder();
        builderSec.setInstrument(builderInst);
        builderSec.setRefPriceCustom(strategy.getRefPriceCustom());
        builderSec.setPriceSlip(strategy.getPriceSlip());
        builderSec.setBidSpread(strategy.getBidSpread());
        builderSec.setAskSpread(strategy.getAskSpread());
        builderSec.setBidQty(strategy.getBidQty());
        builderSec.setAskQty(strategy.getAskQty());
        builderSec.setMaxAllowFilledQty(strategy.getDealLimit());
        builderSec.setHedgeContract(strategy.getHedgeContract());
        builderSec.setLongHedgePriceCustom(strategy.getHedgePriceCustomSell());
        builderSec.setShortHedgePriceCustom(strategy.getHedgePriceCustomBuy());
        if (strategy.getHedgePriceCustomSell().contains("LFP")) {
            custom = strategy.getHedgePriceCustomSell().replace("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE");
            builderSec.setLongHedgePriceCustom(custom);
        }
        if (strategy.getHedgePriceCustomBuy().contains("LFP")) {
            custom = strategy.getHedgePriceCustomBuy().replace("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE");
            builderSec.setShortHedgePriceCustom(custom);
        }
        builderSec.setHedgeContractQtyScale(strategy.getHedgeCount());
        builderSec.setMmContractQtyScale(strategy.getMarketMakingCount());
        builderSec.setShFlag(PField.SHFlag.forNumber((int)Integer.valueOf(strategy.getShFlag())));
        builderSec.setPositionEffect(PField.PositionEffect.forNumber((int)Integer.valueOf(strategy.getOcFlag())));
        builderSec.setTimeoutFill(strategy.getTimeoutFill());
        builderSec.setStoplossFill(strategy.getStoplossFill());
        builderSec.setTotalQty(strategy.getTotalQty());
        PMarketMaking.MarketMakingContextSettings.Builder builderCtx = PMarketMaking.MarketMakingContextSettings.newBuilder();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        PStrategy.ContextSettings.Builder builderCt = PStrategy.ContextSettings.newBuilder();
        builderCt.setName(ByteString.copyFrom((byte[])strategy.getName().getBytes()));
        if (strategy.getContextId() != null) {
            builderCt.setContextId(strategy.getContextId());
        }
        builderCt.setUserId(this.iba.getUserId());
        builderCt.setPartyId(this.iba.getPartyId());
        builderCt.setPostId(this.iba.getPostId());
        builderCt.setCtxState(PStrategy.CtxState.CTX_STATE_STOPPED);
        builderCt.setCreateTime(strategy.getCreateTime());
        builderCt.setErrorMsg(strategy.getErrorMsg());
        builderCt.setDetails(Any.pack((Message)builderCtx.build()));
        if (strategy.getTacticsType().getRaw().equals("9")) {
            if (strategy.isBuy()) {
                builderCt.setStrategyTypeValue(9);
            } else {
                builderCt.setStrategyTypeValue(10);
            }
        } else {
            builderCt.setStrategyTypeValue(Integer.valueOf(strategy.getTacticsType().getRaw()).intValue());
        }
        builderCt.setCtxSettingStatus(strategy.isInExe() ? PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_RUNNING : PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE);
        builderCt.setExecModeTypeValue(this.getExecModeType(strategy.getTacticsType().getRaw()));
        return builderCt.build();
    }

    public void addStrategy(FutureStrategy strategy) throws MException {
        PStrategy.ContextSettings settings = this.getSettingsByStrategy(strategy);
        PStrategy.NewCtxSettingsReq.Builder builder = PStrategy.NewCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(settings);
        builder.setExecModeTypeValue(this.getExecModeType(strategy.getTacticsType().getRaw()));
        this.api.addStrategy(builder.build());
    }

    public void addStrategy(FutureStrategySerialize strategy) throws MException {
        String custom;
        PMarketMaking.AccountSettings.Builder builderAcct = PMarketMaking.AccountSettings.newBuilder();
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        builderAcct.setParentExtAccntId(((CtpFundAccount)this.accMng.getCtpAccountMap().get(strategy.getExtFundAccntId())).getParentId());
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityId(strategy.getSecurity());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        PMarketMaking.SecuritySettings.Builder builderSec = PMarketMaking.SecuritySettings.newBuilder();
        builderSec.setInstrument(builderInst);
        builderSec.setRefPriceCustom(strategy.getRefPriceCustom());
        builderSec.setPriceSlip(strategy.getPriceSlip());
        builderSec.setBidSpread(strategy.getBidSpread());
        builderSec.setAskSpread(strategy.getAskSpread());
        builderSec.setBidQty(strategy.getBidQty());
        builderSec.setAskQty(strategy.getAskQty());
        builderSec.setMaxAllowFilledQty(strategy.getDealLimit());
        builderSec.setHedgeContract(strategy.getHedgeContract());
        builderSec.setLongHedgePriceCustom(strategy.getHedgePriceCustomSell());
        builderSec.setShortHedgePriceCustom(strategy.getHedgePriceCustomBuy());
        if (strategy.getHedgePriceCustomSell().contains("LFP")) {
            custom = strategy.getHedgePriceCustomSell().replace("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE");
            builderSec.setLongHedgePriceCustom(custom);
        }
        if (strategy.getHedgePriceCustomBuy().contains("LFP")) {
            custom = strategy.getHedgePriceCustomBuy().replace("LFP", "[" + strategy.getSecurity() + "].LAST_FILL_PRICE");
            builderSec.setShortHedgePriceCustom(custom);
        }
        builderSec.setHedgeContractQtyScale(strategy.getHedgeCount());
        builderSec.setMmContractQtyScale(strategy.getMarketMakingCount());
        builderSec.setShFlag(PField.SHFlag.forNumber((int)Integer.valueOf(strategy.getShFlag())));
        builderSec.setPositionEffect(PField.PositionEffect.forNumber((int)Integer.valueOf(strategy.getOcFlag())));
        builderSec.setTimeoutFill(strategy.getTimeoutFill());
        builderSec.setStoplossFill(strategy.getStoplossFill());
        builderSec.setTotalQty(strategy.getTotalQty());
        PMarketMaking.MarketMakingContextSettings.Builder builderCtx = PMarketMaking.MarketMakingContextSettings.newBuilder();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        PStrategy.ContextSettings.Builder builderCt = PStrategy.ContextSettings.newBuilder();
        builderCt.setName(ByteString.copyFrom((byte[])strategy.getName().getBytes()));
        builderCt.setUserId(this.iba.getUserId());
        builderCt.setPartyId(this.iba.getPartyId());
        builderCt.setPostId(this.iba.getPostId());
        builderCt.setCreateTime(strategy.getCreateTime());
        builderCt.setErrorMsg(strategy.getErrorMsg());
        builderCt.setDetails(Any.pack((Message)builderCtx.build()));
        if (strategy.getTacticsType().equals("9")) {
            if (strategy.isBuy()) {
                builderCt.setStrategyTypeValue(9);
            } else {
                builderCt.setStrategyTypeValue(10);
            }
        } else {
            builderCt.setStrategyTypeValue(Integer.valueOf(strategy.getTacticsType()).intValue());
        }
        builderCt.setCtxSettingStatus(strategy.isInExe() ? PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_RUNNING : PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE);
        builderCt.setExecModeTypeValue(this.getExecModeType(strategy.getTacticsType()));
        PStrategy.NewCtxSettingsReq.Builder builder = PStrategy.NewCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(builderCt);
        builder.setExecModeTypeValue(this.getExecModeType(strategy.getTacticsType()));
        this.api.addStrategy(builder.build());
    }

    private int getExecModeType(String type) {
        int execModeType = 0;
        execModeType = StringUtils.belongto((String)type, (String[])new String[]{"7", "8", "9"}) ? 9 : 6;
        return execModeType;
    }

    public void updateStrategy(FutureStrategy strategy) throws MException {
        PStrategy.ContextSettings settings = this.getSettingsByStrategy(strategy);
        PStrategy.UpdateCtxSettingsReq.Builder builder = PStrategy.UpdateCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(settings);
        builder.setExecModeTypeValue(this.getExecModeType(strategy.getTacticsType().getRaw()));
        this.api.updateStrategy(builder.build());
    }

    public void delStrategy(String contextId) throws MException {
        PStrategy.DeleteCtxSettingsReq.Builder builder = PStrategy.DeleteCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setContextId(contextId);
        builder.setExecModeTypeValue(6);
        this.api.delStrategy(builder.build());
    }

    public Map<String, String> startStrategy(List<String> listId) throws MException {
        PStrategy.StartContextReq.Builder builder = PStrategy.StartContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        return this.api.startStrategy(builder.build());
    }

    public Map<String, String> stopStrategy(List<String> listId) throws MException {
        PStrategy.StopContextReq.Builder builder = PStrategy.StopContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(6);
        return this.api.stopStrategy(builder.build());
    }

    public ObservableList<FutureStrategy> getMlistStrategyLib() {
        return this.mlistStrategyLib.getList();
    }

    public ObservableList<FutureStrategy> getList() {
        return this.mlist.getList();
    }

    public FutureStrategy getFutureStrategy(String contextId) {
        for (FutureStrategy strategy : this.mlist.getList()) {
            if (!strategy.getContextId().equals(contextId)) continue;
            return strategy;
        }
        return null;
    }

    public final BooleanProperty statusChangedAndSelectedProperty() {
        return this.statusChangedAndSelected;
    }

    public void statusChangedAndSelected() {
        this.statusChangedAndSelected.set(!this.statusChangedAndSelected.get());
    }

    public final BooleanProperty statusChangedProperty() {
        return this.statusChanged;
    }

    public void statusChanged() {
        this.statusChanged.set(!this.statusChanged.get());
    }

    public FutureStrategy getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(FutureStrategy copyStrategy) {
        this.copyStrategy = copyStrategy;
    }

    public MxList<FutureStrategy> getMlistSubStrategy() {
        return this.mlistSubStrategy;
    }

    public void setMlistSubStrategy(MxList<FutureStrategy> mlistSubStrategy) {
        this.mlistSubStrategy = mlistSubStrategy;
    }

    public BooleanProperty changedLibProperty() {
        return this.changedLib;
    }

    public void changedLib() {
        this.changedLib.set(!this.changedLib.get());
    }

    public BooleanProperty changedSubProperty() {
        return this.changedSub;
    }

    public void changedSub() {
        this.changedSub.set(!this.changedSub.get());
    }
}

