/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.core.MException;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.ConversionParam;
import cms.tmx.entity.trade.FutureMarket;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.pricingit.SecurityServiceApi;
import cms.tmx.http.futures.api.FutureYtmApi;
import cms.tmx.http.futures.dto.DoFutureYtmCalcSettingReq;
import cms.tmx.http.futures.dto.FutureYtmCalcSetting;
import cms.tmx.http.futures.dto.GetFutureYtmCalcSettingReq;
import cms.tmx.http.futures.dto.GetFutureYtmCalcSettingResp;
import cms.tmx.http.security.dto.GetFuturesReq;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureMarketListModel
extends MxModel {
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private MarketDataModel newMktMng;
    @Inject
    private SecurityServiceApi secApi;
    @Inject
    private FutureYtmApi ytmApi;
    private List<RefItem> nationalRefList = null;
    private ObservableList<FutureMarket> list = FxUtils.newList();
    private InvalidationListener listenerRefMng = ob -> {
        this.resetList();
        this.changed();
    };

    @PostConstruct
    public void init() {
        this.refMng.changedProperty().addListener(this.listenerRefMng);
        this.resetList();
    }

    @PreDestroy
    private void close() {
        this.refMng.changedProperty().removeListener(this.listenerRefMng);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetList() {
        if (this.nationalRefList == null || this.nationalRefList.size() == 0) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        ObservableList<FutureMarket> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.newMktMng.subMarketItems(this.nationalRefList, (Object)"FutureYtm");
            for (RefItem item : this.nationalRefList) {
                FutureMarket future = new FutureMarket();
                if (item instanceof CtpRefItem) {
                    CtpRefItem ctp = (CtpRefItem)item;
                    future.setRefItem(ctp);
                }
                MarketItem market = this.mktMng.getItem(item);
                MarketItem mktNew = this.newMktMng.getItem(item);
                future.setMarketItem(market);
                future.setMktItemNew(mktNew);
                this.list.add((Object)future);
            }
            this.list.sort((o1, o2) -> o1.getRefItem().getCode().compareTo(o2.getRefItem().getCode()));
        }
    }

    public List<ConversionParam> getYtmPrarms() throws MException, IOException {
        HashMap map = new HashMap();
        GetFutureYtmCalcSettingReq req = new GetFutureYtmCalcSettingReq();
        GetFutureYtmCalcSettingResp resp = this.ytmApi.getFutureYmts(req);
        List listYtm = resp.getFutureYtmSetting();
        if (listYtm != null) {
            listYtm.forEach(ytm -> {
                ConversionParam param = new ConversionParam();
                param.update(ytm);
                map.put(ytm.getInstrument().getSecurityId(), param);
            });
        }
        GetFuturesReq newReq = new GetFuturesReq();
        LinkedList listInst = new LinkedList();
        this.list.forEach(futMkt -> {
            Instrument inst = new Instrument();
            inst.setSecurityId(futMkt.getRefItem().getCode());
            inst.setMarket(futMkt.getRefItem().getMarket());
            inst.setSecurityType(futMkt.getRefItem().getType());
            listInst.add(inst);
        });
        newReq.setInstrument(listInst);
        List listInfo = this.secApi.getFutures(newReq);
        LinkedList<ConversionParam> listParam = new LinkedList<ConversionParam>();
        listInfo.forEach(info -> {
            ConversionParam param = (ConversionParam)map.get(info.getSecurity().getInstrument().getSecurityId());
            if (param == null) {
                param = new ConversionParam();
            }
            param.update(info);
            listParam.add(param);
        });
        return listParam;
    }

    public void setFutureYmts(List<ConversionParam> listParam) throws IOException, MException {
        DoFutureYtmCalcSettingReq request = new DoFutureYtmCalcSettingReq();
        LinkedList listYtm = new LinkedList();
        listParam.forEach(param -> {
            FutureYtmCalcSetting ytm = new FutureYtmCalcSetting();
            ytm.setInstrument(param.getConSec());
            ytm.setCtd(param.getCtdSec());
            ytm.setCapitalCost(param.getCostCapital());
            listYtm.add(ytm);
        });
        request.setFutureYtmSetting(listYtm);
        this.ytmApi.setFutureYmts(request);
    }

    public ObservableList<FutureMarket> getList() {
        return this.list;
    }
}

