/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.FutureCrossOrder;
import cms.tmx.entity.trade.FutureEntrust;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FutureManualModel
extends MxModel {
    private StringProperty fundAcct = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty basePrice = new SimpleDoubleProperty();
    private DoubleProperty diffMax = new SimpleDoubleProperty();
    private DoubleProperty diffBuy = new SimpleDoubleProperty();
    private DoubleProperty diffSell = new SimpleDoubleProperty();
    private DoubleProperty priceBuy = new SimpleDoubleProperty();
    private DoubleProperty priceSell = new SimpleDoubleProperty();
    private LongProperty countBuy = new SimpleLongProperty();
    private LongProperty countSell = new SimpleLongProperty();
    private BooleanProperty bs = new SimpleBooleanProperty(true);
    private BooleanProperty buy = new SimpleBooleanProperty(false);
    private ObjectProperty<MxNode> hedgeType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> ocFlag = new SimpleObjectProperty();
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private INewOrderSingleApi manualApi;
    @Inject
    public CtpAccountMap accMng;
    @Inject
    private IRefDataMng refMng;

    public final MarketItem getMI() {
        return this.mktItem;
    }

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(5);
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("position_effect", "79");
        this.ocFlag.setValue((Object)node);
        node = ((MxNode)this.of.create(MxNode.class)).load("sh_flag", "1");
        this.hedgeType.setValue((Object)node);
    }

    public void onSecChange() {
        this.mktMng.dye(this.mktItem);
    }

    public void submit() throws MException, Exception {
        PComponent.Instrument.Builder instrumentBuilder = PComponent.Instrument.newBuilder();
        instrumentBuilder.setSecurityId(this.mktItem.getRefItem().getCode());
        instrumentBuilder.setMarket(this.mktItem.getRefItem().getMarket());
        instrumentBuilder.setMarketGroup(MarketUtils.getMarketGroup((String)this.mktItem.getRefItem().getMarket()));
        instrumentBuilder.setSecurityType(this.mktItem.getRefItem().getType());
        instrumentBuilder.setApplId("010");
        PComponent.ExecMode.Builder moBuilder = PComponent.ExecMode.newBuilder();
        moBuilder.setEmName("\u624b\u5de5");
        moBuilder.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_MANUAL);
        PMessage.NewOrderCross.Builder builder = PMessage.NewOrderCross.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setInstrument(instrumentBuilder);
        builder.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        builder.setCrossType(1);
        builder.setExtAccntId(this.accMng.getFundAcc(this.getFundAcct()).getExtAccntId());
        builder.setExtSecAccntId(this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), this.getMI().getRefItem().getMarket()).getExtSecAccntId());
        builder.setExecMode(moBuilder);
        builder.setPositionEffectValue(Integer.valueOf(this.getOcFlag().getRaw()).intValue());
        builder.setPurpose(Integer.valueOf(this.getHedgeType().getRaw()).intValue());
        PComponent.SideCrossOrdMod.Builder sb1 = PComponent.SideCrossOrdMod.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setPrice(this.getPriceBuy());
        sb1.setOrderQty((double)this.getCountBuy());
        PComponent.SideCrossOrdMod s1 = sb1.build();
        builder.addModSide(s1);
        PComponent.SideCrossOrdMod.Builder sb2 = PComponent.SideCrossOrdMod.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setPrice(this.getPriceSell());
        sb2.setOrderQty((double)this.getCountSell());
        PComponent.SideCrossOrdMod s2 = sb2.build();
        builder.addModSide(s2);
        this.manualApi.newFutureOrder(builder.build());
    }

    public void submit(FutureEntrust future) throws MException, Exception {
        PComponent.Instrument.Builder instrumentBuilder = PComponent.Instrument.newBuilder();
        instrumentBuilder.setSecurityId(future.getSecurityId());
        instrumentBuilder.setMarket("CCFX");
        instrumentBuilder.setMarketGroup(MarketUtils.getMarketGroup((String)"CCFX"));
        instrumentBuilder.setSecurityType("FUT");
        instrumentBuilder.setApplId("010");
        PComponent.ExecMode.Builder moBuilder = PComponent.ExecMode.newBuilder();
        moBuilder.setEmName("\u624b\u5de5");
        moBuilder.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_MANUAL);
        PMessage.NewOrderCross.Builder builder = PMessage.NewOrderCross.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setInstrument(instrumentBuilder);
        builder.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        builder.setCrossType(1);
        builder.setExtAccntId(this.accMng.getFundAcc(this.getFundAcct()).getExtAccntId());
        builder.setExtSecAccntId(this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), "CCFX").getExtSecAccntId());
        builder.setExecMode(moBuilder);
        builder.setPositionEffectValue(Integer.valueOf(this.getOcFlag().getRaw()).intValue());
        builder.setPurpose(Integer.valueOf(this.getHedgeType().getRaw()).intValue());
        PComponent.SideCrossOrdMod.Builder sb1 = PComponent.SideCrossOrdMod.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setPrice(future.getPriceBuy());
        sb1.setOrderQty((double)future.getCountBuy());
        PComponent.SideCrossOrdMod s1 = sb1.build();
        builder.addModSide(s1);
        PComponent.SideCrossOrdMod.Builder sb2 = PComponent.SideCrossOrdMod.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setPrice(future.getPriceSell());
        sb2.setOrderQty((double)future.getCountSell());
        PComponent.SideCrossOrdMod s2 = sb2.build();
        builder.addModSide(s2);
        this.manualApi.newFutureOrder(builder.build());
    }

    public void cancelReplace(FutureCrossOrder order) throws MException, Exception {
        POrderService.CrossOrder.Builder crossOrder = POrderService.CrossOrder.newBuilder();
        crossOrder.setCrossId(order.getId());
        crossOrder.setCrossType(order.getCrossType().intValue());
        PComponent.Instrument.Builder instrumentBuilder = PComponent.Instrument.newBuilder();
        instrumentBuilder.setSecurityId(this.mktItem.getRefItem().getCode());
        instrumentBuilder.setMarket(this.mktItem.getRefItem().getMarket());
        instrumentBuilder.setMarketGroup(MarketUtils.getMarketGroup((String)this.mktItem.getRefItem().getMarket()));
        instrumentBuilder.setSecurityType(this.mktItem.getRefItem().getType());
        instrumentBuilder.setApplId("010");
        PComponent.ExecMode.Builder moBuilder = PComponent.ExecMode.newBuilder();
        moBuilder.setEmName("\u624b\u5de5");
        moBuilder.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_MANUAL);
        PComponent.SideCrossOrdMod.Builder sb1 = PComponent.SideCrossOrdMod.newBuilder();
        sb1.setSide(PField.Side.SIDE_BUY);
        sb1.setPrice(this.getPriceBuy());
        sb1.setOrderQty((double)this.getCountBuy());
        PComponent.SideCrossOrdMod s1 = sb1.build();
        PComponent.SideCrossOrdMod.Builder sb2 = PComponent.SideCrossOrdMod.newBuilder();
        sb2.setSide(PField.Side.SIDE_SELL);
        sb2.setPrice(this.getPriceSell());
        sb2.setOrderQty((double)this.getCountSell());
        PComponent.SideCrossOrdMod s2 = sb2.build();
        LinkedList<PComponent.SideCrossOrdMod> modSitList = new LinkedList<PComponent.SideCrossOrdMod>();
        modSitList.add(s1);
        modSitList.add(s2);
        PMessage.CrossOrderCancelReplaceRequest.Builder ccsBuilder = PMessage.CrossOrderCancelReplaceRequest.newBuilder();
        ccsBuilder.setOpUser(this.iba.getOpUser());
        ccsBuilder.setCrossId(crossOrder.getCrossId());
        ccsBuilder.setHostCrossId(crossOrder.getCrossId());
        ccsBuilder.setCrossType(crossOrder.getCrossType());
        ccsBuilder.addAllModSide(modSitList);
        ccsBuilder.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        ccsBuilder.setInstrument(instrumentBuilder);
        ccsBuilder.setExtAccntId(this.accMng.getFundAcc(this.getFundAcct()).getExtAccntId());
        ccsBuilder.setExtSecAccntId(this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), this.getMI().getRefItem().getMarket()).getExtSecAccntId());
        ccsBuilder.setExecMode(moBuilder);
        ccsBuilder.setPositionEffectValue(Integer.valueOf(this.getOcFlag().getRaw()).intValue());
        ccsBuilder.setPurpose(Integer.valueOf(this.getHedgeType().getRaw()).intValue());
        this.manualApi.CancelReplaceFutureOrder(ccsBuilder.build());
    }

    public void submitSingle() throws MException, Exception {
        PComponent.Instrument.Builder instrumentBuilder = PComponent.Instrument.newBuilder();
        instrumentBuilder.setSecurityId(this.mktItem.getRefItem().getCode());
        instrumentBuilder.setMarket(this.mktItem.getRefItem().getMarket());
        instrumentBuilder.setMarketGroup(MarketUtils.getMarketGroup((String)this.mktItem.getRefItem().getMarket()));
        instrumentBuilder.setSecurityType(this.mktItem.getRefItem().getType());
        PMessage.NewOrderSingle.Builder builder = PMessage.NewOrderSingle.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setInstrument(instrumentBuilder);
        builder.setOrdType(PField.OrdType.ORD_TYPE_LIMIT);
        builder.setCrossType(1);
        builder.setExtAccntId(this.accMng.getFundAcc(this.getFundAcct()).getExtAccntId());
        builder.setExtSecAccntId(this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), this.getMI().getRefItem().getMarket()).getExtSecAccntId());
        builder.setPositionEffectValue(Integer.valueOf(this.getOcFlag().getRaw()).intValue());
        builder.setPurpose(Integer.valueOf(this.getHedgeType().getRaw()).intValue());
        builder.setSide(this.isBuy() ? PField.Side.SIDE_BUY : PField.Side.SIDE_SELL);
        builder.setPrice(this.isBuy() ? this.getPriceBuy() : this.getPriceSell());
        builder.setOrderQty((double)(this.isBuy() ? this.getCountBuy() : this.getCountSell()));
        this.manualApi.newFutureOrder(builder.build());
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws Exception, MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        if (secAcct == null) {
            throw new Exception("\u6839\u636e\u8d44\u91d1\u8d26\u53f7\u548c\u6295\u4fdd\u6807\u8bc6\u672a\u80fd\u627e\u5230\u8bc1\u5238\u8d26\u53f7");
        }
        return secAcct;
    }

    public List<FutureSingleEntrust> getEntrustList() throws MException, Exception {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        CtpFundAccount fund = this.accMng.getFundAcc(this.getFundAcct());
        CtpSecAccount secAcct = (CtpSecAccount)this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), this.getMI().getRefItem().getMarket());
        if (this.isBs() || this.isBuy()) {
            this.getHedgeType().getRaw();
            this.getOcFlag().getRaw();
            FutureSingleEntrust enBuy = (FutureSingleEntrust)this.of.create(FutureSingleEntrust.class);
            enBuy.setAcc(fund.getExtAccntId());
            enBuy.setSecAcc(secAcct.getExtSecAccntId());
            enBuy.setFundAccount((FundAccount)fund);
            enBuy.setSecAccount((SecAccount)secAcct);
            enBuy.setInvestorId(fund.getInvestId());
            enBuy.setInvestorSecId(secAcct.getInverstorSecId());
            enBuy.setSide(49);
            enBuy.setQuantity(this.getCountBuy());
            enBuy.setMarket(this.mktItem.getRefItem().getMarket());
            enBuy.setSecType(this.mktItem.getRefItem().getType());
            enBuy.setPrice(this.getPriceBuy());
            enBuy.setSec(this.mktItem.getRefItem().getCode());
            enBuy.setSecName(this.mktItem.getRefItem().getName());
            enBuy.setAppID("010");
            enList.add(enBuy);
        }
        if (this.isBs() || !this.isBs() && !this.isBuy()) {
            FutureSingleEntrust enSell = (FutureSingleEntrust)this.of.create(FutureSingleEntrust.class);
            enSell.setAcc(fund.getExtAccntId());
            enSell.setSecAcc(secAcct.getExtSecAccntId());
            enSell.setFundAccount((FundAccount)fund);
            enSell.setSecAccount((SecAccount)secAcct);
            enSell.setInvestorId(fund.getInvestId());
            enSell.setInvestorSecId(secAcct.getInverstorSecId());
            enSell.setSide(50);
            enSell.setQuantity(this.getCountSell());
            enSell.setMarket(this.mktItem.getRefItem().getMarket());
            enSell.setSecType(this.mktItem.getRefItem().getType());
            enSell.setPrice(this.getPriceSell());
            enSell.setSec(this.mktItem.getRefItem().getCode());
            enSell.setSecName(this.mktItem.getRefItem().getName());
            enSell.setAppID("010");
            enSell.setCanSell(100000000L);
            enList.add(enSell);
        }
        return enList;
    }

    public List<FutureSingleEntrust> getEntrustList(List<FutureEntrust> list) throws MException, Exception {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        CtpFundAccount fund = this.accMng.getFundAcc(this.getFundAcct());
        CtpSecAccount secAcct = (CtpSecAccount)this.getExtSecAcc(this.getFundAcct(), this.getHedgeType().getRaw(), "CCFX");
        for (FutureEntrust future : list) {
            RefItem ref = this.refMng.getItem("CCFX", future.getSecurityId());
            if (ref == null) {
                throw new Exception(String.valueOf(future.getSecurityId()) + "\u627e\u4e0d\u5230\u9759\u6001\u6570\u636e");
            }
            FutureSingleEntrust enBuy = (FutureSingleEntrust)this.of.create(FutureSingleEntrust.class);
            enBuy.setAcc(fund.getExtAccntId());
            enBuy.setSecAcc(secAcct.getExtSecAccntId());
            enBuy.setFundAccount((FundAccount)fund);
            enBuy.setSecAccount((SecAccount)secAcct);
            enBuy.setInvestorId(fund.getInvestId());
            enBuy.setInvestorSecId(secAcct.getInverstorSecId());
            enBuy.setSide(49);
            enBuy.setQuantity(future.getCountBuy());
            enBuy.setMarket(ref.getMarket());
            enBuy.setSecType(ref.getType());
            enBuy.setPrice(future.getPriceBuy());
            enBuy.setSec(ref.getCode());
            enBuy.setSecName(ref.getName());
            enBuy.setAppID("010");
            enList.add(enBuy);
            FutureSingleEntrust enSell = (FutureSingleEntrust)this.of.create(FutureSingleEntrust.class);
            enSell.setAcc(fund.getExtAccntId());
            enSell.setSecAcc(secAcct.getExtSecAccntId());
            enSell.setFundAccount((FundAccount)fund);
            enSell.setSecAccount((SecAccount)secAcct);
            enSell.setInvestorId(fund.getInvestId());
            enSell.setInvestorSecId(secAcct.getInverstorSecId());
            enSell.setSide(50);
            enSell.setQuantity(future.getCountSell());
            enSell.setMarket(ref.getMarket());
            enSell.setSecType(ref.getType());
            enSell.setPrice(future.getPriceSell());
            enSell.setSec(ref.getCode());
            enSell.setSecName(ref.getName());
            enSell.setAppID("010");
            enSell.setCanSell(100000000L);
            enList.add(enSell);
        }
        return enList;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final DoubleProperty diffBuyProperty() {
        return this.diffBuy;
    }

    public final double getDiffBuy() {
        return this.diffBuyProperty().get();
    }

    public final void setDiffBuy(double diffBuy) {
        this.diffBuyProperty().set(diffBuy);
    }

    public final DoubleProperty diffSellProperty() {
        return this.diffSell;
    }

    public final double getDiffSell() {
        return this.diffSellProperty().get();
    }

    public final void setDiffSell(double diffSell) {
        this.diffSellProperty().set(diffSell);
    }

    public final DoubleProperty priceBuyProperty() {
        return this.priceBuy;
    }

    public final double getPriceBuy() {
        return this.priceBuyProperty().get();
    }

    public final void setPriceBuy(double priceBuy) {
        this.priceBuyProperty().set(priceBuy);
    }

    public final DoubleProperty priceSellProperty() {
        return this.priceSell;
    }

    public final double getPriceSell() {
        return this.priceSellProperty().get();
    }

    public final void setPriceSell(double priceSell) {
        this.priceSellProperty().set(priceSell);
    }

    public final LongProperty countBuyProperty() {
        return this.countBuy;
    }

    public final long getCountBuy() {
        return this.countBuyProperty().get();
    }

    public final void setCountBuy(long countBuy) {
        this.countBuyProperty().set(countBuy);
    }

    public final LongProperty countSellProperty() {
        return this.countSell;
    }

    public final long getCountSell() {
        return this.countSellProperty().get();
    }

    public final void setCountSell(long countSell) {
        this.countSellProperty().set(countSell);
    }

    public final DoubleProperty basePriceProperty() {
        return this.basePrice;
    }

    public final double getBasePrice() {
        return this.basePriceProperty().get();
    }

    public final void setBasePrice(double basePrice) {
        this.basePriceProperty().set(basePrice);
    }

    public final BooleanProperty bsProperty() {
        return this.bs;
    }

    public final boolean isBs() {
        return this.bsProperty().get();
    }

    public final void setBs(boolean bs) {
        this.bsProperty().set(bs);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final ObjectProperty<MxNode> ocFlagProperty() {
        return this.ocFlag;
    }

    public final MxNode getOcFlag() {
        return (MxNode)this.ocFlagProperty().get();
    }

    public final void setOcFlag(MxNode ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }

    public final ObjectProperty<MxNode> hedgeTypeProperty() {
        return this.hedgeType;
    }

    public final MxNode getHedgeType() {
        return (MxNode)this.hedgeTypeProperty().get();
    }

    public final void setHedgeType(MxNode hedgeType) {
        this.hedgeTypeProperty().set((Object)hedgeType);
    }

    public final DoubleProperty diffMaxProperty() {
        return this.diffMax;
    }

    public final double getDiffMax() {
        return this.diffMaxProperty().get();
    }

    public final void setDiffMax(double diffMax) {
        this.diffMaxProperty().set(diffMax);
    }

    public final StringProperty fundAcctProperty() {
        return this.fundAcct;
    }

    public final String getFundAcct() {
        return (String)this.fundAcctProperty().get();
    }

    public final void setFundAcct(String fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }
}

